/* vi: set sw=4 ts=4 sts=4: */
/*
 *	wireless.c -- Wireless Settings 
 *
 *	Copyright (c) Ralink Technology Corporation All Rights Reserved.
 *
 *	$Id: wireless.c,v 1.91.2.4 2008-07-18 06:14:16 yy Exp $
 */

#include	<stdlib.h>
#include	<sys/ioctl.h>
#include	<arpa/inet.h>
#include	"../../autoconf.h"
#ifdef CONFIG_DEFAULTS_KERNEL_2_6_21
  #include	<linux/types.h>
  #include	<linux/socket.h>
  #include	<linux/if.h>
#endif
#include	<linux/wireless.h>

#include	"internet.h"
#include	"nvram.h"
#include	"utils.h"
#include	"webs.h"
#include	"wireless.h"
#define AP_MODE
#include	"oid.h"

#include	"linux/autoconf.h"
#include <sys/ioctl.h>

#include "flash_ioctl.h"

#define RTPRIV_IOCTL_E2P (SIOCIWFIRSTPRIV + 0x07)


#define MAX_MBSSID_NUM		8

/*
 * RT2860, RTINIC, RT2561
 */
static int default_shown_mbssid[3]  = {0,0,0};

extern int g_wsc_configured;

//static int  getWirelessMode(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlan11aChannels(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlan11bChannels(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlan11gChannels(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlanApcliBuilt(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlanChannel(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlanCurrentMac(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlanStaInfo(int eid, webs_t wp, int argc, char_t **argv);
static int  getDLSBuilt(int eid, webs_t wp, int argc, char_t **argv);
static int  getDFSBuilt(int eid, webs_t wp, int argc, char_t **argv);
static int  getCarrierBuilt(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlanM2UBuilt(int eid, webs_t wp, int argc, char_t **argv);
static int  getWlanWdsEncType(int eid, webs_t wp, int argc, char_t **argv);
static int  getWirelessMacRuleNumsASP(int eid, webs_t wp, int argc, char_t **argv);
static int  showWirelessMacFilterRulesASP(int eid, webs_t wp, int argc, char_t **argv);
static int  getWirelessMacFilterPolicy(int eid, webs_t wp, int argc, char_t **argv);
static void wirelessMacFilterDelete(webs_t wp, char_t *path, char_t *query);
static void wirelessMacFilterPolicy(webs_t wp, char_t *path, char_t *query);
static void wirelessAddMacFilter(webs_t wp, char_t *path, char_t *query);
static void wirelessBasic(webs_t wp, char_t *path, char_t *query);
static void wirelessAdvanced(webs_t wp, char_t *path, char_t *query);
static void wirelessWds(webs_t wp, char_t *path, char_t *query);
static void wirelessApcli(webs_t wp, char_t *path, char_t *query);
static void wirelessWmm(webs_t wp, char_t *path, char_t *query);
static void wirelessGetSecurity(webs_t wp, char_t *path, char_t *query);
static void APSecurity(webs_t wp, char_t *path, char_t *query);
static int  is3t3r(int eid, webs_t wp, int argc, char_t **argv);
static int  isWPSConfiguredASP(int eid, webs_t wp, int argc, char_t **argv);
int deleteNthValueMulti(int index[], int count, char *value, char delimit);		/* for Access Policy list deletion*/
static void APDeleteAccessPolicyList(webs_t wp, char_t *path, char_t *query);
void DeleteAccessPolicyList(int nvram, webs_t wp, char_t *path, char_t *query);
static int  isAntennaDiversityBuilt(int eid, webs_t wp, int argc, char_t **argv);
#ifdef CONFIG_RT2860V2_RT3XXX_AP_ANTENNA_DIVERSITY
static void AntennaDiversity(webs_t wp, char_t *path, char_t *query);
static void getAntenna(webs_t wp, char_t *path, char_t *query);
#endif
#ifdef CONFIG_RT2860V2_AP_MESH
static void wirelessMesh(webs_t wp, char_t *path, char_t *query);
static void meshManualLink(webs_t wp, char_t *path, char_t *query);
static int ShowMeshState(int eid, webs_t wp, int argc, char_t **argv);
#endif


static int isMacValid(char *str)
{
	int i, len = strlen(str);
	if(len != 17)
		return 0;

	for(i=0; i<5; i++){
		if( (!isxdigit( str[i*3])) || (!isxdigit( str[i*3+1])) || (str[i*3+2] != ':') )
			return 0;
	}
	return (isxdigit(str[15]) && isxdigit(str[16])) ? 1: 0;
}

int deleteAPNthValueMulti(int index[], int count, char *value, char delimit)
{
	char *begin, *end;
	int i=0,j=0;
	int need_check_flag=0;
	char *buf = strdup(value);

	begin = buf;

	end = strchr(begin, delimit);
	while(end){
		if(i == index[j]){
			memset(begin, 0, end - begin );
			if(index[j] == 0)
				need_check_flag = 1;
			j++;
			if(j >=count)
				break;
		}
		begin = end;

		end = strchr(begin+1, delimit);
		i++;
	}

	if(!end && index[j] == i)
		memset(begin, 0, strlen(begin));

	if(need_check_flag){
		for(i=0; i<strlen(value); i++){
			if(buf[i] == '\0')
				continue;
			if(buf[i] == ';')
				buf[i] = '\0';
			break;
		}
	}

	for(i=0, j=0; i<strlen(value); i++){
		if(buf[i] != '\0'){
			value[j++] = buf[i];
		}
	}
	value[j] = '\0';

	free(buf);
	return 0;
}

static int getAPNums(char *value, char delimit)
{
	char *pos = value;
    int count=1;
    if(!pos)
    	return 0;
	while( (pos = strchr(pos, delimit))){
		pos = pos+1;
		count++;
	}
	return count;
}

inline int getAPRuleNums(char *rules){
	return getAPNums(rules, ';');
}

//Jacky.Yang 7-Jan-2007, get Country region code in eeprom 0x39
static int getEEPROMCountryCode(char *eeprom_addr)
{
	int socket_id, ret;
	struct iwreq wrq;
	char name[25];
	char data[4096];
	int addr, value, p1, p2;
	
	socket_id = socket(AF_INET, SOCK_DGRAM, 0);
	if(socket_id < 0) {
		printf("\nrtuser::error::Open socket error!\n\n");
		return -1;
	}
	
	sprintf(name, "ra0");
	memset(data, 0x00, sizeof(data));
	
	//strcpy(data, "39"); // Country region code in eeprom 0x39
	strcpy(data, eeprom_addr); // Country region code in eeprom 0x39(2.4G), 0x38(5G)
	strcpy(wrq.ifr_name, name);
	wrq.u.data.length = strlen(data)+1;
	wrq.u.data.pointer = data;
	wrq.u.data.flags = 0;
	ret = ioctl(socket_id, RTPRIV_IOCTL_E2P, &wrq);
	if(ret != 0) {
		printf("\nrtuser::error::get eeprom\n\n");
		//exit(0);
	}
	sscanf(wrq.u.data.pointer, "\n[%dx%04X]:%dx%X ", &p1, &addr, &p2, &value);
	printf("\nGet EEP[0x%02X]:0x%04X\n", addr, value);
	return value;
}

/*
 * description: write 802.11a channels in <select> tag
 */
static int getWlan11aChannels(int eid, webs_t wp, int argc, char_t **argv)
{
	int  idx = 0, channel, returnEEPROMValue=0;
	char *value = nvram_bufget(RT2860_NVRAM,"CountryCode");
	char *channel_s = nvram_bufget(RT2860_NVRAM, "Channel");
	char *RemoveDFSChannel = nvram_bufget(RT2860_NVRAM, "RemoveDFSChannel");

	returnEEPROMValue = getEEPROMCountryCode("38");
	/*channel = (channel_s == NULL)? 0 : atoi(channel_s);
	if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "US") == 0) || (strcmp(value, "FR") == 0) ||
			(strcmp(value, "IE") == 0) || (strcmp(value, "JP") == 0) ||
			(strcmp(value, "HK") == 0)) {*/
	if (((returnEEPROMValue & 0x00FF) == 0x00) || ((returnEEPROMValue & 0x00FF) == 0x01) || ((returnEEPROMValue & 0x00FF) == 0x02) ||
		((returnEEPROMValue & 0x00FF) == 0x06) || ((returnEEPROMValue & 0x00FF) == 0x07)) // EEPROM 0x38, channel:36~48
	{
		for (idx = 0; idx < 4; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", 36+4*idx,
					(36+4*idx == channel)? "selected" : "", 5180+20*idx,
					"MHz (Channel ", 36+4*idx, ")</option>");
	}
	//Jacky.Yang 1-Jun-2008, Remove DFS channel:52~64, channel:100~140
	/*if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "US") == 0) || (strcmp(value, "FR") == 0) ||
			(strcmp(value, "IE") == 0) || (strcmp(value, "TW") == 0) ||
			(strcmp(value, "HK") == 0)) {*/
if (atoi(RemoveDFSChannel) == 1)
{
	if (((returnEEPROMValue & 0x00FF) == 0x00) || ((returnEEPROMValue & 0x00FF) == 0x01) || ((returnEEPROMValue & 0x00FF) == 0x02) ||
		((returnEEPROMValue & 0x00FF) == 0x03) || ((returnEEPROMValue & 0x00FF) == 0x07) || ((returnEEPROMValue & 0x00FF) == 0x08)) // EEPROM 0x38, channel:52~64
	{
		for (idx = 4; idx < 8; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", 36+4*idx,
					(36+4*idx == channel)? "selected" : "", 5180+20*idx,
					"MHz (Channel ", 36+4*idx, ")</option>");
	}
	//if ((value == NULL) || (strcmp(value, "") == 0)) {
	if (((returnEEPROMValue & 0x00FF) == 0x01) || ((returnEEPROMValue & 0x00FF) == 0x07)) // EEPROM 0x38, channel:100~140
	{
		for (idx = 16; idx < 27; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", 36+4*idx,
				   	(36+4*idx == channel)? "selected" : "", 5180+20*idx,
					"MHz (Channel ", 36+4*idx, ")</option>");
	}
}//if (atoi(RemoveDFSChannel) == 0)
	/*if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "US") == 0) || (strcmp(value, "TW") == 0) ||
			(strcmp(value, "CN") == 0) || (strcmp(value, "HK") == 0)) {*/
	if (((returnEEPROMValue & 0x00FF) == 0x00) || ((returnEEPROMValue & 0x00FF) == 0x03) || ((returnEEPROMValue & 0x00FF) == 0x04) || 
		((returnEEPROMValue & 0x00FF) == 0x05) || ((returnEEPROMValue & 0x00FF) == 0x07)) // EEPROM 0x38, channel:149~161
	{
		for (idx = 28; idx < 32; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=",
					36+4*idx+1, (36+4*idx+1 == channel)? "selected" : "",
					5180+20*idx+5, "MHz (Channel ", 36+4*idx+1, ")</option>");
	}
	/*if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "US") == 0) || (strcmp(value, "CN") == 0) ||
			(strcmp(value, "HK") == 0)) {*/
	if (((returnEEPROMValue & 0x00FF) == 0x00) || ((returnEEPROMValue & 0x00FF) == 0x04) || ((returnEEPROMValue & 0x00FF) == 0x07)) // EEPROM 0x38, channel:165
	{
		return websWrite(wp,
				T("<option value=165 %s>5825MHz (Channel 165)</option>\n"),
				(165 == channel)? "selected" : "");
	}
	return 0;
}

/*
 * description: write 802.11b channels in <select> tag
 */
static int getWlan11bChannels(int eid, webs_t wp, int argc, char_t **argv)
{
	int idx = 0, channel;
	char *value = nvram_bufget(RT2860_NVRAM, "CountryCode");
	char *channel_s = nvram_bufget(RT2860_NVRAM, "Channel");

	channel = (channel_s == NULL)? 0 : atoi(channel_s);	
	if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "US") == 0) || (strcmp(value, "JP") == 0) ||
			(strcmp(value, "FR") == 0) || (strcmp(value, "IE") == 0) ||
			(strcmp(value, "TW") == 0) || (strcmp(value, "CN") == 0) ||
			(strcmp(value, "HK") == 0)) {
		for (idx = 0; idx < 11; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", idx+1,
					(idx+1 == channel)? "selected" : "", 2412+5*idx,
					"MHz (Channel ", idx+1, ")</option>");
	}

	if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "JP") == 0) || (strcmp(value, "TW") == 0) ||
			(strcmp(value, "FR") == 0) ||
			(strcmp(value, "IE") == 0) || (strcmp(value, "CN") == 0) ||
			(strcmp(value, "HK") == 0)) {
		for (idx = 11; idx < 13; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", idx+1,
					(idx+1 == channel)? "selected" : "", 2412+5*idx,
					"MHz (Channel ", idx+1, ")</option>");
	}
//Tim Wang, never need to show channel 14	
#if 0
	if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "JP") == 0)) {
		return websWrite(wp,
				T("<option value=14 %s>2484MHz (Channel 14)</option>\n"),
				(14 == channel)? "selected" : "");
	}
#endif	
	return 0;
}

/*
 * description: write 802.11g channels in <select> tag
 */
static int getWlan11gChannels(int eid, webs_t wp, int argc, char_t **argv)
{
	int idx = 0, channel;
	char *value = nvram_bufget(RT2860_NVRAM, "CountryCode");
	char *channel_s = nvram_bufget(RT2860_NVRAM, "Channel");

	channel = (channel_s == NULL)? 0 : atoi(channel_s);

	//Jacky.Yang 24-Jan-2008, Control FCC or CE useing eeprom value to check.
	/*if ((value == NULL) || (strcmp(value, "") == 0) ||
			(strcmp(value, "US") == 0) || (strcmp(value, "JP") == 0) ||
			(strcmp(value, "FR") == 0) || (strcmp(value, "IE") == 0) ||
			(strcmp(value, "TW") == 0) || (strcmp(value, "CN") == 0) ||
			(strcmp(value, "HK") == 0)) {*/
		for (idx = 0; idx < 11; idx++)
			websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", idx+1,
					(idx+1 == channel)? "selected" : "", 2412+5*idx,
					"MHz (Channel ", idx+1, ")</option>");
	//}
	if ((getEEPROMCountryCode("39") & 0x00FF) == 0x01) // EEPROM 0x39, 01:channel 1~11, other:channel 1~13 or 1~14
	{
		/*if ((value == NULL) || (strcmp(value, "") == 0) ||
				(strcmp(value, "JP") == 0) || (strcmp(value, "TW") == 0) ||
				(strcmp(value, "FR") == 0) || (strcmp(value, "IE") == 0) ||
				(strcmp(value, "CN") == 0) || (strcmp(value, "HK") == 0)) {*/
			for (idx = 11; idx < 13; idx++)
				websWrite(wp, T("%s%d %s>%d%s%d%s"), "<option value=", idx+1,
						(idx+1 == channel)? "selected" : "", 2412+5*idx,
						"MHz (Channel ", idx+1, ")</option>");
		//}

		/*if ((value == NULL) || (strcmp(value, "") == 0)) {
			return websWrite(wp,
					T("<option value=14 %s>2484MHz (Channel 14)</option>\n"),
					(14 == channel)? "selected" : "");
		}*/
	}
	
	return 0;
}

static int getWlanApcliBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
#ifdef CONFIG_RT2860V2_AP_APCLI
	return websWrite(wp, T("1"));
#else
	return websWrite(wp, T("0"));
#endif
}

/*
 * description: write channel number or 0 if auto-select
 */
static int getWlanChannel(int eid, webs_t wp, int argc, char_t **argv)
{
	char *value = nvram_bufget(RT2860_NVRAM, "AutoChannelSelect");

	if (NULL == value)
		return websWrite(wp, T("9"));
	if (!strncmp(value, "1", 2))
		return websWrite(wp, T("0"));

	value = nvram_bufget(RT2860_NVRAM, "Channel");
	if (NULL == value)
		return websWrite(wp, T("9"));
	else
		return websWrite(wp, T("%s"), value);
}

/*
 * description: write MAC address from interface 'ra0'
 */
static int getWlanCurrentMac(int eid, webs_t wp, int argc, char_t **argv)
{
	char if_hw[18] = {0};

	if (-1 == getIfMac("ra0", if_hw))
		return websWrite(wp, T(" "));
	return websWrite(wp, T("%s"), if_hw);
}

typedef union _MACHTTRANSMIT_SETTING {
	struct  {
		unsigned short  MCS:7;  // MCS
		unsigned short  BW:1;   //channel bandwidth 20MHz or 40 MHz
		unsigned short  ShortGI:1;
		unsigned short  STBC:2; //SPACE
		unsigned short  rsv:3;
		unsigned short  MODE:2; // Use definition MODE_xxx.
	} field;
	unsigned short      word;
} MACHTTRANSMIT_SETTING;

typedef struct _RT_802_11_MAC_ENTRY {
	unsigned char            Addr[6];
	unsigned char            Aid;
	unsigned char            Psm;     // 0:PWR_ACTIVE, 1:PWR_SAVE
	unsigned char            MimoPs;  // 0:MMPS_STATIC, 1:MMPS_DYNAMIC, 3:MMPS_Enabled
	char                     AvgRssi0;
	char                     AvgRssi1;
	char                     AvgRssi2;
	unsigned int             ConnectedTime;
	MACHTTRANSMIT_SETTING    TxRate;
} RT_802_11_MAC_ENTRY;

typedef struct _RT_802_11_MAC_TABLE {
	unsigned long            Num;
	RT_802_11_MAC_ENTRY      Entry[32]; //MAX_LEN_OF_MAC_TABLE = 32
} RT_802_11_MAC_TABLE;

unsigned int ConvertToSignalQuality(short RSSI)
{
    unsigned int signal_quality;
    if (RSSI >= -50)
        signal_quality = 100;
    else if (RSSI >= -80)    // between -50 ~ -80dbm
        signal_quality = (unsigned int)(24 + (RSSI + 80) * 2.6);
    else if (RSSI >= -90)   // between -80 ~ -90dbm
        signal_quality = (unsigned int)((RSSI + 90) * 2.6);
    else    // < -84 dbm
        signal_quality = 0;

    return signal_quality;
}

static int getWlanStaInfo(int eid, webs_t wp, int argc, char_t **argv)
{
	int i, s;
	struct iwreq iwr;
	RT_802_11_MAC_TABLE table = {0};

	s = socket(AF_INET, SOCK_DGRAM, 0);
	strncpy(iwr.ifr_name, "ra0", IFNAMSIZ);
	iwr.u.data.pointer = (caddr_t) &table;

	if (s < 0) {
		websError(wp, 500, "ioctl sock failed!");
		return -1;
	}

	if (ioctl(s, RTPRIV_IOCTL_GET_MAC_TABLE, &iwr) < 0) {
		//websError(wp, 500, "ioctl -> RTPRIV_IOCTL_GET_MAC_TABLE failed!");
		close(s);
		return 0;
	}

	for (i = 0; i < table.Num; i++) {
		char mode[32], rate[32];
		if (table.Entry[i].TxRate.field.MODE == 0){
			strcpy(mode , "802.11b");
			if(table.Entry[i].TxRate.field.MCS == 0)
				strcpy(rate, "1Mbps");
			if(table.Entry[i].TxRate.field.MCS == 1)
				strcpy(rate, "2Mbps");
			if(table.Entry[i].TxRate.field.MCS == 2)
				strcpy(rate, "5.5Mbps");
			if(table.Entry[i].TxRate.field.MCS == 3)
				strcpy(rate, "11Mbps");
			if(table.Entry[i].TxRate.field.MCS == 8)
				strcpy(rate, "1Mbps");
			if(table.Entry[i].TxRate.field.MCS == 9)
				strcpy(rate, "2Mbps");
			if(table.Entry[i].TxRate.field.MCS == 10)
				strcpy(rate, "5.5Mbps");
			if(table.Entry[i].TxRate.field.MCS == 11)
				strcpy(rate, "11Mbps");
		} else if (table.Entry[i].TxRate.field.MODE == 1) {
			strcpy(mode , "802.11g");
			if(table.Entry[i].TxRate.field.MCS == 0)
				strcpy(rate, "6Mbps");
			if(table.Entry[i].TxRate.field.MCS == 1)
				strcpy(rate, "9Mbps");
			if(table.Entry[i].TxRate.field.MCS == 2)
				strcpy(rate, "12Mbps");
			if(table.Entry[i].TxRate.field.MCS == 3)
				strcpy(rate, "18Mbps");
			if(table.Entry[i].TxRate.field.MCS == 4)
				strcpy(rate, "24Mbps");
			if(table.Entry[i].TxRate.field.MCS == 5)
				strcpy(rate, "36Mbps");
			if(table.Entry[i].TxRate.field.MCS == 6)
				strcpy(rate, "48Mbps");
			if(table.Entry[i].TxRate.field.MCS == 7)
				strcpy(rate, "54Mbps");
		} else if (table.Entry[i].TxRate.field.MODE == 2 || table.Entry[i].TxRate.field.MODE == 3) {
			strcpy(mode , "802.11n");
			if(table.Entry[i].TxRate.field.BW == 0) {
				if(table.Entry[i].TxRate.field.MCS == 0)
					strcpy(rate, "6.5Mbps");
				if(table.Entry[i].TxRate.field.MCS == 1)
					strcpy(rate, "13Mbps");
				if(table.Entry[i].TxRate.field.MCS == 2)
					strcpy(rate, "19.5Mbps");
				if(table.Entry[i].TxRate.field.MCS == 3)
					strcpy(rate, "26Mbps");
				if(table.Entry[i].TxRate.field.MCS == 4)
					strcpy(rate, "39Mbps");
				if(table.Entry[i].TxRate.field.MCS == 5)
					strcpy(rate, "52Mbps");
				if(table.Entry[i].TxRate.field.MCS == 6)
					strcpy(rate, "58.5Mbps");
				if(table.Entry[i].TxRate.field.MCS == 7)
					strcpy(rate, "65Mbps");
				if(table.Entry[i].TxRate.field.MCS == 8)
					strcpy(rate, "13Mbps");
				if(table.Entry[i].TxRate.field.MCS == 9)
					strcpy(rate, "26Mbps");
				if(table.Entry[i].TxRate.field.MCS == 10)
					strcpy(rate, "39Mbps");
				if(table.Entry[i].TxRate.field.MCS == 11)
					strcpy(rate, "52Mbps");
				if(table.Entry[i].TxRate.field.MCS == 12)
					strcpy(rate, "78Mbps");
				if(table.Entry[i].TxRate.field.MCS == 13)
					strcpy(rate, "104Mbps");
				if(table.Entry[i].TxRate.field.MCS == 14)
					strcpy(rate, "117Mbps");
				if(table.Entry[i].TxRate.field.MCS == 15)
					strcpy(rate, "130Mbps");
				if(table.Entry[i].TxRate.field.MCS == 32)
					strcpy(rate, "6Mbps");
			} else if (table.Entry[i].TxRate.field.BW == 1) {
				if(table.Entry[i].TxRate.field.MCS == 0)
					strcpy(rate, "13.5Mbps");
				if(table.Entry[i].TxRate.field.MCS == 1)
					strcpy(rate, "27Mbps");
				if(table.Entry[i].TxRate.field.MCS == 2)
					strcpy(rate, "40.5Mbps");
				if(table.Entry[i].TxRate.field.MCS == 3)
					strcpy(rate, "54Mbps");
				if(table.Entry[i].TxRate.field.MCS == 4)
					strcpy(rate, "81Mbps");
				if(table.Entry[i].TxRate.field.MCS == 5)
					strcpy(rate, "108Mbps");
				if(table.Entry[i].TxRate.field.MCS == 6)
					strcpy(rate, "121.5Mbps");
				if(table.Entry[i].TxRate.field.MCS == 7)
					strcpy(rate, "135Mbps");
				if(table.Entry[i].TxRate.field.MCS == 8)
					strcpy(rate, "27Mbps");
				if(table.Entry[i].TxRate.field.MCS == 9)
					strcpy(rate, "54Mbps");
				if(table.Entry[i].TxRate.field.MCS == 10)
					strcpy(rate, "81Mbps");
				if(table.Entry[i].TxRate.field.MCS == 11)
					strcpy(rate, "108Mbps");
				if(table.Entry[i].TxRate.field.MCS == 12)
					strcpy(rate, "162Mbps");
				if(table.Entry[i].TxRate.field.MCS == 13)
					strcpy(rate, "216Mbps");
				if(table.Entry[i].TxRate.field.MCS == 14)
					strcpy(rate, "243Mbps");
				if(table.Entry[i].TxRate.field.MCS == 15)
					strcpy(rate, "270Mbps");
				if(table.Entry[i].TxRate.field.MCS == 32)
					strcpy(rate, "13Mbps");
			}
		} else {
			strcpy(mode, table.Entry[i].TxRate.field.MODE);
			strcpy(rate, table.Entry[i].TxRate.field.MCS);
		}
			
		websWrite(wp, T("<tr><td>%02X:%02X:%02X:%02X:%02X:%02X</td>"),
				table.Entry[i].Addr[0], table.Entry[i].Addr[1],
				table.Entry[i].Addr[2], table.Entry[i].Addr[3],
				table.Entry[i].Addr[4], table.Entry[i].Addr[5]);
/*		websWrite(wp, T("<td>%d</td><td>%d</td><td>%d</td>"),
				table.Entry[i].Aid, table.Entry[i].Psm, table.Entry[i].MimoPs);
		websWrite(wp, T("<td>%d</td><td>%s</td><td>%d</td><td>%d</td></tr>"),
				table.Entry[i].TxRate.field.MCS,
				(table.Entry[i].TxRate.field.BW == 0)? "20M":"40M",
				table.Entry[i].TxRate.field.ShortGI, table.Entry[i].TxRate.field.STBC);
*/
		websWrite(wp, T("<td>%s</td><td>%s</td><td>%d%%</td>"),
				mode, rate, ConvertToSignalQuality(table.Entry[i].AvgRssi0));
	}
	close(s);
	return 0;
}

static int getDLSBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
#ifdef CONFIG_RT2860V2_AP_DLS
	return websWrite(wp, T("1"));
#else
	return websWrite(wp, T("0"));
#endif
}

static int getDFSBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
#ifdef CONFIG_RT2860V2_AP_DFS
	return websWrite(wp, T("1"));
#else
	return websWrite(wp, T("0"));
#endif
}

static int getCarrierBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
#ifdef CONFIG_RT2860V2_AP_CARRIER
	return websWrite(wp, T("1"));
#else
	return websWrite(wp, T("0"));
#endif
}

static int getWlanM2UBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
#ifdef CONFIG_RT2860V2_AP_IGMP_SNOOP
	return websWrite(wp, T("1"));
#else
	return websWrite(wp, T("0"));
#endif
}

/*
 * description: write the WDS Encryp Type
 */
static int getWlanWdsEncType(int eid, webs_t wp, int argc, char_t **argv)
{
	char *value = nvram_bufget(RT2860_NVRAM, "WdsEncrypType");

	if (NULL == value)
		return websWrite(wp, T("0"));
	else if (strcmp(value, "NONE") == 0)
		return websWrite(wp, T("0"));
	else if (strcmp(value, "WEP") == 0)
		return websWrite(wp, T("1"));
	else if (strcmp(value, "TKIP") == 0)
		return websWrite(wp, T("2"));
	else if (strcmp(value, "AES") == 0)
		return websWrite(wp, T("3"));
	else
		return websWrite(wp, T("0"));
}

static int getWirelessMacRuleNumsASP(int eid, webs_t wp, int argc, char_t **argv)
{
    char *rules = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterRules");
	if(!rules || !strlen(rules) ){
		websWrite(wp, T("0"));
		return 0;
	}
	websWrite(wp, "%d", getAPRuleNums(rules));
	return 0;
}

static int showWirelessMacFilterRulesASP(int eid, webs_t wp, int argc, char_t **argv)
{
	int i=0, j=0, mode;
	char *fw_mode;
	char mac_address[32], comment[16];
	char rec[256], rec2[256];
	char *rules = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterRules");
	char *RuleComment = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterComment");
	if(!rules)
		return 0;
	if(!strlen(rules))
		return 0;

	/*fw_mode = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterPolicy");
	if(!fw_mode || !strlen(fw_mode))
		return 0;
	mode = atoi(fw_mode);*/
	while((getNthValueSafe(i++, rules, ';', rec, 256) != -1) && (getNthValueSafe(j++, RuleComment, ';', rec2, 256) != -1)){
		// get ip address
		if((getNthValueSafe(0, rec, ',', mac_address, 32) == -1))
			continue;
		getNthValueSafe(0, rec2, ',', comment, 16);
		
		if(!isMacValid(mac_address)){
			continue;
		}
		
		/*if((getNthValueSafe(1, rec, ',', comment, 16) == -1))
			continue;*/

		websWrite(wp, T("<tr class=\"form_label_row\">\n"));
		// output No.
		websWrite(wp, T("<th> %d&nbsp; <input type=\"checkbox\" name=\"delRule%d\"> </th>"), i, i-1 );

		// output MAC address
		websWrite(wp, T("<th align=center> %s </th>"), mac_address);
		// output Comment
		if(strlen(comment))
			websWrite(wp, T("<th align=center> %s</th>"), comment);
		else
			websWrite(wp, T("<th align=center> &nbsp; </th>"));
		//websWrite(wp, T("<td align=center> &nbsp; </td>"));
		
		websWrite(wp, T("</tr>\n"));
	}

	return 0;
}

static void wirelessMacFilterDelete(webs_t wp, char_t *path, char_t *query)
{
	int i, j, rule_count, comment_count;
	char_t name_buf[16];
	char_t *value;
	int *deleArray;

    char *rules = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterRules");
    char *comment = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterComment");
    if(!rules || !strlen(rules) )
        return;

	rule_count = getAPRuleNums(rules);
	comment_count = getAPRuleNums(comment);
	if(!rule_count)
		return;

	deleArray = (int *)malloc(rule_count * sizeof(int));

	for(i=0, j=0; i< rule_count; i++){
		snprintf(name_buf, 16, "delRule%d", i);
		value = websGetVar(wp, T(name_buf), NULL);
		if(value){
			deleArray[j++] = i;
		}
	}

    if(!j){
        websHeader(wp);
        websWrite(wp, T("You didn't select any rules to delete.<br>\n"));
        websFooter(wp);
        websDone(wp, 200);
        return;
    }

	deleteAPNthValueMulti(deleArray, rule_count, rules, ';');
	deleteAPNthValueMulti(deleArray, comment_count, comment, ';');
	free(deleArray);

	nvram_set(RT2860_NVRAM, "wirelessMacFilterRules", rules);
	nvram_set(RT2860_NVRAM, "wirelessMacFilterComment", comment);

	rules[strlen(rules)-1] = '\0';
	doSystem("iwpriv ra0 set AccessControlList=\"%s\"", rules);
	
    websHeader(wp);
    websWrite(wp, T("<head>"));
	websWrite(wp, T("<meta http-equiv=\"refresh\" content=\"0;url=../wireless/wireless_mac_filtering.asp\" />"));
	websWrite(wp, T("</head>"));
    /*websWrite(wp, T("s<br>\n") );
    websWrite(wp, T("mac_adress: <br>\n"));
    websWrite(wp, T("protocol: <br>\n"));*/
    websFooter(wp);
    websDone(wp, 200);

	return;
}

/*
 * description: getWirelessMacFilterPolicy
 */
static int getWirelessMacFilterPolicy(int eid, webs_t wp, int argc, char_t **argv)
{
	int type, value;
	char *mfe = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterPolicy");
	if(mfe)
		value = atoi(mfe);
	else
		value = 0;

	if( ejArgs(argc, argv, T("%d"), &type) == 1){
		if(type == value)
			websWrite(wp, T("selected"));
		else
			websWrite(wp, T(" "));
		return 0;
	}
	return -1;
}

static void revise_mbss_value(int old_num, int new_num)
{
	/* {{{ The parameters that support multiple BSSID is listed as followed,
	   1.) SSID,                 char SSID[33];
	   2.) AuthMode,             char AuthMode[14];
	   3.) EncrypType,           char EncrypType[8];
	   4.) WPAPSK,               char WPAPSK[65];
	   5.) DefaultKeyID,         int  DefaultKeyID;
	   6.) Key1Type,             int  Key1Type;
	   7.) Key1Str,              char Key1Str[27];
	   8.) Key2Type,             int  Key2Type;
	   9.) Key2Str,              char Key2Str[27];
	   10.) Key3Type,            int  Key3Type;
	   11.) Key3Str,             char Key3Str[27];
	   12.) Key4Type,            int  Key4Type;
	   13.) Key4Str,             char Key4Str[27];
	   14.) AccessPolicy,
	   15.) AccessControlList,
	   16.) NoForwarding,
	   17.) IEEE8021X,           int  IEEE8021X;
	   18.) TxRate,              int  TxRate;
	   19.) HideSSID,            int  HideSSID;
	   20.) PreAuth,             int  PreAuth;
	   21.) WmmCapable
	                             int  SecurityMode;
                             	 char VlanName[20];
	                             int  VlanId;
	                             int  VlanPriority;
	}}} */
	char new_value[264], *old_value, *p;
	int i;

#define MBSS_INIT(field, default_value) \
	do { \
		old_value = nvram_bufget(RT2860_NVRAM, #field); \
		snprintf(new_value, 264, "%s", old_value); \
		p = new_value + strlen(old_value); \
		for (i = old_num; i < new_num; i++) { \
			snprintf(p, 264 - (p - new_value), ";%s", default_value); \
			p += 1 + strlen(default_value); \
		} \
		nvram_bufset(RT2860_NVRAM, #field, new_value); \
	} while (0)

#define MBSS_REMOVE(field) \
	do { \
		old_value = nvram_bufget(RT2860_NVRAM, #field); \
		snprintf(new_value, 264, "%s", old_value); \
		p = new_value; \
		for (i = 0; i < new_num; i++) { \
			if (0 == i) \
				p = strchr(p, ';'); \
			else \
				p = strchr(p+1, ';'); \
			if (NULL == p) \
				break; \
		} \
		if (p) \
			*p = '\0'; \
		nvram_bufset(RT2860_NVRAM, #field, new_value); \
	} while (0)

	if (new_num > old_num) {
		//MBSS_INIT(SSID, "ssid");
		MBSS_INIT(AuthMode, "OPEN");
		MBSS_INIT(EncrypType, "NONE");
		//MBSS_INIT(WPAPSK, "12345678");
		MBSS_INIT(DefaultKeyID, "1");
		MBSS_INIT(Key1Type, "0");
		//MBSS_INIT(Key1Str, "");
		MBSS_INIT(Key2Type, "0");
		//MBSS_INIT(Key2Str, "");
		MBSS_INIT(Key3Type, "0");
		//MBSS_INIT(Key3Str, "");
		MBSS_INIT(Key4Type, "0");
		//MBSS_INIT(Key4Str, "");
/*		MBSS_INIT(AccessPolicy0, "0");
		MBSS_INIT(AccessControlList0, "");
		MBSS_INIT(AccessPolicy1, "0");
		MBSS_INIT(AccessControlList1, "");
		MBSS_INIT(AccessPolicy2, "0");
		MBSS_INIT(AccessControlList2, "");
		MBSS_INIT(AccessPolicy3, "0");
		MBSS_INIT(AccessControlList3, ""); */
		MBSS_INIT(NoForwarding, "0");
		MBSS_INIT(NoForwardingBTNBSSID, "0");
		MBSS_INIT(IEEE8021X, "0");
		MBSS_INIT(TxRate, "0");
		//MBSS_INIT(HideSSID, "0");
		MBSS_INIT(PreAuth, "0");
		MBSS_INIT(WmmCapable, "1");
		for (i = old_num + 1; i <= new_num; i++) {
			nvram_bufset(RT2860_NVRAM, racat("WPAPSK", i), "12345678");
			nvram_bufset(RT2860_NVRAM, racat("Key1Str", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key2Str", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key3Str", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key4Str", i), "");
			// The index of AccessPolicy & AccessControlList starts at 0.
			nvram_bufset(RT2860_NVRAM, racat("AccessPolicy", i-1), "0");
			nvram_bufset(RT2860_NVRAM, racat("AccessControlList", i-1), "");
		}
	}
	else if (new_num < old_num) {
		//MBSS_REMOVE(SSID);
		MBSS_REMOVE(AuthMode);
		MBSS_REMOVE(EncrypType);
		//MBSS_REMOVE(WPAPSK);
		MBSS_REMOVE(DefaultKeyID);
		MBSS_REMOVE(Key1Type);
		//MBSS_REMOVE(Key1Str);
		MBSS_REMOVE(Key2Type);
		//MBSS_REMOVE(Key2Str);
		MBSS_REMOVE(Key3Type);
		//MBSS_REMOVE(Key3Str);
		MBSS_REMOVE(Key4Type);
		//MBSS_REMOVE(Key4Str);
/*		MBSS_REMOVE(AccessPolicy0);
		MBSS_REMOVE(AccessControlList0);
		MBSS_REMOVE(AccessPolicy1);
		MBSS_REMOVE(AccessControlList1);
		MBSS_REMOVE(AccessPolicy2);
		MBSS_REMOVE(AccessControlList2);
		MBSS_REMOVE(AccessPolicy3);
		MBSS_REMOVE(AccessControlList3); */
		MBSS_REMOVE(NoForwarding);
		MBSS_REMOVE(NoForwardingBTNBSSID);
		MBSS_REMOVE(IEEE8021X);
		MBSS_REMOVE(TxRate);
		MBSS_REMOVE(HideSSID);
		MBSS_REMOVE(PreAuth);
		MBSS_REMOVE(WmmCapable);
		for (i = new_num + 1; i <= old_num; i++) {
			nvram_bufset(RT2860_NVRAM, racat("SSID", i), "");
			nvram_bufset(RT2860_NVRAM, racat("WPAPSK", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key1Str", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key2Str", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key3Str", i), "");
			nvram_bufset(RT2860_NVRAM, racat("Key4Str", i), "");
			// The index of AccessPolicy & AccessControlList starts at 0.
			nvram_bufset(RT2860_NVRAM, racat("AccessPolicy", i-1), "0");
			nvram_bufset(RT2860_NVRAM, racat("AccessControlList", i-1), "");
		}
	}
}

/* goform/wirelessMacFilterPolicy */
static void wirelessMacFilterPolicy(webs_t wp, char_t *path, char_t *query)
{
	char *mfe;
	mfe = websGetVar(wp, T("macFilterEnabled"), T(""));
	switch(atoi(mfe))
	{
		case 0:
			nvram_set(RT2860_NVRAM, "wirelessMacFilterPolicy", "0");			
			break;
		case 1:
			nvram_set(RT2860_NVRAM, "wirelessMacFilterPolicy", "1");
			break;
		case 2:
			nvram_set(RT2860_NVRAM, "wirelessMacFilterPolicy", "2");
			break;
	}
	doSystem("iwpriv ra0 set AccessPolicy=%s", mfe);
	websHeader(wp);
	websWrite(wp, T("<head>"));
	websWrite(wp, T("<meta http-equiv=\"refresh\" content=\"0;url=../wireless/wireless_mac_filtering.asp\" />"));
	websWrite(wp, T("</head>"));
	websFooter(wp);
	websDone(wp, 200);
}

/* goform/wirelessAddMacFilter */
static void wirelessAddMacFilter(webs_t wp, char_t *path, char_t *query)
{
	char rule[1024], comment_buf[1024];
	char *mac_address, *comment, *wirelessMacFilterRules, *wirelessMacFilterComment;
	mac_address = websGetVar(wp, T("mac_address"), T(""));
	comment = websGetVar(wp, T("comment"), T(""));
	doSystem("echo comment=%s", comment);
	if(strlen(comment) > 32)
		return;

	if(( wirelessMacFilterComment = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterComment")) && strlen( wirelessMacFilterComment))
		snprintf(comment_buf, 1024, "%s%s;", wirelessMacFilterComment, comment);
	else
		snprintf(comment_buf, 1024, "%s;", comment);
	nvram_set(RT2860_NVRAM, "wirelessMacFilterComment", comment_buf);
	
	if(strlen(mac_address)){	// user input a rule
		if(( wirelessMacFilterRules = nvram_bufget(RT2860_NVRAM, "wirelessMacFilterRules")) && strlen( wirelessMacFilterRules))
			//snprintf(rule, 1024, "%s%s,%s,;", wirelessMacFilterRules, mac_address, comment);
			snprintf(rule, 1024, "%s%s;", wirelessMacFilterRules, mac_address);
		else
			//snprintf(rule, 1024, "%s,%s,;", mac_address, comment);
			snprintf(rule, 1024, "%s;", mac_address);
		nvram_set(RT2860_NVRAM, "wirelessMacFilterRules", rule);
		rule[strlen(rule)-1] = '\0';
		doSystem("iwpriv ra0 set AccessControlList=\"%s\"", rule);
	}
	websHeader(wp);
	websWrite(wp, T("<head>"));
	websWrite(wp, T("<meta http-equiv=\"refresh\" content=\"0;url=../wireless/wireless_mac_filtering.asp\" />"));
	websWrite(wp, T("</head>"));
	websFooter(wp);
	websDone(wp, 200);
}

/* goform/wirelessBasic */
static void wirelessBasic(webs_t wp, char_t *path, char_t *query)
{
	char_t	*wirelessmode;
	char_t	*ssid, *mssid_1, *mssid_2, *mssid_3, *mssid_4, *mssid_5, *mssid_6,
			*mssid_7, *bssid_num, *broadcastssid, *apisolated, *mbssidapisolated;
	char_t	*sz11aChannel, *sz11bChannel, *sz11gChannel, *abg_rate;
	char_t	*wds_list, *wds_mode, *wds_phy_mode, *wds_encryp_type, *wds_encryp_key;
	char_t	*n_mode, *n_bandwidth, *n_gi, *n_mcs, *n_rdg, *n_extcha, *n_amsdu;
	char_t	*n_autoba, *n_badecline;
	char_t	*tx_stream, *rx_stream;
	char_t	*radio;
	int i = 0, is_n = 0, new_bssid_num, old_bssid_num = 1;
	//Jacky.Yang
	char_t *nowChannel;
	char *TXRate;
	int ssidChang=0; //ssid change flage,for set WSCConfigured is need.
	char_t *Web_ssid[MAX_MBSSID_NUM]={ssid,mssid_1,mssid_2,mssid_3,mssid_4,mssid_5,mssid_6,mssid_7};
	
	radio = websGetVar(wp, T("radiohiddenButton"), T("2"));
		if (!strncmp(radio, "0", 2)) {
		doSystem("iwpriv ra0 set RadioOn=0");
		nvram_set(RT2860_NVRAM, "RadioOff", "1");
		doSystem("ifconfig ra3 down");
		doSystem("ifconfig ra2 down");
		doSystem("ifconfig ra1 down");
		doSystem("ifconfig ra0 down");
		websRedirect(wp, "wireless/basic.asp");
		return;
	}
	else if (!strncmp(radio, "1", 2)) {
		doSystem("iwpriv ra0 set RadioOn=1");
		nvram_set(RT2860_NVRAM, "RadioOff", "0");
		doSystem("ifconfig ra0 up");
		doSystem("ifconfig ra1 down");
		doSystem("ifconfig ra2 down");
		doSystem("ifconfig ra3 down");
		doSystem("/sbin/ant_div.sh");
		websRedirect(wp, "wireless/basic.asp");
		return;
	}

	//fetch from web input
	wirelessmode = websGetVar(wp, T("wirelessmode"), T("9")); //9: bgn mode
	TXRate = websGetVar(wp, T("TXRate"), T(""));
	/*ssid = websGetVar(wp, T("ssid"), T("")); 
	mssid_1 = websGetVar(wp, T("mssid_1"), T("")); 
	mssid_2 = websGetVar(wp, T("mssid_2"), T("")); 
	mssid_3 = websGetVar(wp, T("mssid_3"), T("")); */
	Web_ssid[0] = ssid = websGetVar(wp, T("submit_SSID1"), T(""));
	Web_ssid[1] = mssid_1 = websGetVar(wp, T("submit_SSID2"), T(""));
	Web_ssid[2] = mssid_2 = websGetVar(wp, T("submit_SSID3"), T(""));
	Web_ssid[3] = mssid_3 = websGetVar(wp, T("submit_SSID4"), T(""));
	Web_ssid[4] = mssid_4 = websGetVar(wp, T("submit_SSID5"), T("")); 
	Web_ssid[5] = mssid_5 = websGetVar(wp, T("submit_SSID6"), T("")); 
	Web_ssid[6] = mssid_6 = websGetVar(wp, T("submit_SSID7"), T("")); 
	Web_ssid[7] = mssid_7 = websGetVar(wp, T("submit_SSID8"), T(""));
	bssid_num = websGetVar(wp, T("bssid_num"), T("1"));
	broadcastssid = websGetVar(wp, T("broadcastssid"), T("1")); 
	apisolated = websGetVar(wp, T("apisolated"), T("0"));
	mbssidapisolated = websGetVar(wp, T("mbssidapisolated"), T("0"));
	sz11aChannel = websGetVar(wp, T("sz11aChannel"), T("")); 
	sz11bChannel = websGetVar(wp, T("sz11bChannel"), T("")); 
	sz11gChannel = websGetVar(wp, T("sz11gChannel"), T("")); 
	//abg_rate = websGetVar(wp, T("abg_rate"), T("")); 
	wds_mode = websGetVar(wp, T("wds_mode"), T("0")); 
	wds_phy_mode = websGetVar(wp, T("wds_phy_mode"), T("0")); 
	wds_encryp_type = websGetVar(wp, T("wds_encryp_type"), T("0")); 
	wds_encryp_key = websGetVar(wp, T("wds_encryp_key"), T("0")); 
	wds_list = websGetVar(wp, T("wds_list"), T("")); 
	if (strlen(wds_list) > 0)
		wds_list[strlen(wds_list) - 1] = '\0';
	n_mode = websGetVar(wp, T("n_mode"), T("0"));
	n_bandwidth = websGetVar(wp, T("n_bandwidth"), T("0"));
	n_gi = websGetVar(wp, T("n_gi"), T("0"));
	n_mcs = websGetVar(wp, T("n_mcs"), T("33"));
	n_rdg = websGetVar(wp, T("n_rdg"), T("0"));
	n_extcha = websGetVar(wp, T("n_extcha"), T("0"));
	n_amsdu = websGetVar(wp, T("n_amsdu"), T("0"));
	n_autoba = websGetVar(wp, T("n_autoba"), T("0"));
	n_badecline = websGetVar(wp, T("n_badecline"), T("0"));
	tx_stream = websGetVar(wp, T("tx_stream"), T("0"));
	rx_stream = websGetVar(wp, T("rx_stream"), T("0"));

	old_bssid_num = atoi(nvram_bufget(RT2860_NVRAM, "BssidNum"));
	new_bssid_num = atoi(bssid_num);

	nvram_bufset(RT2860_NVRAM, "WirelessMode", wirelessmode);
	if (!strncmp(wirelessmode, "4", 2))
		nvram_bufset(RT2860_NVRAM, "BasicRate", "351");
	//Jacky.Yang 11-Jan-2008, for all support N to use extension channel.
	//else if (!strncmp(wirelessmode, "8", 2) || !strncmp(wirelessmode, "9", 2))
	else if (atoi(wirelessmode) >= 6)
		is_n = 1;

	//Jacky.Yang 26-Mar-2008, set TXRate
	//printf("jacky - TXRate:%s\n", TXRate);
	//printf("jacky - wirelessmode=%d\n", atoi(wirelessmode));
	if (atoi(wirelessmode) < 6) {
		if (!strcmp(TXRate, "CCK_long_0")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "1");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "0");
		}
		else if (!strcmp(TXRate, "CCK_long_1")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "1");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "1");
		}
		else if (!strcmp(TXRate, "CCK_long_2")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "1");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "2");
		}
		else if (!strcmp(TXRate, "CCK_long_3")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "1");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "3");
		}
		else if (!strcmp(TXRate, "CCK_long_33")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "1");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "33");
		}
		else if (!strcmp(TXRate, "OFDM_0")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "0");
		}
		else if (!strcmp(TXRate, "OFDM_1")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "1");
		}
		else if (!strcmp(TXRate, "OFDM_2")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "2");
		}
		else if (!strcmp(TXRate, "OFDM_3")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "3");
		}
		else if (!strcmp(TXRate, "OFDM_4")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "4");
		}
		else if (!strcmp(TXRate, "OFDM_5")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "5");
		}
		else if (!strcmp(TXRate, "OFDM_6")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "6");
		}
		else if (!strcmp(TXRate, "OFDM_7")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "7");
		}
		else if (!strcmp(TXRate, "OFDM_33")) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "2");
			nvram_bufset(RT2860_NVRAM, "HT_MCS", "33");
		}
	}
	else
		nvram_bufset(RT2860_NVRAM, "FixedTxMode", "0");
	
#if 0
	i = atoi(mode);
	if (i == 1)
		nvram_bufset(RT2860_NVRAM, "BasicRate", "3");
	else if (i == 0) {
		nvram_bufset(RT2860_NVRAM, "TxPreamble","0");
		nvram_bufset(RT2860_NVRAM, "TxBurst", "0");
		nvram_bufset(RT2860_NVRAM, "PktAggregate", "0");
	}
	else if (i == 5) {
		nvram_bufset(RT2860_NVRAM, "TxPreamble","1");
		nvram_bufset(RT2860_NVRAM, "TxBurst", "1");
		nvram_bufset(RT2860_NVRAM, "PktAggregate", "1");
		nvram_bufset(RT2860_NVRAM, "DisableOLBC", "1");
	}
	if (i != 5) {
		nvram_bufset(RT2860_NVRAM, "DisableOLBC", "0");
	}
#endif

	//SSID, Multiple SSID
	if (0 == strlen(ssid)) {
		nvram_commit(RT2860_NVRAM);
		websError(wp, 403, T("'SSID' should not be empty!"));
		return;
	}

//#WPS
	char_t tmpSSID[35] ;

#if 0
	if(old_bssid_num != new_bssid_num)
	{
			ssidChang=1;
	}else{
			for(i=0; i< old_bssid_num; i++) {
				tmpSSID[0] = 0;
				strcpy(tmpSSID, nvram_bufget(RT2860_NVRAM, racat("SSID", i+1)));
				if(tmpSSID) {
					printf("%s, %d, %s\n", tmpSSID, i, Web_ssid[i]); 
					if( strncmp(tmpSSID, Web_ssid[i], strlen(tmpSSID)) ){
						ssidChang=1;
						break;
					}
				}
			}
	}
#endif
	char *wscStatus = nvram_bufget(RT2860_NVRAM, "WscConfigured");
	/* WPS supported only with the Primary SSID */
	strcpy(tmpSSID, nvram_bufget(RT2860_NVRAM, "SSID1"));
	
	if( strcmp(tmpSSID, Web_ssid[0]) ){
		ssidChang=1;
	}

	if((ssidChang)||(atoi(wscStatus)))
	{
		char *wordlist= nvram_bufget(RT2860_NVRAM, "WscModeOption");
		if(wordlist){
			if (strcmp(wordlist, "0"))
				doSystem("iwpriv ra0 set WscConfStatus=1");
			nvram_bufset(RT2860_NVRAM, "WscConfigured", "1");
			g_wsc_configured = 1;
		}
	}
//#WPS
	nvram_bufset(RT2860_NVRAM, "SSID1", ssid);
	default_shown_mbssid[RT2860_NVRAM] = 0;

	i = 2;
	if (0 != strlen(mssid_1)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_1);
		i++;
	}
	if (0 != strlen(mssid_2)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_2);
		i++;
	}
	if (0 != strlen(mssid_3)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_3);
		i++;
	}
	if (0 != strlen(mssid_4)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_4);
		i++;
	}
	if (0 != strlen(mssid_5)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_5);
		i++;
	}
	if (0 != strlen(mssid_6)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_6);
		i++;
	}
	if (0 != strlen(mssid_7)) {
		nvram_bufset(RT2860_NVRAM, racat("SSID", i), mssid_7);
		i++;
	}

	nvram_bufset(RT2860_NVRAM, "BssidNum", bssid_num);
	if (new_bssid_num < 1 || new_bssid_num > 8) {
		nvram_commit(RT2860_NVRAM);
		websError(wp, 403, T("'bssid_num' %s is out of range!"), bssid_num);
		return;
	}
	revise_mbss_value(old_bssid_num, new_bssid_num);

	//Broadcast SSID
	if (new_bssid_num == 1) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1");
	}
	else if (new_bssid_num == 2) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1");
	}
	else if (new_bssid_num == 3) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1;1");
	}
	else if (new_bssid_num == 4) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0;0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1;1;1");
	}
	else if (new_bssid_num == 5) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0;0;0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1;1;1;1");
	}
	else if (new_bssid_num == 6) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0;0;0;0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1;1;1;1;1");
	}
	else if (new_bssid_num == 7) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0;0;0;0;0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1;1;1;1;1;1");
	}
	else if (new_bssid_num == 8) {
		if (!strncmp(broadcastssid, "1", 2))
			nvram_bufset(RT2860_NVRAM, "HideSSID", "0;0;0;0;0;0;0;0");
		else
			nvram_bufset(RT2860_NVRAM, "HideSSID", "1;1;1;1;1;1;1;1");
	}

	// NoForwarding and NoForwardingBTNBSSID
	nvram_bufset(RT2860_NVRAM, "NoForwarding", apisolated);
	nvram_bufset(RT2860_NVRAM, "NoForwardingBTNBSSID", mbssidapisolated);

	//11abg Channel or AutoSelect
	if ((0 == strlen(sz11aChannel)) && (0 == strlen(sz11bChannel)) &&
			(0 == strlen(sz11gChannel))) {
		nvram_commit(RT2860_NVRAM);
		websError(wp, 403, T("'Channel' should not be empty!"));
		return;
	}
	if (!strncmp(sz11aChannel, "0", 2) && !strncmp(sz11bChannel, "0", 2) &&
			!strncmp(sz11gChannel, "0", 2))
		nvram_bufset(RT2860_NVRAM, "AutoChannelSelect", "1");
	else
		nvram_bufset(RT2860_NVRAM, "AutoChannelSelect", "0");
	if (0 != strlen(sz11aChannel))
		nvram_bufset(RT2860_NVRAM, "Channel", sz11aChannel);
	if (0 != strlen(sz11bChannel))
		nvram_bufset(RT2860_NVRAM, "Channel", sz11bChannel);
	if (0 != strlen(sz11gChannel))
		nvram_bufset(RT2860_NVRAM, "Channel", sz11gChannel);

	//Rate for a, b, g
	/*
	if (strncmp(abg_rate, "", 1)) {
		int rate = atoi(abg_rate);
		if (!strncmp(wirelessmode, "0", 2) || !strncmp(wirelessmode, "2", 2) || !strncmp(wirelessmode, "4", 2)) {
			if (rate == 1 || rate == 2 || rate == 5 || rate == 11)
				nvram_bufset(RT2860_NVRAM, "FixedTxMode", "CCK");
			else
				nvram_bufset(RT2860_NVRAM, "FixedTxMode", "OFDM");

			if (rate == 1)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "0");
			else if (rate == 2)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "1");
			else if (rate == 5)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "2");
			else if (rate == 6)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "0");
			else if (rate == 9)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "1");
			else if (rate == 11)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "3");
			else if (rate == 12)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "2");
			else if (rate == 18)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "3");
			else if (rate == 24)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "4");
			else if (rate == 36)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "5");
			else if (rate == 48)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "6");
			else if (rate == 54)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "7");
			else
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "33");
		}
		else if (!strncmp(wirelessmode, "1", 2)) {
			nvram_bufset(RT2860_NVRAM, "FixedTxMode", "CCK");
			if (rate == 1)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "0");
			else if (rate == 2)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "1");
			else if (rate == 5)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "2");
			else if (rate == 11)
				nvram_bufset(RT2860_NVRAM, "HT_MCS", "3");
		}
		else //shall not happen
			error(E_L, E_LOG, T("wrong configurations from web UI"));
	}
	else
		nvram_bufset(RT2860_NVRAM, "FixedTxMode", "HT");
	*/

	//WdsEnable, WdsPhyMode, WdsEncrypType, WdsKey, WdsList
	//where WdsPhyMode - 0:CCK, 1:OFDM, 2:HTMIX, 3:GREENFIELD
	//      WdsEncryptType - NONE, WEP, TKIP, AES
	nvram_bufset(RT2860_NVRAM, "WdsEnable", wds_mode);
	if (strncmp(wds_mode, "0", 2)) {
		nvram_bufset(RT2860_NVRAM, "WdsPhyMode", wds_phy_mode);
		//Jacky.Yang 29-Oct-2008, The WDS security setting is move to security page.
		//nvram_bufset(RT2860_NVRAM, "WdsEncrypType", wds_encryp_type);
		//nvram_bufset(RT2860_NVRAM, "WdsKey", wds_encryp_key);
		if (!strncmp(wds_mode, "2", 2) || !strncmp(wds_mode, "3", 2)) {
			if (0 != strlen(wds_list))
				nvram_bufset(RT2860_NVRAM, "WdsList", wds_list);
		}
	}

	//HT_OpMode, HT_BW, HT_GI, HT_MCS, HT_RDG, HT_EXTCHA, HT_AMSDU, HT_TxStream, HT_RxStream
	if (is_n) {
		nowChannel = nvram_bufget(RT2860_NVRAM, "Channel");
		nvram_bufset(RT2860_NVRAM, "HT_OpMode", n_mode);
		nvram_bufset(RT2860_NVRAM, "HT_BW", n_bandwidth);
		nvram_bufset(RT2860_NVRAM, "HT_GI", n_gi);
		if (atoi(wirelessmode) >= 6) {
			nvram_bufset(RT2860_NVRAM, "HT_MCS", n_mcs);
		}
		nvram_bufset(RT2860_NVRAM, "HT_RDG", n_rdg);
		nvram_bufset(RT2860_NVRAM, "HT_EXTCHA", n_extcha);
		nvram_bufset(RT2860_NVRAM, "HT_AMSDU", n_amsdu);
		nvram_bufset(RT2860_NVRAM, "HT_AutoBA", n_autoba);
		nvram_bufset(RT2860_NVRAM, "HT_BADecline", n_badecline);
	}
	nvram_bufset(RT2860_NVRAM, "HT_TxStream", tx_stream);
	nvram_bufset(RT2860_NVRAM, "HT_RxStream", rx_stream);

	nvram_commit(RT2860_NVRAM);

//#if CONFIG_RT2860V2_AP == CONFIG_MIPS
     // this is a workaround:
     // when AP is built as kernel
     // if more ssids are created, driver won't exe RT28xx_MBSS_Init again
     //  therefore, we reboot to make it available
     //  (PS. CONFIG_MIPS would be "y")
     //
/*
NOTE : (by David.Lin, 2010-02-23)
	For passing WCN of windows7, we should runtime      
	make wireless workable when we change any settings; 
	except Muti-SSID & WDS, we should reboot DUT to     
	make it work.
*/
    if (new_bssid_num != old_bssid_num)
        websRedirect(wp, "/applied2.asp?url=/wireless/basic.asp");
    else if(atoi(nvram_bufget(RT2860_NVRAM, "WdsEnable")))
        websRedirect(wp, "/applied2.asp?url=/wireless/basic.asp");
    else
//#endif
    initInternet("wirelessBasic");
}

/* goform/wirelessAdvanced */
static void wirelessAdvanced(webs_t wp, char_t *path, char_t *query)
{
	char_t	*bg_protection, *basic_rate, *beacon, *dtim, *fragment, *rts,
			*tx_power, *short_preamble, *short_slot, *tx_burst, *pkt_aggregate,
			*ieee_80211h, *wmm_capable, *apsd_capable, *dls_capable, *countrycode;
	char_t	*m2u_enable;
	int		i, ssid_num, wlan_mode;
	char	wmm_enable[8];

	//fetch from web input
	bg_protection = websGetVar(wp, T("bg_protection"), T("0"));
	basic_rate = websGetVar(wp, T("basic_rate"), T("15"));
	beacon = websGetVar(wp, T("beacon"), T("100"));
	dtim = websGetVar(wp, T("dtim"), T("1"));
	fragment = websGetVar(wp, T("fragment"), T("2346"));
	rts = websGetVar(wp, T("rts"), T("2347"));
	tx_power = websGetVar(wp, T("tx_power"), T("100"));
	short_preamble = websGetVar(wp, T("short_preamble"), T("0"));
	short_slot = websGetVar(wp, T("short_slot"), T("0"));
	tx_burst = websGetVar(wp, T("tx_burst"), T("0"));
	pkt_aggregate = websGetVar(wp, T("pkt_aggregate"), T("0"));
	ieee_80211h = websGetVar(wp, T("ieee_80211h"), T("0"));
	wmm_capable = websGetVar(wp, T("wmm_capable"), T("0"));
	apsd_capable = websGetVar(wp, T("apsd_capable"), T("0"));
	dls_capable = websGetVar(wp, T("dls_capable"), T("0"));
	m2u_enable = websGetVar(wp, T("m2u_enable"), T("0"));
	countrycode = websGetVar(wp, T("country_code"), T("NONE"));

	if (NULL != nvram_bufget(RT2860_NVRAM, "BssidNum"))
		ssid_num = atoi(nvram_bufget(RT2860_NVRAM, "BssidNum"));
	else
		ssid_num = 1;
	wlan_mode = atoi(nvram_bufget(RT2860_NVRAM, "WirelessMode"));

	//set to nvram
	nvram_bufset(RT2860_NVRAM, "BGProtection", bg_protection);
	nvram_bufset(RT2860_NVRAM, "BasicRate", basic_rate);
	nvram_bufset(RT2860_NVRAM, "BeaconPeriod", beacon);
	nvram_bufset(RT2860_NVRAM, "DtimPeriod", dtim);
	nvram_bufset(RT2860_NVRAM, "FragThreshold", fragment);
	nvram_bufset(RT2860_NVRAM, "RTSThreshold", rts);
	nvram_bufset(RT2860_NVRAM, "TxPower", tx_power);
	nvram_bufset(RT2860_NVRAM, "TxPreamble", short_preamble);
	nvram_bufset(RT2860_NVRAM, "ShortSlot", short_slot);
	nvram_bufset(RT2860_NVRAM, "TxBurst", tx_burst);
	nvram_bufset(RT2860_NVRAM, "PktAggregate", pkt_aggregate);
	nvram_bufset(RT2860_NVRAM, "IEEE80211H", ieee_80211h);
	nvram_bufset(RT2860_NVRAM, "WmmCapable", wmm_capable);
	nvram_bufset(RT2860_NVRAM, "APSDCapable", apsd_capable);
	nvram_bufset(RT2860_NVRAM, "DLSCapable", dls_capable);
	nvram_bufset(RT2860_NVRAM, "M2UEnabled", m2u_enable);

	bzero(wmm_enable, sizeof(char)*8);
	for (i = 0; i < ssid_num; i++)
	{
		sprintf(wmm_enable+strlen(wmm_enable), "%d", atoi(wmm_capable));
		sprintf(wmm_enable+strlen(wmm_enable), "%c", ';');
	}
	wmm_enable[strlen(wmm_enable) - 1] = '\0';

	if (!strncmp(wmm_capable, "1", 2)) {
		if (wlan_mode < 5)
			nvram_bufset(RT2860_NVRAM, "TxBurst", "0");
	}

	nvram_bufset(RT2860_NVRAM, "CountryCode", countrycode);
	if (!strncmp(countrycode, "US", 3)) {
		nvram_bufset(RT2860_NVRAM, "CountryRegion", "0");
		nvram_bufset(RT2860_NVRAM, "CountryRegionABand", "0");
	}
	else if (!strncmp(countrycode, "JP", 3)) {
		nvram_bufset(RT2860_NVRAM, "CountryRegion", "5");
		nvram_bufset(RT2860_NVRAM, "CountryRegionABand", "6");
	}
	else if (!strncmp(countrycode, "FR", 3)) {
		nvram_bufset(RT2860_NVRAM, "CountryRegion", "1");
		nvram_bufset(RT2860_NVRAM, "CountryRegionABand", "2");
	}
	else if (!strncmp(countrycode, "TW", 3)) {
		nvram_bufset(RT2860_NVRAM, "CountryRegion", "1");
		nvram_bufset(RT2860_NVRAM, "CountryRegionABand", "3");
	}
	else if (!strncmp(countrycode, "IE", 3)) {
		nvram_bufset(RT2860_NVRAM, "CountryRegion", "1");
		nvram_bufset(RT2860_NVRAM, "CountryRegionABand", "2");
	}
	else if (!strncmp(countrycode, "HK", 3)) {
		nvram_bufset(RT2860_NVRAM, "CountryRegion", "1");
		nvram_bufset(RT2860_NVRAM, "CountryRegionABand", "0");
	}
	else {
		nvram_bufset(RT2860_NVRAM, "CountryCode", "");
	}

	nvram_commit(RT2860_NVRAM);
	initInternet("wirelessAdvanced");

#ifdef CONFIG_RT2860V2_AP_IGMP_SNOOP
	if (!strncmp(m2u_enable, "1", 2))
		doSystem("iwpriv ra0 set IgmpSnEnable=1");
	else
		doSystem("iwpriv ra0 set IgmpSnEnable=0");
#endif

	//websRedirect(wp, "/wireless/advanced.asp");
	websRedirect(wp, "/applied.asp?url=/wireless/advanced.asp");
}

/* goform/wirelessWds */
static void wirelessWds(webs_t wp, char_t *path, char_t *query)
{
	char_t	*wds_mode, *wds_phy_mode, *wds_encryp_type, *wds_encryp_key0,
			*wds_encryp_key1,*wds_encryp_key2, *wds_encryp_key3, *wds_list;

	wds_mode = websGetVar(wp, T("wds_mode"), T("0"));
	wds_phy_mode = websGetVar(wp, T("wds_phy_mode"), T(""));
	wds_encryp_type = websGetVar(wp, T("wds_encryp_type"), T(""));
	wds_encryp_key0 = websGetVar(wp, T("wds_encryp_key0"), T(""));
	wds_encryp_key1 = websGetVar(wp, T("wds_encryp_key1"), T(""));
	wds_encryp_key2 = websGetVar(wp, T("wds_encryp_key2"), T(""));
	wds_encryp_key3 = websGetVar(wp, T("wds_encryp_key3"), T(""));
	wds_list = websGetVar(wp, T("wds_list"), T(""));

	nvram_bufset(RT2860_NVRAM, "WdsEnable", wds_mode);
	if (strncmp(wds_mode, "0", 2)) {
		nvram_bufset(RT2860_NVRAM, "WdsPhyMode", wds_phy_mode);
		nvram_bufset(RT2860_NVRAM, "WdsEncrypType", wds_encryp_type);
		nvram_bufset(RT2860_NVRAM, "Wds0Key", wds_encryp_key0);
		nvram_bufset(RT2860_NVRAM, "Wds1Key", wds_encryp_key1);
		nvram_bufset(RT2860_NVRAM, "Wds2Key", wds_encryp_key2);
		nvram_bufset(RT2860_NVRAM, "Wds3Key", wds_encryp_key3);
		if (!strncmp(wds_mode, "2", 2) || !strncmp(wds_mode, "3", 2)) {
			if (0 != strlen(wds_list))
				nvram_bufset(RT2860_NVRAM, "WdsList", wds_list);
		}
	}
	nvram_commit(RT2860_NVRAM);

	initInternet("");

	//debug print
	websHeader(wp);
	websWrite(wp, T("wds_mode: %s<br>\n"), wds_mode);
	websWrite(wp, T("wds_phy_mode: %s<br>\n"), wds_phy_mode);
	websWrite(wp, T("wds_encryp_type: %s<br>\n"), wds_encryp_type);
	websWrite(wp, T("wds_encryp_key0: %s<br>\n"), wds_encryp_key0);
	websWrite(wp, T("wds_encryp_key1: %s<br>\n"), wds_encryp_key1);
	websWrite(wp, T("wds_encryp_key2: %s<br>\n"), wds_encryp_key2);
	websWrite(wp, T("wds_encryp_key3: %s<br>\n"), wds_encryp_key3);
	websWrite(wp, T("wds_list: %s<br>\n"), wds_list);
	websFooter(wp);
	websDone(wp, 200);
}

/* goform/wirelessApcli */
static void wirelessApcli(webs_t wp, char_t *path, char_t *query)
{
	char_t	*ssid, *bssid, *mode, *enc, *wpapsk, *keyid, *keytype,
			*key1, *key2, *key3, *key4;

	//fetch from web input
	ssid = websGetVar(wp, T("apcli_ssid"), T(""));
	bssid = websGetVar(wp, T("apcli_bssid"), T(""));
	mode = websGetVar(wp, T("apcli_mode"), T("OPEN"));
	enc = websGetVar(wp, T("apcli_enc"), T("NONE"));
	wpapsk = websGetVar(wp, T("apcli_wpapsk"), T("12345678"));
	keyid = websGetVar(wp, T("apcli_default_key"), T("1"));
	keytype = websGetVar(wp, T("apcli_key1type"), T("1"));
	key1 = websGetVar(wp, T("apcli_key1"), T(""));
	key2 = websGetVar(wp, T("apcli_key2"), T(""));
	key3 = websGetVar(wp, T("apcli_key3"), T(""));
	key4 = websGetVar(wp, T("apcli_key4"), T(""));

	if (gstrlen(ssid) == 0) {
		websError(wp, 200, "SSID is empty");
		return;
	}

	nvram_bufset(RT2860_NVRAM, "ApCliEnable", "1");
	nvram_bufset(RT2860_NVRAM, "ApCliSsid", ssid);
	nvram_bufset(RT2860_NVRAM, "ApCliBssid", bssid);
	nvram_bufset(RT2860_NVRAM, "ApCliAuthMode", mode);
	nvram_bufset(RT2860_NVRAM, "ApCliEncrypType", enc);
	nvram_bufset(RT2860_NVRAM, "ApCliWPAPSK", wpapsk);
	nvram_bufset(RT2860_NVRAM, "ApCliDefaultKeyId", keyid);
	nvram_bufset(RT2860_NVRAM, "ApCliKey1Type", keytype);
	nvram_bufset(RT2860_NVRAM, "ApCliKey1Str", key1);
	nvram_bufset(RT2860_NVRAM, "ApCliKey2Type", keytype);
	nvram_bufset(RT2860_NVRAM, "ApCliKey2Str", key2);
	nvram_bufset(RT2860_NVRAM, "ApCliKey3Type", keytype);
	nvram_bufset(RT2860_NVRAM, "ApCliKey3Str", key3);
	nvram_bufset(RT2860_NVRAM, "ApCliKey4Type", keytype);
	nvram_bufset(RT2860_NVRAM, "ApCliKey4Str", key4);
	nvram_commit(RT2860_NVRAM);
	initInternet("wirelessApcli");

	//debug print
	websHeader(wp);
	websWrite(wp, T("ssid: %s<br>\n"), ssid);
	websWrite(wp, T("bssid: %s<br>\n"), bssid);
	websWrite(wp, T("mode: %s<br>\n"), mode);
	websWrite(wp, T("enc: %s<br>\n"), enc);
	if (!strcmp(mode, "WPAPSK") || !strcmp(mode, "WPA2PSK")) {
		websWrite(wp, T("wpapsk: %s<br>\n"), wpapsk);
	}
	if (!strcmp(mode, "OPEN") || !strcmp(mode, "SHARED")) {
		websWrite(wp, T("keyid: %s<br>\n"), keyid);
		websWrite(wp, T("keytype: %s<br>\n"), keytype);
		websWrite(wp, T("key1: %s<br>\n"), key1);
		websWrite(wp, T("key2: %s<br>\n"), key2);
		websWrite(wp, T("key3: %s<br>\n"), key3);
		websWrite(wp, T("key4: %s<br>\n"), key4);
	}
	websFooter(wp);
	websDone(wp, 200);
}

void WPSRestart(void);

/* goform/wirelessWmm */
static void wirelessWmm(webs_t wp, char_t *path, char_t *query)
{
	char_t	*ap_aifsn_all, *ap_cwmin_all, *ap_cwmax_all, *ap_txop_all,
			*ap_acm_all, *ap_ackpolicy_all,
			*sta_aifsn_all, *sta_cwmin_all, *sta_cwmax_all, *sta_txop_all,
			*sta_acm_all;
	//Add for create WDS interface - Ricky Cao on 11 Jan. 2008
	char *wds_enabled = nvram_bufget(RT2860_NVRAM, "WdsEnable");
	char *wds_list = nvram_bufget(RT2860_NVRAM, "WdsList");
	int wds_link_num = 0, wds_list_len = strlen(wds_list), c=0;
	//Ricky Cao on 11 Jan. 2008

	ap_aifsn_all = websGetVar(wp, T("ap_aifsn_all"), T(""));
	ap_cwmin_all = websGetVar(wp, T("ap_cwmin_all"), T(""));
	ap_cwmax_all = websGetVar(wp, T("ap_cwmax_all"), T(""));
	ap_txop_all = websGetVar(wp, T("ap_txop_all"), T(""));
	ap_acm_all = websGetVar(wp, T("ap_acm_all"), T(""));
	ap_ackpolicy_all = websGetVar(wp, T("ap_ackpolicy_all"), T(""));
	sta_aifsn_all = websGetVar(wp, T("sta_aifsn_all"), T(""));
	sta_cwmin_all = websGetVar(wp, T("sta_cwmin_all"), T(""));
	sta_cwmax_all = websGetVar(wp, T("sta_cwmax_all"), T(""));
	sta_txop_all = websGetVar(wp, T("sta_txop_all"), T(""));
	sta_acm_all = websGetVar(wp, T("sta_acm_all"), T(""));

	if (0 != strlen(ap_aifsn_all))
		nvram_bufset(RT2860_NVRAM, "APAifsn", ap_aifsn_all);
	if (0 != strlen(ap_cwmin_all))
		nvram_bufset(RT2860_NVRAM, "APCwmin", ap_cwmin_all);
	if (0 != strlen(ap_cwmax_all))
		nvram_bufset(RT2860_NVRAM, "APCwmax", ap_cwmax_all);
	if (0 != strlen(ap_txop_all))
		nvram_bufset(RT2860_NVRAM, "APTxop", ap_txop_all);
	if (0 != strlen(ap_acm_all))
		nvram_bufset(RT2860_NVRAM, "APACM", ap_acm_all);
	if (0 != strlen(ap_ackpolicy_all))
		nvram_bufset(RT2860_NVRAM, "AckPolicy", ap_ackpolicy_all);
	if (0 != strlen(sta_aifsn_all))
		nvram_bufset(RT2860_NVRAM, "BSSAifsn", sta_aifsn_all);
	if (0 != strlen(sta_cwmin_all))
		nvram_bufset(RT2860_NVRAM, "BSSCwmin", sta_cwmin_all);
	if (0 != strlen(sta_cwmax_all))
		nvram_bufset(RT2860_NVRAM, "BSSCwmax", sta_cwmax_all);
	if (0 != strlen(sta_txop_all))
		nvram_bufset(RT2860_NVRAM, "BSSTxop", sta_txop_all);
	if (0 != strlen(sta_acm_all))
		nvram_bufset(RT2860_NVRAM, "BSSACM", sta_acm_all);

	nvram_commit(RT2860_NVRAM);

	doSystem("ifconfig ra0 down");
	doSystem("ralink_init make_wireless_config rt2860");
	doSystem("ifconfig ra0 up");
	//after ra0 down&up we must restore WPS status
	//Add for create WDS interface - Ricky Cao on 11 Jan. 2008
	//Jacky.Yang 28-Feb-2008, disalbe in SDK 2.3.0.0
	/* 
	if(strcmp(wds_enabled, "0")){
		if(wds_list_len>0){
			wds_link_num++;
		}
		for(c=0; c<wds_list_len; c++){
			if(wds_list[c] == ';'){
				wds_link_num++;
			}
		}
		if(wds_link_num == 1){
			doSystem("ifconfig wds0 up");
			doSystem("ifconfig wds1 down");
			doSystem("ifconfig wds2 down");
			doSystem("ifconfig wds3 down");
		}else if(wds_link_num == 2){
			doSystem("ifconfig wds0 up");
			doSystem("ifconfig wds1 up");
			doSystem("ifconfig wds2 down");
			doSystem("ifconfig wds3 down");
		}else if(wds_link_num == 3){
			doSystem("ifconfig wds0 up");
			doSystem("ifconfig wds1 up");
			doSystem("ifconfig wds2 up");
			doSystem("ifconfig wds3 down");
		}else{
			doSystem("ifconfig wds0 up");
			doSystem("ifconfig wds1 up");
			doSystem("ifconfig wds2 up");
			doSystem("ifconfig wds3 up");
		}
	}
	*/
	//Ricky Cao on 11 Jan. 2008
	WPSRestart();

	websHeader(wp);
	websWrite(wp, T("ap_aifsn_all: %s<br>\n"), ap_aifsn_all);
	websWrite(wp, T("ap_cwmin_all: %s<br>\n"), ap_cwmin_all);
	websWrite(wp, T("ap_cwmax_all: %s<br>\n"), ap_cwmax_all);
	websWrite(wp, T("ap_txop_all: %s<br>\n"), ap_txop_all);
	websWrite(wp, T("ap_acm_all: %s<br>\n"), ap_acm_all);
	websWrite(wp, T("ap_ackpolicy_all: %s<br>\n"), ap_ackpolicy_all);
	websWrite(wp, T("sta_aifsn_all: %s<br>\n"), sta_aifsn_all);
	websWrite(wp, T("sta_cwmin_all: %s<br>\n"), sta_cwmin_all);
	websWrite(wp, T("sta_cwmax_all: %s<br>\n"), sta_cwmax_all);
	websWrite(wp, T("sta_txop_all: %s<br>\n"), sta_txop_all);
	websWrite(wp, T("sta_acm_all: %s<br>\n"), sta_acm_all);
	websFooter(wp);
	websDone(wp, 200);
}

void restart8021XDaemon(int nvram)
{
	int i, num, apd_flag = 0;
	char *auth_mode = nvram_bufget(nvram, "AuthMode");
	char *ieee8021x = nvram_bufget(nvram, "IEEE8021X");
	char *num_s = nvram_bufget(nvram, "BssidNum");
	if(!num_s)
		return;
	num = atoi(num_s);

	if(nvram == RT2860_NVRAM)
		doSystem("killall rt2860apd 1>/dev/null 2>&1");
	else if(nvram == RTINIC_NVRAM)
		doSystem("killall rtinicapd 1>/dev/null 2>&1");
	else if(nvram == RT2561_NVRAM)
		doSystem("killall rt61apd 1>/dev/null 2>&1");
	
	/*
	 * In fact we only support mbssid[0] to use 802.1x radius settings.
	 */
	for(i=0; i<num; i++){
		char tmp_auth[128];
		if( getNthValueSafe(i, auth_mode, ';', tmp_auth, 128) != -1){
			if(!strcmp(tmp_auth, "WPA") || !strcmp(tmp_auth, "WPA2") || !strcmp(tmp_auth, "WPA1WPA2")){
				apd_flag = 1;
				break;
			}
		}

		if( getNthValueSafe(i, ieee8021x, ';', tmp_auth, 128) != -1){
			if(!strcmp(tmp_auth, "1")){
				apd_flag = 1;
				break;
			}
		}
	}

	if(apd_flag){
		if(nvram == RT2860_NVRAM)
			doSystem("rt2860apd");	
		else if(nvram == RTINIC_NVRAM)
			doSystem("rtinicapd");
		else if(nvram == RT2561_NVRAM)
			doSystem("rt61apd");
	}
}


/* LFF means "Load From Flash" ...*/
#define LFF(result, nvram, x, n)	\
							do{		char tmp[128];										\
									if(! ( x  = nvram_bufget(nvram, #x)) )				\
										tmp[0] = '\0';									\
									else{												\
										if( getNthValueSafe(n, x, ';', tmp, 128) != -1){\
											gstrncat(result, tmp, 4096);				\
										}												\
									}gstrncat(result, "\r", 4096);						\
							}while(0)

/* Load from Web */
#define LFW(x, y)	do{												\
						if(! ( x = websGetVar(wp, T(#y), T(""))))	\
							return;									\
					}while(0)

void getSecurity(int nvram, webs_t wp, char_t *path, char_t *query)
{
	int num_ssid, i;
	char *num_s = nvram_bufget(nvram, "BssidNum");
	char_t result[4096];
	
	char_t *PreAuth, *AuthMode, *EncrypType, *DefaultKeyID, *Key1Type, *Key2Type,
		   *Key3Type, *Key4Type, *RekeyMethod, *RekeyInterval, *PMKCachePeriod, *IEEE8021X;
	char_t *RADIUS_Server, *RADIUS_Port, *RADIUS_Key, *session_timeout_interval;

//	printf("***** nvram = %d\n", nvram);

	if(num_s)
		num_ssid = atoi(num_s);
	else
		num_ssid = 1;

	result[0] = '\0';

	// deal with shown MBSSID
	if(default_shown_mbssid[nvram] > atoi(num_s))
		default_shown_mbssid[nvram] = 0;
	sprintf(result, "%d\n",  default_shown_mbssid[nvram]);

	if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)) {
		for(i=0; i<num_ssid; i++) {
			//LFF(result, nvram, SSID, i);
			gstrncat(result, nvram_bufget(nvram, racat("SSID", i+1)), 4096);
			gstrncat(result, "\r", 4096);
			LFF(result, nvram, PreAuth, i);
			LFF(result, nvram, AuthMode, i);
			LFF(result, nvram, EncrypType, i);
			LFF(result, nvram, DefaultKeyID, i);
			LFF(result, nvram, Key1Type, i);
			//LFF(result, nvram, Key1Str, i);
			gstrncat(result, nvram_bufget(nvram, racat("Key1Str", i+1)), 4096);
			gstrncat(result, "\r", 4096);
			LFF(result, nvram, Key2Type, i);
			//LFF(result, nvram, Key2Str, i);
			gstrncat(result, nvram_bufget(nvram, racat("Key2Str", i+1)), 4096);
			gstrncat(result, "\r", 4096);
			LFF(result, nvram, Key3Type, i);
			//LFF(result, nvram, Key3Str, i);
			gstrncat(result, nvram_bufget(nvram, racat("Key3Str", i+1)), 4096);
			gstrncat(result, "\r", 4096);
			LFF(result, nvram, Key4Type, i);
			//LFF(result, nvram, Key4Str, i);
			gstrncat(result, nvram_bufget(nvram, racat("Key4Str", i+1)), 4096);
			gstrncat(result, "\r", 4096);
			//LFF(result, nvram, WPAPSK, i);
			gstrncat(result, nvram_bufget(nvram, racat("WPAPSK", i+1)), 4096);
			gstrncat(result, "\r", 4096);

			LFF(result, nvram, RekeyMethod, i);
			LFF(result, nvram, RekeyInterval, i);
			LFF(result, nvram, PMKCachePeriod, i);
			LFF(result, nvram, IEEE8021X, i);
			LFF(result, nvram, RADIUS_Server, i);
			LFF(result, nvram, RADIUS_Port, i);
			LFF(result, nvram, RADIUS_Key, i);
			LFF(result, nvram, session_timeout_interval, i);

			// access control related.
			gstrncat(result, nvram_bufget(nvram, racat("AccessPolicy", i)), 4096);
			gstrncat(result, "\r", 4096);
			gstrncat(result, nvram_bufget(nvram, racat("AccessControlList", i)), 4096);
			gstrncat(result, "\r", 4096);
			gstrncat(result, "\n", 4096);
		}
	} else if (RT2561_NVRAM == nvram) {
		char_t *SSID, *Key1Str, *Key2Str, *Key3Str, *Key4Str, *WPAPSK;
		for(i=0; i<num_ssid; i++) {
			LFF(result, nvram, SSID, i);
			LFF(result, nvram, PreAuth, i);
			LFF(result, nvram, AuthMode, i);
			LFF(result, nvram, EncrypType, i);
			LFF(result, nvram, DefaultKeyID, i);
			LFF(result, nvram, Key1Type, i);
			LFF(result, nvram, Key1Str, i);
			LFF(result, nvram, Key2Type, i);
			LFF(result, nvram, Key2Str, i);
			LFF(result, nvram, Key3Type, i);
			LFF(result, nvram, Key3Str, i);
			LFF(result, nvram, Key4Type, i);
			LFF(result, nvram, Key4Str, i);
			LFF(result, nvram, WPAPSK, i);
			LFF(result, nvram, RekeyMethod, i);
			LFF(result, nvram, RekeyInterval, i);
			LFF(result, nvram, PMKCachePeriod, i);
			LFF(result, nvram, IEEE8021X, i);
			LFF(result, nvram, RADIUS_Server, i);
			LFF(result, nvram, RADIUS_Port, i);
			LFF(result, nvram, RADIUS_Key, i);
			LFF(result, nvram, session_timeout_interval, i);
			gstrncat(result, "\n", 4096);

		/* access control related.
		   gstrncat(result, nvram_bufget(nvram, racat("AccessPolicy", i)), 4096);
		   gstrncat(result, "\r", 4096);
		   gstrncat(result, nvram_bufget(nvram, racat("AccessControlList", i)), 4096);
		   gstrncat(result, "\r", 4096);
		*/
		}
	}

	websWrite(wp, T("HTTP/1.1 200 OK\nContent-type: text/plain\nPragma: no-cache\nCache-Control: no-cache\n\n"));
	websWrite(wp, T("%s"), result);
	websDone(wp, 200);

}

static void wirelessGetSecurity(webs_t wp, char_t *path, char_t *query)
{
	return getSecurity(RT2860_NVRAM, wp, path, query);
}

/*
 *   TODO:   move to util.c?
 */
static void STFs(int nvram, int index, char *flash_key, char *value)
{
	char *result;
	char *tmp = nvram_bufget(nvram, flash_key);
	if(!tmp)
		tmp = "";
	result = setNthValue(index, tmp, value);
	nvram_bufset(nvram, flash_key, result);
	return ;
}


#define STF(nvram, index, flash_key)	STFs(nvram, index, #flash_key, flash_key)

void updateFlash8021x(int nvram)
{
	char lan_if_addr[16];
	char *RADIUS_Server;
	char *operation_mode;

	// if(! (operation_mode = nvram_bufget(nvram, "OperationMode")))
	if(! (operation_mode = nvram_bufget(RT2860_NVRAM, "OperationMode")))
		return;

	if(! (RADIUS_Server = nvram_bufget(nvram, "RADIUS_Server")))
		return;

	if(!strlen(RADIUS_Server))
		return;

	if(*operation_mode == '0'){ // Bridge
		if (getIfIp(getLanIfName(), lan_if_addr) == -1)
			return;
		nvram_bufset(nvram, "own_ip_addr", lan_if_addr);
		if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)) {
			nvram_bufset(nvram, "EAPifname", getLanIfName());
			nvram_bufset(nvram, "PreAuthifname", getLanIfName());
		} else if (RT2561_NVRAM == nvram)
			nvram_bufset(nvram, "Ethifname", getLanIfName());
	}else if(*operation_mode == '1'){	// Gateway
		if (getIfIp(getLanIfName(), lan_if_addr) == -1)
			return;
		nvram_bufset(nvram, "own_ip_addr", lan_if_addr);
		if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)) {
			nvram_bufset(nvram, "EAPifname", getLanIfName());
			nvram_bufset(nvram, "PreAuthifname", getLanIfName());
		} else if (RT2561_NVRAM == nvram)
			nvram_bufset(nvram, "Ethifname", getLanIfName());
	}else if(*operation_mode == '2'){	// Wireless gateway
		if (getIfIp(getLanIfName(), lan_if_addr) == -1)
			return;
		nvram_bufset(nvram, "own_ip_addr", lan_if_addr);
		if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)) {
			nvram_bufset(nvram, "EAPifname", getLanIfName());
			nvram_bufset(nvram, "PreAuthifname", getLanIfName());
		} else if (RT2561_NVRAM == nvram)
			nvram_bufset(nvram, "Ethifname", getLanIfName());
	}else{
		printf("not op mode\n");
		return;
	}
	nvram_commit(nvram);
}


int AccessPolicyHandle(int nvram, webs_t wp, int mbssid)
{
	char_t *apselect, *newap_list;
	char str[32];
	char ap_list[2048];

	if(mbssid > 8 || mbssid < 0) {
		return -1;
	}

	sprintf(str, "apselect_%d", mbssid);	// UI on web page
	apselect = websGetVar(wp, str, T(""));
	if(!apselect){
		printf("cant find %s\n", apselect);
		return -1;
	}

	sprintf(str, "AccessPolicy%d", mbssid);
	nvram_bufset(nvram, str, apselect);

	sprintf(str, "newap_text_%d", mbssid);
	newap_list = websGetVar(wp, str, T(""));
	if(!newap_list) {
		return -1;
	}
	if(!gstrlen(newap_list))
		return 0;
	sprintf(str, "AccessControlList%d", mbssid);
	sprintf(ap_list, "%s", nvram_bufget(nvram, str));
	if(strlen(ap_list))
		sprintf(ap_list, "%s;%s", ap_list, newap_list);
	else
		sprintf(ap_list, "%s", newap_list);

	nvram_bufset(nvram, str, ap_list);
	return 0;
}



void conf8021x(int nvram, webs_t wp, int mbssid)
{
	char_t *RadiusServerIP, *RadiusServerPort, *RadiusServerSecret, *RadiusServerSessionTimeout;//, *RadiusServerIdleTimeout;

	LFW(RadiusServerIP, RadiusServerIP);
	LFW(RadiusServerPort, RadiusServerPort);
	LFW(RadiusServerSecret, RadiusServerSecret);
	LFW(RadiusServerSessionTimeout, RadiusServerSessionTimeout);
	//LFW(RadiusServerIdleTimeout, RadiusServerIdleTimeout);
	if(!gstrlen(RadiusServerSessionTimeout))
		RadiusServerSessionTimeout = "0";

	STFs(nvram, mbssid, "RADIUS_Server", RadiusServerIP);
	STFs(nvram, mbssid, "RADIUS_Port", RadiusServerPort);
	STFs(nvram, mbssid, "RADIUS_Key", RadiusServerSecret);
	STFs(nvram, mbssid, "session_timeout_interval", RadiusServerSessionTimeout);

	updateFlash8021x(nvram);
	restart8021XDaemon(nvram);
}

void confWEP(int nvram, webs_t wp, int mbssid)
{
	char_t *DefaultKeyID, *Key1Type, *Key1Str, *Key2Type, *Key2Str, *Key3Type, *Key3Str, *Key4Type, *Key4Str;

	LFW(DefaultKeyID, wep_default_key);
	LFW(Key1Str, wep_key_1);
	LFW(Key2Str, wep_key_2);
	LFW(Key3Str, wep_key_3);
	LFW(Key4Str, wep_key_4);
	LFW(Key1Type, WEP1Select);
	LFW(Key2Type, WEP2Select);
	LFW(Key3Type, WEP3Select);
	LFW(Key4Type, WEP4Select);

	STF(nvram, mbssid, DefaultKeyID);
	STF(nvram, mbssid, Key1Type);
	STF(nvram, mbssid, Key2Type);
	STF(nvram, mbssid, Key3Type);
	STF(nvram, mbssid, Key4Type);
	if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)){
		nvram_bufset(nvram, racat("Key1Str", mbssid+1), Key1Str);
		nvram_bufset(nvram, racat("Key2Str", mbssid+1), Key2Str);
		nvram_bufset(nvram, racat("Key3Str", mbssid+1), Key3Str);
		nvram_bufset(nvram, racat("Key4Str", mbssid+1), Key4Str);
	} else if (RT2561_NVRAM == nvram) {
		// nvram_bufset(nvram, "Key1Str", Key1Str);
		// nvram_bufset(nvram, "Key2Str", Key2Str);
		// nvram_bufset(nvram, "Key3Str", Key3Str);
		// nvram_bufset(nvram, "Key4Str", Key4Str);
		STF(nvram, mbssid, Key1Str);
		STF(nvram, mbssid, Key2Str);
		STF(nvram, mbssid, Key3Str);
		STF(nvram, mbssid, Key4Str);
	}
}

void confWPAGeneral(int nvram, webs_t wp, int mbssid)
{
	char *cipher_str;
	char *key_renewal_interval;
	//Jacky.Yang 27-Oct-2008, for WDS secuirty setting.
	char *wdsEnable = nvram_bufget(RT2860_NVRAM, "WdsEnable");

	LFW(cipher_str, cipher);
	LFW(key_renewal_interval, keyRenewalInterval);

	STFs(nvram, mbssid, "RekeyInterval", key_renewal_interval);

	switch(cipher_str[0]){
	case '0':
		STFs(nvram, mbssid, "EncrypType", "TKIP");
		//Jacky.Yang 27-Oct-2008, for WDS secuirty setting.
		//if (atoi(wdsEnable) > 0)
			STFs(nvram, mbssid, "WdsEncrypType", "TKIP");
		break;
	case '1':
		STFs(nvram, mbssid, "EncrypType", "AES");
		//Jacky.Yang 27-Oct-2008, for WDS secuirty setting.
		//if (atoi(wdsEnable) > 0)
			STFs(nvram, mbssid, "WdsEncrypType", "AES");
		break;
	case '2':
		STFs(nvram, mbssid, "EncrypType", "TKIPAES");
		return;							// there is no tkip-aes mixed mode in WPA-PSK.
	}
	STFs(nvram, mbssid, "DefaultKeyID", "1");	// DefaultKeyID is 1
	STFs(nvram, mbssid, "RekeyInterval", key_renewal_interval);
	STFs(nvram, mbssid, "RekeyMethod", "TIME");		
	STFs(nvram, mbssid, "IEEE8021X", "0");
}

inline void clearRadiusSetting(int nvram, int mbssid)
{
	char *RADIUS_Server, *RADIUS_Port, *RADIUS_Key;
	//char *session_timeout_interval = NULL;

	RADIUS_Server = nvram_bufget(nvram, "RADIUS_Server");
	RADIUS_Port = nvram_bufget(nvram, "RADIUS_Port");
	RADIUS_Key = nvram_bufget(nvram, "RADIUS_Key");
	//session_timeout_interval = nvram_bufget(nvram, "session_timeout_interval");

	nvram_bufset(nvram, "RADIUS_Server", setNthValue(mbssid, RADIUS_Server, "0"));
	nvram_bufset(nvram, "RADIUS_Port", setNthValue(mbssid, RADIUS_Port, "1812"));
	nvram_bufset(nvram, "RADIUS_Key", setNthValue(mbssid, RADIUS_Key, ""));
	//nvram_bufset(nvram, "session_timeout_interval", setNthValue(mbssid, session_timeout_interval, ""));
            
	return;
}


void Security(int nvram, webs_t wp, char_t *path, char_t *query)
{
	char_t *SSID;
	int mbssid, mbssid_num, i;
	char_t *security_mode;
	
	//Jacky.Yang 27-Oct-2008, for WDS secuirty setting.
	char *wdsEnable = nvram_bufget(RT2860_NVRAM, "WdsEnable");

	LFW(SSID, ssidIndex);
	if(!gstrlen(SSID))
		return;

	mbssid = atoi(SSID);

	default_shown_mbssid[nvram] = mbssid;

	LFW(security_mode, security_mode);

#ifndef CONFIG_RALINK_RT2880
	// RT2880: GPIO13 is belong to WPS PBC indicator.

	if (!strcmp(security_mode, "Disable") || !strcmp(security_mode, "OPEN"))
		ledAlways(13, LED_OFF); //turn off security LED (gpio 13)
	else
		ledAlways(13, LED_ON); //turn on security LED (gpio 13)

#endif

	//clear Radius settings
	clearRadiusSetting(nvram, mbssid);

	if( !strcmp(security_mode, "Disable")){			// !------------------       Disable Mode --------------
		STFs(nvram, mbssid, "AuthMode", "OPEN");
		STFs(nvram, mbssid, "EncrypType", "NONE");
		STFs(nvram, mbssid, "IEEE8021X", "0");
		//Jacky.Yang 27-Oct-2008, for WDS
		STFs(nvram, mbssid, "WdsEncrypType", "NONE");
	}else if( !strcmp(security_mode, "OPEN")){		// !------------------       Open Mode ----------------
		confWEP(nvram, wp, mbssid);
		STFs(nvram, mbssid, "AuthMode", security_mode);
		STFs(nvram, mbssid, "EncrypType", "WEP");
		STFs(nvram, mbssid, "IEEE8021X", "0");
		//Jacky.Yang 27-Oct-2008, for WDS
		STFs(nvram, mbssid, "WdsEncrypType", "WEP");
	}else if( !strcmp(security_mode, "SHARED")){	// !------------------       Shared Mode ----------------
		char *security_shared_mode;
		confWEP(nvram, wp, mbssid);

		LFW(security_shared_mode, security_shared_mode);

		STFs(nvram, mbssid, "AuthMode", security_mode);
		if(!strcmp(security_shared_mode, "None"))
			STFs(nvram, mbssid, "EncrypType", "NONE");
		else
			STFs(nvram, mbssid, "EncrypType", "WEP");

		STFs(nvram, mbssid, "IEEE8021X", "0");
		//Jacky.Yang 27-Oct-2008, for WDS
		STFs(nvram, mbssid, "WdsEncrypType", "WEP");
	}else if( !strcmp(security_mode, "WEPAUTO")){ // !------------------       WEP Auto Mode ----------------
		confWEP(nvram, wp, mbssid);
		STFs(nvram, mbssid, "AuthMode", security_mode);
		STFs(nvram, mbssid, "EncrypType", "WEP");
		STFs(nvram, mbssid, "IEEE8021X", "0");
	}else if(	!strcmp(security_mode, "WPA") ||  
				!strcmp(security_mode, "WPA1WPA2") ){	// !------------------		WPA Enterprise Mode ----------------
		conf8021x(nvram, wp, mbssid);							// !------------------		WPA1WPA2 mixed mode
		confWPAGeneral(nvram, wp, mbssid);

		STFs(nvram, mbssid, "AuthMode", security_mode);
		STFs(nvram, mbssid, "IEEE8021X", "0");
	}else if( !strcmp(security_mode, "WPAPSK")){ // !------------------       WPA Personal Mode ----------------
		char *pass_phrase_str;

		confWPAGeneral(nvram, wp, mbssid);

		LFW(pass_phrase_str, passphrase);

		STFs(nvram, mbssid, "AuthMode", security_mode);
		STFs(nvram, mbssid, "IEEE8021X", "0");

		if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)){
			nvram_bufset(nvram, racat("WPAPSK", mbssid+1), pass_phrase_str);
			//Jacky.Yang 27-Oct-2008, for WDS
			nvram_bufset(nvram, "WdsKey", pass_phrase_str);
		} else if (RT2561_NVRAM == nvram) {
			// nvram_bufset(nvram, "WPAPSK", pass_phrase_str);
			STFs(nvram, mbssid, "WPAPSK", pass_phrase_str);
		}
	}else if( !strcmp(security_mode, "WPA2")){		// !------------------  WPA2 Enterprise Mode ----------------
		char *pass_phrase_str;
		char *PMKCachePeriod;
		char *PreAuth;

		conf8021x(nvram, wp, mbssid);
		confWPAGeneral(nvram, wp, mbssid);

		LFW(pass_phrase_str, passphrase);
		LFW(PMKCachePeriod, PMKCachePeriod);
		LFW(PreAuth, PreAuthentication);

		STFs(nvram, mbssid, "AuthMode", security_mode);
		STFs(nvram, mbssid, "IEEE8021X", "0");
		if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)){
			nvram_bufset(nvram, racat("WPAPSK", mbssid+1), pass_phrase_str);
		} else if (RT2561_NVRAM == nvram) {
			// nvram_bufset(nvram, "WPAPSK", pass_phrase_str);
			STFs(nvram, mbssid, "WPAPSK", pass_phrase_str);
		}
		STF(nvram, mbssid, PMKCachePeriod);
		STF(nvram, mbssid, PreAuth);
	}else if(	!strcmp(security_mode, "WPA2PSK") ||	// !------------------  WPA2 Personal Mode ----------------
				!strcmp(security_mode, "WPAPSKWPA2PSK") ){ 	//! -------------   WPA PSK WPA2 PSK mixed
		char *pass_phrase_str;

		confWPAGeneral(nvram, wp, mbssid);
		LFW(pass_phrase_str, passphrase);

		STFs(nvram, mbssid, "AuthMode", security_mode);
		STFs(nvram, mbssid, "IEEE8021X", "0");

		if ((RT2860_NVRAM == nvram) || (RTINIC_NVRAM == nvram)) {
			nvram_bufset(nvram, racat("WPAPSK", mbssid+1), pass_phrase_str);
			//Jacky.Yang 27-Oct-2008, for WDS
			nvram_bufset(nvram, "WdsKey", pass_phrase_str);
		} else if (RT2561_NVRAM == nvram) {
			// nvram_bufset(nvram, "WPAPSK", pass_phrase_str);
			STFs(nvram, mbssid, "WPAPSK", pass_phrase_str);
		}
	}else if( !strcmp(security_mode, "IEEE8021X")){	// !------------------ 802.1X WEP Mode ----------------
		char *ieee8021x_wep;

		conf8021x(nvram, wp, mbssid);
		STFs(nvram, mbssid, "IEEE8021X", "1");
		STFs(nvram, mbssid, "AuthMode", "OPEN");

		LFW(ieee8021x_wep, ieee8021x_wep);
		if(ieee8021x_wep[0] == '0')
			STFs(nvram, mbssid, "EncrypType", "NONE");
		else
			STFs(nvram, mbssid, "EncrypType", "WEP");
	}else{
		return;
	}

//# Access Policy
	if(AccessPolicyHandle(nvram, wp, mbssid) == -1)
		printf("Invalid policy\n");
		
//# WPS
	{
		if((nvram == RT2860_NVRAM) && (mbssid == 0)){		// only ra0 supports WPS now.
			char *wordlist= nvram_bufget(RT2860_NVRAM, "WscModeOption");
			if(wordlist){
				if (strcmp(wordlist, "0"))
					doSystem("iwpriv ra0 set WscConfStatus=1");
				nvram_bufset(RT2860_NVRAM, "WscConfigured", "1");
				g_wsc_configured = 1;
			}
		}
	}
//# WPS

	nvram_commit(nvram);

	/*
	 *  TODO: move to inic.c
	 */
	mbssid_num = atoi(nvram_bufget(nvram, "BssidNum"));
	if(nvram == RT2860_NVRAM){
		doSystem("ralink_init make_wireless_config rt2860");
		for(i=0; i<mbssid_num; i++){
			doSystem("ifconfig ra%d down", i);
		}
		for(i=0; i<mbssid_num; i++){
			doSystem("ifconfig ra%d up", i);
		}
		WPSRestart();
	}else if(nvram == RTINIC_NVRAM){
		doSystem("ralink_init make_wireless_config inic");
		for(i=0; i<mbssid_num; i++){
			doSystem("ifconfig rai%d down", i);
			doSystem("ifconfig rai%d up", i);
		}
		// WPSRestart();
	} else if(nvram == RT2561_NVRAM) {
		doSystem("ralink_init make_wireless_config rt2561");
		for(i=0; i<mbssid_num; i++){
			doSystem("ifconfig raL%d down", i);
			doSystem("ifconfig raL%d up", i);
		}
		// WPSRestart();
	}else
		printf("*** Unknown interface.\n");

	restart8021XDaemon(nvram);
	
	//Jacky.Yang 27-Oct-2008, for WDS secuirty setting.
	if (atoi(wdsEnable) != 0)
		initInternet("wdsEnable");
	//websRedirect(wp, "/wireless/security.asp");
	websRedirect(wp, "/applied2.asp?url=/wireless/security.asp");
}

static void APSecurity(webs_t wp, char_t *path, char_t *query)
{
	Security(RT2860_NVRAM, wp, path, query);
}


void DeleteAccessPolicyList(int nvram, webs_t wp, char_t *path, char_t *query)
{
	int mbssid, aplist_num;
	char str[32], apl[64*20], *tmp;
	sscanf(query, "%d,%d", &mbssid, &aplist_num);

	sprintf(str, "AccessControlList%d", mbssid);
	if(!(tmp = nvram_bufget(nvram, str)))
		return;
	strcpy(apl, tmp);

	deleteNthValueMulti(&aplist_num, 1, apl, ';');

	nvram_bufset(nvram, str, apl);

	default_shown_mbssid[nvram] = mbssid;

	websWrite(wp, T("HTTP/1.1 200 OK\nContent-type: text/plain\nPragma: no-cache\nCache-Control: no-cache\n\n"));
	websWrite(wp, T("ok done"));
	websDone(wp, 200);
	
}

static void APDeleteAccessPolicyList(webs_t wp, char_t *path, char_t *query)
{
	DeleteAccessPolicyList(RT2860_NVRAM, wp, path, query);
}

#ifdef CONFIG_RT2860V2_AP_MESH
/* goform/wirelessMesh */
static void wirelessMesh(webs_t wp, char_t *path, char_t *query)
{
	char_t	*meshenable, *mid, *hostname;
	char_t	*autolink;
	char_t	*mode, *encrypt_type, *wepkey, *wep_select, *wpakey;
	char defaultkey[2];

	//fetch from web input
	meshenable = websGetVar(wp, T("MeshEnable"), T("")); 
	mid = websGetVar(wp, T("MeshID"), T("")); 
	hostname = websGetVar(wp, T("HostName"), T("")); 
	autolink = websGetVar(wp, T("AutoLinkEnable"), T(""));
	mode = websGetVar(wp, T("security_mode"), T(""));
	strcpy(defaultkey, "");
	if (0 == strcmp(mode, "OPEN"))
	{
		encrypt_type = websGetVar(wp, T("open_encrypt_type"), T(""));
		if (0 == strcmp(encrypt_type, "WEP"))
			strcpy(defaultkey, "1");
	}
	else if (0 == strcmp(mode, "WPANONE"))
	{
		encrypt_type = websGetVar(wp, T("wpa_cipher"), T(""));
	}
	wepkey = websGetVar(wp, T("wep_key"), T(""));
	wep_select = websGetVar(wp, T("wep_select"), T(""));
	wpakey = websGetVar(wp, T("passphrase"), T(""));

	// store to flash
	nvram_bufset(RT2860_NVRAM, "MeshEnabled", meshenable);
	nvram_bufset(RT2860_NVRAM, "MeshId", mid);
	nvram_bufset(RT2860_NVRAM, "MeshHostName", hostname);
	nvram_bufset(RT2860_NVRAM, "MeshAutoLink", autolink);
	nvram_bufset(RT2860_NVRAM, "MeshAuthMode", mode);
	nvram_bufset(RT2860_NVRAM, "MeshEncrypType", encrypt_type);
	nvram_bufset(RT2860_NVRAM, "MeshDefaultkey", defaultkey);
	nvram_bufset(RT2860_NVRAM, "MeshWEPKEY", wepkey);
	nvram_bufset(RT2860_NVRAM, "MeshWEPKEYType", wep_select);
	nvram_bufset(RT2860_NVRAM, "MeshWPAKEY", wpakey);

	nvram_commit(RT2860_NVRAM);
	
	// restart network
	doSystem("internet.sh");

	// debug print
	websHeader(wp);
	websWrite(wp, T("MeshEnable: %s<br>\n"), meshenable);
	websWrite(wp, T("MeshID: %s<br>\n"), mid);
	websWrite(wp, T("HostName: %s<br>\n"), hostname);
	websWrite(wp, T("AutoLinkEnable: %s<br>\n"), autolink);
	websWrite(wp, T("security_mode: %s<br>\n"), mode);
	websWrite(wp, T("encrypt_type: %s<br>\n"), encrypt_type);
	websWrite(wp, T("defaultkey: %s<br>\n"), defaultkey);
	websWrite(wp, T("wep_key: %s<br>\n"), wepkey);
	websWrite(wp, T("wep_select: %s<br>\n"), wep_select);
	websWrite(wp, T("passphrase: %s<br>\n"), wpakey);
	websFooter(wp);
	websDone(wp, 200);
}

/* goform/meshManualLink */
static void meshManualLink(webs_t wp, char_t *path, char_t *query)
{
	char_t *action, *mpmac;

	// fetch from web input
	action = websGetVar(wp, T("link_action"), T(""));
	mpmac = websGetVar(wp, T("mpmac"), T(""));
	
	// link action
	if (0 == strcmp(action, "add"))
		doSystem("iwpriv mesh0 set MeshAddLink=%s", mpmac);
	if (0 == strcmp(action, "del"))
		doSystem("iwpriv mesh0 set MeshDelLink=%s", mpmac);
	sleep(1);

	websRedirect(wp, "wireless/mesh.asp");
}

typedef struct _MESH_NEIGHBOR_ENTRY_INFO {
	char			Rssi;
	unsigned char	HostName[32 + 1];
	unsigned char	MacAddr[6];
	unsigned char	MeshId[32 + 1];
	unsigned char	Channel;
	unsigned char	Status;
	unsigned char	MeshEncrypType;
} MESH_NEIGHBOR_ENTRY_INFO;

typedef struct _MESH_NEIGHBOR_INFO {
	MESH_NEIGHBOR_ENTRY_INFO	Entry[64];
	unsigned char				num;
} MESH_NEIGHBOR_INFO;

/* goform/ShowMeshState */
static int ShowMeshState(int eid, webs_t wp, int argc, char_t **argv)
{
	int socket_id, ret, i;
	struct iwreq wrq;
	MESH_NEIGHBOR_INFO *neighbor;

	if (NULL == (neighbor = (MESH_NEIGHBOR_INFO *) malloc(sizeof(MESH_NEIGHBOR_INFO))))
	{
		fprintf(stderr, "can't allocat memory in MESH_NEIGHBOR_INFO !\n");
		return -1;
	}
	memset(neighbor, 0, sizeof(MESH_NEIGHBOR_INFO));

	if ((socket_id = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
		fprintf(stderr, "ShowMeshState: open socket error !\n");
		websError(wp, 500, "ioctl sockey failed !");
		return -1;
	}

	strcpy(wrq.ifr_name, "mesh0");
	wrq.u.data.length = sizeof(MESH_NEIGHBOR_INFO);
	wrq.u.data.pointer = (caddr_t) neighbor;
	wrq.u.data.flags = OID_802_11_MESH_LIST;
	if ((ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq)) < 0)
	{
		fprintf(stderr, "ShowMeshState: ioctl -> OID_802_11_MESH_LIST error !\n");
		websError(wp, 500, "ioctl -> OID_802_11_MESH_LIST failed!");
		close(socket_id);
		return -1;
	}
	
	for(i=0;i<neighbor->num;i++)
	{
		websWrite(wp, T("<tr align=\"center\">"));
		if (1 == neighbor->Entry[i].Status)
			websWrite(wp, T("<td>%s</td>"), "<img src=\"/graphics/handshake.gif\">");
		else
			websWrite(wp, T("<td>%s</td>"), "<br />");
		websWrite(wp, T("<td>%02X:%02X:%02X:%02X:%02X:%02X</td>"), 
					  neighbor->Entry[i].MacAddr[0],
					  neighbor->Entry[i].MacAddr[1],
					  neighbor->Entry[i].MacAddr[2],
					  neighbor->Entry[i].MacAddr[3],
					  neighbor->Entry[i].MacAddr[4],
					  neighbor->Entry[i].MacAddr[5]);
		websWrite(wp, T("<td>%d</td>"), neighbor->Entry[i].Rssi);
		websWrite(wp, T("<td>%s</td>"), neighbor->Entry[i].MeshId);
		websWrite(wp, T("<td>%s</td>"), neighbor->Entry[i].HostName);
		websWrite(wp, T("<td>%d</td>"), neighbor->Entry[i].Channel);
		if (neighbor->Entry[i].MeshEncrypType == 1)
			websWrite(wp, T("<td>%s</td>"), "OPEN-WEP");
		else if (neighbor->Entry[i].MeshEncrypType == 2)
			websWrite(wp, T("<td>%s</td>"), "WPANONE-TKIP");
		else if (neighbor->Entry[i].MeshEncrypType == 3)
			websWrite(wp, T("<td>%s</td>"), "WPANONE-AES");
		else
			websWrite(wp, T("<td>%s</td>"), "OPEN-NONE");
		websWrite(wp, T("</tr>"));
	}
	close(socket_id);

	return 0;
}
#endif

static int is3t3r(int eid, webs_t wp, int argc, char_t **argv)
{
#ifdef CONFIG_RALINK_RT2883
		websWrite(wp, T("1"));
#else
		websWrite(wp, T("0"));	
#endif
	return 0;
}

static int isWPSConfiguredASP(int eid, webs_t wp, int argc, char_t **argv)
{
	if(g_wsc_configured){
		websWrite(wp, T("1"));
	}else
		websWrite(wp, T("0"));	
	return 0;
}

#ifdef CONFIG_RT2860V2_RT3XXX_AP_ANTENNA_DIVERSITY
void AntennaDiversityInit(void)
{
	char *mode = nvram_bufget(RT2860_NVRAM, "AntennaDiversity");

	if(!gstrcmp(mode, "Disable")){						// Disable
		doSystem("echo 0 > /proc/AntDiv/AD_RUN");
	}else if(!gstrcmp(mode, "Enable_Algorithm1")){
		doSystem("echo 1 > /proc/AntDiv/AD_ALGORITHM"); // Algorithm1
		doSystem("echo 1 > /proc/AntDiv/AD_RUN");
	}else if(!gstrcmp(mode, "Enable_Algorithm2")){
		doSystem("echo 2 > /proc/AntDiv/AD_ALGORITHM"); // Algorithm2
		doSystem("echo 1 > /proc/AntDiv/AD_RUN");
	}else if(!gstrcmp(mode, "Antenna0")){				// fix Ant0
		doSystem("echo 0 > /proc/AntDiv/AD_RUN");
		doSystem("echo 0 > /proc/AntDiv/AD_FORCE_ANTENNA");
	}else if(!gstrcmp(mode, "Antenna2")){				// fix Ant2
		doSystem("echo 0 > /proc/AntDiv/AD_RUN");
		doSystem("echo 2 > /proc/AntDiv/AD_FORCE_ANTENNA");
	}else{
		doSystem("echo 0 > /proc/AntDiv/AD_RUN");
	return;
}
	return;
}

static void AntennaDiversity(webs_t wp, char_t *path, char_t *query)
{
	char_t	*mode;

	mode = websGetVar(wp, T("ADSelect"), T(""));
	if(!mode || !strlen(mode))
		return;
	
	nvram_bufset(RT2860_NVRAM, "AntennaDiversity", mode);
	nvram_commit(RT2860_NVRAM);

	// re-init
	AntennaDiversityInit();

	//debug print
	websHeader(wp);
	websWrite(wp, T("mode:%s"), mode);
	websFooter(wp);
	websDone(wp, 200);	
}

static void getAntenna(webs_t wp, char_t *path, char_t *query)
{
	char buf[32];
	FILE *fp = fopen("/proc/AntDiv/AD_CHOSEN_ANTENNA", "r");
	if(!fp){
		strcmp(buf, "err");
	}else{
		fgets(buf, 32, fp);
		fclose(fp);
	}
	websWrite(wp, T("HTTP/1.1 200 OK\nContent-type: text/plain\nPragma: no-cache\nCache-Control: no-cache\n\n"));
	websWrite(wp, "%s", buf);
	websDone(wp, 200);
}

static int isAntennaDiversityBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
	websWrite(wp, T("1"));
	return 0;
}
#else
static int isAntennaDiversityBuilt(int eid, webs_t wp, int argc, char_t **argv)
{
	websWrite(wp, T("0"));
	return 0;
}
#endif

static int getWlanCurrentChannel(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp;
	char buf[32];
	
	fp = popen("iwgetid -c ra0 | sed -n 's/ra0//p' | sed -n 's/Channel://p'", "r");
	fgets(buf, sizeof(buf), fp);
	pclose(fp); //Add by Ricky Cao on 2008/11/12
	
	websWrite(wp, T("%d"), atoi(buf));
	//printf("Channel:%d\n", atoi(buf));
}

void formDefineWireless(void) {
	//websAspDefine(T("getWirelessMode"), getWirelessMode);
	websAspDefine(T("getWlan11aChannels"), getWlan11aChannels);
	websAspDefine(T("getWlan11bChannels"), getWlan11bChannels);
	websAspDefine(T("getWlan11gChannels"), getWlan11gChannels);
	websAspDefine(T("getWlanApcliBuilt"), getWlanApcliBuilt);
	websAspDefine(T("getWlanChannel"), getWlanChannel);
	websAspDefine(T("getWlanCurrentMac"), getWlanCurrentMac);
	websAspDefine(T("getWlanStaInfo"), getWlanStaInfo);
	websAspDefine(T("getDLSBuilt"), getDLSBuilt);
	websAspDefine(T("getDFSBuilt"), getDFSBuilt);
	websAspDefine(T("getCarrierBuilt"), getCarrierBuilt);
	websAspDefine(T("getWlanM2UBuilt"), getWlanM2UBuilt);
	websAspDefine(T("getWlanWdsEncType"), getWlanWdsEncType);
	websAspDefine(T("is3t3r"), is3t3r);
	websAspDefine(T("getWirelessMacRuleNumsASP"), getWirelessMacRuleNumsASP);
	websAspDefine(T("getWirelessMacFilterPolicy"), getWirelessMacFilterPolicy);
	websAspDefine(T("isWPSConfiguredASP"), isWPSConfiguredASP);
	websAspDefine(T("isAntennaDiversityBuilt"), isAntennaDiversityBuilt);
#ifdef CONFIG_RT2860V2_AP_MESH
	websAspDefine(T("ShowMeshState"), ShowMeshState);
#endif
#ifdef CONFIG_RT2860V2_AP_ANTENNA_DIVERSITY
	websFormDefine(T("AntennaDiversity"), AntennaDiversity);
	websFormDefine(T("getAntenna"), getAntenna);
#endif
	websAspDefine(T("getWlanCurrentChannel"), getWlanCurrentChannel);
	websAspDefine(T("showWirelessMacFilterRulesASP"), showWirelessMacFilterRulesASP);
	websFormDefine(T("wirelessMacFilterDelete"), wirelessMacFilterDelete);
	websFormDefine(T("wirelessMacFilterPolicy"), wirelessMacFilterPolicy);
	websFormDefine(T("wirelessAddMacFilter"), wirelessAddMacFilter);
	websFormDefine(T("wirelessBasic"), wirelessBasic);
	websFormDefine(T("wirelessAdvanced"), wirelessAdvanced);
	websFormDefine(T("wirelessApcli"), wirelessApcli);
	websFormDefine(T("wirelessWmm"), wirelessWmm);
	websFormDefine(T("wirelessGetSecurity"), wirelessGetSecurity);
	websFormDefine(T("APSecurity"), APSecurity);
	websFormDefine(T("APDeleteAccessPolicyList"), APDeleteAccessPolicyList);
}
