/* vi: set sw=4 ts=4 sts=4: */
/*
 * main.c -- Main program for the GoAhead WebServer (LINUX version)
 *
 * Copyright (c) GoAhead Software Inc., 1995-2000. All Rights Reserved.
 *
 * See the file "license.txt" for usage and redistribution license requirements
 *
 * $Id: goahead.c,v 1.100.2.4 2009-04-08 08:52:59 chhung Exp $
 */

/******************************** Description *********************************/

/*
 *	Main program for for the GoAhead WebServer. This is a demonstration
 *	main program to initialize and configure the web server.
 */

/********************************* Includes ***********************************/

#include	"uemf.h"
#include	"wsIntrn.h"
#include	"nvram.h"
#include	"ralink_gpio.h"
#include	"internet.h"
#if defined INIC_SUPPORT || defined INICv2_SUPPORT
#include	"inic.h"
#endif
#if defined (CONFIG_RT2561_AP) || defined (CONFIG_RT2561_AP_MODULE)
#include	"legacy.h"
#endif
#include	"utils.h"
#include	"wps.h"
#include	"wireless.h"
#include	"firewall.h" 
#include	"schedule.h" 
#include	"management.h"
#include	"station.h"
#include	"usb.h"
#include	"media.h"
#include	<signal.h>
#include	<unistd.h> 
#include	<sys/types.h>
#include	<sys/wait.h>
#include	"linux/autoconf.h"
#include	"config/autoconf.h" //user config

#ifdef CONFIG_RALINKAPP_SWQOS
#include      "qos.h"
#endif

//Add for initiate WPS process by setup wizard - U-Media Ricky Cao on 04 Jan. 2008
#include <sys/ipc.h>
#include <sys/msg.h>
//U-Media Ricky Cao on 04 Jan. 2008
#include "routing.h" //Add for GUI operation of Static Route, Dynamic Route and Rouging List - Ricky Cao on Mar. 05 2008
#ifdef WEBS_SSL_SUPPORT
#include	"websSSL.h"
#endif

#ifdef USER_MANAGEMENT_SUPPORT
#include	"um.h"
void	formDefineUserMgmt(void);
#endif

#define FIREWALL_RELOAD_KEY	9999

/*********************************** Locals ***********************************/
/*
 *	Change configuration here
 */

static char_t		*rootWeb = T("/etc_ro/web");		/* Root web directory */
static char_t		*password = T("");				/* Security password */
static int			port = 80;						/* Server port */
static int			retries = 5;					/* Server port retries */
static int			finished;						/* Finished flag */
static char_t		*gopid = T("/var/run/goahead.pid");	/* pid file */

/****************************** Forward Declarations **************************/

static int	writeGoPid(void);
static int 	initSystem(void);
static int 	initWebs(void);
static int  websHomePageHandler(webs_t wp, char_t *urlPrefix, char_t *webDir,
				int arg, char_t *url, char_t *path, char_t *query);
extern void defaultErrorHandler(int etype, char_t *msg);
extern void defaultTraceHandler(int level, char_t *buf);
extern void ripdRestart(void);
#ifdef B_STATS
static void printMemStats(int handle, char_t *fmt, ...);
static void memLeaks();
#endif
extern void WPSAPPBCStartAll(void);
extern void WPSSingleTriggerHandler(int);
#if defined CONFIG_USB
extern void hotPluglerHandler(int);
#endif
//Add for initiate WPS process by setup wizard - U-Media Ricky Cao on 04 Jan. 2008
extern int getWscStatus(char *interface);
extern char *getWscStatusStr(int status);
#define MAX_TEXT	512
extern void WPS_by_setup_wizard(int WscMode, char *pin);
//U-Media Ricky Cao on 04 Jan. 2008

#ifdef CONFIG_RT2860V2_STA_WSC
extern void WPSSTAPBCStartEnr(void);
#endif

#define PWRLED_ORANGE	12	//led, 0:on, 1:off

#ifdef CONFIG_DUAL_IMAGE
static int set_stable_flag(void);
#endif
/*********************************** Code *************************************/
/*
 *	Main -- entry point from LINUX
 */

int main(int argc, char** argv)
{
	//Jacky.Yang 19-Jan-2009, adjust nat maximum session number to 10240
	//system("echo 10240 > /proc/sys/net/ipv4/netfilter/ip_conntrack_max");
	system("echo 15000 > /proc/sys/net/ipv4/netfilter/ip_conntrack_max");
	//system("echo 30000 > /proc/sys/net/ipv4/netfilter/ip_conntrack_max");
	
	//Add for status page - U-Media Ricky Cao on Mar. 18 2008
	char *opmode, *connType, *reconnectMode; 
	int wanPort_PhyIsUp = 1;
	int pid;
	FILE *wanStatusFile;
	//U-Media Ricky Cao on Mar. 18 2008
	
	//Jacky.Yang 25-Mar-2008,
	char cmd[256];
	int firewallReloadID;
	int msgSize=1024;
	struct msgbuffer {
		long mtype;
		char mtext[msgSize];
	}msgInfo;


	firewallReloadID = msgget(FIREWALL_RELOAD_KEY, IPC_CREAT | 0666);
	if(firewallReloadID == -1){
		printf("goahead: Create firewall reload message queue fail!\n");
		perror("msgget");
	}
	//Jacky.Yang 25-Mar-2008,
	
	//Add for initiate WPS process by setup wizard - U-Media Ricky Cao on 04 Jan. 2008
	int msgid;
	struct my_msg_st{
		long int my_msg_type;
		char some_text[BUFSIZ];
	} some_data;
	long int wps_start = 11;
	long int wps_end = 12;
	long int wps_mode = 13;
	long int wps_pin = 14;
	long int wps_status = 15;
	int recv_msg_result = 0;
	int is_wps_running = 0;
	int WpsStatus = 0;
	char *WpsStatusStr;
	int CurStatus = 0;

	printf("Create a message queue in goahead for interprocess communication!! \n");
	msgid = msgget((key_t)4321, 0666|IPC_CREAT);
	if(msgid == -1){
		printf("Create message queue fail !!!\n");
	}

	//U-Media Ricky Cao on 04 Jan. 2008
/*
 *	Initialize the memory allocator. Allow use of malloc and start 
 *	with a 60K heap.  For each page request approx 8KB is allocated.
 *	60KB allows for several concurrent page requests.  If more space
 *	is required, malloc will be used for the overflow.
 */
	bopen(NULL, (60 * 1024), B_USE_MALLOC);
	signal(SIGPIPE, SIG_IGN);

	if (writeGoPid() < 0)
		return -1;
	if (initSystem() < 0)
		return -1;

/*
 *	Initialize the web server
 */
	if (initWebs() < 0) {
		return -1;
	}

#ifdef WEBS_SSL_SUPPORT
	websSSLOpen();
#endif
	//Apply Outsourcing team patch - Ricky Cao on Feb. 20 2008
	trace(0, T("goahead: local script ")); // Arthur add call rc.local here
	doSystem("rc.local");

	//Add for set port trigger on/off, this rule must be set on last in nat table - U-Media Ricky Cao on Apr. 23 2008
	PortTriggerOnInitiate();

	//Add for status page - U-Media Ricky Cao on Mar. 18 2008
	opmode = nvram_bufget(RT2860_NVRAM, "OperationMode");
	//connType = nvram_get(RT2860_NVRAM, "wanConnectionMode");
	wanPort_PhyIsUp = getWanPortPhyStatus();
	//U-Media Ricky Cao on Mar. 18 2008
	
	//Tom.Hung 2009-4-23, detect wan port status and change /var/wan_status value if wan port is up at goahead start
	if (wanPort_PhyIsUp)
		system("echo 1 > /var/wan_status");
	//Tom.Hung 2009-4-23

	//Jacky.Yang 15-Sep-2008, initial orange Power LED
	//doSystem("gpio r");
	system("echo 1 > /var/goahead_init");
	
	//Jacky.Yang 17-Sep-2008, You can use the following command to reset the PHY without reboot the system necessary. This command include link down the PHY about 2 seconds then link up.
	//doSystem("i2ccmd rtl vlan");
	//doSystem("reset_all_phys.sh"); //move to rcS
/*
 *	Basic event loop. SocketReady returns true when a socket is ready for
 *	service. SocketSelect will block until an event occurs. SocketProcess
 *	will actually do the servicing.
 */
	if (lang_init())
		printf("goahead.c: multi-lang init success.\n");
	else
		printf("goahead.c: multi-lang init fail.\n");

	while (!finished) {
		if (socketReady(-1) || socketSelect(-1, 1000)) {
			socketProcess(-1);
		}
		websCgiCleanup();
		emfSchedProcess();

		//Jacky.Yang 25-Mar-2008, begin detect wan port ip address change.
		if (msgrcv(firewallReloadID, &msgInfo, msgSize, 0, IPC_NOWAIT) != -1)
		{
			printf("goahead: Get message from send_event, the message is %s\n", msgInfo.mtext);
			if (!strcmp(msgInfo.mtext, "firewall_reload")) {
				printf("goahead: start firewall_init()\n");
				firewall_init();
				//iptablesAllNATRun();
			}
			else if (!strcmp(msgInfo.mtext, "stopWPS")) {
				printf("jacky - Stop WPS process!\n");
				resetTimerAll();
				LedReset();
				//iptablesAllNATRun();
			}
			else if (!strcmp(msgInfo.mtext, "openDebug")) {
				printf("goahead: Open Debug message.\n");
				openDebug = 1;
				//iptablesAllNATRun();
			}
			else if (!strcmp(msgInfo.mtext, "closeDebug")) {
				printf("goahead: Close Debug message.\n");
				openDebug = 0;
				//iptablesAllNATRun();
			}
			else {
				printf("goahead: for schedule rule\n");
				//The file runBySchedule in the firewall.c
				runBySchedule(msgInfo.mtext);
			}
		}
		//Jacky.Yang 25-Mar-2008, end detect wan port ip address change.

		//Add for initiate WPS process by setup wizard - U-Media Ricky Cao on 04 Jan. 2008
		if(!is_wps_running){
			recv_msg_result = msgrcv(msgid, (void *)&some_data, BUFSIZ, wps_start, IPC_NOWAIT);
			if(recv_msg_result != -1){
				printf("Got a message \" %s \" from message queue\n", some_data.some_text);
				recv_msg_result = msgrcv(msgid, (void *)&some_data, BUFSIZ, wps_mode, IPC_NOWAIT);
				if(recv_msg_result != -1){
					printf("Got a wps mode \" %s \" from message queue\n", some_data.some_text);
					if(!strcmp(some_data.some_text, "pin")){
						recv_msg_result = msgrcv(msgid, (void *)&some_data, BUFSIZ, wps_pin, IPC_NOWAIT);
						printf("Got a pin \" %s \" from message queue\n", some_data.some_text);
						//start the pin process on below ..
						WPS_by_setup_wizard(1, some_data.some_text);
						is_wps_running = 1;
					}else if(!strcmp(some_data.some_text, "pbc")){
						//start the pbc process on below ..
						WPS_by_setup_wizard(2, NULL);
						is_wps_running = 1;
					}else{
						printf("unknow wps mode !!\n");
					}
				}
			}
		}else{
			WpsStatus = getWscStatus("ra0");
			if(CurStatus != WpsStatus){
				CurStatus = WpsStatus;
				WpsStatusStr = (char *)malloc(6);
				sprintf(WpsStatusStr, "%d", WpsStatus);
				some_data.my_msg_type = wps_status;
				strcpy(some_data.some_text, WpsStatusStr);			
				if(msgsnd(msgid, (void *)&some_data, MAX_TEXT, 0) == -1){
					printf("send message to message queue by goahead fail !!\n");
				}else{
					printf("send message to message queue by goahead successfully !!\n");
				}
				if(WpsStatus == 1 || WpsStatus == 2 || WpsStatus == 34){
					is_wps_running = 0;
					CurStatus = 0;
				}
				free(WpsStatusStr);
			}
		}
		//U-Media Ricky Cao on 04 Jan. 2008
		
		//Add for status page - U-Media Ricky Cao on Mar. 18 2008
		//printf("wan port physical status  = %d, wanPort_PhyIsUp = %d, opmode = %s, connection type = %s\n", getWanPortPhyStatus(), wanPort_PhyIsUp, opmode, connType);
		
		if(!strcmp(opmode, "1")){
			connType = nvram_bufget(RT2860_NVRAM, "wanConnectionMode");			
			if(!strcmp(connType, "PPPOE"))
				reconnectMode = nvram_bufget(RT2860_NVRAM, "wan_pppoe_reconnectMode");
			else if(!strcmp(connType, "L2TP"))
				reconnectMode = nvram_bufget(RT2860_NVRAM, "wan_l2tp_reconnectMode");
			else if(!strcmp(connType, "PPTP"))
				reconnectMode = nvram_bufget(RT2860_NVRAM, "wan_pptp_reconnectMode");	
			
			if(getWanPortPhyStatus() && !wanPort_PhyIsUp){ //cable be re-attached
				if(!strcmp(connType, "DHCP")){
					pid = getPid("/var/run/udhcpc.pid");
					if(pid!=0){
						kill(pid, SIGUSR1);
					}
				}else if(!strcmp(connType, "STATIC")){
					wanStatusFile = fopen("/var/wan_status", "w+");
					if(wanStatusFile){
						fputs("1", wanStatusFile);
						fclose(wanStatusFile);
						system("/var/staticRoute"); //Because the static route will be deleted from routing table, so I need re-insert route again after cable be reconnected
					}else{
						printf("Open \"/var/wan_status\" fail");
					}
				}else if((!strcmp(connType, "PPPOE") && strncmp(reconnectMode, "Manual", 1))
						|| (!strcmp(connType, "L2TP") && strncmp(reconnectMode, "Manual", 1))
						|| (!strcmp(connType, "PPTP") && strncmp(reconnectMode, "Manual", 1))){
					//If we configure pppd to Manual mode, then we don't reconnect ppp link again
					//User should reconnect manual 
					//Ricky CAO
					doSystem("echo 'Goahead: Do wan.sh when cable be re-attached.' > /dev/console");
					doSystem("wan.sh");
				}
				wanPort_PhyIsUp = 1;
			}else if(!getWanPortPhyStatus() && wanPort_PhyIsUp){ //cable be removed
				if(!strcmp(connType, "DHCP")){
					pid = getPid("/var/run/udhcpc.pid");
					if(pid!=0){
						kill(pid, SIGUSR2);
					}
				}else if(!strcmp(connType, "PPPOE") || !strcmp(connType, "L2TP") || !strcmp(connType, "PPTP")){
					pid = getPsPid("pppd");
					if(pid != 0){
						doSystem("kill %d", pid);
					}
				}
				wanPort_PhyIsUp = 0;
				wanStatusFile = fopen("/var/wan_status", "w+");
				if(wanStatusFile){
					fputs("0", wanStatusFile);
					fclose(wanStatusFile);
				}else{
					printf("Open \"/var/wan_status\" fail");
				}
			}
		}
		//U-Media Ricky Cao on Mar. 18 2008
		
		//Jacky.Yang 9-Sep-2008, close orange power led
		/*snprintf(cmd, sizeof(cmd), "gpio l %d 0 300 1 1 1", PWRLED_ORANGE);
		system(cmd);*/
	}

#ifdef WEBS_SSL_SUPPORT
	websSSLClose();
#endif

#ifdef USER_MANAGEMENT_SUPPORT
	umClose();
#endif

/*
 *	Close the socket module, report memory leaks and close the memory allocator
 */
	websCloseServer();
	socketClose();
#ifdef B_STATS
	memLeaks();
#endif
	bclose();
	return 0;
}

/******************************************************************************/
/*
 *	Write pid to the pid file
 */
int writeGoPid(void)
{
	FILE *fp;

	fp = fopen(gopid, "w+");
	if (NULL == fp) {
		error(E_L, E_LOG, T("goahead.c: cannot open pid file"));
		return (-1);
	}
	fprintf(fp, "%d", getpid());
    fclose(fp);
	return 0;
}

static void goaSigHandler(int signum)
{
#ifdef CONFIG_RT2860V2_STA_WSC
	char *opmode = nvram_bufget(RT2860_NVRAM, "OperationMode");
	char *ethCon = nvram_bufget(RT2860_NVRAM, "ethConvert");
#endif

	/*if (signum != SIGUSR2)
		return;*/

#ifdef CONFIG_RT2860V2_STA_WSC
	if(!strcmp(opmode, "2") || (!strcmp(opmode, "0") &&   !strcmp(ethCon, "1") ) )		// wireless isp mode
		WPSSTAPBCStartEnr();	// STA WPS default is "Enrollee mode".
	else
#endif
		WPSAPPBCStartAll();
}

//Jacky.Yang 22-Dec-2008, define wps h/w button gpio
static void goaSIGUSR2Handler(int signum)
{
	return;
}

#ifndef CONFIG_RALINK_RT2880
static void goaInitGpio()
{
	int fd;
	ralink_gpio_reg_info info;

	fd = open("/dev/gpio", O_RDONLY);
	if (fd < 0) {
		perror("/dev/gpio");
		return;
	}
	//set gpio direction to input
	if (ioctl(fd, RALINK_GPIO_SET_DIR_IN, RALINK_GPIO(0)) < 0)
		goto ioctl_err;
	//enable gpio interrupt
	if (ioctl(fd, RALINK_GPIO_ENABLE_INTP) < 0)
		goto ioctl_err;
	//register my information
	info.pid = getpid();
	info.irq = 0;
	if (ioctl(fd, RALINK_GPIO_REG_IRQ, &info) < 0)
		goto ioctl_err;
	close(fd);

	//issue a handler to handle SIGUSR1
	signal(SIGUSR2, goaSigHandler);
	signal(SIGUSR1, goaSIGUSR2Handler);
	return;

ioctl_err:
	perror("ioctl");
	close(fd);
	return;
}
#endif

//Jacky.Yang 1-Oct-2008, temp for fix push wps button 5 second to reset to default.

static void dhcpcHandler(int signum)
{
	ripdRestart();
	//Jacky.Yang 3-Oct-2008, firewall init when the dhcp client get ip.
	//firewall_init(); //in the udhcpc.sh
}

static void LoadDefault(int signum)
{
	//ripdRestart();
	/*system("ralink_init clear 2860");
	system("ralink_init renew 2860 /etc_ro/Wireless/RT2860AP/TEW-635BRP.dat");
	system("reboot");*/
}


/******************************************************************************/
/*
 *	Initialize System Parameters
 */
static int initSystem(void)
{
	int setDefault(void);

	//signal(SIGUSR2, dhcpcHandler);
	signal(SIGALRM, dhcpcHandler);
	//signal(SIGUSR2, LoadDefault);
	if (setDefault() < 0)
		return (-1);
	if (initInternet("first") < 0)
		return (-1);
	//printf("Initiate the Port Trigger feature\n");//Add for initiate port trigger feature - Ricky Cao on Apr. 10 2008
	//PortTriggerRulesInitiate();//Add for initiate port trigger feature - Ricky Cao on Apr. 10 2008
	initStaticRoute();//Add for GUI operation of Static Route, Dynamic Route and Rouging List - Ricky Cao on Mar. 05 2008
#if defined CONFIG_USB
	signal(SIGTTIN, hotPluglerHandler);
	hotPluglerHandler(SIGTTIN);
#endif
#ifdef CONFIG_RALINK_RT2880
	//signal(SIGUSR1, goaSigHandler);
	signal(SIGUSR2, goaSigHandler);
#else
	goaInitGpio();
#endif
	signal(SIGXFSZ, WPSSingleTriggerHandler);

	return 0;
}

/******************************************************************************/
/*
 *	Set Default should be done by nvram_daemon.
 *	We check the pid file's existence.
 */
int setDefault(void)
{
	FILE *fp;
	int i;

	//retry 15 times (15 seconds)
	for (i = 0; i < 15; i++) {
		fp = fopen("/var/run/nvramd.pid", "r");
		if (fp == NULL) {
			if (i == 0)
				trace(0, T("goahead: waiting for nvram_daemon "));
			else
				trace(0, T(". "));
		}
		else {
			fclose(fp);
			nvram_init(RT2860_NVRAM);
#if defined INIC_SUPPORT || defined INICv2_SUPPORT
			nvram_init(RTINIC_NVRAM);
#endif
#if defined (CONFIG_RT2561_AP) || defined (CONFIG_RT2561_AP_MODULE)
			//Jacky.Yang, You only use RT2860_NVRAM and outsourcing will use 0x3a000 that is RT2561_NVRAM
			//nvram_init(RT2561_NVRAM);
#endif

			return 0;
		}
		Sleep(1);
	}
printf("Salim-goahead: please execute nvram_daemon first!");
	error(E_L, E_LOG, T("goahead: please execute nvram_daemon first!"));
	return (-1);
}

/******************************************************************************/
/*
 *	Initialize the web server.
 */

static int initWebs(void)
{
	struct in_addr	intaddr;
#ifdef GA_HOSTNAME_SUPPORT
	struct hostent	*hp;
	char			host[128];
#else
	char			*lan_ip = nvram_bufget(RT2860_NVRAM, "lan_ipaddr");
#endif
	char			webdir[128];
	char			*cp;
	char_t			wbuf[128];

/*
 *	Initialize the socket subsystem
 */
	socketOpen();

#ifdef USER_MANAGEMENT_SUPPORT
/*
 *	Initialize the User Management database
 */
	char *admu = nvram_bufget(RT2860_NVRAM, "Login");
	char *admp = nvram_bufget(RT2860_NVRAM, "Password");
	umOpen();
	//umRestore(T("umconfig.txt"));
	//winfred: instead of using umconfig.txt, we create 'the one' adm defined in nvram
	umAddGroup(T("adm"), 0x07, AM_DIGEST, FALSE, FALSE);
	/*if (admu && strcmp(admu, "") && admp && strcmp(admp, "")) {
		umAddUser(admu, admp, T("adm"), FALSE, FALSE);*/
	if (admu && strcmp(admu, "") && admp) {
		umAddUser(admu, admp, T("adm"), FALSE, FALSE);
		umAddAccessLimit(T("/"), AM_DIGEST, FALSE, T("adm"));
	}
	/*else
		error(E_L, E_LOG, T("gohead.c: Warning: empty administrator account or password"));*/
#endif

#ifdef GA_HOSTNAME_SUPPORT
/*
 *	Define the local Ip address, host name, default home page and the 
 *	root web directory.
 */
	if (gethostname(host, sizeof(host)) < 0) {
		error(E_L, E_LOG, T("gohead.c: Can't get hostname"));
		return -1;
	}
	if ((hp = gethostbyname(host)) == NULL) {
		error(E_L, E_LOG, T("gohead.c: Can't get host address"));
		return -1;
	}
	memcpy((char *) &intaddr, (char *) hp->h_addr_list[0],
		(size_t) hp->h_length);
#else
/*
 * get ip address from nvram configuration (we executed initInternet)
 */
	if (NULL == lan_ip) {
		error(E_L, E_LOG, T("initWebs: cannot find lan_ip in NVRAM"));
		return -1;
	}
	intaddr.s_addr = inet_addr(lan_ip);
	if (intaddr.s_addr == INADDR_NONE) {
		error(E_L, E_LOG, T("initWebs: failed to convert %s to binary ip data"),
				lan_ip);
		return -1;
	}
#endif

/*
 *	Set rootWeb as the root web. Modify this to suit your needs
 */
	sprintf(webdir, "%s", rootWeb);

/*
 *	Configure the web server options before opening the web server
 */
	websSetDefaultDir(webdir);
	cp = inet_ntoa(intaddr);
	ascToUni(wbuf, cp, min(strlen(cp) + 1, sizeof(wbuf)));
	websSetIpaddr(wbuf);
#ifdef GA_HOSTNAME_SUPPORT
	ascToUni(wbuf, host, min(strlen(host) + 1, sizeof(wbuf)));
#else
	//use ip address (already in wbuf) as host
#endif
	websSetHost(wbuf);

/*
 *	Configure the web server options before opening the web server
 */
	websSetDefaultPage(T("default.asp"));
	websSetPassword(password);

/* 
 *	Open the web server on the given port. If that port is taken, try
 *	the next sequential port for up to "retries" attempts.
 */
	websOpenServer(port, retries);

/*
 * 	First create the URL handlers. Note: handlers are called in sorted order
 *	with the longest path handler examined first. Here we define the security 
 *	handler, forms handler and the default web page handler.
 */
	websUrlHandlerDefine(T(""), NULL, 0, websSecurityHandler, 
		WEBS_HANDLER_FIRST);
	websUrlHandlerDefine(T("/goform"), NULL, 0, websFormHandler, 0);
	websUrlHandlerDefine(T("/cgi-bin"), NULL, 0, websCgiHandler, 0);
	websUrlHandlerDefine(T(""), NULL, 0, websDefaultHandler, 
		WEBS_HANDLER_LAST); 

/*
 *	Define our functions
 */
	formDefineUtilities();
	formDefineInternet();
#if defined CONFIG_RALINKAPP_SWQOS
	formDefineQoS();
#endif
#if defined CONFIG_USB
	formDefineUSB();
#endif
#if defined CONFIG_RALINKAPP_MPLAYER
	formDefineMedia();
#endif
	formDefineWireless();
#if defined INIC_SUPPORT || defined INICv2_SUPPORT
	formDefineInic();
#endif
#if defined (CONFIG_RT2561_AP) || defined (CONFIG_RT2561_AP_MODULE)
	formDefineLegacy();
#endif
#if defined CONFIG_RT2860V2_STA || defined CONFIG_RT2860V2_STA_MODULE
	formDefineStation();
#endif
	formDefineFirewall();
	formDefineManagement();
	//Jacky.Yang 27-Mar-2008, schedule rule api
	formDefineSchedule();
	formDefineRouting(); //Add for GUI operation of Static Route, Dynamic Route and Rouging List - Ricky Cao on Mar. 05 2008

/*
 *	Create the Form handlers for the User Management pages
 */
#ifdef USER_MANAGEMENT_SUPPORT
	//formDefineUserMgmt();  winfred: we do it ourselves
#endif

/*
 *	Create a handler for the default home page
 */
	websUrlHandlerDefine(T("/"), NULL, 0, websHomePageHandler, 0); 
	return 0;
}

/******************************************************************************/
/*
 *	Home page handler
 */

static int websHomePageHandler(webs_t wp, char_t *urlPrefix, char_t *webDir,
	int arg, char_t *url, char_t *path, char_t *query)
{
/*
 *	If the empty or "/" URL is invoked, redirect default URLs to the home page
 */
	if (*url == '\0' || gstrcmp(url, T("/")) == 0) {
		//websRedirect(wp, T("home.asp"));
		websRedirect(wp, T("/adm/status.asp"));
		return 1;
	}
	return 0;
}

/******************************************************************************/
/*
 *	Default error handler.  The developer should insert code to handle
 *	error messages in the desired manner.
 */

void defaultErrorHandler(int etype, char_t *msg)
{
	write(1, msg, gstrlen(msg));
}

/******************************************************************************/
/*
 *	Trace log. Customize this function to log trace output
 */

void defaultTraceHandler(int level, char_t *buf)
{
/*
 *	The following code would write all trace regardless of level
 *	to stdout.
 */
	if (buf) {
		if (0 == level)
			write(1, buf, gstrlen(buf));
	}
}

/******************************************************************************/
/*
 *	Returns a pointer to an allocated qualified unique temporary file name.
 *	This filename must eventually be deleted with bfree();
 */
#if defined CONFIG_USB_STORAGE && defined CONFIG_USER_STORAGE
char_t *websGetCgiCommName(webs_t wp)
{
	char *force_mem_upgrade = nvram_bufget(RT2860_NVRAM, "Force_mem_upgrade");
	char_t	*pname1 = NULL, *pname2 = NULL;
	char *part;

	if(!strcmp(force_mem_upgrade, "1")){
		pname1 = (char_t *)tempnam(T("/var"), T("cgi"));
	}else if(wp && (wp->flags & WEBS_CGI_FIRMWARE_UPLOAD) ){
		// see if usb disk is present and available space is enough?
		if( (part = isStorageOK()) )
			pname1 = (char_t *)tempnam(part, T("cgi"));
		else
			pname1 = (char_t *)tempnam(T("/var"), T("cgi"));
	}else{
		pname1 = (char_t *)tempnam(T("/var"), T("cgi"));
	}

	pname2 = bstrdup(B_L, pname1);
	free(pname1);

	return pname2;
}
#else
char_t *websGetCgiCommName(webs_t wp)
{
	char_t	*pname1, *pname2;

	pname1 = (char_t *)tempnam(T("/var"), T("cgi"));
	pname2 = bstrdup(B_L, pname1);
	free(pname1);

	return pname2;
}
#endif
/******************************************************************************/
/*
 *	Launch the CGI process and return a handle to it.
 */

int websLaunchCgiProc(char_t *cgiPath, char_t **argp, char_t **envp,
					  char_t *stdIn, char_t *stdOut)
{
	int	pid, fdin, fdout, hstdin, hstdout, rc;

	fdin = fdout = hstdin = hstdout = rc = -1; 
	if ((fdin = open(stdIn, O_RDWR | O_CREAT, 0666)) < 0 ||
		(fdout = open(stdOut, O_RDWR | O_CREAT, 0666)) < 0 ||
		(hstdin = dup(0)) == -1 ||
		(hstdout = dup(1)) == -1 ||
		dup2(fdin, 0) == -1 ||
		dup2(fdout, 1) == -1) {
		goto DONE;
	}

 	rc = pid = fork();
 	if (pid == 0) {
/*
 *		if pid == 0, then we are in the child process
 */
		if (execve(cgiPath, argp, envp) == -1) {
			printf("content-type: text/html\n\n"
				"Execution of cgi process failed\n");
		}
		exit (0);
	} 

DONE:
	if (hstdout >= 0) {
		dup2(hstdout, 1);
      close(hstdout);
	}
	if (hstdin >= 0) {
		dup2(hstdin, 0);
      close(hstdin);
	}
	if (fdout >= 0) {
		close(fdout);
	}
	if (fdin >= 0) {
		close(fdin);
	}
	return rc;
}

/******************************************************************************/
/*
 *	Check the CGI process.  Return 0 if it does not exist; non 0 if it does.
 */

int websCheckCgiProc(int handle, int *status)
{
/*
 *	Check to see if the CGI child process has terminated or not yet.  
 */
	if (waitpid(handle, status, WNOHANG) == handle) {
		return 0;
	} else {
		return 1;
	}
}

/******************************************************************************/

#ifdef B_STATS
static void memLeaks() 
{
	int		fd;

	if ((fd = gopen(T("leak.txt"), O_CREAT | O_TRUNC | O_WRONLY, 0666)) >= 0) {
		bstats(fd, printMemStats);
		close(fd);
	}
}

/******************************************************************************/
/*
 *	Print memory usage / leaks
 */

static void printMemStats(int handle, char_t *fmt, ...)
{
	va_list		args;
	char_t		buf[256];

	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);
	write(handle, buf, strlen(buf));
}
#endif

/******************************************************************************/

/* added by YYhuang 07/04/02 */
int getGoAHeadServerPort(void)
{
    return port;
}

#ifdef CONFIG_DUAL_IMAGE
static int set_stable_flag(void)
{
	int set = 0;
	char *wordlist = nvram_get(UBOOT_NVRAM, "Image1Stable");

	if (wordlist) {
		if (strcmp(wordlist, "1") != 0)
			set = 1;
	}
	else
		set = 1;

	if (set) {
		printf("Set Image1 stable flag\n");
		nvram_set(UBOOT_NVRAM, "Image1Stable", "1");
	}
	
	return 0;

}
#endif
