#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define  REFRESH_TIMEOUT		"40000"		/* 40000 = 40 secs*/

#include "include/linux/autoconf.h"		/* !!! for CONFIG_MTD_KERNEL_PART_SIZ  !!! */
                                        /*   CONFIG_RT2880_ROOTFS_IN_FLASH */
                                        /*   CONFIG_RT2880_ROOTFS_IN_RAM   */
#define RFC_ERROR "RFC1867 error"

void *memmem(const void *buf, size_t buf_len, const void *byte_line, size_t byte_line_len)
{
    unsigned char *bl = (unsigned char *)byte_line;
    unsigned char *bf = (unsigned char *)buf;
    unsigned char *p  = bf;

    while (byte_line_len <= (buf_len - (p - bf))){
        unsigned int b = *bl & 0xff;
        if ((p = (unsigned char *) memchr(p, b, buf_len - (p - bf))) != NULL){
            if ( (memcmp(p, byte_line, byte_line_len)) == 0)
                return p;
            else
                p++;
        }else{
            break;
        }
    }
    return NULL;
}

#define MEM_SIZE	1024
#define MEM_HALF	512
int findStrInFile(char *filename, int offset, unsigned char *str, int str_len)
{
	int pos = 0, rc;
	FILE *fp;
	unsigned char mem[MEM_SIZE];

	if(str_len > MEM_HALF)
		return -1;
	if(offset <0)
		return -1;

	fp = fopen(filename, "rb");
	if(!fp)
		return -1;

	rewind(fp);
	fseek(fp, offset + pos, SEEK_SET);
	rc = fread(mem, 1, MEM_SIZE, fp);
	while(rc){
		unsigned char *mem_offset;
		mem_offset = (unsigned char*)memmem(mem, rc, str, str_len);
		if(mem_offset){
			fclose(fp);	//found it
			return (mem_offset - mem) + pos + offset;
		}

		if(rc == MEM_SIZE){
			pos += MEM_HALF;	// 8
		}else
			break;
		
		rewind(fp);
		fseek(fp, offset+pos, SEEK_SET);
		rc = fread(mem, 1, MEM_SIZE, fp);
	}

	fclose(fp);
	return -1;
}

/*
 *  ps. callee must free memory...
 */
void *getMemInFile(char *filename, int offset, int len)
{
    void *result;
    FILE *fp;
    if( (fp = fopen(filename, "r")) == NULL ){
        return NULL;
    }
	fseek(fp, offset, SEEK_SET);
    result = malloc(sizeof(unsigned char) * len );
	if(!result)
		return NULL;
    if( fread(result, 1, len, fp) != len){
        free(result);
        return NULL;
    }
    return result;
}


void mtd_write_bootloader(char *filename, int offset, int len)
{
    char cmd[512];
    snprintf(cmd, 512, "/bin/mtd_write -o %d -l %d write %s Bootloader", offset, len, filename);
	printf("write bootloader");
	system(cmd);
    return ;
}

void mtd_write_firmware(char *filename, int offset, int len)
{
    char cmd[512];

#if defined (CONFIG_RT2880_ROOTFS_IN_RAM)
    snprintf(cmd, 512, "/bin/mtd_write -o %d -l %d write %s Kernel", offset, len, filename);
    system(cmd);
#elif defined (CONFIG_RT2880_ROOTFS_IN_FLASH)
    if(CONFIG_MTD_KERNEL_PART_SIZ > len){
      printf("fatal error");
      return;
    }

    snprintf(cmd, 512, "/bin/mtd_write -o %d -l %d write %s Kernel", offset,  CONFIG_MTD_KERNEL_PART_SIZ, filename);
    system(cmd);
    snprintf(cmd, 512, "/bin/mtd_write -o %d -l %d write %s RootFS", offset + CONFIG_MTD_KERNEL_PART_SIZ, len - CONFIG_MTD_KERNEL_PART_SIZ, filename);
    system(cmd);
#else
    fprintf(stderr, "goahead: no CONFIG_RT2880_ROOTFS defined!");
#endif
    return ;
}


int check(char *filename, int offset, int len)
{
    unsigned char buf[4];
    FILE *fp;

    if(len < 4)
      return 0;

    fp = fopen(filename, "r");

    if(!fp){
      return 0;
    }
    
    fseek(fp, offset, SEEK_SET);

    if(fread(buf, 1, 4, fp) != 4){
      fclose(fp);
      return 0;
    }

    if(buf[0] != 0x27 || buf[1] != 0x05 || buf[2] != 0x19 || buf[3] != 0x56){
//    printf("=== %d %d %d %d == \n", buf[0],buf[1],buf[2],buf[3]);
      fclose(fp);
      return 0;
    }

    fclose(fp);
    return 1;
}

/*
 * arguments: ifname  - interface name
 *            if_addr - a 16-byte buffer to store ip address
 * description: fetch ip address, netmask associated to given interface name
 */
int getIfIp(char *ifname, char *if_addr)
{
    struct ifreq ifr;
    int skfd = 0;

    if((skfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
        printf("getIfIp: open socket error");
        return -1;
    }

    strncpy(ifr.ifr_name, ifname, IF_NAMESIZE);
    if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {
        printf("getIfIp: ioctl SIOCGIFADDR error for %s", ifname);
        return -1;
    }
    strcpy(if_addr, inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr));

    close(skfd);
    return 0;
}

/*
 * I'm too lazy to use popen() instead of system()....
 * ( note:  static buffer used)
 */
char *getLanIP(void)
{
#define DEFAULT_LAN_IP "10.10.10.254"
	FILE *fp;
	char interface[32];
    static char result[32];

	system("./getLAN.sh > /var/lazyfox");
	if(! (fp = fopen("/var/lazyfox", "r"))  ){
		// is this possible?
		return DEFAULT_LAN_IP;
	}
	fgets(interface, 32, fp);
	if( getIfIp(interface, result) == -1)
		return DEFAULT_LAN_IP;
	fclose(fp);
	return result;
}

void javascriptUpdate(int success)
{
    printf("<script language=\"JavaScript\" type=\"text/javascript\">");
    if(success){
        printf(" \
function refresh_all(){	\
  top.location.href = \"http://%s\"; \
} \
function update(){ \
  self.setTimeout(\"refresh_all()\", %s);\
}", getLanIP(), REFRESH_TIMEOUT);
    }else{
        printf("function update(){ parent.menu.setUnderFirmwareUpload(0);}");
    }
    printf("</script>");
}

inline void webFoot(void)
{
    printf("</body></html>\n");
}

int main (int argc, char *argv[])
{
    int file_begin, file_end;
    int line_begin, line_end;
    char *boundary; int boundary_len;
    char *filename = getenv("UPLOAD_FILENAME");

    printf(
"\
Server: %s\n\
Pragma: no-cache\n\
Content-type: text/html\n",
getenv("SERVER_SOFTWARE"));

    printf("\n\
<html>\n\
<head>\n\
<TITLE>Upload Firmware</TITLE>\n\
<link rel=stylesheet href=/style/normal_ws.css type=text/css>\n\
<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\">\n\
</head>\n\
<body onload=\"update()\"> <h1> Upload Firmware</h1>");

    if(!filename){
        printf("failed, can't get env var.\n");
        return -1;
    }

    line_begin = 0;
    if((line_end = findStrInFile(filename, line_begin, "\r\n", 2)) == -1){
        printf("%s %d", RFC_ERROR, 1);
        return -1;
    }
	boundary_len = line_end - line_begin;
    boundary = getMemInFile(filename, line_begin, boundary_len);
//  printf("boundary:%s\n", boundary);

    // sth like this..
    // Content-Disposition: form-data; name="filename"; filename="\\192.168.3.171\tftpboot\a.out"
    //
    char *line, *semicolon, *user_filename;
    line_begin = line_end + 2;
    if((line_end = findStrInFile(filename, line_begin, "\r\n", 2)) == -1){
        printf("%s %d", RFC_ERROR, 2);
        goto err;
    }
    line = getMemInFile(filename, line_begin, line_end - line_begin);
    if(strncasecmp(line, "content-disposition: form-data;", strlen("content-disposition: form-data;"))){
        printf("%s %d", RFC_ERROR, 3);
        goto err;
    }
    semicolon = line + strlen("content-disposition: form-data;") + 1;
    if(! (semicolon = strchr(semicolon, ';'))  ){
        printf("We dont support multi-field upload.\n");
        goto err;
    }
    user_filename = semicolon + 2;
    if( strncasecmp(user_filename, "filename=", strlen("filename="))  ){
        printf("%s %d", RFC_ERROR, 4);
        goto err;
    }
    user_filename += strlen("filename=");
    //until now we dont care about what the true filename is.
    free(line);

    // We may check a string  "Content-Type: application/octet-stream" here
    // but if our firmware extension name is the same with other known name, 
    // the browser will use other content-type instead.
    // So we dont check Content-type here...
    line_begin = line_end + 2;
    if((line_end = findStrInFile(filename, line_begin, "\r\n", 2)) == -1){
        printf("%s %d", RFC_ERROR, 5);
        goto err;
    }

    line_begin = line_end + 2;
    if((line_end = findStrInFile(filename, line_begin, "\r\n", 2)) == -1){
        printf("%s %d", RFC_ERROR, 6);
        goto err;
    }

    file_begin = line_end + 2;

    if( (file_end = findStrInFile(filename, file_begin, boundary, boundary_len)) == -1){
        printf("%s %d", RFC_ERROR, 7);
        goto err;
    }
    file_end -= 2;		// back 2 chars.(\r\n);

    // printf("file:%s, file_begin:%d, len:%d<br>\n", filename, file_begin, file_end - file_begin);
    
    // examination
#if defined (UPLOAD_FIRMWARE_SUPPORT)
    if(!check(filename, file_begin, file_end - file_begin) ){
        printf("Not a valid firmware.");
        javascriptUpdate(0);
        goto err;
    }

    // flash write
    mtd_write_firmware(filename, file_begin, file_end - file_begin);
#elif defined (UPLOAD_BOOTLOADER_SUPPORT)
    mtd_write_bootloader(filename, file_begin, file_end - file_begin);
#else
#error "no upload support defined!"
#endif

    printf("Done...rebooting");
    system("sleep 3 && reboot &");
    javascriptUpdate(1);
err:
    webFoot();
    free(boundary);
    exit(0);
}

