#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>   
#include <fcntl.h>

int main() {
        int fd, i; 
        struct stat fst;
        char line[1024], rule[40], cmd[1024];
        FILE *dat;

        if (-1 == stat("/tmp/rfw/rule.cts", &fst)) {
                printf("rule file not found!\n");
                return -1;          
        } else {                        
                fd = open("/tmp/rfw/rule.cts", O_RDONLY);
        }

        if (fd == -1) {
                printf("Open rule file error!\n");
                return -1;
        }


        if (fst.st_size == 0) {
                printf("rule file have no content\n");
                return -1;
        }

        dat = fdopen(fd, "r");
        fgets(line, 1023, dat);

        do {
	        bzero(cmd, 1024);	
                if (line[0] != '[') {
			fgets(line, 1023, dat);
		       	continue;
		}
		bzero(rule, 40);
		for (i = 0; i < 40; i++) {
			if (line[i+1] == ']') break;
			rule[i] = line[i+1];
		}
		printf("bind policy %s\n", rule);
		sprintf(cmd, "/bin/rfwcmd bind %s > /dev/null", rule);
		system(cmd);

		fgets(line, 1023, dat);
        } while (!feof(dat));
}
