#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

int usage(char *name) {
	printf("%s usage:\n", name);
	printf("	%s dat2conf\n",name);
	printf("	%s conf2dat\n",name);
	return -1;
}

int dat2conf() {
	int fd;
	struct stat fst;
	char line[1024];
	FILE *dat, *conf;

	if (-1 == stat("/etc/app_config.dat", &fst)) {
		printf("dat file not found!\n");
		return -1;
	} else {
		fd = open("/etc/app_config.dat", O_RDONLY);
	}

	if (fd == -1) {
		printf("Open dat file error!\n");
		return -1;
	}

	if (fst.st_size == 0) {
		printf("dat file have no content\n");
		return -1;
	}
	//printf("config file size = %d\n", fst.st_size);

	dat = fdopen(fd, "r");
	fgets(line, 1023, dat);

	do {
		if (line[0] != '[') {
			fgets(line, 1023, dat);
		       	continue;
		}
		if (!strncmp(line, "[ZEBRA]", 7)) {
			conf = fopen("/etc/zebra.conf", "w+");
		} else if (!strncmp(line, "[RIPD]", 6)) {
			conf = fopen("/etc/ripd.conf", "w+");
		} else if (!strncmp(line, "[RULE_TJB]", 10)) {
			conf = fopen("/tmp/rfw/rule.cts", "w+");
		} else if (!strncmp(line, "[IFNS_TJB]", 10)) {
			fgets(line, 1023, dat);
			continue;
		} else if (!strncmp(line, "[NAME_TJB]", 10)) {
			conf = fopen("/tmp/rfw/name.cts", "w+");
		}
		do {
			fgets(line, 1023, dat);
			if (feof(dat)) break;
			if (line[0] == '[') {
				if ((!strncmp(line, "[ZEBRA]", 7)) ||
				    (!strncmp(line, "[RIPD]", 6)) || (!strncmp(line, "[IFNS_TJB]", 10)) ||
				    (!strncmp(line, "[RULE_TJB]", 10)) || (!strncmp(line, "[NAME_TJB]", 10)))
					break;
			}
			fprintf(conf, "%s", line);
		} while (!feof(dat));
		//  printf("Generated \n");
		fclose(conf);
	} while (!feof(dat));


	fclose(dat);
	close(fd);
	
	return 0;
}

int conf2dat() {
	int fd, fd2, len;
	char *buf;
	char line[1024];
	struct stat fst;
	

	fd = open("/etc/app_config.dat", O_CREAT|O_RDWR|O_TRUNC);
	if (fd == -1) {
		printf("creat config file error!\n");
		return -1;
	}

	fd2 = open("/etc/zebra.conf", O_RDONLY);

	if (fd2 == -1) {
		printf("zebra.conf not found\n");
		close(fd);
		return -1;
	}

	stat("/etc/zebra.conf", &fst);
	//printf("zebra.conf size = %d bytes\n", fst.st_size);
		
	sprintf(line, "[ZEBRA]\n");
	len = strlen(line);
	write(fd, line, len);
	
	buf = malloc(fst.st_size);
	read(fd2, buf, fst.st_size);

	write(fd, buf, fst.st_size);
	
	close(fd2);
	free(buf);

	fd2 = open("/etc/ripd.conf", O_RDONLY);

	if (fd2 == -1) {
		printf("ripd.conf not found\n");
		close(fd);
		return -1;
	}

	stat("/etc/ripd.conf", &fst);
	//printf("ripd.conf size = %d bytes\n", fst.st_size);
		
	sprintf(line, "[RIPD]\n");
	len = strlen(line);
	write(fd, line, len);
	
	buf = malloc(fst.st_size);
	read(fd2, buf, fst.st_size);

	write(fd, buf, fst.st_size);
	
	close(fd2);
	free(buf);

	fd2 = open("/tmp/rfw/rule.cts", O_RDONLY);
	
	if (fd2 == -1) {
		printf("rule.cts not found\n");
		close(fd);
		return -1;
	}

	stat("/tmp/rfw/rule.cts", &fst);
		
	sprintf(line, "[RULE_TJB]\n");
	len = strlen(line);
	write(fd, line, len);
	
	buf = malloc(fst.st_size);
	read(fd2, buf, fst.st_size);

	write(fd, buf, fst.st_size);
	
	close(fd2);
	free(buf);

	fd2 = open("/tmp/rfw/name.cts", O_RDONLY);
	
	if (fd2 == -1) {
		printf("name.cts not found\n");
		close(fd);
		return -1;
	}

	stat("/tmp/rfw/name.cts", &fst);
		
	sprintf(line, "[NAME_TJB]\n");
	len = strlen(line);
	write(fd, line, len);
	
	buf = malloc(fst.st_size);
	read(fd2, buf, fst.st_size);

	write(fd, buf, fst.st_size);
	
	close(fd2);
	free(buf);


	close(fd);
	return 0;
}
	

int main(int argc,char **argv) {
	int rc;
	if (argc == 1 || argc > 2)
		return usage(argv[0]);

	if (!strncmp(argv[1], "conf2dat", 9))
		rc = conf2dat();
	else if (!strncmp(argv[1], "dat2conf", 9))
		rc = dat2conf();
	else
		return usage(argv[0]);

	return rc;
}


