#ifndef _AG7100_H
#define _AG7100_H

#include <linux/types.h>
#include <linux/spinlock_types.h>
#include <linux/workqueue.h>
#include <asm/system.h>
#include <linux/netdevice.h>
#include "ar7100.h"
#include "ag7100_trc.h"

#define DEBUG  		1
//#define ATHEROS_VLAN	1
/* MII for AG7100
//#define CONFIG_AG7100_GE0_RGMII 1
//#define CONFIG_AG7100_GE1_IS_CONNECTED 1
//#define CONFIG_AG7100_GE1_RGMII 1
//#define CONFIG_PORT0_AS_SWITCH 1
//#define CONFIG_AG7100_MAC_LOCATION 1

*/

/*
 * h/w descriptor
 */
typedef struct {
    uint32_t    pkt_start_addr;

    uint32_t    is_empty       :  1;
    uint32_t    res1           :  6;
    uint32_t    more           :  1;
    uint32_t    res2           :  3;
    uint32_t    ftpp_override  :  5;
    uint32_t    res3           :  4;
    uint32_t    pkt_size       : 12;

    uint32_t    next_desc      ;
}ag7100_desc_t;


/*
 * s/w descriptor
 */
typedef struct {
    struct sk_buff *buf_pkt;        /*ptr to skb*/
    int             buf_nds;        /*no. of desc for this skb*/
    ag7100_desc_t  *buf_lastds;     /*the last desc. (for convenience)*/
#ifdef DMA_DEBUG
    unsigned long   trans_start;    /*  descriptor time stamp */
#endif
}ag7100_buffer_t;

/*
 * Tx and Rx descriptor rings;
 */
typedef struct {
    ag7100_desc_t     *ring_desc;           /* hardware descriptors */
    dma_addr_t         ring_desc_dma;       /* dma addresses of desc*/
    ag7100_buffer_t   *ring_buffer;         /* OS buffer info       */
    int                ring_head;           /* producer index       */
    int                ring_tail;           /* consumer index       */
    int                ring_nelem;          /* nelements            */
}ag7100_ring_t;

typedef struct {
    int stats;
}ag7100_stats_t;

/*
 * 0, 1, 2: based on hardware values for mii ctrl bits [5,4]
 */
typedef enum {
    AG7100_PHY_SPEED_10T,
    AG7100_PHY_SPEED_100TX,
    AG7100_PHY_SPEED_1000T,
}ag7100_phy_speed_t;

/*
 * Represents an ethernet MAC. Contains ethernet devices (LAN and WAN)
 */

#define NUM_RX_DESC     256
#define NUM_TX_DESC     256

#define net_rx_packets      mac_net_stats.rx_packets
#define net_rx_fifo_errors  mac_net_stats.rx_fifo_errors
#define net_tx_packets      mac_net_stats.tx_packets
#define net_rx_bytes        mac_net_stats.rx_bytes
#define net_tx_bytes        mac_net_stats.tx_bytes
#define net_rx_over_errors  mac_net_stats.rx_over_errors
#define net_tx_dropped      mac_net_stats.tx_dropped;

#define ag7100_dev_up(_dev)                                     \
    (((_dev)->flags & (IFF_RUNNING|IFF_UP)) != (IFF_RUNNING|IFF_UP))

typedef enum {
    AG7100_RX_STATUS_DONE,
    AG7100_RX_STATUS_NOT_DONE,
    AG7100_RX_STATUS_OOM,
#ifdef CONFIG_AR9100
    AG7100_RX_DMA_HANG
#endif
}ag7100_rx_status_t;

/*
 * This defines the interconnects between MAC and PHY at compile time
 * There are several constraints - the Kconfig largely takes care of them
 * at compile time.
 */
#if defined (CONFIG_AG7100_GE0_GMII)
    #define     AG7100_MII0_INTERFACE   0
#elif defined (CONFIG_AG7100_GE0_MII)
    #define     AG7100_MII0_INTERFACE   1
#elif defined (CONFIG_AG7100_GE0_RGMII)
    #define     AG7100_MII0_INTERFACE   2
#elif defined (CONFIG_AG7100_GE0_RMII)
    #define     AG7100_MII0_INTERFACE   3
#endif /*defined (AG7100_GE0_GMII)*/

/*
 * Port 1 may or may not be connected
 */
#if defined(CONFIG_AG7100_GE1_IS_CONNECTED)

    #define AG7100_NMACS            2

    #if defined (CONFIG_AG7100_GE1_RGMII)
        #define AG7100_MII1_INTERFACE   0
    #elif defined (CONFIG_AG7100_GE1_RMII)
        #define AG7100_MII1_INTERFACE   1
    #endif /*AG7100_GE1_RGMII*/
#else
    #define AG7100_NMACS            1
    #define AG7100_MII1_INTERFACE   0        /*not connected*/
#endif  /*AG7100_GE1_IS_CONNECTED*/

#define mii_reg(_mac)   (AR7100_MII0_CTRL + ((_mac)->mac_unit * 4))
#define mii_if(_mac)    (((_mac)->mac_unit == 0) ? mii0_if : mii1_if)

#define ag7100_set_mii_ctrl_speed(_mac, _spd)   do {                        \
    ar7100_reg_rmw_clear(mii_reg(_mac), (3 << 4));                          \
    ar7100_reg_rmw_set(mii_reg(_mac), ((_spd) << 4));                       \
}while(0);

/*
 * IP needs 16 bit alignment. But RX DMA needs 4 bit alignment. We sacrifice IP
 * Plus Reserve extra head room for wmac
 */
#define ETHERNET_FCS_SIZE            4
#define AG7100_RX_RESERVE           (64)
#define AG7100_RX_BUF_SIZE      \
    (AG7100_RX_RESERVE + ETH_HLEN + ETH_FRAME_LEN + ETHERNET_FCS_SIZE)


#define ag7100_mac_base(_no)    0xB0110000 
#define ag7100_mac_irq(_no)     3 

#define ag7100_reset_mask(_no) (_no) ? (AR7100_RESET_GE1_MAC |  \
                                        AR7100_RESET_GE1_PHY)   \
                                     : (AR7100_RESET_GE0_MAC |  \
                                        AR7100_RESET_GE0_PHY)

#define ag7100_unit2mac(_unit)     ag7100_macs[(_unit)]

#define assert(_cond)   do {                                     \
    if(!(_cond)) {                                               \
        ag7100_trc_dump();                                       \
        printk("%s:%d: assertion failed\n", __func__, __LINE__); \
        BUG();                                                   \
    }                                                            \
}while(0);


#define PHYS_TO_K1(physaddr) KSEG1ADDR(physaddr)

typedef unsigned int RA2880_REG;

#define sysRegRead(phys)        \
        (*(volatile RA2880_REG *)PHYS_TO_K1(phys))

#define sysRegWrite(phys, val)  \
        ((*(volatile RA2880_REG *)PHYS_TO_K1(phys)) = (val))



#define ag7100_reg_rd(_mac, _reg)                                       \
            (ar7100_reg_rd((_mac)->mac_base + (_reg)))

#define ag7100_reg_wr(_mac, _reg, _val)                                 \
                ar7100_reg_wr((_mac)->mac_base + (_reg), (_val));

/*
 * The no flush version
 */
#define ag7100_reg_wr_nf(_mac, _reg, _val)                             \
                ar7100_reg_wr_nf((_mac)->mac_base + (_reg), (_val));

#define ag7100_reg_rmw_set(_mac, _reg, _mask)                           \
                 ar7100_reg_rmw_set((_mac)->mac_base + (_reg), (_mask));

#define ag7100_reg_rmw_clear(_mac, _reg, _mask)                          \
                 ar7100_reg_rmw_clear((_mac)->mac_base + (_reg), (_mask));


uint16_t ag7100_mii_read(int unit, uint32_t phy_addr, uint32_t reg);
void ag7100_mii_write(int unit, uint32_t phy_addr, uint32_t phy_register, uint32_t write_data);


#define phys_to_bus(a) (a & 0x1FFFFFFF)

#define SURFBOARDINT_ESW  17
#define RA2882ETH_BASE		0xB0100000  /* FRAME_ENGINE_BASE  */
#define RALINK_ETH_SW_BASE      0xB0110000
/*
     FE_INT_STATUS
*/
#define RT2880_CNT_PPE_AF       RT2880_BIT(31)
#define RT2880_CNT_GDM_AF       RT2880_BIT(29)
#define RT2880_PSE_P2_FC        RT2880_BIT(26)
#define RT2880_PSE_BUF_DROP     RT2880_BIT(24)
#define RT2880_GDM_OTHER_DROP   RT2880_BIT(23)
#define RT2880_PSE_P1_FC        RT2880_BIT(22)
#define RT2880_PSE_P0_FC        RT2880_BIT(21)
#define RT2880_PSE_FQ_EMPTY     RT2880_BIT(20)
#define RT2880_GE1_STA_CHG      RT2880_BIT(18)
#define RT2880_TX_COHERENT      RT2880_BIT(17)
#define RT2880_RX_COHERENT      RT2880_BIT(16)
#define RT2880_TX_DONE_INT3     RT2880_BIT(11)
#define RT2880_TX_DONE_INT2     RT2880_BIT(10)
#define RT2880_TX_DONE_INT1     RT2880_BIT(9)
#define RT2880_TX_DONE_INT0     RT2880_BIT(8)
#define RT2880_RX_DONE_INT0     RT2880_BIT(2)
#define RT2880_TX_DLY_INT       RT2880_BIT(1)
#define RT2880_RX_DLY_INT       RT2880_BIT(0)

#define RX_BUF_ALLOC_SIZE       2000
#define FASTPATH_HEADROOM       64

#define ETHER_BUFFER_ALIGN      32              ///// Align on a cache line

#define ETHER_ALIGNED_RX_SKB_ADDR(addr) \
        ((((unsigned long)(addr) + ETHER_BUFFER_ALIGN - 1) & \
        ~(ETHER_BUFFER_ALIGN - 1)) - (unsigned long)(addr))

/* Register Categories Definition */
#define RAFRAMEENGINE_OFFSET    0x0000
#define RAGDMA_OFFSET           0x0020
#define RAPSE_OFFSET            0x0040
#define RAGDMA2_OFFSET          0x0060
#define RACDMA_OFFSET           0x0080
#define RAPDMA_OFFSET           0x0100
#define RAPPE_OFFSET            0x0200
#define RACMTABLE_OFFSET        0x0400
#define RAPOLICYTABLE_OFFSET    0x1000

#define RALINK_INTCL_BASE       0xB0000200

#define PDMA_FC_CFG             (RA2882ETH_BASE+0x1f0)

#define NUM_RX_MAX_PROCESS 16

/* 1. Frame Engine Global Registers */
#define MDIO_ACCESS             (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x00)
#define MDIO_CFG                (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x04)
#define FE_GLO_CFG              (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x08)
#define FE_RST_GL               (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x0C)
#define FE_INT_STATUS           (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x10)
#define FE_INT_ENABLE           (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x14)
#define MDIO_CFG2               (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x18) //Original:FC_DROP_STA
#define FOC_TS_T                (RA2882ETH_BASE+RAFRAMEENGINE_OFFSET+0x1C)


/* 2. GDMA Registers */
#define GDMA1_FWD_CFG           (RA2882ETH_BASE+RAGDMA_OFFSET+0x00)
#define GDMA1_SCH_CFG           (RA2882ETH_BASE+RAGDMA_OFFSET+0x04)
#define GDMA1_SHPR_CFG          (RA2882ETH_BASE+RAGDMA_OFFSET+0x08)
#define GDMA1_MAC_ADRL          (RA2882ETH_BASE+RAGDMA_OFFSET+0x0C)
#define GDMA1_MAC_ADRH          (RA2882ETH_BASE+RAGDMA_OFFSET+0x10)

#define GDMA2_FWD_CFG           (RA2882ETH_BASE+RAGDMA2_OFFSET+0x00)
#define GDMA2_SCH_CFG           (RA2882ETH_BASE+RAGDMA2_OFFSET+0x04)
#define GDMA2_SHPR_CFG          (RA2882ETH_BASE+RAGDMA2_OFFSET+0x08)
#define GDMA2_MAC_ADRL          (RA2882ETH_BASE+RAGDMA2_OFFSET+0x0C)
#define GDMA2_MAC_ADRH          (RA2882ETH_BASE+RAGDMA2_OFFSET+0x10)

/* 3. PSE */
#define PSE_FQ_CFG              (RA2882ETH_BASE+RAPSE_OFFSET+0x00)
#define CDMA_FC_CFG             (RA2882ETH_BASE+RAPSE_OFFSET+0x04)
#define GDMA1_FC_CFG            (RA2882ETH_BASE+RAPSE_OFFSET+0x08)
#define GDMA2_FC_CFG            (RA2882ETH_BASE+RAPSE_OFFSET+0x0C)
#define PDMA_FC_CFG             (RA2882ETH_BASE+0x1f0)

/* 4. CDMA */
#define CDMA_CSG_CFG            (RA2882ETH_BASE+RACDMA_OFFSET+0x00)
#define CDMA_SCH_CFG            (RA2882ETH_BASE+RACDMA_OFFSET+0x04)
/* skip ppoe sid and vlan id definition */

/* 5. PDMA */
#define PDMA_GLO_CFG            (RA2882ETH_BASE+RAPDMA_OFFSET+0x00)
#define PDMA_RST_CFG            (RA2882ETH_BASE+RAPDMA_OFFSET+0x04)
#define PDMA_SCH_CFG            (RA2882ETH_BASE+RAPDMA_OFFSET+0x08)

#define DLY_INT_CFG             (RA2882ETH_BASE+RAPDMA_OFFSET+0x0C)

#define TX_BASE_PTR0            (RA2882ETH_BASE+RAPDMA_OFFSET+0x10)
#define TX_MAX_CNT0             (RA2882ETH_BASE+RAPDMA_OFFSET+0x14)
#define TX_CTX_IDX0             (RA2882ETH_BASE+RAPDMA_OFFSET+0x18)
#define TX_DTX_IDX0             (RA2882ETH_BASE+RAPDMA_OFFSET+0x1C)

#define TX_BASE_PTR1            (RA2882ETH_BASE+RAPDMA_OFFSET+0x20)
#define TX_MAX_CNT1             (RA2882ETH_BASE+RAPDMA_OFFSET+0x24)
#define TX_CTX_IDX1             (RA2882ETH_BASE+RAPDMA_OFFSET+0x28)
#define TX_DTX_IDX1             (RA2882ETH_BASE+RAPDMA_OFFSET+0x2C)

#define TX_BASE_PTR2            (RA2882ETH_BASE+RAPDMA_OFFSET+0x40)
#define TX_MAX_CNT2             (RA2882ETH_BASE+RAPDMA_OFFSET+0x44)
#define TX_CTX_IDX2             (RA2882ETH_BASE+RAPDMA_OFFSET+0x48)
#define TX_DTX_IDX2             (RA2882ETH_BASE+RAPDMA_OFFSET+0x4C)

#define TX_BASE_PTR3            (RA2882ETH_BASE+RAPDMA_OFFSET+0x50)
#define TX_MAX_CNT3             (RA2882ETH_BASE+RAPDMA_OFFSET+0x54)
#define TX_CTX_IDX3             (RA2882ETH_BASE+RAPDMA_OFFSET+0x58)
#define TX_DTX_IDX3             (RA2882ETH_BASE+RAPDMA_OFFSET+0x5C)

#define RX_BASE_PTR0            (RA2882ETH_BASE+RAPDMA_OFFSET+0x30)
#define RX_MAX_CNT0             (RA2882ETH_BASE+RAPDMA_OFFSET+0x34)
#define RX_CALC_IDX0            (RA2882ETH_BASE+RAPDMA_OFFSET+0x38)
#define RX_DRX_IDX0             (RA2882ETH_BASE+RAPDMA_OFFSET+0x3C)

#define RX_BASE_PTR1            (RA2882ETH_BASE+RAPDMA_OFFSET+0x40)
#define RX_MAX_CNT1             (RA2882ETH_BASE+RAPDMA_OFFSET+0x44)
#define RX_CALC_IDX1            (RA2882ETH_BASE+RAPDMA_OFFSET+0x48)
#define RX_DRX_IDX1             (RA2882ETH_BASE+RAPDMA_OFFSET+0x4C)

#define DELAY_INT_INIT          0x84048404
#define FE_INT_DLY_INIT         (RT2880_TX_DLY_INT | RT2880_RX_DLY_INT)
#define FE_INT_ALL              (RT2880_PSE_P2_FC | RT2880_PSE_BUF_DROP | \
                                 RT2880_GDM_OTHER_DROP | RT2880_PSE_P1_FC | \
                                 RT2880_PSE_P0_FC | RT2880_PSE_FQ_EMPTY |   \
                                 RT2880_TX_COHERENT | RT2880_RX_COHERENT |  \
                                 RT2880_TX_DONE_INT3 | RT2880_TX_DONE_INT2 | \
                                 RT2880_TX_DONE_INT1 | RT2880_TX_DONE_INT0 | \
                                 RT2880_RX_DONE_INT0 | RT2880_GE1_STA_CHG )



#define RT2880_BIT(x)              ((1 << x))


/* ====================================== */
#define RT2880_GDM1_DISPAD       RT2880_BIT(18)
#define RT2880_GDM1_DISCRC       RT2880_BIT(17)

//GDMA1 uni-cast frames destination port
#define RT2880_GDM1_ICS_EN         (0x1 << 22)
#define RT2880_GDM1_TCS_EN         (0x1 << 21)
#define RT2880_GDM1_UCS_EN         (0x1 << 20)
#define RT2880_GDM1_JMB_EN         (0x1 << 19)
#define RT2880_GDM1_STRPCRC        (0x1 << 16)
#define RT2880_GDM1_UFRC_P_CPU     (0 << 12)
#define RT2880_GDM1_UFRC_P_GDMA1   (1 << 12)
#define RT2880_GDM1_UFRC_P_PPE     (6 << 12)

//GDMA1 broad-cast MAC address frames
#define RT2880_GDM1_BFRC_P_CPU     (0 << 8)
#define RT2880_GDM1_BFRC_P_GDMA1   (1 << 8)
#define RT2880_GDM1_BFRC_P_PPE     (6 << 8)

//GDMA1 multi-cast MAC address frames
#define RT2880_GDM1_MFRC_P_CPU     (0 << 4)
#define RT2880_GDM1_MFRC_P_GDMA1   (1 << 4)
#define RT2880_GDM1_MFRC_P_PPE     (6 << 4)
//GDMA1 other MAC address frames destination port
#define RT2880_GDM1_OFRC_P_CPU     (0 << 0)
#define RT2880_GDM1_OFRC_P_GDMA1   (1 << 0)
#define RT2880_GDM1_OFRC_P_PPE     (6 << 0)

#define RT2880_ICS_GEN_EN          (1 << 2)
#define RT2880_UCS_GEN_EN          (1 << 1)
#define RT2880_TCS_GEN_EN          (1 << 0)

// MDIO_CFG     bit
#define RT2880_MDIO_CFG_GP1_FC_TX       (1 << 11)
#define RT2880_MDIO_CFG_GP1_FC_RX       (1 << 10)

/* ====================================== */
/* ====================================== */
#define RT2880_GP1_LNK_DWN     RT2880_BIT(9)
#define RT2880_GP1_AN_FAIL     RT2880_BIT(8)
/* ====================================== */
/* ====================================== */
#define RT2880_PSE_RESET       RT2880_BIT(0)
/* ====================================== */

#define RT2880_PST_DRX_IDX0       RT2880_BIT(16)
#define RT2880_PST_DTX_IDX3       RT2880_BIT(3)
#define RT2880_PST_DTX_IDX2       RT2880_BIT(2)
#define RT2880_PST_DTX_IDX1       RT2880_BIT(1)
#define RT2880_PST_DTX_IDX0       RT2880_BIT(0)

#define RT2880_TX_WB_DDONE       RT2880_BIT(6)
#define RT2880_RX_DMA_BUSY       RT2880_BIT(3)
#define RT2880_TX_DMA_BUSY       RT2880_BIT(1)
#define RT2880_RX_DMA_EN         RT2880_BIT(2)
#define RT2880_TX_DMA_EN         RT2880_BIT(0)

#define PDMA_BT_SIZE_4DWORDS     (0<<4)
#define PDMA_BT_SIZE_8DWORDS     (1<<4)
#define PDMA_BT_SIZE_16DWORDS    (2<<4)

#define TX_CTX_IDX0             (RA2882ETH_BASE+RAPDMA_OFFSET+0x18)

#define INIT_VALUE_OF_RT2883_PSE_FQ_CFG         0xff908000
#define INIT_VALUE_OF_RT2880_PSE_FQFC_CFG       0x80504000
#define INIT_VALUE_OF_ICPLUS_PHY_INIT_VALUE     0x1001BC01

#define RT2880_IRQ_ENET0	3

#define RALINK_FE_RST                   (1<<21)
#define RALINK_OTG_RST                  (1<<22)
#define RALINK_SW_RST                   (1<<23)
#define RALINK_EPHY_RST                 (1<<24)

#define FE_RESET        (RALINK_SYSCTL_BASE + 0x34)
#define FE_RESET_BIT    RALINK_FE_RST

/*=========================================
      PDMA RX Descriptor Format define
=========================================*/

//-------------------------------------------------
typedef struct _PDMA_RXD_INFO1_  PDMA_RXD_INFO1_T;

struct _PDMA_RXD_INFO1_
{
    unsigned int    PDP0;
};
//-------------------------------------------------
typedef struct _PDMA_RXD_INFO2_    PDMA_RXD_INFO2_T;

struct _PDMA_RXD_INFO2_
{
    unsigned int    PLEN1                 : 14;
    unsigned int    LS1                   : 1;
    unsigned int    UN_USED               : 1;
    unsigned int    PLEN0                 : 14;
    unsigned int    LS0                   : 1;
    unsigned int    DDONE_bit             : 1;
};
//-------------------------------------------------
typedef struct _PDMA_RXD_INFO3_  PDMA_RXD_INFO3_T;

struct _PDMA_RXD_INFO3_
{
    unsigned int    UN_USE1;
};
//-------------------------------------------------
typedef struct _PDMA_RXD_INFO4_    PDMA_RXD_INFO4_T;

struct _PDMA_RXD_INFO4_
{

    unsigned int    FOE_Entry           : 14;
    unsigned int    FVLD                : 1;
    unsigned int    UN_USE1             : 1;
    unsigned int    AI                  : 8;
    unsigned int    SP                  : 3;
    unsigned int    AIS                 : 1;
    unsigned int    L4F                 : 1;
    unsigned int    IPF                  : 1;
    unsigned int    L4FVLD_bit           : 1;
    unsigned int    IPFVLD_bit           : 1;
};


struct PDMA_rxdesc {
        PDMA_RXD_INFO1_T rxd_info1;
        PDMA_RXD_INFO2_T rxd_info2;
        PDMA_RXD_INFO3_T rxd_info3;
        PDMA_RXD_INFO4_T rxd_info4;
};

/*=========================================
      PDMA TX Descriptor Format define
=========================================*/
//-------------------------------------------------
typedef struct _PDMA_TXD_INFO1_  PDMA_TXD_INFO1_T;

struct _PDMA_TXD_INFO1_
{
    unsigned int    SDP0;
};
//-------------------------------------------------
typedef struct _PDMA_TXD_INFO2_    PDMA_TXD_INFO2_T;

struct _PDMA_TXD_INFO2_
{
    unsigned int    SDL1                  : 14;
    unsigned int    LS1_bit               : 1;
    unsigned int    BURST_bit             : 1;
    unsigned int    SDL0                  : 14;
    unsigned int    LS0_bit               : 1;
    unsigned int    DDONE_bit             : 1;
};
//-------------------------------------------------
typedef struct _PDMA_TXD_INFO3_  PDMA_TXD_INFO3_T;

struct _PDMA_TXD_INFO3_
{
    unsigned int    SDP1;
};
//-------------------------------------------------
typedef struct _PDMA_TXD_INFO4_    PDMA_TXD_INFO4_T;

struct _PDMA_TXD_INFO4_
{

    unsigned int    VIDX                : 4;
    unsigned int    VPRI                : 3;
    unsigned int    INSV                : 1;
    unsigned int    SIDX                : 4;
    unsigned int    INSP                : 1;
    unsigned int    RXIF                : 1; /* RT2880E used by hw_nat to identity RX interface */
    unsigned int    UN_USE3             : 2;
    unsigned int    QN                  : 3;
    unsigned int    UN_USE2             : 5;
    unsigned int    PN                  : 3;
    unsigned int    UN_USE1             : 2;
    unsigned int    TCO                 : 1;
    unsigned int    UCO                 : 1;
    unsigned int    ICO                 : 1;
};


struct PDMA_txdesc {
        PDMA_TXD_INFO1_T txd_info1;
        PDMA_TXD_INFO2_T txd_info2;
        PDMA_TXD_INFO3_T txd_info3;
        PDMA_TXD_INFO4_T txd_info4;
};


typedef struct MACInfo_s
{
        int ivec;       /* interrupt vector */
        unsigned char   macaddr[6];
} MAC_INFO;

typedef struct end_device
{
    unsigned int        ppeEbl;
    int                 enetUnit;       /* enet unit number */
    int                 isLAN;          /* 0-->WAN; 1-->LAN */
    int                 isRequestedUp;  /* desired state of UP & RUNNING */

    unsigned int        tx_cpu_owner_idx0;
    unsigned int        rx_cpu_owner_idx0;
    unsigned int        fe_int_status;
#if defined (CONFIG_RAETH_QOS)
    unsigned int        tx0_full, tx1_full, tx2_full, tx3_full, tx_full;
    unsigned int	phy_tx_ring0, phy_tx_ring1, phy_tx_ring2, phy_tx_ring3;
#else
    unsigned int        tx_full;
    unsigned int	phy_rx_ring, phy_tx_ring0;
#endif

    struct              tasklet_struct     rx_tasklet;
    struct              tasklet_struct     tx_tasklet;

#if defined(CONFIG_RAETH_QOS)
    struct		sk_buff *	   skb_free[NUM_TX_RINGS][NUM_TX_DESC];
    unsigned int	free_idx[NUM_TX_RINGS];
#else
    struct		sk_buff*	   skb_free[NUM_TX_DESC];
    unsigned int	free_idx;
#endif

    struct              MACInfo_s          *MACInfo;
    struct              net_device_stats stat;  /* The new statistics table. */
    spinlock_t          page_lock;              /* Page register locks */
    struct PDMA_txdesc *tx_ring0, *tx_ring1, *tx_ring2, *tx_ring3;
#ifdef CONFIG_RAETH_NAPI
    atomic_t irq_sem;
#endif
#ifdef CONFIG_PSEUDO_SUPPORT
    struct net_device *PseudoDev;
    unsigned int isPseudo;
#endif
#if defined (CONFIG_ETHTOOL) && ( defined (CONFIG_RAETH_ROUTER) || defined (CONFIG_RT_3052_ESW) )
	struct mii_if_info	mii_info;
#endif
} END_DEVICE, *pEND_DEVICE;

#define RA2882_ENET0	RA2882ETH_BASE

#define GMAC2_OFFSET    0x22
#define GMAC0_OFFSET    0x28 
#define GMAC1_OFFSET    0x2E

#define RT2880_IRQ_ENET0	3 

#define RAETH_VERSION   "v2.00"

void ei_tx_timeout(struct net_device *dev);

typedef struct rt3052_esw_reg {
	unsigned int off;
	unsigned int val;
} esw_reg;

typedef struct ralink_mii_ioctl_data {
	__u32	phy_id;
	__u32	reg_num;
	__u32	val_in;
	__u32	val_out;
} ra_mii_ioctl_data;

#define RAETH_MII_READ                  0x89F3
#define RAETH_MII_WRITE                 0x89F4

#define CONFIG_GIGAPHY

#endif
