#include <stdio.h>
#include <string.h>

static char *tmp_file = "/tmp/tmp.txt";

static int test_gpio(void)
{	
	FILE *fp;
	int i;
	fp=fopen("/proc/rf_switch","r");
	fscanf(fp,"%d",&i);
	fclose(fp); 
	return i;	
}

static int get_flash_int_value(char *keyword, int *pVal)
{
	char tmpbuf[100], *ptr;
	FILE *fp;
	
	sprintf(tmpbuf, "flash get %s > %s", keyword, tmp_file);
	system(tmpbuf);
		
	fp = fopen(tmp_file, "r");
	if (fp == NULL) {
		printf("read tmp file [%s] failed!\n", tmp_file);
		return 0;
	}
	fgets(tmpbuf, 100, fp);
	fclose(fp);	
	
	ptr = strchr(tmpbuf, '=');
	if (ptr == NULL) {
		printf("read %s value failed!\n", keyword);		
		return 0;			
	}
	
	*pVal = atoi(ptr+1);
	return 1;	
}

static is_wlan0_exist(void)
{
	char tmpbuf[100], *ptr;
	FILE *fp;
	
	sprintf(tmpbuf, "ifconfig > %s", tmp_file);
	system(tmpbuf);
	
	fp = fopen(tmp_file, "r");
	if (fp == NULL)
		return 0;
	
	while (fgets(tmpbuf, 100, fp)) {
		ptr = strstr(tmpbuf, "wlan0");	
		if (ptr) {
			if (strlen(ptr) <= 5)
				break;
			if (*(ptr+5) != '-')
				break;
		}
	}
	fclose(fp);
	
	return (ptr ? 1 : 0);
}

static void enable_wlan(void) 
{
	int repeader_enabled = 0; 
	
	get_flash_int_value("REPEATER_ENABLED1", &repeader_enabled);
	system("ifconfig wlan0 up"); 
	
	if (repeader_enabled) 
		system("ifconfig wlan0-vxd up"); 
}

static void disable_wlan(void)
{
	int repeader_enabled = 0;
	
	get_flash_int_value("REPEATER_ENABLED1", &repeader_enabled);
	system("iwpriv wlan0 set_mib keep_rsnie=1");
	system("ifconfig wlan0 down");	
	
	if (repeader_enabled)
		system("ifconfig wlan0-vxd down");
}

// Read RF h/w switch (GPIO6) to see if need to disable/enable wlan interface
static void poll_rf_switch(void)
{
	static int rf_enabled=2;
	static int is_wlan_enabled=-1;
	int temp, wlan_disabled;

	temp = test_gpio();
	
	if (rf_enabled == 2) { // first time
		rf_enabled = temp;
		return;		
	}
		
	if (temp != rf_enabled) {
		rf_enabled = temp;		
		
		if (!get_flash_int_value("WLAN_DISABLED", &wlan_disabled))
			return;		
		
		if (rf_enabled && !wlan_disabled)
			enable_wlan();		
		else	
			disable_wlan();
	}
	else {	
		if (is_wlan_enabled < 0) { // first time
			is_wlan_enabled = is_wlan0_exist();	
			get_flash_int_value("WLAN_DISABLED", &wlan_disabled);				
	
			if (!wlan_disabled && is_wlan_enabled && temp == 0)
				disable_wlan();
		}		
	}	
}

main()
{
FILE *fp;
int i;

  while(1)
  {	  
  fp=fopen("/proc/load_default","r");
  fscanf(fp,"%d",&i);
  if(i==1)
    {
    printf("Going to Reload Default\n");
    system("flash reset");
    system("reboot");
    }
  fclose(fp); 
  
  poll_rf_switch();   
  
  sleep(3);
  }
}
	
