var subnet_mask = new Array(0, 128, 192, 224, 240, 248, 252, 254, 255);
var msg = new Array("The IP address is an invalid address.",
					"The Lan IP address can not be zero.",
					"Lan IP address",
					"The Subnet Mask address is an invalid address.",
					"The Subnet Mask address can not be zero.",
					"Subnet Mask address",
					"The Gateway address is an invalid address.",
					"The Gateway address can not be zero.",
					"Gateway address",
					"The Lan IP address and the Gateway address are not in the same domain.",
					"The Start IP address is an invalid address.",
					"The Start IP address can not be zero.",
					"Start IP address",
					"The Lan IP address and the Start IP address are not in the same domain.",
					"The End IP address is an invalid address.",
					"The End IP address can not be zero.",
					"End IP address",
					"The Lan IP address and the End IP address are not in the same domain.",
					"The DNS Server address is an invalid address.",
					"The DNS Server address can not be zero.",
					"DNS Server address",
					"SSID can not be empty.",
					"The Encryption can not be disable when the Authentication Type is in the Shared Key mode.",
					"The length of PSK Key must be at least 8 characters.",
					"The Confirmed Passphrase does not match the Passphrase.",
					"The verfiy password does not match the password.",
					"The selected wep key can not be empty.",
					"The wep key can not be empty.",
					"Quit setup wizard and discard settings?",
					"The legal characters of MAC must be 0~9, A~F, or a~f.",
                    "The length of Passphrase is over 63 characters.");// PSK_OVER_LEN
var INVALID_IP_ADDRESS = 0;
var ZERO_IP_ADDRESS = 1;
var IP_ADDRESS_DESC = 2;
var INVALID_MASK_ADDRESS = 3;
var ZERO_MASK_ADDRESS = 4;
var MASK_ADDRESS_DESC = 5;
var INVALID_GATEWAY_ADDRESS = 6;
var ZERO_GATEWAY_ADDRESS = 7;
var GATEWAY_ADDRESS_DESC = 8;
var NOT_SAME_DOMAIN = 9;
var INVALID_START_IP = 10;
var ZERO_START_IP = 11;
var START_IP_DESC = 12;
var START_INVALID_DOMAIN = 13;
var INVALID_END_IP = 14;
var ZERO_END_IP = 15;
var END_IP_DESC = 16;
var END_INVALID_DOMAIN = 17;
var INVALID_DNS_ADDRESS = 18;
var ZERO_DNS_ADDRESS = 19;
var DNS_ADDRESS_DESC = 20;
var SSID_EMPTY_ERROR = 21;
var AUTH_TYPE_ERROR = 22;
var PSK_LENGTH_ERROR = 23;
var PSK_MATCH_ERROR = 24;
var MATCH_PWD_ERROR = 25;
var WEP_KEY_EMPTY = 26;
var WIZARD_KEY_EMPTY = 27;
var QUIT_WIZARD = 28;
var MAC_ADDRESS_ERROR = 29;
var PSK_OVER_LEN = 30;

function get_by_id(id){
	with(document){
		return getElementById(id);
	}
}

function get_by_name(name){
	with(document){
		return getElementsByName(name);
	}
}

function merge_addr(id, start, end){
	var addr = "";
	
	for (var i = start; i <= end; i++){
		var temp = get_by_id(id + i);
	
		addr += temp.value;		
		if (i < end){
			addr += ".";    		
		}
	}
    return addr;
}

function addr_obj(addr, desc, allow_zero, e_msg1, e_msg2, e_msg3, is_mask){	
	this.addr = addr;
	this.desc = msg[desc];
	this.allow_zero = allow_zero;	
	this.e_msg1 = msg[e_msg1];
	this.e_msg2 = msg[e_msg2];	
	
	if (e_msg3 != -1){
		this.e_msg3 = msg[e_msg3];	
	}
	this.is_mask = is_mask;	
}

function get_seq(index){
	var seq;
	
	switch(index){
		case 0:
			seq = "1st";
			break;
		case 1:
			seq = "2nd";
			break;
		case 2:
			seq = "3rd";
			break;
		case 3:
			seq = "4th";
			break;
	}
	return seq;
}

function check_ip_range(order, my_obj){
	var which_ip = (my_obj.addr[order]).split(" ");				
	var start, end;
								
	if (order != 3 || my_obj.is_mask){
		start = 0;
		end = 255;
	}else{					
		start = 1;
		end = 254;				
	}
					
	if (isNaN(which_ip) || which_ip == "" || which_ip.length > 1){
		alert("The " + get_seq(order) + " address of " + my_obj.desc + " must be an integer.");
		return false;
	}else if (parseInt(which_ip) < start || parseInt(which_ip) > end){
		alert("The " + get_seq(order) + " range of " + my_obj.desc + " must be between " + start + " to " + end + ".");
		return false;
	}				
	return true;
}

function is_valid_ip(my_obj){
	var count_zero = 0;
	var ip = my_obj.addr;
	
	for(var i = 0; i < ip.length; i++){
		if (ip[i] == "0"){
			count_zero++;
		}								
	}
	
	if (!my_obj.allow_zero && count_zero == 4){
		alert(my_obj.e_msg2);
		return false;
	}else{
		if (count_zero != 4){
			for(var i = 0; i < ip.length; i++){
				if (!check_ip_range(i, my_obj)){
					return false;
				}							
			}
		}
	}
	return true;				
}

function check_address(my_obj){					
	if (my_obj.addr.length == 4){										
		if (!is_valid_ip(my_obj)){					
			return false;
		}else{
			return true;
		}
	}else{
		alert(my_obj.e_msg1);
		return false;
	}				
}

function check_mask(my_mask){
	var temp_mask = my_mask.addr;							
	var in_range = false;
	var error;
	
	for (var i = 0; i < temp_mask.length; i++){	
		var mask = parseInt(temp_mask[i]);
						
		for (var j = 0; j < subnet_mask.length; j++){
			if (mask == subnet_mask[j]){							
				in_range = true;
				break;
			}else{
				in_range = false;
			}
		}
		
		if (!in_range){	// when not in the subnet mask range
			error = "The " + get_seq(i) + " range of " 
				+ my_mask.desc + " must be ";
			for (var j = 0; j < subnet_mask.length; j++){
				error += subnet_mask[j];
				if (j < subnet_mask.length - 1){
					error += ", ";
				}
			}
			alert(error);
			return false;
		}
		
		if (i != 0 && mask != 0){ // when not the 1st range and the value is not 0
			if (parseInt(temp_mask[i-1]) != 255){  // check the previous value is 255 or not
				alert(my_mask.e_msg1);
				return false;
			}
		}					
	}
	return true;
}

function check_domain(ip, mask, gateway){
	var temp_ip = ip.addr;
	var temp_mask = mask.addr;
	var temp_gateway = gateway.addr;
	var is_same = true;
	
	if (temp_gateway[0] == 0 && temp_gateway[1] == 0 && temp_gateway[2] == 0
			&& temp_gateway[3] == 0){
		if (gateway.allow_zero){
			return is_same;
		}
	}
		
	for (var i = 0; i < temp_ip.length - 1; i++){
		if ((temp_ip[i] & temp_mask[i]) != (temp_gateway[i] & temp_mask[i])){
			alert(gateway.e_msg3);
			is_same = false;		// when not in the same subnet mask, return false
			break;
		}
	}

	return is_same;
}

function check_lan_setting(ip, mask, gateway){				
	var temp_ip_obj = new addr_obj(ip.split("."), IP_ADDRESS_DESC, false, INVALID_IP_ADDRESS, ZERO_IP_ADDRESS, -1, false);
	var temp_mask_obj = new addr_obj(mask.split("."), MASK_ADDRESS_DESC, false, INVALID_MASK_ADDRESS, ZERO_MASK_ADDRESS, -1, true);
	var temp_gateway_obj = new addr_obj(gateway.split("."), GATEWAY_ADDRESS_DESC, true, INVALID_GATEWAY_ADDRESS, ZERO_GATEWAY_ADDRESS, NOT_SAME_DOMAIN, false);
		
	if (!check_address(temp_ip_obj)){
		return false;		// when ip is invalid
	}else if (!check_address(temp_mask_obj)){
		return false;	// when subnet mask is invalid
	}else if (!check_mask(temp_mask_obj)){
		return false;   // when subnet mask is not in the subnet mask range
	}else if (!check_address(temp_gateway_obj)){
		return false;	// when gateway is invalid
	}else if (!check_domain(temp_ip_obj, temp_mask_obj, temp_gateway_obj)){		// check if the ip and the gateway are in the same subnet mask or not					
		return false;
	}
	return true;
}

function check_dhcp_setting(ip, mask, start_ip, end_ip){				
	var temp_ip_obj = new addr_obj(ip.split("."), IP_ADDRESS_DESC, false, INVALID_IP_ADDRESS, ZERO_IP_ADDRESS, -1, false);
	var temp_mask_obj = new addr_obj(mask.split("."), MASK_ADDRESS_DESC, false, INVALID_MASK_ADDRESS, ZERO_MASK_ADDRESS, -1, true);
	var temp_start_obj = new addr_obj(start_ip.split("."), START_IP_DESC, false, INVALID_START_IP, ZERO_START_IP, START_INVALID_DOMAIN, false);
	var temp_end_obj = new addr_obj(end_ip.split("."), END_IP_DESC, false, INVALID_END_IP, ZERO_END_IP, END_INVALID_DOMAIN, false);
		
	if (!check_address(temp_start_obj)){
		return false;		// when start ip is invalid
	}else if (!check_address(temp_end_obj)){
		return false;	// when end ip is invalid	
	}else if (!check_domain(temp_ip_obj, temp_mask_obj, temp_start_obj)){	
		return false;	// check if the ip and the start ip are in the same subnet mask or not					
	}else if (!check_domain(temp_ip_obj, temp_mask_obj, temp_end_obj)){	
		return false;	// check if the ip and the end ip are in the same subnet mask or not					
	}
	return true;
}

function check_ssid(id){
	if (get_by_id(id).value == ""){
	    alert(msg[SSID_EMPTY_ERROR]);
	    return false;
	}
	return true;        
}

function check_pwd(pwd1, pwd2){
	if (get_by_id(pwd1).value != get_by_id(pwd2).value){
		 alert(msg[MATCH_PWD_ERROR]);
		 return false;
	}
	return true;
}

function send_submit(which_form){
	get_by_id(which_form).submit();
}

	function get_length(){
	var wep_key_len =get_by_name("wep_key_len");
	var length;
	
	if(wep_key_len[0].checked){
        	length = 5;
        }else if(wep_key_len[1].checked){
        	length = 13;
        }else{
        	length =5;
	}
	
	//switch(wep_key_len){
	//	case 1 :
	//		length = 5;
	//		break;
	//	case 2 :
	//		length = 13;
	//		break;
	//	default :
	//		length = 5;
	//		break;
	//}
	
	if (get_by_id("wep_key_type").value == "0"){
	    length *= 2;
	}
	return length;
}

	function get_wizard_length(){
	var wep_key_len =get_by_name("wep_key_len");
	var length;
	
	if(wep_key_len[1].checked){
        	length = 5;
        }else if(wep_key_len[2].checked){
        	length = 13;
        }else{
        	length =5;
	}
	
	//switch(wep_key_len){
	//	case 1 :
	//		length = 5;
	//		break;
	//	case 2 :
	//		length = 13;
	//		break;
	//	default :
	//		length = 5;
	//		break;
	//}
	
	if (get_by_id("wep_key_type").value == "0"){
	    length *= 2;
	}
	return length;
}

function check_key(){
	var wep_key_len = get_by_name("wep_key_len").value;
	var length = get_length();
	var wep_def_key = get_by_name("wep_def_key");
	var wep_key_type = get_by_id("wep_key_type").value;
	var key_len_msg;
	
	for (var i = 1; i < 5; i++){					
	    var key = get_by_id("key" + i).value;
	    
	    if (wep_def_key[i-1].checked){
		if (key == ''){
	            alert(msg[WEP_KEY_EMPTY]);
		    return false;
	        }
	        
		if (key.length < length){
                    alert("The length of Key" + i + " must be " + length + " characters.");
                    return false;
                }else{
            	if (wep_key_type == "0"){	// check the key is hex or not
	            	for (var j = 0; j < key.length; j++){
	            		if (!check_hex(key.substring(j, j+1))){
	            			alert("Key"+i+" is wrong, the legal characters are 0~9, A~F, or a~f.");
	            			return false;
	            		}
	            	}
	            }
            }
        }
      }
	return true;
}

function check_hex(data){
     data = data.toUpperCase();	    
	
     if (!(data >= 'A' && data <= 'F') && !(data >= '0' && data <= '9')){	
     	return false;
     }
     return true;
}




function check_filter_mac(node){
	var data = node.value;
	
	if (data.length == 0){
		node.value = "00";
	}else if (data.length == 1){
		if (check_hex(data)){
			node.value = "0" + data.toUpperCase();
		}else{
			node.value = "00";
			alert(msg[MAC_ADDRESS_ERROR]);
		}
	}else if (node.value.length == 2){		
		if (check_hex(data.substr(0,1)) && check_hex(data.substr(1,1))){
			node.value = data.toUpperCase();
		}else{
			node.value = "00";
			alert(msg[MAC_ADDRESS_ERROR]);
		}
	}
}

function MM_openBrWindow(theURL,winName,features) { //v2.0
  window.open(theURL, winName, features);
}

function ShowWizard(name){
	window.open(name,"Wizard","width=450,height=369")
}

function ExitWizard(){
    if (confirm(msg[QUIT_WIZARD])){
        window.close();
    }
}
