/* fpont 1/00 */
/* pont.net    */
/* tcpServer.c */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h> /* close */
#include <pthread.h>
#include <stdlib.h>
#include <string.h>
#include "mpcli.h"

#define SUCCESS 0
#define ERROR   1

#define END_LINE '\r'
#define SERVER_PORT 1501
#define MAX_MSG 100

#define MP_TIMEOUT_SECS		120

//#define ADDRESS_MAC_ETH0 0x07
//#define ADDRESS_MAC_ETH1 0x0d
//#define ADDRESS_MAC_WLAN 0x13
//#define LENGTH_MAC 6

#define FLASH_DEVICE_NAME		("/dev/mtd")

// Global variable for cli return infomation
RET_INFO	ret_info={ERR_OK, ""};

/* function readline */
int read_line();

/*
static int Read_Flash(char *buf, int offset, int len)
{
	int fh;
	int ok=1;

#ifdef __mips__
	fh = open(FLASH_DEVICE_NAME, O_RDWR);
#endif

#ifdef __i386__
	fh = open(FLASH_DEVICE_NAME, O_RDONLY);
#endif
	if ( fh == -1 )
		return 0;

	lseek(fh, offset, SEEK_SET);

	if ( read(fh, buf, len) != len)
		ok = 0;

	close(fh);

	return SUCCESS;
}


int ParseCMD(char *Cmd, char *Result)
{
	if(strcmp(Cmd,"ReadMAC_WLAN")==0)
	{
		Read_Flash(Result, ADDRESS_MAC_WLAN, LENGTH_MAC);
	}
	else if(strcmp(Cmd,"ReadMAC_ETH0")==0)
	{
		Read_Flash(Result, ADDRESS_MAC_ETH0, LENGTH_MAC);
	}
	else if(strcmp(Cmd,"ReadMAC_ETH1")==0)
	{
		Read_Flash(Result, ADDRESS_MAC_ETH1, LENGTH_MAC);
	}

	return SUCCESS;
}
*/
/*--------------------------------------------------------------
* ROUTINE NAME - MP_Process
*---------------------------------------------------------------
* FUNCTION: Run for "argv[0]" seconds.
* 
* INPUT:    How long this process should close
* OUTPUT:   None
* RETURN:   None
* NOTE:
---------------------------------------------------------------*/
int MP_Process (unsigned long secs) {
  
  int sd, newSd, cliLen, ret;
  
  fd_set        fdvar;
  struct        timeval tv;
  
  struct sockaddr_in cliAddr, servAddr;
  char line[MAX_MSG];

  /* create socket */
  sd = socket(AF_INET, SOCK_STREAM, 0);
   if(sd<0) {
    printf("\nMP:cannot open socket ");
    goto ERROR_OUT;
  }
  
  /* prepare FD set and timeout structure */
  FD_ZERO(&fdvar);
  FD_SET(sd, &fdvar);
  
  // in case of an unexpect error value
  if (secs > MP_TIMEOUT_SECS)
  	secs =  MP_TIMEOUT_SECS;
  	
  tv.tv_sec = secs;
  tv.tv_usec = 0;

  /* bind server port */
  servAddr.sin_family = AF_INET;
  servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servAddr.sin_port = htons(SERVER_PORT);
  
  if(bind(sd, (struct sockaddr *) &servAddr, sizeof(servAddr))<0) {
    	printf("\nMP:cannot bind port ");
    	goto ERROR_OUT;
  }

  if(listen(sd,5) == -1)
  { 
  	printf("\nListen error"); 
    	goto ERROR_OUT;
  } 

  while(1) {
	ret = select(sd+1, &fdvar, NULL, NULL, &tv);

	if (ret == 0) {
  		printf("\nMP_Process:no connection in %d seconds\r\n", secs);
  		goto ERROR_OUT;
	}	
	else if (ret == -1)	{
  		printf("\nMP_Process:select error !!");
  		goto ERROR_OUT;
	}
	
    cliLen = sizeof(cliAddr);
    newSd = accept(sd, (struct sockaddr *) &cliAddr, &cliLen);
    if(newSd<0) {
      printf("\nMP:cannot accept connection ");
      goto ERROR_OUT;
    }
    
    /* init line */
    memset(line,0x0,MAX_MSG);
    
    /* receive segments */
    while(read_line(newSd,line)!=ERROR) {
      
      printf("\nMP_Process: received from %s:TCP %d : %s\r\n", 
	     inet_ntoa(cliAddr.sin_addr),
	     ntohs(cliAddr.sin_port), line);

	  ret = MPCliProcess(line, strlen(line));

	  switch (ret_info.msg)
	  {
	  	case ERR_MAC_MAGIC:
	  	case ERR_NO_BID:
	  	case ERR_UNKNOW_CMD:
	  	case ERR_PASS_FAIL:
	  	case ERR_ARG_ERROR:
	  	case ERR_CMD_TOO_LONG:
	  		printf("Error : 0x%x\r\n", ret_info.msg);
	  		send(newSd, ret_info.value, strlen(ret_info.value) + 1, 0);
	  		break;
	  	case ERR_OK:
	  		printf("Done\r\n");
	  		break;
	  	case ERR_OK_PARAM:
	  		printf("  %s \r\n", ret_info.value);
	  		send(newSd, ret_info.value, strlen(ret_info.value) + 1, 0);
	  		break;
	  	default:
	  	case ERR_QUIT:
	  		// if return message is quit, that means we can shutdown server
	  		close(newSd);
	  		printf("Bye!\r\n");
	  		exit(1);
	  		// Should not be here!
	  		break;
	  }
	 
      /* init line */
      memset(line,0x0,MAX_MSG);
      memset(ret_info.value, 0x0, RET_VALUE_LENGTH);
	  
    } /* while(read_line) */
    
  } /* while (1) */

ERROR_OUT:
  //KNL_TASK_EXIT();
  
  return ERROR;
}


/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING       */
/* this function is experimental.. I don't know yet if it works  */
/* correctly or not. Use Steven's readline() function to have    */
/* something robust.                                             */
/* WARNING WARNING WARNING WARNING WARNING WARNING WARNING       */

/* rcv_line is my function readline(). Data is read from the socket when */
/* needed, but not byte after bytes. All the received data is read.      */
/* This means only one call to recv(), instead of one call for           */
/* each received byte.                                                   */
/* You can set END_CHAR to whatever means endofline for you. (0x0A is \n)*/
/* read_lin returns the number of bytes returned in line_to_return       */
int read_line(int newSd, char *line_to_return) {
  
  int rcv_ptr=0;
  char rcv_msg[MAX_MSG];
  int n=0;
  int offset;

  offset=0;

  while(1) {
    if(rcv_ptr==0) 
    {
      /* read data from socket */
      memset(rcv_msg,0x0,MAX_MSG); /* init buffer */
      n = recv(newSd, rcv_msg, MAX_MSG, 0); /* wait for data */
	  //printf("recv = %s, n=%d\r\n", rcv_msg, n);
	  if (n<0) 
      {
		printf(" cannot receive data ");
		return ERROR;
      } 
      else if (n==0) 
      {
		printf(" connection closed by client\n");
		close(newSd);
		return ERROR;
      }
	
    }



//HANDLE:  
    /* if new data read on socket */
    /* OR */
    /* if another line is still in buffer */

    /* copy line into 'line_to_return' */
    while(*(rcv_msg+rcv_ptr)!=END_LINE && rcv_ptr<n) {
      memcpy(line_to_return+offset,rcv_msg+rcv_ptr,1);
      offset++;
      rcv_ptr++;
    }

    
//printf("line_to_return %s\r",line_to_return);

    /* end of line + end of buffer => return line */
    if(rcv_ptr==n-1) { 
      /* set last byte to END_LINE */
      *(line_to_return+offset)=END_LINE;
      rcv_ptr=0;
      return ++offset;
    } 
    
    /* end of line but still some data in buffer => return line */
    if(rcv_ptr <n-1) {
      /* set last byte to END_LINE */
      *(line_to_return+offset)=END_LINE;
      rcv_ptr++;
      return ++offset;
    }

    /* end of buffer but line is not ended => */
    /*  wait for more data to arrive on socket */
    if(rcv_ptr == n) {
      rcv_ptr = 0;
    } 
    
  } /* while */
}
  
/*--------------------------------------------------------------
* ROUTINE NAME - MP_ProcessInit
*---------------------------------------------------------------
* FUNCTION: Run for "secs" seconds.
* 
* INPUT:    How long this process should close
* OUTPUT:   None
* RETURN:   None
* NOTE:
---------------------------------------------------------------*/
int MP_ProcessInit (unsigned long secs) 
{
	//pthread_t pthread_id;
	int child;

		
	/*if (pthread_create(&pthread_id, NULL, (void *)&MP_Process, secs) == -1) {
		perror("Thread creation error !!\n");
		exit(1);
	}*/

printf("child = fork();\n");
	child = fork();

	if (child == -1) {
		printf("MP: create fork faild !!\n");
		return -1;
	} else if(child != 0) {
printf("MP_Process....\n");
		MP_Process(secs);
		exit(1);
	}
		
	return 0;
}

