#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#include "errMsg.h"
#include "mpcli.h"

#include "apmib.h"
#include "apform.h"
#include "mibtbl.h"

#define MAX_ARG_NUM		16
#define MAX_CMD_LEN		256
#define PASSWORD_LENGTH	8

static int CmdIdx, NumCmd;
static char clibuf[MAX_CMD_LEN];
static int bufidx = 0, argcnt;
static char *argarray[MAX_ARG_NUM];

// Global variable in the tcpServer.c, for cmd return information
extern	RET_INFO	ret_info;

#define CAMEO_FW_VERSION cameofwVersion
#define CAMEO_FW_DATE	cameofwDate

extern char *cameofwVersion;	//defined in version.c
extern char *cameofwDate;		//defined in version.c


void CmdGetRegion(int argc, char **argv);
void CmdSetRegion(int argc, char **argv);
void CmdGetMac(int argc, char **argv);
void CmdSetNIC0Mac(int argc, char **argv);
void CmdSetNIC1Mac(int argc, char **argv);
void CmdSetWLANMac(int argc, char **argv);
void CmdGetFirmVer(int argc, char **argv);
void CmdGetFirmDate(int argc, char **argv);
void CmdQuit(int argc, char **argv);


static MPCLI_ENTRY mpcli_tab[] =
{
	{"12345678", "GetRegion", 9, CmdGetRegion, "Get Region", "<Password> GetRegion", 2, 2},
	{"12345678", "SetRegion", 9, CmdSetRegion, "Set Region", "<Password> SetRegion <Region Number>", 3, 3},
	{"12345678", "GetMac", 6, CmdGetMac, "Get Mac Address", "<Password> GetMac", 2, 2},
	{"12345678", "SetNIC0Mac", 10, CmdSetNIC0Mac, "Set NIC0 Mac Address", "<Password> SetNIC0Mac <MAC Address>", 3, 3},
	{"12345678", "SetNIC1Mac", 10, CmdSetNIC1Mac, "Set NIC1 Mac Address", "<Password> SetNIC1Mac <MAC Address>", 3, 3},
	{"12345678", "SetWLANMac", 10, CmdSetWLANMac, "Set WLAN Mac Address", "<Password> SetWLANMac <MAC Address>", 3, 3},
	{"12345678", "GetFirmVer", 10, CmdGetFirmVer, "Get Firmware Version", "<Password> GetFirmVer", 2, 2},
	{"12345678", "GetFirmDate", 11, CmdGetFirmDate, "Get Firmware Date", "<Password> GetFirmDate", 2, 2},
	{"12345678", "QQuit", 5, CmdQuit, "Quit Server", "QQuit", 2, 2},
};

// Project special definiton
#define	BID_LOCATION		(ROM_BASE+NIC0_MAC_LOCATION)

/**********************************************************************************/
/* InitCliProcess:																  */
/**********************************************************************************/
unsigned int MPInitCmdProcess(void)
{
	NumCmd = sizeof(mpcli_tab) / sizeof(MPCLI_ENTRY);
	CmdIdx = NumCmd - 1;

	return 1;
}



/**********************************************************************************/
/* CliProcess:																	  */
/**********************************************************************************/
CMD_MSG MPCliProcess(char *argv, int iLen)
{
	int i, key, iIndex= 0;
	
	char *token, ch;

	//count 
	MPInitCmdProcess();
	bufidx = 0;

	while(1)
	{
		if (iIndex >= iLen) 
		{
			break;
		}
		key = argv[iIndex++];
	
		// Put the character into the command line buffer
		ch = clibuf[bufidx++] = (char) key;

		switch(ch)
		{
			case '\r':		// Carrage return
				// Terminate the command line with NULL character (0x00)
				clibuf[bufidx] = 0;

				// Break the input line into arguments
				argcnt = 0;
				token = (char *) strtok(clibuf, " \t\n\r");
				while(token != NULL)
				{
					argarray[argcnt++] = token;
					if(argcnt >= MAX_ARG_NUM) 
							break;
					else	
							token = (char *) strtok(NULL, " \t\n\r");
				}
		
				if(argcnt > 0)
				{
					

					// Dispatch the command
					for(i=0; i< NumCmd; i++)
					{
						if(strncmp(argarray[1], mpcli_tab[i].cmdname, mpcli_tab[i].cmdlen)==0)
						{
							// check passowrd
							if (strncmp(argarray[0], mpcli_tab[i].password, PASSWORD_LENGTH) != 0)
							{
								bufidx = 0;
								printf("Password error!\r\n");
								ret_info.msg = ERR_PASS_FAIL;
								sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
								return ERR_PASS_FAIL;
							}
							else
							{
								// The command has been found and pass the password check.
							
								// Check the argument count
								if(argcnt < mpcli_tab[i].minargc || argcnt > mpcli_tab[i].maxargc)
								{
									ret_info.msg = ERR_ARG_ERROR;
									sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
									return ERR_ARG_ERROR;
								}
								else
								{						
									CmdIdx = i;			// Log the command ID
									printf("Exec : %s!\r\n", mpcli_tab[i].cmdname);
									// Execute the command
									(*mpcli_tab[i].cmd)(argcnt, argarray);
									
									return ret_info.msg;
								}
								break;
							}
						}
					}
					if(i == NumCmd)
					{
						// Unknown Command
						printf("unknow command\r\n");
						ret_info.msg = ERR_UNKNOW_CMD;
						sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
						return ERR_UNKNOW_CMD;
					}
				}
				// Empty the command buffer
				bufidx = 0;
				
				return ret_info.msg;
				break;

			default:
				if(bufidx >= MAX_CMD_LEN)
				{
					// The command line is too long. 
					// Drop the command.
					bufidx = 0;
					ret_info.msg = ERR_CMD_TOO_LONG;
					sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
					return 	ERR_CMD_TOO_LONG;
				}
		}
	}

	return ERR_OK;
}

void CmdGetRegion(int argc, char **argv)
{
	REG_DOMAIN_T domain;
	unsigned char buf[128];

	if ( !apmib_get( MIB_HW_REG_DOMAIN, (void *)&domain) ) {
		printf("Get MIB_HW_REG_DOMAIN error!!.\n");
		goto ErrorGetRegion;
	}

	ret_info.msg = ERR_OK_PARAM;
	sprintf(buf, "HW_REG_DOMAIN: %d \n", domain);
	strcpy(ret_info.value, buf);

	return;

ErrorGetRegion:
	ret_info.msg = ERR_ARG_ERROR;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	
	return;
}

void CmdSetRegion(int argc, char **argv)
{
	unsigned char buf[128];
	REG_DOMAIN_T domain;

	switch(atoi(argv[2])) {
		case 1:
			domain = FCC;
			break;
		case 2:
			domain = IC;
			break;
		case 3:
			domain = ETSI;
			break;
		case 4:
			domain = SPAIN;
			break;
		case 5:
			domain = FRANCE;
			break;
		case 6:
			domain = MKK;
			break;
		case 7:
			domain = ISRAEL;
			break;

		default:
			printf("Error Region domain code %d \n", atoi(argv[2]));
			goto ErrorSetRegion;
	}

	if ( !apmib_set(MIB_HW_REG_DOMAIN, (void *)&domain)) {
		printf("Set MIB_HW_REG_DOMAIN error!!.\n");
		goto ErrorSetRegion;
	}

	apmib_update(HW_SETTING);

	ret_info.msg = ERR_OK_PARAM;
	sprintf(buf, "HW_REG_DOMAIN: %d \n", domain);
	strcpy(ret_info.value, buf);
   	
	return;

ErrorSetRegion:
	ret_info.msg = ERR_ARG_ERROR;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	
	return;
}

void CmdGetMac(int argc, char **argv)
{
	unsigned char buf[128];
	unsigned char mac[8]={0};
	
	if ( !apmib_get(MIB_HW_NIC0_ADDR,  (void *)mac) ) {
		printf("Get MIB_ELAN_MAC_ADDR error!!.\n");
		goto ErrorGetMac;
	}

	ret_info.msg = ERR_OK_PARAM;
	sprintf(buf, "HW_NIC0_ADDR_NIC0: %02x%02x%02x%02x%02x%02x\r", 	mac[0], mac[1],mac[2],
								mac[3], mac[4],mac[5]);
	strcpy(ret_info.value, buf);
	
	return;
	
ErrorGetMac:
	ret_info.msg = ERR_MAC_MAGIC;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	
	return;
}

void CmdSetNIC0Mac(int argc, char **argv)
{
	char macbuf[100];

	if(argv[2][0] != 0)
	{
		if (strlen(argv[2])!=12 || !string_to_hex(argv[2], macbuf, 12)) {
			printf("Error! Invalid MAC address.!!\n");
			goto ErrorSetNIC0Mac;
		}

		if ( !apmib_set(MIB_HW_NIC0_ADDR, (void *)macbuf)) {
			printf("Set MIB_HW_NIC0_ADDR mib error!!\n");
			goto ErrorSetNIC0Mac;
		}
		
		apmib_update(HW_SETTING);
	}
	else
	{
		printf("Error! Invalid MAC address. !!\n");
		goto ErrorSetNIC0Mac;
	}
	
	ret_info.msg = ERR_OK_PARAM;
	sprintf(ret_info.value, "HW_NIC0_ADDR: %s\r\n", argv[2]);
	
	return;
	
ErrorSetNIC0Mac:
	ret_info.msg = ERR_MAC_MAGIC;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	return;
}

void CmdSetNIC1Mac(int argc, char **argv)
{
	char macbuf[100];

	if(argv[2][0] != 0)
	{
		if (strlen(argv[2])!=12 || !string_to_hex(argv[2], macbuf, 12)) {
			printf("Error! Invalid MAC address.!!\n");
			goto ErrorSetNIC1Mac;
		}

		if ( !apmib_set(MIB_HW_NIC1_ADDR, (void *)macbuf)) {
			printf("Set MIB_HW_NIC1_ADDR mib error!!\n");
			goto ErrorSetNIC1Mac;
		}
		
		apmib_update(HW_SETTING);
	}
	else
	{
		printf("Error! Invalid MAC address. !!\n");
		goto ErrorSetNIC1Mac;
	}
	
	ret_info.msg = ERR_OK_PARAM;
	sprintf(ret_info.value, "HW_NIC1_ADDR: %s\r\n", argv[2]);
	
	return;
	
ErrorSetNIC1Mac:
	ret_info.msg = ERR_MAC_MAGIC;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	return;
}

void CmdSetWLANMac(int argc, char **argv)
{
	char macbuf[100];

	if(argv[2][0] != 0)
	{
		if (strlen(argv[2])!=12 || !string_to_hex(argv[2], macbuf, 12)) {
			printf("Error! Invalid MAC address.!!\n");
			goto ErrorSetWLANMac;
		}

		if ( !apmib_set(MIB_HW_WLAN_ADDR, (void *)macbuf)) {
			printf("Set MIB_HW_WLAN_ADDR mib error!!\n");
			goto ErrorSetWLANMac;
		}
		
		apmib_update(HW_SETTING);
	}
	else
	{
		printf("Error! Invalid MAC address. !!\n");
		goto ErrorSetWLANMac;
	}
	
	ret_info.msg = ERR_OK_PARAM;
	sprintf(ret_info.value, "HW_WLAN_ADDR: %s\r\n", argv[2]);
	
	return;
	
ErrorSetWLANMac:
	ret_info.msg = ERR_MAC_MAGIC;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	return;
}

void CmdGetFirmVer(int argc, char **argv)
{
	unsigned char buf[128];

	ret_info.msg = ERR_OK_PARAM;
	sprintf(buf, "%s", CAMEO_FW_VERSION );
	strcpy(ret_info.value, buf);

	return;

ErrorGetFirmVer:
	ret_info.msg = ERR_ARG_ERROR;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	
	return;
}

void CmdGetFirmDate(int argc, char **argv)
{
	unsigned char buf[128];

	ret_info.msg = ERR_OK_PARAM;
	sprintf(buf, "%s", CAMEO_FW_DATE);
	strcpy(ret_info.value, buf);

	return;

ErrorGetFirmDate:
	ret_info.msg = ERR_ARG_ERROR;
	sprintf(ret_info.value, "err: 0x%08x\r", ret_info.msg);
	
	return;
}


void CmdQuit(int argc, char **argv)
{
	printf("Quit\r\n");
	ret_info.msg = ERR_QUIT;
	
	return;
}

