/*
 *      Web server handler routines for TCP/IP stuffs
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmtcpip.c,v 1.2 2005/07/13 03:27:21 CAMEO+brian Exp $
 *
 */

/*-- System inlcude files --*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>
#include <net/route.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <net/if.h>

/*-- Local inlcude files --*/
//#include "webs.h"
#ifdef HOME_GATEWAY
#include "../wsIntrn.h"
#endif
#include "apmib.h"
#include "apform.h"
#include "utility.h"
#include "uemf.h"

#ifdef __i386__
#define _LITTLE_ENDIAN_
#endif

#define _DHCPD_PROG_NAME	T("udhcpd")
#define _DHCPD_PID_PATH		T("/var/run")
#define _DHCPC_PROG_NAME	T("udhcpc")
#define _DHCPC_PID_PATH		T("/etc/udhcpc")
#define _PATH_DHCPS_LEASES	T("/var/lib/misc/udhcpd.leases")

extern char *BRIDGE_IF;
extern char *ELAN_IF;

/*-- Macro declarations --*/
#ifdef _LITTLE_ENDIAN_
#define ntohdw(v) ( ((v&0xff)<<24) | (((v>>8)&0xff)<<16) | (((v>>16)&0xff)<<8) | ((v>>24)&0xff) )

#else
#define ntohdw(v) (v)
#endif

#define RECONNECT_MSG(url) { \
	websHeader(wp); \
	websWrite(wp, T("<HEAD><TITLE>Change Settings</TITLE><BODY text=#000000 bgColor=#ffffff topMargin=0>\n")); \
	websWrite(wp, T("<TABLE cellSpacing=0 cellPadding=0 width=765 align=center border=0>\n")); \
	websWrite(wp, T("<TBODY><TR><TD><IMG height=95 src=\"/images/home_01.jpg\" width=765></TD></TR>\n")); \
	websWrite(wp, T("<TR><TD background=/images/home_02.jpg><DIV align=left>\n")); \
	websWrite(wp, T("<TABLE height=\"131\" cellSpacing=0 cellPadding=0 width=\"500\" align=center border=0>\n")); \
	websWrite(wp, T("<TBODY><TR><TD><DIV align=center><FONT face=Arial><B></B></FONT></DIV></TD></TR>\n")); \
	websWrite(wp, T("<TR><TD>&nbsp;</TD></TR><TR><TD><DIV align=center>\n")); \
	websWrite(wp, T("<FONT face=Arial color=#000000 size=2>Change setting successfully!" \
					"<BR><BR>If IP address was modified, you have to re-connect the WebServer" \
					"<BR>with the new address.<BR><BR></FONT></DIV></TD></TR>\n")); \
	websWrite(wp, T("<TR><TD>&nbsp;</TD></TR><TR><TD><DIV align=center>\n")); \
	websWrite(wp, T("<A href=javascript:window.location.replace(\"%s\")>\n"), url); \
	websWrite(wp, T("<IMG height=35 src=\"/images/continue_p.gif\" width=70 border=0></A></DIV></TD></TR>\n")); \
	websWrite(wp, T("<TR><TD><DIV align=center></DIV></TD></TR></TBODY></TABLE></DIV></TD></TR>\n")); \
	websWrite(wp, T("<TR><TD background=/images/home_03.jpg><DIV align=right>\n")); \
	websWrite(wp, T("<IMG height=27 src=\"/images/down_44.gif\" width=25></DIV></TD></TR></TBODY></TABLE></BODY>\n")); \
	websFooter(wp); \
	websDone(wp, 200); \
}

/*-- Forward declarations --*/
static int getOneDhcpClient(char **ppStart, unsigned long *size, char *name, char *ip, char *mac, char *liveTime);
static int getOnePCList(char **ppStart, unsigned long *size, char *ip, char *mac, char *liveTime);
static int getPid(char *filename);
#if 0
static DHCP_T wanDhcpTmp=(DHCP_T)-1;
#endif

//////////////////////////////////////////////////////////////////////////////
static int getOnePCList(char **ppStart, unsigned long *size, char *ip, char *mac, char *liveTime)
{
	struct dhcpOfferedAddr {
        	u_int8_t chaddr[16];
        	u_int32_t yiaddr;       /* network order */
        	u_int32_t expires;      /* host order */
		u_int8_t hostname[64];	/* host name */
	};

	struct dhcpOfferedAddr entry;

	if ( *size < sizeof(entry) )
		return -1;

	entry = *((struct dhcpOfferedAddr *)*ppStart);
	*ppStart = *ppStart + sizeof(entry);
	*size = *size - sizeof(entry);

	if (entry.expires == 0)
		return 0;

	snprintf(mac, 20, "%02x-%02x-%02x-%02x-%02x-%02x",
			entry.chaddr[0],entry.chaddr[1],entry.chaddr[2],entry.chaddr[3],
			entry.chaddr[4], entry.chaddr[5]);

	return 1;
}

//////////////////////////////////////////////////////////////////////////////
static int getOneDhcpClient(char **ppStart, unsigned long *size, char *name, char *ip, char *mac, char *liveTime)
{
	struct dhcpOfferedAddr {
        	u_int8_t chaddr[16];
        	u_int32_t yiaddr;       /* network order */
        	u_int32_t expires;      /* host order */
		u_int8_t hostname[64];	/* host name */
	};

	struct dhcpOfferedAddr entry;

	if ( *size < sizeof(entry) )
		return -1;

	entry = *((struct dhcpOfferedAddr *)*ppStart);
	*ppStart = *ppStart + sizeof(entry);
	*size = *size - sizeof(entry);

	if (entry.expires == 0)
		return 0;

	if (entry.hostname[0])
		strcpy(name, (char *)&entry.hostname);
	else
		strcpy(name, "UnKnow");
	strcpy(ip, inet_ntoa(*((struct in_addr *)&entry.yiaddr)) );
	snprintf(mac, 20, "%02x:%02x:%02x:%02x:%02x:%02x",
			entry.chaddr[0],entry.chaddr[1],entry.chaddr[2],entry.chaddr[3],
			entry.chaddr[4], entry.chaddr[5]);

	snprintf(liveTime, 10, "%lu", (unsigned long)ntohl(entry.expires));

	return 1;
}

///////////////////////////////////////////////////////////
static int getPid(char *filename)
{
	struct stat status;
	char buff[100];
	FILE *fp;

	if ( stat(filename, &status) < 0)
		return -1;
	fp = fopen(filename, "r");
	if (!fp) {
        	error(E_L, E_LOG, T("Read pid file error!\n"));
		return -1;
   	}
	fgets(buff, 100, fp);
	fclose(fp);

	return (atoi(buff));
}
int tcpipLanHandler(webs_t wp, char *tmpBuf)
{
	char_t	*strIp, *strMask, *strGateway, *strDhcp, *strStp, *strMac, *strDNS, *strLeaseTime, *strLantype;
	struct in_addr inIp, inMask, inGateway;
	DHCP_T dhcp, curDhcp;	

	int stp, leaseTime;
	char_t	*strdhcpRangeStart, *strdhcpRangeEnd;
	struct in_addr dhcpRangeStart, dhcpRangeEnd;
	struct in_addr dns1, dns2, dns3;
	char dhcp_0[2];	


	// Set STP
	strStp = websGetVar(wp, T("stp"), T(""));
	if (strStp[0]) {
		if (strStp[0] == '0')
			stp = 0;
		else
			stp = 1;
		if ( !apmib_set(MIB_STP_ENABLED, (void *)&stp)) {
			strcpy(tmpBuf, T("Set STP mib error!"));
			goto setErr_tcpip;
		}
	}

	// Set clone MAC address
	strMac = websGetVar(wp, T("lan_macAddr"), T(""));
	if (strMac[0]) {
		if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_ELAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_ELAN_MAC_ADDR mib error!"));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_WLAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WLAN_MAC_ADDR mib error!"));
			goto setErr_tcpip;
		}
	}

	// Read current DHCP setting for reference later
	if ( !apmib_get( MIB_DHCP, (void *)&curDhcp) ) {
		strcpy(tmpBuf, T("Get DHCP MIB error!"));
		goto setErr_tcpip;
	}

	strDhcp = websGetVar(wp, T("dhcp"), T(""));
	strLantype = websGetVar(wp, T("lan_type"), T(""));
	if(!strDhcp[0]) 
	{
		strDhcp = dhcp_0;
		strDhcp[0] = '0';
	}
	if ( strDhcp[0] && strLantype[0]) {
		if ( strDhcp[0]!='0' && strDhcp[0]!='2' ) {
			strcpy(tmpBuf, T("Invalid DHCP value!"));
			goto setErr_tcpip;
		}
		if ( strLantype[0]!='0' && strLantype[0]!='1' ) {
			strcpy(tmpBuf, T("Invalid DHCP value!"));
			goto setErr_tcpip;
		}
		// set to MIB
		if ( strLantype[0] == '1' ){
			dhcp = DHCP_CLIENT;
		}else if (strLantype[0] == '0'){
			if ( strDhcp[0] == '0' ){
				dhcp = DHCP_DISABLED;
			}else if (strDhcp[0] == '2'){
				dhcp = DHCP_SERVER;
			}
		}
	}
	else
		dhcp = curDhcp;
	
	if ( dhcp == DHCP_DISABLED || dhcp == DHCP_SERVER ) {
		strIp = websGetVar(wp, T("lan_ip"), T(""));
		if ( strIp[0] ) {
			if ( !inet_aton(strIp, &inIp) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}
		}
		else { // get current used IP
			if ( !getInAddr(BRIDGE_IF, IP_ADDR, (void *)&inIp) ) {
				strcpy(tmpBuf, T("Get IP-address error!"));
				goto setErr_tcpip;
			}
		}

		strMask = websGetVar(wp, T("lan_mask"), T(""));
		if ( strMask[0] ) {
			if ( !inet_aton(strMask, &inMask) ) {
				strcpy(tmpBuf, T("Invalid subnet-mask value!"));
				goto setErr_tcpip;
			}
		}
		else { // get current used netmask
			if ( !getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&inMask )) {
				strcpy(tmpBuf, T("Get subnet-mask error!"));
				goto setErr_tcpip;
			}
		}
		//John H. 2006.01.10 move here to fix LAN ip bug
		if ( strIp[0] && strMask[0] ) {
			unsigned long mask_t, ip_t, mask_all=0xffffffff;

			ip_t = *((unsigned long *)&inIp);
			mask_t = *((unsigned long *)&inMask);

		    if((((ip_t & 0xff000000) >> 24) == 127) ||
		        (((ip_t & 0xff000000) >> 24) == 224) ) {
			    strcpy(tmpBuf, T("127 and 224 is special for Microsoft!"));
			    goto setErr_tcpip;
		    }
		    if((ip_t & (~mask_t)) == (mask_all & (~mask_t))) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}		        
		    if(mask_t == mask_all) {
				strcpy(tmpBuf, T("Invalid subnet-mask value!"));
				goto setErr_tcpip;
			}		        
		}
		
		if ( dhcp == DHCP_SERVER ) {
			// Get/Set DHCP client range
			strdhcpRangeStart = websGetVar(wp, T("dhcpRangeStart"), T(""));
			if ( strdhcpRangeStart[0] ) {
				if ( !inet_aton(strdhcpRangeStart, &dhcpRangeStart) ) {
					strcpy(tmpBuf, T("Invalid DHCP client start address!"));
					goto setErr_tcpip;
				}
			}
			strdhcpRangeEnd = websGetVar(wp, T("dhcpRangeEnd"), T(""));
			if ( strdhcpRangeEnd[0] ) {
				if ( !inet_aton(strdhcpRangeEnd, &dhcpRangeEnd) ) {
					strcpy(tmpBuf, T("Invalid DHCP client end address!"));
					goto setErr_tcpip;
				}
			}

			if ( strdhcpRangeStart[0] && strdhcpRangeEnd[0] ) {
				unsigned long start, end, mask, ip;
				int diff;

				start = *((unsigned long *)&dhcpRangeStart);
				end = *((unsigned long *)&dhcpRangeEnd);
				diff = (int) ( ntohdw(end) - ntohdw(start) );
				ip = *((unsigned long *)&inIp);
				mask = *((unsigned long *)&inMask);
				if (diff <= 0 ||
					diff > 256*3 ||
					(ip&mask) != (start&mask) ||
					(ip&mask) != (end& mask) ) {
					strcpy(tmpBuf, T("Invalid DHCP client range!"));
					goto setErr_tcpip;
				}
				if((ip>=start)&&(ip<=end)) {
					strcpy(tmpBuf, T("Invalid DHCP client range!"));
					goto setErr_tcpip;
				}
			}

            //John H. 2006.01.23 move here to fix DHCP bug
		    strLeaseTime = websGetVar(wp, T("leaseTime"), T(""));
		    if ( strLeaseTime[0] ) {
			    if ( !string_to_dec(strLeaseTime, &leaseTime) ) {
				    strcpy(tmpBuf, T("Error! Invalid value of DHCP Lease Time."));
				    goto setErr_tcpip;
			    }

			    if ( !apmib_set(MIB_DHCP_LEASE_TIME, (void *)&leaseTime)) {
	  			    strcpy(tmpBuf, T("Set DHCP LEASE TIME MIB error!"));
				    goto setErr_tcpip;
			    }
		    }
            //John H. 2006.01.23 move here to fix DHCP bug

            //John H. 2006.01.10 move here to fix DHCP bug
            if ( strdhcpRangeStart[0] )
			if ( !apmib_set(MIB_DHCP_CLIENT_START, (void *)&dhcpRangeStart)) {
				strcpy(tmpBuf, T("Set DHCP client start address error!"));
				goto setErr_tcpip;
			}
			if ( strdhcpRangeEnd[0] )
			if ( !apmib_set(MIB_DHCP_CLIENT_END, (void *)&dhcpRangeEnd)) {
				strcpy(tmpBuf, T("Set DHCP client end address error!"));
				goto setErr_tcpip;
			}			
			//John H. 2006.01.10 move here to fix DHCP bug

			// If DHCP server is enabled in LAN, update dhcpd.conf
			strDNS = websGetVar(wp, T("dns1"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns1) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}

				if ( !apmib_set(MIB_WAN_DNS1, (void *)&dns1)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}

			strDNS = websGetVar(wp, T("dns2"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns2) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_WAN_DNS2, (void *)&dns2)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}

			strDNS = websGetVar(wp, T("dns3"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns3) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_WAN_DNS3, (void *)&dns3)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
		}

		//John H. 2006.05.03 move here to fix LAN ip bug
		
		strGateway = websGetVar(wp, T("lan_gateway"), T(""));
		if ( (dhcp == DHCP_DISABLED && strGateway[0]) || 
			(dhcp == DHCP_SERVER && strGateway[0])	) {
			if ( !inet_aton(strGateway, &inGateway) ) {
				strcpy(tmpBuf, T("Invalid default-gateway value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_DEFAULT_GATEWAY, (void *)&inGateway)) {
				strcpy(tmpBuf, T("Set default-gateway error!"));
				goto setErr_tcpip;
			}
		}

		
		// If DHCP server is enabled in LAN, update dhcpd.conf
		strDNS = websGetVar(wp, T("dns1"), T(""));
		if ( strDNS[0] ) {
			if ( !inet_aton(strDNS, &dns1) ) {
				strcpy(tmpBuf, T("Invalid DNS address value!"));
				goto setErr_tcpip;
			}

			if ( !apmib_set(MIB_WAN_DNS1, (void *)&dns1)) {
	  			strcpy(tmpBuf, T("Set DNS MIB error!"));
				goto setErr_tcpip;
			}
		}

		if ( strIp[0] )
		if ( !apmib_set( MIB_IP_ADDR, (void *)&inIp)) {
			strcpy(tmpBuf, T("Set IP-address error!"));
			goto setErr_tcpip;
		}
		if ( strMask[0] )
		if ( !apmib_set(MIB_SUBNET_MASK, (void *)&inMask)) {
			strcpy(tmpBuf, T("Set subnet-mask error!"));
			goto setErr_tcpip;
		}		
		//John H. 2006.05.03 move here to fix LAN ip bug
		
	}
    //John H. 2006.01.23 move here to fix DHCP bug
	if ( strDhcp[0] && strLantype[0] ) {
		if ( !apmib_set(MIB_DHCP, (void *)&dhcp)) {
	  		strcpy(tmpBuf, T("Set DHCP error!"));
			goto setErr_tcpip;
		}
	}
    //John H. 2006.01.23 move here to fix DHCP bug
	return 0 ;
setErr_tcpip:
	return -1 ;	
}

///////////////////////////////////////////////////////////////////
void formTcpipSetup(webs_t wp, char_t *path, char_t *query)
{

	char tmpBuf[100];
	char_t *submitUrl ;
#ifndef NO_ACTION
	int pid;
#endif

	if(tcpipLanHandler(wp, tmpBuf) < 0)
		goto setErr_end ;

	apmib_update(CURRENT_SETTING);	// update configuration to flash

#ifndef NO_ACTION
	pid = fork();
        if (pid)
                waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
                exit(1);
        }
#endif

	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	
	//RECONNECT_MSG(submitUrl);	// display reconnect msg to remote
	OK_MSG(submitUrl);

	return;

setErr_end:
	ERR_MSG(tmpBuf);
}


#ifdef HOME_GATEWAY
int tcpipWanHandler(webs_t wp, char * tmpBuf, int *dns_changed)
{
	
	char_t	*strIp, *strMask, *strGateway, *strDNS, *strMode, *strConnect, *strMac;
	char_t  *strVal;
	int intVal;
	struct in_addr inIp, inMask,dns1, dns2, dns3, inGateway;
	DHCP_T dhcp, curDhcp;
	
	DNS_TYPE_T dns, dns_old;

	char_t *submitUrl;
#ifndef NO_ACTION
	int pid;
#endif
	

	int buttonState=0;	
	
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	strConnect = websGetVar(wp, T("pppConnect"), T(""));
	if (strConnect && strConnect[0]) {
		buttonState = 1;
		strMode = T("ppp");
		goto set_ppp;
	}

        strConnect = websGetVar(wp, T("pppDisconnect"), T(""));
	if (strConnect && strConnect[0]) {
		buttonState = 2;
		strMode = T("ppp");
		goto set_ppp;
	}
#if 0 //sc_yang
	strVal = websGetVar(wp, T("save"), T(""));
	if (!strVal || !strVal[0]) { // not save, wan type is changed
		strVal = websGetVar(wp, T("wanType"), T(""));
		wanDhcpTmp = (DHCP_T)(strVal[0] - '0');

		if (submitUrl && submitUrl[0])
			websRedirect(wp, submitUrl);
		return;
	}
#endif
 	// Set clone MAC address
	strMac = websGetVar(wp, T("wan_macAddr"), T(""));
	if (strMac[0]) {
		if (strlen(strMac)!=12 || !string_to_hex(strMac, tmpBuf, 12)) {
			strcpy(tmpBuf, T("Error! Invalid MAC address."));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_WAN_MAC_ADDR, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("Set MIB_WAN_MAC_ADDR mib error!"));
			goto setErr_tcpip;
		}
	}

	strMode = websGetVar(wp, T("dnsMode"), T(""));
	if ( strMode && strMode[0] ) {
		if (!strcmp(strMode, T("dnsAuto")))
			dns = DNS_AUTO;
		else if (!strcmp(strMode, T("dnsManual")))
			dns = DNS_MANUAL;
		else {
			strcpy(tmpBuf, T("Invalid DNS mode value!"));
			goto setErr_tcpip;
		}

		if ( !apmib_get(MIB_WAN_DNS_MODE, (void *)&dns_old)) {
	  		strcpy(tmpBuf, T("Get DNS MIB error!"));
			goto setErr_tcpip;
		}
		if (dns != dns_old)
			*dns_changed = 1;

		// Set DNS to MIB
		if ( !apmib_set(MIB_WAN_DNS_MODE, (void *)&dns)) {
	  		strcpy(tmpBuf, T("Set DNS MIB error!"));
			goto setErr_tcpip;
		}

		if ( dns == DNS_MANUAL ) {
			struct in_addr dns1_old, dns2_old, dns3_old;
			if ( !apmib_get(MIB_WAN_DNS1, (void *)&dns1_old)) {
	  			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
				goto setErr_tcpip;
			}
			if ( !apmib_get(MIB_WAN_DNS2, (void *)&dns2_old)) {
	  			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
				goto setErr_tcpip;
			}
			if ( !apmib_get(MIB_WAN_DNS3, (void *)&dns3_old)) {
	  			strcpy(tmpBuf, T("Get DNS1 MIB error!"));
				goto setErr_tcpip;
			}

			// If DHCP server is enabled in LAN, update dhcpd.conf
			strDNS = websGetVar(wp, T("dns1"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns1) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}

				if ( !apmib_set(MIB_WAN_DNS1, (void *)&dns1)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
			else {
				if ( !apmib_get(MIB_WAN_DNS1, (void *)&dns1) ) {
					strcpy(tmpBuf, T("Get DNS1 MIB error!"));
					goto setErr_tcpip;
				}
			}
			strDNS = websGetVar(wp, T("dns2"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns2) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_WAN_DNS2, (void *)&dns2)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
			else {
				if ( !apmib_get(MIB_WAN_DNS2, (void *)&dns2) ) {
					strcpy(tmpBuf, T("Get DNS2 MIB error!"));
					goto setErr_tcpip;
				}
			}
			strDNS = websGetVar(wp, T("dns3"), T(""));
			if ( strDNS[0] ) {
				if ( !inet_aton(strDNS, &dns3) ) {
					strcpy(tmpBuf, T("Invalid DNS address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_WAN_DNS3, (void *)&dns3)) {
	  				strcpy(tmpBuf, T("Set DNS MIB error!"));
					goto setErr_tcpip;
				}
			}
			else {
				if ( !apmib_get(MIB_WAN_DNS3, (void *)&dns3) ) {
					strcpy(tmpBuf, T("Get DNS3 MIB error!"));
					goto setErr_tcpip;
				}
			}

			if ( *((long *)&dns1) != *((long *)&dns1_old) ||
				 *((long *)&dns2) != *((long *)&dns2_old) ||
				  *((long *)&dns3) != *((long *)&dns3_old) )
				*dns_changed = 1;
		}
	}

	// Read current ip mode setting for reference later
	if ( !apmib_get( MIB_WAN_DHCP, (void *)&curDhcp) ) {
		strcpy(tmpBuf, T("Get WAN DHCP MIB error!"));
		goto setErr_tcpip;
	}
	//sc_yang
	//strMode = websGetVar(wp, T("ipMode"), T(""));
	strMode = websGetVar(wp, T("wanType"), T(""));

set_ppp:
	if ( strMode && strMode[0] ) {
		if ( !strcmp(strMode, T("autoIp")))
			dhcp = DHCP_CLIENT;
		else if ( !strcmp(strMode, T("fixedIp")))
			dhcp = DHCP_DISABLED;
		else if ( !strcmp(strMode, T("ppp"))) {
			char_t	*strName, *strPassword, *strType;
			dhcp = PPPOE;
  			strName = websGetVar(wp, T("pppUserName"), T(""));
			if ( strName[0] ) {
				if ( apmib_set(MIB_PPP_USER, (void *)strName) == 0) {
					strcpy(tmpBuf, T("Set PPP user name MIB error!"));
					goto setErr_tcpip;
				}
			}

 			strPassword = websGetVar(wp, T("pppPassword"), T(""));
			if ( strPassword[0] ) {
				if ( apmib_set(MIB_PPP_PASSWORD, (void *)strPassword) == 0) {
					strcpy(tmpBuf, T("Set PPP user password MIB error!"));
					goto setErr_tcpip;
				}
			}
			strType = websGetVar(wp, T("pppConnectType"), T(""));
			if ( strType[0] ) {
				PPP_CONNECT_TYPE_T type;
				if ( strType[0] == '0' )
					type = CONTINUOUS;
				else if ( strType[0] == '1' )
					type = CONNECT_ON_DEMAND;
				else if ( strType[0] == '2' )
					type = MANUAL;
				else {
					strcpy(tmpBuf, T("Invalid PPP type value!"));
					goto setErr_tcpip;
				}
				if ( apmib_set(MIB_PPP_CONNECT_TYPE, (void *)&type) == 0) {
   					strcpy(tmpBuf, T("Set PPP type MIB error!"));
					goto setErr_tcpip;
				}
				if (type != CONTINUOUS) {
					char_t *strTime;
					strTime = websGetVar(wp, T("pppIdleTime"), T(""));
					if ( strTime[0] ) {
						int time;
 						time = strtol(strTime, (char**)NULL, 10) * 60;
						if ( apmib_set(MIB_PPP_IDLE_TIME, (void *)&time) == 0) {
   							strcpy(tmpBuf, T("Set PPP idle time MIB error!"));
							goto setErr_tcpip;
						}
					}
				}
			}
			strVal = websGetVar(wp, T("pppMtuSize"), T(""));
			if ( strVal[0] ) {
				int mtuSize;
 				mtuSize = strtol(strVal, (char**)NULL, 10);
				if ( apmib_set(MIB_PPP_MTU_SIZE, (void *)&mtuSize) == 0) {
					strcpy(tmpBuf, T("Set PPP mtu size MIB error!"));
					goto setErr_tcpip;
				}
			}
		}
		else if ( !strcmp(strMode, T("pptp"))) {
			char_t	*strName, *strPassword;
			dhcp = PPTP;
  			strName = websGetVar(wp, T("pptpUserName"), T(""));
			if ( strName[0] ) {
				if ( apmib_set(MIB_PPTP_USER, (void *)strName) == 0) {
					strcpy(tmpBuf, T("Set PPTP user name MIB error!"));
					goto setErr_tcpip;
				}
			}
 			strPassword = websGetVar(wp, T("pptpPassword"), T(""));
			if ( strPassword[0] ) {
				if ( apmib_set(MIB_PPTP_PASSWORD, (void *)strPassword) == 0) {
					strcpy(tmpBuf, T("Set PPTP user password MIB error!"));
					goto setErr_tcpip;
				}
			}
			
			strIp = websGetVar(wp, T("pptpIpAddr"), T(""));
			if ( strIp[0] ) {
				if ( !inet_aton(strIp, &inIp) ) {
					strcpy(tmpBuf, T("Invalid IP-address value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_PPTP_IP, (void *)&inIp)) {
					strcpy(tmpBuf, T("Set IP-address error!"));
					goto setErr_tcpip;
				}
			}

			strMask = websGetVar(wp, T("pptpSubnetMask"), T(""));
			if ( strMask[0] ) {
				if ( !inet_aton(strMask, &inMask) ) {
					strcpy(tmpBuf, T("Invalid subnet-mask value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_PPTP_SUBNET_MASK, (void *)&inMask)) {
					strcpy(tmpBuf, T("Set subnet-mask error!"));
					goto setErr_tcpip;
				}
			}

			strGateway = websGetVar(wp, T("pptpServerIpAddr"), T(""));
			if ( strGateway[0] ) {
				if ( !inet_aton(strGateway, &inGateway) ) {
					strcpy(tmpBuf, T("Invalid pptp server ip value!"));
					goto setErr_tcpip;
				}
				if ( !apmib_set(MIB_PPTP_SERVER_IP, (void *)&inGateway)) {
					strcpy(tmpBuf, T("Set pptp server ip error!"));
					goto setErr_tcpip;
				}
			}

			strVal = websGetVar(wp, T("pptpMtuSize"), T(""));
			if ( strVal[0] ) {
				int mtuSize;
 				mtuSize = strtol(strVal, (char**)NULL, 10);
				if ( apmib_set(MIB_PPTP_MTU_SIZE, (void *)&mtuSize) == 0) {
					strcpy(tmpBuf, T("Set PPTP mtu size MIB error!"));
					goto setErr_tcpip;
				}
			}
		}
		else {
			strcpy(tmpBuf, T("Invalid IP mode value!"));
			goto setErr_tcpip;
		}
		if ( !apmib_set(MIB_WAN_DHCP, (void *)&dhcp)) {
	  		strcpy(tmpBuf, T("Set DHCP error!"));
			goto setErr_tcpip;
		}

		if ( dhcp == PPPOE && buttonState == 1 ) { // connect button is pressed
			int wait_time=30;

			apmib_update(CURRENT_SETTING);	// update to flash
#ifndef NO_ACTION
			pid = fork();
        		if (pid)
	        		waitpid(pid, NULL, 0);
			else if (pid == 0) {
				snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _PPPOE_SCRIPT_PROG);
				execl( tmpBuf, _PPPOE_SCRIPT_PROG, "connect", WAN_IF, NULL);
       				exit(1);
			}
			while (wait_time-- >0) {
				if (isConnectPPP())
					break;
				sleep(1);
			}
			if (isConnectPPP())
				strcpy(tmpBuf, T("Connected to server successfully.\n"));
			else
				strcpy(tmpBuf, T("Connect to server failed!\n"));

			OK_MSG1(tmpBuf, submitUrl);
#endif
			return 1;
		}

		if ( dhcp == PPPOE && buttonState == 2 ) { // disconnect button is pressed

			apmib_update(CURRENT_SETTING);	// update to flash
#ifndef NO_ACTION
			pid = fork();
        		if (pid)
	             		waitpid(pid, NULL, 0);
        		else if (pid == 0) {
				snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _PPPOE_DC_SCRIPT_PROG);
				execl( tmpBuf, _PPPOE_DC_SCRIPT_PROG, "all", NULL);
                		exit(1);
        		}
			strcpy(tmpBuf, T("PPPoE disconnected.\n"));
			OK_MSG1(tmpBuf, submitUrl);
#endif
			return 1;
		}
	}
	else
		dhcp = curDhcp;

	if ( dhcp == DHCP_DISABLED ) {
		strIp = websGetVar(wp, T("wan_ip"), T(""));
		if ( strIp[0] ) {
			if ( !inet_aton(strIp, &inIp) ) {
				strcpy(tmpBuf, T("Invalid IP-address value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_WAN_IP_ADDR, (void *)&inIp)) {
				strcpy(tmpBuf, T("Set IP-address error!"));
				goto setErr_tcpip;
			}
		}

		strMask = websGetVar(wp, T("wan_mask"), T(""));
		if ( strMask[0] ) {
			if ( !inet_aton(strMask, &inMask) ) {
				strcpy(tmpBuf, T("Invalid subnet-mask value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_WAN_SUBNET_MASK, (void *)&inMask)) {
				strcpy(tmpBuf, T("Set subnet-mask error!"));
				goto setErr_tcpip;
			}
		}

		strGateway = websGetVar(wp, T("wan_gateway"), T(""));
		if ( strGateway[0] ) {
			if ( !inet_aton(strGateway, &inGateway) ) {
				strcpy(tmpBuf, T("Invalid default-gateway value!"));
				goto setErr_tcpip;
			}
			if ( !apmib_set(MIB_WAN_DEFAULT_GATEWAY, (void *)&inGateway)) {
				strcpy(tmpBuf, T("Set default-gateway error!"));
				goto setErr_tcpip;
			}
		}
	}

	strVal = websGetVar(wp, T("upnpEnabled"), T(""));
	if ( !gstrcmp(strVal, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( !apmib_set(MIB_UPNP_ENABLED, (void *)&intVal)) {
		strcpy(tmpBuf, T("Set MIB_UPNP_ENABLED error!"));
		goto setErr_tcpip;
	}
	
	strVal = websGetVar(wp, T("webWanAccess"), T(""));
	if ( !gstrcmp(strVal, T("ON")))
		intVal = 1;
	else
		intVal = 0;
	if ( !apmib_set(WEB_WAN_ACCESS_ENABLED, (void *)&intVal)) {
		strcpy(tmpBuf, T("Set WEB_WAN_ACCESS_ENABLED error!"));
		goto setErr_tcpip;
	}		
		
	return 0 ;
setErr_tcpip:
	return -1 ;	
}	



///////1/////////////////////////////////////////////////////////////////////////
void formWanTcpipSetup(webs_t wp, char_t *path, char_t *query)
{


	char tmpBuf[100];
	int dns_changed=0;
	char *arg;
	char_t *submitUrl;
	int val ;
		
#ifndef NO_ACTION
	int pid;
#endif

	
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	if((val = tcpipWanHandler(wp, tmpBuf, &dns_changed)) < 0 )
		goto setErr_end ;
	else if (val == 1) // return ok
		return ;

	apmib_update(CURRENT_SETTING);	// update to flash

	// run script
	if ( dns_changed )
		arg = "all";
	else
		arg = "wan";

#ifndef NO_ACTION
        pid = fork();
        if (pid)
                waitpid(pid, NULL, 0);

        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", arg, NULL);
                exit(1);
        }
#endif

	OK_MSG(submitUrl);

	return;
setErr_end:
	ERR_MSG(tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
#if 0
int showWanPage(int eid, webs_t wp, int argc, char_t **argv)
{
	char_t *p1, *p2, *p3, *p4, *lpath, *cp, *tmp1, *curPage=NULL;
	DHCP_T dhcp;
	int n;

	n = ejArgs(argc, argv, T("%s %s %s %s"), &p1, &p2, &p3, &p4);

	if (wanDhcpTmp == -1)
		apmib_get(MIB_WAN_DHCP, (void *)&dhcp);
	else
		dhcp = wanDhcpTmp;

	if (dhcp == DHCP_DISABLED && n > 0)
		curPage = p1;
	else if (dhcp == DHCP_CLIENT && n > 1)
		curPage = p2;
	else if (dhcp == PPPOE && n > 2)
		curPage = p3;
	else if (dhcp == PPTP && n > 3)
		curPage = p4;

	if (curPage == NULL)
		return -1;

	lpath = websGetRequestLpath(wp);

	if ((cp = gstrrchr(lpath, '/')) != NULL)
		*cp = '\0';

	tmp1 = balloc(B_L, strlen(lpath)+100);
	if (tmp1 == NULL) {
		ERR_MSG("allocate buffer failed!");
		return 0;
	}
	gstrcpy(tmp1, lpath);
	gstrcat(tmp1, curPage);

	bfree(B_L, wp->lpath);
	bfree(B_L, wp->path);
	bfree(B_L, wp->url);

	lpath = tmp1;
	wp->lpath = lpath;
	wp->path = bstrdup(B_L, curPage);
	wp->url = bstrdup(B_L, curPage);

	if (websPageOpen(wp, lpath, curPage, SOCKET_RDONLY | SOCKET_BINARY, 0666) < 0) {
		websError(wp, 400, T("Cannot open URL <b>%s</b>"), p1);
		return -1;
	}
	if (websAspRequest(wp, lpath) < 0)
		return 1;

	return 0;
}
#endif
#endif

/////////////////////////////////////////////////////////////////////////////
int dhcpClientList(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp;
	int nBytesSent=0;
	int element=0, ret;
	char ipAddr[40], macAddr[40], liveTime[80], *buf=NULL, *ptr, tmpBuf[100], hostName[64];
	struct stat status;
	int pid;

	// siganl DHCP server to update lease file
	snprintf(tmpBuf, 100, "%s/%s.pid", _DHCPD_PID_PATH, _DHCPD_PROG_NAME);
	pid = getPid(tmpBuf);
	if ( pid > 0)
		kill(pid, SIGUSR1);
	usleep(1000);

	if ( stat(_PATH_DHCPS_LEASES, &status) < 0 )
		goto err;

	buf = malloc(status.st_size);
	if ( buf == NULL )
		goto err;
	fp = fopen(_PATH_DHCPS_LEASES, "r");
	if ( fp == NULL )
		goto err;

	fread(buf, 1, status.st_size, fp);
	fclose(fp);

	ptr = buf;
	nBytesSent += websWrite(wp,
   		T("MAC Address         "
		  "IP address		"
		  "Time	"
		  "Host Name\n"
			  ));
	while (1) {
		ret = getOneDhcpClient(&ptr, &status.st_size, hostName, ipAddr, macAddr, liveTime);

		if (ret < 0)
			break;
		if (ret == 0)
			continue;
		nBytesSent += websWrite(wp,
	   	T("%s  "
		  "%s	"
		  "%s	"
		  "%s\n"
		  ),
		macAddr, ipAddr, liveTime, hostName);

		element++;
	}
err:
	if (element == 0) {
		nBytesSent += websWrite(wp,
	   	T("None                "
		  "----		"
		  "----	"
		  "----\n"
		  ));
	}
	if (buf)
		free(buf);

	return nBytesSent;
}

/////////////////////////////////////////////////////////////////////////////
// This is parsing connect PC that get IP from dhcp
#if 0
int connectPCList(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp;
	int nBytesSent=0;
	int element=0, ret;
	char ipAddr[40], macAddr[40], liveTime[80], *buf=NULL, *ptr, tmpBuf[100];
	struct stat status;
	int pid;

	// siganl DHCP server to update lease file
	snprintf(tmpBuf, 100, "%s/%s.pid", _DHCPD_PID_PATH, _DHCPD_PROG_NAME);
	pid = getPid(tmpBuf);
	if ( pid > 0)
		kill(pid, SIGUSR1);
	usleep(1000);

	if ( stat(_PATH_DHCPS_LEASES, &status) < 0 )
		goto err;

	buf = malloc(status.st_size);
	if ( buf == NULL )
		goto err;
	fp = fopen(_PATH_DHCPS_LEASES, "r");
	if ( fp == NULL )
		goto err;

	fread(buf, 1, status.st_size, fp);
	fclose(fp);

	ptr = buf;
	while (1) {
		ret = getOnePCList(&ptr, &status.st_size, ipAddr, macAddr, liveTime);

		if (ret < 0)
			break;
		if (ret == 0)
			continue;
		nBytesSent += websWrite(wp, T("<option >%s</option>"), macAddr);

		element++;
	}
err:
	if (element == 0) {
		nBytesSent += websWrite(wp, T("<option ></option>"));
	}
	if (buf)
		free(buf);

	return nBytesSent;
}
#endif

int connectPCList(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0, i, found=0;
	WLAN_STA_INFO_Tp pInfo;
	char *buff;
	int mode;

	buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));
	if ( buff == 0 ) {
		printf("Allocate buffer failed!\n");
		return 0;
	}

	if ( getWlStaInfo(WLAN_IF,  (WLAN_STA_INFO_Tp)buff ) < 0 ) {
		free(buff);
		printf("Read wlan sta info failed!\n");
		return 0;
	}

	for (i=1; i<=MAX_STA_NUM; i++) {
		pInfo = (WLAN_STA_INFO_Tp)&buff[i*sizeof(WLAN_STA_INFO_T)];
		if (pInfo->aid && (pInfo->flag & STA_INFO_FLAG_ASOC)) {
			nBytesSent += websWrite(wp, T("<option >%02x-%02x-%02x-%02x-%02x-%02x</option>"),
			pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5]
		);
			found++;
		}
	}

	apmib_get( MIB_WLAN_MODE, (void *)&mode);
	if(mode==4)
	{
        	if ( getWlStaInfo("wlan0-vxd",  (WLAN_STA_INFO_Tp)buff ) < 0 ) {
                	free(buff);
               	 	printf("Read wlan sta info failed!\n");
               	 	return 0;
        	}
                                                                                                               
        	for (i=1; i<=MAX_STA_NUM; i++) {
                	pInfo = (WLAN_STA_INFO_Tp)&buff[i*sizeof(WLAN_STA_INFO_T)];
                	if (pInfo->aid && (pInfo->flag & STA_INFO_FLAG_ASOC)) {
                        	nBytesSent += websWrite(wp, T("<option >%02x-%02x-%02x-%02x-%02x-%02x</option>"),
                        	pInfo->addr[0],pInfo->addr[1],pInfo->addr[2],pInfo->addr[3],pInfo->addr[4],pInfo->addr[5]
                	);
                        	found++;
                	}
        	}
	}

	if (found == 0) {
		nBytesSent += websWrite(wp, T("<option ></option>"));
	}

	free(buff);

	return nBytesSent;
}


/////////////////////////////////////////////////////////////////////////////
void formReflashClientTbl(webs_t wp, char_t *path, char_t *query)
{
//yibin-----------------------
/*
	char_t *submitUrl;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));
	if (submitUrl[0])
		websRedirect(wp, submitUrl);
*/
}


//////////////////////////////////////////////////////////////////////////////
int isDhcpClientExist(char *name)
{
	char tmpBuf[100];
	struct in_addr intaddr;

	if ( getInAddr(name, IP_ADDR, (void *)&intaddr ) ) {
		snprintf(tmpBuf, 100, "%s/%s-%s.pid", _DHCPC_PID_PATH, _DHCPC_PROG_NAME, name);
		if ( getPid(tmpBuf) > 0)
			return 1;
	}
	return 0;
}





