/*
 *      Web server handler routines for management (password, save config, f/w update)
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmmgmt.c,v 1.3 2005/07/13 03:25:56 CAMEO+brian Exp $
 *
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/reboot.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "apmib.h"
#include "apform.h"
#include "utility.h"

#define DEFAULT_GROUP		T("administrators")
#define ACCESS_URL		T("/")
#define UM_TXT_FILENAME			T("/var/umconfig.txt")	// david

static char superName[MAX_NAME_LEN]={0}, superPass[MAX_NAME_LEN]={0};
static char userName[MAX_NAME_LEN]={0}, userPass[MAX_NAME_LEN]={0};

int currentPage = 0;

int  opModeHandler(webs_t wp, char *tmpBuf);
static unsigned short calculateChecksum(char *buf, int len);

////////////////////////////////////////////////////////////////////////////////
#ifdef _LITTLE_ENDIAN_
static void swap_mib_word_value(APMIB_Tp pMib)
{
	pMib->wlan[wlan_idx].fragThreshold = WORD_SWAP(pMib->wlan[wlan_idx].fragThreshold);
	pMib->wlan[wlan_idx].rtsThreshold = WORD_SWAP(pMib->wlan[wlan_idx].rtsThreshold);
	pMib->wlan[wlan_idx].supportedRates = WORD_SWAP(pMib->wlan[wlan_idx].supportedRates);
	pMib->wlan[wlan_idx].basicRates = WORD_SWAP(pMib->wlan[wlan_idx].basicRates);
	pMib->wlan[wlan_idx].beaconInterval = WORD_SWAP(pMib->wlan[wlan_idx].beaconInterval);
	pMib->wlan[wlan_idx].inactivityTime = DWORD_SWAP(pMib->wlan[wlan_idx].inactivityTime);
	pMib->wlan[wlan_idx].wpaGroupRekeyTime = DWORD_SWAP(pMib->wlan[wlan_idx].wpaGroupRekeyTime);
	pMib->wlan[wlan_idx].rsPort = WORD_SWAP(pMib->wlan[wlan_idx].rsPort);
	pMib->wlan[wlan_idx].rs2Port = WORD_SWAP(pMib->wlan[wlan_idx].rs2Port);

#ifdef HOME_GATEWAY
{
	int i;
	pMib->pppIdleTime = WORD_SWAP(pMib->pppIdleTime);
	for (i=0; i<pMib->portFwNum; i++) {
		pMib->portFwArray[i].fromPort = WORD_SWAP(pMib->portFwArray[i].fromPort);
		pMib->portFwArray[i].toPort = WORD_SWAP(pMib->portFwArray[i].toPort);
	}

	for (i=0; i<pMib->portFilterNum; i++) {
		pMib->portFilterArray[i].fromPort = WORD_SWAP(pMib->portFilterArray[i].fromPort);
		pMib->portFilterArray[i].toPort = WORD_SWAP(pMib->portFilterArray[i].toPort);
	}
	for (i=0; i<pMib->triggerPortNum; i++) {
		pMib->triggerPortArray[i].tri_fromPort = WORD_SWAP(pMib->triggerPortArray[i].tri_fromPort);
		pMib->triggerPortArray[i].tri_toPort = WORD_SWAP(pMib->triggerPortArray[i].tri_toPort);
		pMib->triggerPortArray[i].inc_fromPort = WORD_SWAP(pMib->triggerPortArray[i].inc_fromPort);
		pMib->triggerPortArray[i].inc_toPort = WORD_SWAP(pMib->triggerPortArray[i].inc_toPort);
	}
}
#endif

}
#endif

///////////////////////////////////////////////////////////////////

static void reset_user_profile()
{
/*
	struct stat status;
	umClose();

	if ( stat(UM_TXT_FILENAME, &status) == 0) // file existed
               	unlink(UM_TXT_FILENAME);

	umOpen();
	umRestore(UM_TXT_FILENAME);

	set_user_profile();
	*/
}


/////////////////////////////////////////////////////////////////////////////
static int fwChecksumOk(char_t *data, int len)
{
	unsigned short sum=0;
	int i;

	for (i=0; i<len; i+=2) {
#ifdef _LITTLE_ENDIAN_
		sum += WORD_SWAP( *((unsigned short *)&data[i]) );
#else
		sum += *((unsigned short *)&data[i]);
#endif

	}
	return( (sum==0) ? 1 : 0);
}


void kill_processes(void)
{


	printf("upgrade: killing tasks...\n");
	
	kill(1, SIGTSTP);		/* Stop init from reforking tasks */
	kill(1, SIGSTOP);		
	kill(2, SIGSTOP);		
	kill(3, SIGSTOP);		
	kill(4, SIGSTOP);		
	kill(5, SIGSTOP);		
	kill(6, SIGSTOP);		
	kill(7, SIGSTOP);		
	//atexit(restartinit);		/* If exit prematurely, restart init */
	sync();

	signal(SIGTERM,SIG_IGN);	/* Don't kill ourselves... */
	setpgrp(); 			/* Don't let our parent kill us */
	sleep(1);
	signal(SIGHUP, SIG_IGN);	/* Don't die if our parent dies due to
					 * a closed controlling terminal */
	
}

extern unsigned long lenPostData;
extern char *postData;

void formUploadConfig(webs_t wp, char_t *path, char_t *query)
{
//////////////////////////////////////////////
// Realtek's implementation
		int len = 0;
		int status = 1;
		int type = 0;
		PARAM_HEADER_Tp pHeader;
		int force;
		char *ptr = NULL;
		int ver;
		char tmpBuf[100];
		int pid;
		
		while (len < lenPostData) {

			pHeader = (PARAM_HEADER_Tp) &postData[len];

#ifdef _LITTLE_ENDIAN_
			pHeader->len = WORD_SWAP(pHeader->len);
#endif
			len += sizeof(PARAM_HEADER_T);

			if ( sscanf(&pHeader->signature[TAG_LEN], "%02d", &ver) != 1)
				ver = -1;

			force = -1;
			if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1; // update
			else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN))
				force = 2; // force
			else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN))
				force = 0; // upgrade

			if ( force >= 0 ) {
#if 0
				if ( !force && (ver < CURRENT_SETTING_VER || // version is less than current
					(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}
#ifdef _LITTLE_ENDIAN_
				swap_mib_word_value((APMIB_Tp)ptr);
#endif
				apmib_updateFlash(CURRENT_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= CURRENT_SETTING;
				continue;
			}


			if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1;	// update
			else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) )
				force = 2;	// force
			else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) )
				force = 0;	// upgrade

			if ( force >= 0 ) {
#if 0
				if ( (ver < DEFAULT_SETTING_VER) || // version is less than current
					(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}

#ifdef _LITTLE_ENDIAN_
				swap_mib_word_value((APMIB_Tp)ptr);
#endif
				apmib_updateFlash(DEFAULT_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= DEFAULT_SETTING;
				continue;
			}


			if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1;	// update
			else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) )
				force = 2;	// force
			else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) )
				force = 0;	// upgrade

			if ( force >= 0 ) {
#if 0
				if ( (ver < HW_SETTING_VER) || // version is less than current
					(pHeader->len < (sizeof(HW_SETTING_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}
				apmib_updateFlash(HW_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= HW_SETTING;
				continue;
			}
		}

		if (status == 0 || type == 0) // checksum error
			strcpy(tmpBuf, "Invalid configuration file!");
		else {
			if (type) { // upload success
				if (apmib_reinit() ==0) {
					strcpy(tmpBuf,T("Re-initialize AP MIB failed!\n"));
					goto back;
				}
//				reset_user_profile();  // re-initialize user password

#ifndef NO_ACTION
				/* restart system init script */
				pid = fork();
        			if (pid)
					waitpid(pid, NULL, 0);
        			else if (pid == 0) {
					snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
					execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
#else
					execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "all", NULL);
#endif

                			exit(1);
        			}
#endif
			}
			strcpy(tmpBuf, "Update successfully!");
		}

back:
		ERR_MSG(tmpBuf);

		return;

///////////////////////// End of Realtek implementation ////////////////////////
}

void formUploadFirmw(webs_t wp, char_t *path, char_t *query)
{
#ifdef __mips__
    int fh;
#else
    FILE *       fp;
    char_t *     bn = NULL;
#endif
 
    int		 len;
    int          locWrite;
    int          numLeft;
    int          numWrite;
    IMG_HEADER_Tp pHeader;
    char tmpBuf[100], strChecksum[8]={0};
    char_t *strRequest, *submitUrl, *strVal, *strFWChecksum;
    int flag, startAddr=-1, startAddrWeb=-1;
#ifndef NO_ACTION
    int pid;
#endif
    int head_offset=0 ;
    unsigned short checksum=0;
    int check_kill_p=0;
    int run_pid_tmp=0;

//    submitUrl = websGetVar(wp, T("submit-url"), T(""));
    submitUrl = "/tools.html";
    checksum = WORD_SWAP(calculateChecksum(&postData[head_offset], lenPostData));

    run_pid_tmp = getpid();
    //printf("run_pid_tmp:%d\n",run_pid_tmp);
    if(run_pid_tmp)
    {    	
	pid = getppid();   
	//printf("httpd pid:%d\n",pid);
	if((pid != run_pid_tmp)&&(pid != 0)&&(pid != 1))
	{
	    kill(pid, SIGTERM);
	    //printf("Enter : kill pid\n");
	}
    }
    
//support multiple image     
while(head_offset <  lenPostData) {
	
    locWrite = 0;
    pHeader = (IMG_HEADER_Tp) &postData[head_offset];
    len = pHeader->len;
#ifdef _LITTLE_ENDIAN_
    len  = DWORD_SWAP(len);
#endif    
    numLeft = len + sizeof(IMG_HEADER_T) ;
    
    // check header and checksum
    if (!memcmp(&postData[head_offset], FW_HEADER, SIGNATURE_LEN))
    	flag = 1;
    else if (!memcmp(&postData[head_offset], WEB_HEADER, SIGNATURE_LEN))
    	flag = 2;
    else if (!memcmp(&postData[head_offset], ROOT_HEADER, SIGNATURE_LEN))
    	flag = 3;
    else {
       	strcpy(tmpBuf, T("<b>Invalid file format!"));
		goto ret_upload;
    }


#if 0
    if (len != numLeft - sizeof(IMG_HEADER_T) ) {
       	sprintf(tmpBuf, T("Image length mismatched!,len=%d"), len);
	goto ret_upload;
    }
#endif
    if(len > 0x200000){ //len check by sc_yang
      		sprintf(tmpBuf, T("<b>Image len exceed max size 0x200000 ! len=0x%x</b><br>"), len);
		goto ret_upload;
    }
    if ( (flag == 1) || (flag == 3)) {
    	if ( !fwChecksumOk(&postData[sizeof(IMG_HEADER_T)+head_offset], len)) {
      		sprintf(tmpBuf, T("<b>Image checksum mismatched! len=0x%x, checksum=0x%x</b><br>"), len,
			*((unsigned short *)&postData[len-2]) );
		goto ret_upload;
	}
    }
    else {
	//printf("oem_tag:%x\n",postData[sizeof(IMG_HEADER_T)+len-2]);
	if((postData[sizeof(IMG_HEADER_T)+len-2] & 0xff)!=0x88) {
                sprintf(tmpBuf, T("<b>Invalid file!"));
                goto ret_upload;
        }

    	char *ptr = &postData[sizeof(IMG_HEADER_T)+head_offset];

    	if ( !CHECKSUM_OK(ptr, len) ) {
     		sprintf(tmpBuf, T("<b>Image checksum mismatched! len=0x%x</b><br>"), len);
		goto ret_upload;
	}
    }

    if(check_kill_p==0)
    {
    //John H. 2006.01.09 Kill auth process
	pid = find_pid_by_name("auth");   
	if(pid)
	{
	    kill(pid, SIGTERM);
	    pid = find_pid_by_name("auth");   
	    if(pid)
	    {
	        kill(pid, SIGTERM);
	    }
	}
	//John H. 2006.01.09 Kill auth process
    //John H. 2006.03.08 Kill auth process
	pid = find_pid_by_name("syslogd");   
	if(pid)
	    kill(pid, SIGTERM);
	pid = find_pid_by_name("klogd");   
	if(pid)
	    kill(pid, SIGTERM);
	pid = find_pid_by_name("udhcpd");   
	if(pid)
	    kill(pid, SIGTERM);
	pid = find_pid_by_name("iapp");   
	if(pid)
	    kill(pid, SIGTERM);
        pid = find_pid_by_name("reload.sh");
        if(pid)
        {
	    //printf("reload.sh:%d\n",pid);    
	    kill(pid, SIGTERM);
	}
	//John H. 2006.01.09 Kill auth process
    }
#ifdef __mips__
    if(flag == 3)
    	fh = open(FLASH_DEVICE_NAME1, O_RDWR);
    else
    fh = open(FLASH_DEVICE_NAME, O_RDWR);

    if ( fh == -1 ) {
#else
    if (flag == 1)
    	bn = "apcode.bin";
    else if (flag == 3)
    	bn = "root.bin" ;
    else
    	bn = "web.gz.up";

    if ((fp = fopen((bn == NULL ? "upldForm.bin" : bn), "w+b")) == NULL) {
#endif
       	strcpy(tmpBuf, T("File open failed!"));
    } else {

#ifdef __mips__
	if (flag == 1) {
		if ( startAddr == -1){
			//startAddr = CODE_IMAGE_OFFSET;
			startAddr = pHeader->burnAddr ;
			#ifdef _LITTLE_ENDIAN_
    				startAddr = DWORD_SWAP(startAddr);
    			#endif
		}

	}
	else if (flag == 3) {
		if ( startAddr == -1){
			//startAddr = ROOT_IMAGE_OFFSET;
			startAddr = pHeader->burnAddr ;
			#ifdef _LITTLE_ENDIAN_
    				startAddr = DWORD_SWAP(startAddr);
    			#endif
			startAddr -= ROOT_IMAGE_OFFSET;
			if(startAddr < 0 )
				startAddr = 0;
		}
	}
	else {
		if ( startAddrWeb == -1){
			//startAddr = WEB_PAGE_OFFSET;
			startAddr = pHeader->burnAddr ;
			#ifdef _LITTLE_ENDIAN_
    				startAddr = DWORD_SWAP(startAddr);
    			#endif
		}
		else
			startAddr = startAddrWeb;

#ifdef COMPACK_SIZE
		if ( startAddr == -1 ) {
			strcpy(tmpBuf, T("Cannot update web pages because flash layout could not support!"));
			goto ret_upload;
		}
#endif
	}
	lseek(fh, startAddr, SEEK_SET);
	if(flag == 3){
		locWrite += sizeof(IMG_HEADER_T); // remove header
		numLeft -=  sizeof(IMG_HEADER_T);
		kill_processes();
	}

	numWrite = write(fh, &(postData[locWrite+head_offset]), numLeft);
	check_kill_p=1;
printf("Done.\n");
#else
	numWrite = fwrite(&(postData[locWrite+head_offset]), sizeof(*(postData)), numLeft, fp);
#endif
	if (numWrite < numLeft) {
#ifdef __mips__
		sprintf(tmpBuf, T("File write failed.<br> locWrite=%d numLeft=%d numWrite=%d Size=%ld bytes."), locWrite, numLeft, numWrite, lenPostData);
#else
                sprintf(tmpBuf, T("File write failed.<br> ferror=%d locWrite=%d numLeft=%d numWrite=%d Size=%ld bytes."), ferror(fp), locWrite, numLeft, numWrite, lenPostData);
#endif
	}
	locWrite += numWrite;
 	numLeft -= numWrite;
#ifdef __mips__
	close(fh);
#else
	fclose(fp);
#endif
	if (numLeft == 0)
		sprintf(tmpBuf, T("Update successfully (size = %d bytes)!<br><br>Please wait a while for rebooting..."), lenPostData);
	else
		sprintf(tmpBuf, T("numLeft=%d locWrite=%d Size=%d bytes."), numLeft, locWrite, len);

#ifdef __mips__
	// Read written data back to compare
{	unsigned char read_buf[4096];
	int read_offset=0, read_len;
    	unsigned char *pData = &postData[head_offset];
	int postLen= len ;

	if(flag == 3){
		fh = open(FLASH_DEVICE_NAME1, O_RDWR);
		pData += sizeof(IMG_HEADER_T);
		postLen -= sizeof(IMG_HEADER_T);
	}
	else
   		fh = open(FLASH_DEVICE_NAME, O_RDWR);
    	if ( fh == -1 ) {
		strcpy(tmpBuf, T("open flash driver error!"));
		goto ret_upload;
	}

	lseek(fh, startAddr, SEEK_SET);

	while (read_offset != postLen) {
		read_len = read(fh, read_buf, 4096);

		if (read_len <= 0) {
			strcpy(tmpBuf, T("Read flash data error!"));
			goto ret_upload;
		}
		if ((read_len + read_offset) > postLen)
			read_len =  postLen - read_offset;

		if (memcmp(pData, read_buf, read_len)) {
			sprintf(tmpBuf, T("Compare flash data error [idx=%d], you may try to update again!"), read_offset);
			goto ret_upload;
		}
		pData += read_len;
		read_offset += read_len;
	}
}

#endif  // __mips__
	//sc_yang
	head_offset += len + sizeof(IMG_HEADER_T) ;
	startAddr = -1 ; //by sc_yang to reset the startAddr for next image
    }
} //while //sc_yang    

	sprintf(strChecksum, "%04x", checksum);

	strFWChecksum = strChecksum;
	if ( apmib_set(MIB_FW_CHECKSUM, (void *)strFWChecksum) == 0) {
 			strcpy(tmpBuf, T("Set Firmware Checksum error!"));
			goto ret_upload;
	}

	apmib_update(CURRENT_SETTING);

	printf("OK_MSG1...\n");
    OK_MSG2(tmpBuf, submitUrl);
{
	// Let's spawn a process to handle the reboot after 5 secs
	int pid;
	pid = fork();
	if (pid == 0) {
		sleep(2);
		reboot( RB_AUTOBOOT);
		exit(1);
       }
}
#ifndef NO_ACTION
/*
	if(flag != 3){
	    pid = find_pid_by_name("init");
	    kill(pid, SIGTERM);
	}
	else */
	//	reboot( RB_AUTOBOOT);  // we don't need to reboot overhere
#endif

    return;

ret_upload:
    ERR_MSG(tmpBuf);
}

///////////////////////////////////////////////////////////////////////////////
void formSaveConfig(webs_t wp, char_t *path, char_t *query)
{
	char_t *strRequest;
	char *buf, *ptr=NULL;
	PARAM_HEADER_Tp pHeader;
	unsigned char checksum;
	int len, status=0, ver, force, len1;
	char tmpBuf[200];
#ifndef NO_ACTION
	int pid;
#endif
	CONFIG_DATA_T type=0;

	len1 = sizeof(PARAM_HEADER_T) + sizeof(APMIB_T) + sizeof(checksum) + 100;  // 100 for expansion
	len = csHeader.len;
#ifdef _LITTLE_ENDIAN_
	len  = WORD_SWAP(len);
#endif
	len += sizeof(PARAM_HEADER_T) + 100;
	if (len1 > len)
		len = len1;

	buf = malloc(len);
	if ( buf == NULL ) {
		strcpy(tmpBuf, "Allocate buffer failed!");
//		goto back;
		ERR_MSG(tmpBuf);

		free(buf);
		return;
	}

	strRequest = websGetVar(wp, T("save-cs"), T(""));
	if (strRequest[0])
		type |= CURRENT_SETTING;

	strRequest = websGetVar(wp, T("save"), T(""));
	if (strRequest[0])
		type |= CURRENT_SETTING;

	strRequest = websGetVar(wp, T("save-hs"), T(""));
	if (strRequest[0])
		type |= HW_SETTING;

	strRequest = websGetVar(wp, T("save-ds"), T(""));
	if (strRequest[0])
		type |= DEFAULT_SETTING;

	strRequest = websGetVar(wp, T("save-all"), T(""));
	if (strRequest[0])
		type |= HW_SETTING | DEFAULT_SETTING | CURRENT_SETTING;

	if (type) {
		websWrite(wp, "HTTP/1.0 200 OK\n");
		websWrite(wp, "Content-Type: application/octet-stream;\n");
		websWrite(wp, "Content-Disposition: attachment;filename=\"config.dat\" \n");
		websWrite(wp, "Pragma: no-cache\n");
		websWrite(wp, "Cache-Control: no-cache\n");
		websWrite(wp, "\n");

		if (type & HW_SETTING) {
			pHeader = (PARAM_HEADER_Tp)buf;
			len = pHeader->len = hsHeader.len;
			memcpy(&buf[sizeof(PARAM_HEADER_T)], pHwSetting, pHeader->len-1);

#ifdef _LITTLE_ENDIAN_
			pHeader->len  = WORD_SWAP(pHeader->len);
#endif
			memcpy(pHeader->signature, hsHeader.signature, SIGNATURE_LEN);
			ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
			checksum = CHECKSUM(ptr, len-1);
			buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

			ptr = &buf[sizeof(PARAM_HEADER_T)];
			ENCODE_DATA(ptr,  len);
			websWriteDataNonBlock(wp, buf, len+sizeof(PARAM_HEADER_T));
		}

		if (type & DEFAULT_SETTING) {
			pHeader = (PARAM_HEADER_Tp)buf;
			len = pHeader->len = dsHeader.len;
			memcpy(&buf[sizeof(PARAM_HEADER_T)], pMibDef, len-1);

#ifdef _LITTLE_ENDIAN_
			pHeader->len  = WORD_SWAP(pHeader->len);
			swap_mib_word_value((APMIB_Tp)&buf[sizeof(PARAM_HEADER_T)]);
#endif
			memcpy(pHeader->signature, dsHeader.signature, SIGNATURE_LEN);
			ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
			checksum = CHECKSUM(ptr, len-1);
			buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

			ptr = &buf[sizeof(PARAM_HEADER_T)];
			ENCODE_DATA(ptr,  len);
			websWriteDataNonBlock(wp, buf, len+sizeof(PARAM_HEADER_T));
		}

		if (type & CURRENT_SETTING) {
			pHeader = (PARAM_HEADER_Tp)buf;
			len = pHeader->len = csHeader.len;
			memcpy(&buf[sizeof(PARAM_HEADER_T)], pMib, len-1);

#ifdef _LITTLE_ENDIAN_
			pHeader->len  = WORD_SWAP(pHeader->len);
			swap_mib_word_value((APMIB_Tp)&buf[sizeof(PARAM_HEADER_T)]);
#endif
			memcpy(pHeader->signature, csHeader.signature, SIGNATURE_LEN);
			ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
			checksum = CHECKSUM(ptr, len-1);
			buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

			ptr = &buf[sizeof(PARAM_HEADER_T)];
			ENCODE_DATA(ptr,  len);
			websWriteDataNonBlock(wp, buf, len+sizeof(PARAM_HEADER_T));
		}
		websDone(wp, 200);
		free(buf);
		return;
	}
#if 0 // roger
	strRequest = websGetVar(wp, T("load"), T(""));
	if (strRequest[0]) {
		len = 0;
		status = 1;
		type = 0;
		while (len < wp->lenPostData) {

			pHeader = (PARAM_HEADER_Tp)&wp->postData[len];

#ifdef _LITTLE_ENDIAN_
			pHeader->len = WORD_SWAP(pHeader->len);
#endif
			len += sizeof(PARAM_HEADER_T);

			if ( sscanf(&pHeader->signature[TAG_LEN], "%02d", &ver) != 1)
				ver = -1;

			force = -1;
			if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1; // update
			else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN))
				force = 2; // force
			else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN))
				force = 0; // upgrade

			if ( force >= 0 ) {
#if 0
				if ( !force && (ver < CURRENT_SETTING_VER || // version is less than current
					(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &wp->postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}
#ifdef _LITTLE_ENDIAN_
				swap_mib_word_value((APMIB_Tp)ptr);
#endif
				apmib_updateFlash(CURRENT_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= CURRENT_SETTING;
				continue;
			}


			if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1;	// update
			else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) )
				force = 2;	// force
			else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) )
				force = 0;	// upgrade

			if ( force >= 0 ) {
#if 0
				if ( (ver < DEFAULT_SETTING_VER) || // version is less than current
					(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &wp->postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}

#ifdef _LITTLE_ENDIAN_
				swap_mib_word_value((APMIB_Tp)ptr);
#endif
				apmib_updateFlash(DEFAULT_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= DEFAULT_SETTING;
				continue;
			}


			if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_TAG, TAG_LEN) )
				force = 1;	// update
			else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) )
				force = 2;	// force
			else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) )
				force = 0;	// upgrade

			if ( force >= 0 ) {
#if 0
				if ( (ver < HW_SETTING_VER) || // version is less than current
					(pHeader->len < (sizeof(HW_SETTING_T)+1)) ) { // length is less than current
					status = 0;
					break;
				}
#endif
				ptr = &wp->postData[len];
				DECODE_DATA(ptr, pHeader->len);
				if ( !CHECKSUM_OK(ptr, pHeader->len)) {
					status = 0;
					break;
				}
				apmib_updateFlash(HW_SETTING, ptr, pHeader->len-1, force, ver);
				len += pHeader->len;
				type |= HW_SETTING;
				continue;
			}
		}

		if (status == 0 || type == 0) // checksum error
			strcpy(tmpBuf, "Invalid configuration file!");
		else {
			if (type) { // upload success
				if (apmib_reinit() ==0) {
					strcpy(tmpBuf,T("Re-initialize AP MIB failed!\n"));
					goto back;
				}
//				reset_user_profile();  // re-initialize user password

#ifndef NO_ACTION
				/* restart system init script */
				pid = fork();
        			if (pid)
					waitpid(pid, NULL, 0);
        			else if (pid == 0) {
					snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
					execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
#else
					execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "all", NULL);
#endif

                			exit(1);
        			}
#endif
			}
			strcpy(tmpBuf, "Update successfully!");
		}

back:
		ERR_MSG(tmpBuf);

		free(buf);
		return;
	}
#endif // roger
	strRequest = websGetVar(wp, T("reset"), T(""));
	if (strRequest[0]) {
		if ( !apmib_updateDef() ) {
			free(ptr);
			strcpy(tmpBuf, "Write default to current setting failed!\n");
			ERR_MSG(tmpBuf);

			free(buf);
			return;
			//	goto back;
		}
		if (apmib_reinit() ==0) {
			free(ptr);
			strcpy(tmpBuf, "Re-initialize AP MIB failed!\n");
			ERR_MSG(tmpBuf);

			free(buf);
			return;
			// goto back;
		}
//		reset_user_profile();  // re-initialize user password

#ifndef NO_ACTION
		/* restart system init script */
		pid = fork();
       		if (pid == 0) {
			snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
			execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
#else
			execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "all", NULL);
#endif
               		exit(1);
       		}
		else
			waitpid(pid, NULL, 0);
#endif
		strcpy(tmpBuf, "Reload setting successfully!");
		ERR_MSG(tmpBuf);

		free(ptr);
	}
}
///////////////////////////////////////////////////////////////////////////////

#if 0
///////////////////////////////////////////////////////////////////////////////
void formUpload(webs_t wp, char_t * path, char_t * query)
{
#ifdef __mips__
    int fh;
#else
    FILE *       fp;
    char_t *     bn = NULL;
#endif
    int		 len;
    int          locWrite;
    int          numLeft;
    int          numWrite;
    IMG_HEADER_Tp pHeader;
    char tmpBuf[200], strChecksum[8]={0};
    char_t *strRequest, *submitUrl, *strVal, *strFWChecksum;
    int flag, startAddr=-1, startAddrWeb=-1;
#ifndef NO_ACTION
//    int pid;
#endif
    int head_offset=0 ;
    unsigned short checksum=0;

    strRequest = websGetVar(wp, T("save"), T(""));
    if (strRequest[0]) {
	int fh=0;
	char *buf=NULL;

#ifdef __mips__
	char *filename=FLASH_DEVICE_NAME;
	int imageLen=-1;
	IMG_HEADER_T header;

	strVal = websGetVar(wp, T("readAddr"), T(""));
	if ( strVal[0] )
		startAddr = strtol( strVal, (char **)NULL, 16);

	strVal = websGetVar(wp, T("size"), T(""));
	if ( strVal[0] )
		imageLen = strtol( strVal, (char **)NULL, 16);

	fh = open(filename, O_RDONLY);
	if ( fh == -1 ) {
      		strcpy(tmpBuf, T("Open file failed!"));
		goto ret_err;
	}

	if (startAddr==-1 || imageLen==-1) {
		// read system image
		lseek(fh, CODE_IMAGE_OFFSET, SEEK_SET);
		if ( read(fh, &header, sizeof(header)) != sizeof(header)) {
     			strcpy(tmpBuf, T("Read image header error!"));
			goto ret_err;
		}
		if ( memcmp(header.signature, FW_HEADER, SIGNATURE_LEN) ) {
       			strcpy(tmpBuf, T("Invalid file format!"));
			goto ret_err;
	    	}
		startAddr = CODE_IMAGE_OFFSET;
		imageLen =  sizeof(header) + header.len;
	}

	buf = malloc(0x10000);
	if ( buf == NULL) {
       		strcpy(tmpBuf, T("Allocate buffer failed!"));
		goto ret_err;
	}

	lseek(fh, startAddr, SEEK_SET);

	websWrite(wp, "HTTP/1.0 200 OK\n");
	websWrite(wp, "Content-Type: application/octet-stream;\n");
	websWrite(wp, "Content-Disposition: attachment;filename=\"apcode.bin\" \n");
	websWrite(wp, "Pragma: no-cache\n");
	websWrite(wp, "Cache-Control: no-cache\n");
	websWrite(wp, "\n");

	while (imageLen > 0) {
		int blocksize=0x10000;
		if (imageLen < blocksize)
			blocksize=imageLen;

		if ( read(fh, buf, blocksize) != blocksize) {
	     		strcpy(tmpBuf, T("Read image error!"));
			goto ret_err;
		}
		websWriteBlock(wp, (char *)buf, blocksize);
		imageLen -= blocksize;
	}
	websDone(wp, 200);
#else
	struct stat status;
	char *filename="apcode.bin";
	if ( stat(filename, &status) < 0 ) {
       		strcpy(tmpBuf, T("Stat file failed!"));
		goto ret_err;
	}
	buf = malloc(status.st_size);
	if ( buf == NULL) {
       		strcpy(tmpBuf, T("Allocate buffer failed!"));
		goto ret_err;
	}

	fh = open(filename, O_RDONLY);
	if ( fh == -1 ) {
      		strcpy(tmpBuf, T("Open file failed!"));
		goto ret_err;
	}
	lseek(fh, CODE_IMAGE_OFFSET, SEEK_SET);

	if ( read(fh, buf, status.st_size) != status.st_size) {
      		strcpy(tmpBuf, T("Read file failed!"));
		goto ret_err;
	}
	websWriteBlock(wp, (char *)buf, status.st_size);
	websDone(wp, 200);
#endif
	goto ret_ok;

ret_err:
	ERR_MSG(tmpBuf);
ret_ok:
	if (fh>0)
		close(fh);
	if (buf)
		free(buf);
	return;
   }

    // assume as firmware upload
    strVal = websGetVar(wp, T("writeAddrCode"), T(""));
    if ( strVal[0] ) {
	if ( !memcmp(strVal, "0x", 2))
		startAddr = strtol( &strVal[2], (char **)NULL, 16);
    }
    strVal = websGetVar(wp, T("writeAddrWebPages"), T(""));
    if ( strVal[0] ) {
	if ( !memcmp(strVal, "0x", 2))
		startAddrWeb = strtol( &strVal[2], (char **)NULL, 16);
    }
    
    submitUrl = websGetVar(wp, T("submit-url"), T(""));
    checksum = WORD_SWAP(calculateChecksum(&wp->postData[head_offset], wp->lenPostData));


//support multiple image     
while(head_offset <   wp->lenPostData) {
	
    locWrite = 0;
    pHeader = (IMG_HEADER_Tp) &wp->postData[head_offset];
    len = pHeader->len;
#ifdef _LITTLE_ENDIAN_
    len  = DWORD_SWAP(len);
#endif    
    numLeft = len + sizeof(IMG_HEADER_T) ;
    
    // check header and checksum
    if (!memcmp(&wp->postData[head_offset], FW_HEADER, SIGNATURE_LEN))
    	flag = 1;
    else if (!memcmp(&wp->postData[head_offset], WEB_HEADER, SIGNATURE_LEN))
    	flag = 2;
    else if (!memcmp(&wp->postData[head_offset], ROOT_HEADER, SIGNATURE_LEN))
    	flag = 3;
    else {
       	strcpy(tmpBuf, T("<b>Invalid file format!"));
	goto ret_upload;
    }


#if 0
    if (len != numLeft - sizeof(IMG_HEADER_T) ) {
       	sprintf(tmpBuf, T("Image length mismatched!,len=%d"), len);
	goto ret_upload;
    }
#endif
    if(len > 0x200000){ //len check by sc_yang
      		sprintf(tmpBuf, T("<b>Image len exceed max size 0x200000 ! len=0x%x</b><br>"), len);
		goto ret_upload;
    }
    if ( (flag == 1) || (flag == 3)) {
    	if ( !fwChecksumOk(&wp->postData[sizeof(IMG_HEADER_T)+head_offset], len)) {
      		sprintf(tmpBuf, T("<b>Image checksum mismatched! len=0x%x, checksum=0x%x</b><br>"), len,
			*((unsigned short *)&wp->postData[len-2]) );
		goto ret_upload;
	}
    }
    else {
    	char *ptr = &wp->postData[sizeof(IMG_HEADER_T)+head_offset];
    	if ( !CHECKSUM_OK(ptr, len) ) {
     		sprintf(tmpBuf, T("<b>Image checksum mismatched! len=0x%x</b><br>"), len);
		goto ret_upload;
	}
    }

#ifdef __mips__
    if(flag == 3)
    	fh = open(FLASH_DEVICE_NAME1, O_RDWR);
    else
    fh = open(FLASH_DEVICE_NAME, O_RDWR);

    if ( fh == -1 ) {
#else
    if (flag == 1)
    	bn = "apcode.bin";
    else if (flag == 3)
    	bn = "root.bin" ;
    else
    	bn = "web.gz.up";

    if ((fp = fopen((bn == NULL ? "upldForm.bin" : bn), "w+b")) == NULL) {
#endif
       	strcpy(tmpBuf, T("File open failed!"));
    } else {

#ifdef __mips__
	if (flag == 1) {
		if ( startAddr == -1){
			//startAddr = CODE_IMAGE_OFFSET;
			startAddr = pHeader->burnAddr ;
			#ifdef _LITTLE_ENDIAN_
    				startAddr = DWORD_SWAP(startAddr);
    			#endif
		}

	}
	else if (flag == 3) {
		if ( startAddr == -1){
			//startAddr = ROOT_IMAGE_OFFSET;
			startAddr = pHeader->burnAddr ;
			#ifdef _LITTLE_ENDIAN_
    				startAddr = DWORD_SWAP(startAddr);
    			#endif
			startAddr -= ROOT_IMAGE_OFFSET;
			if(startAddr < 0 )
				startAddr = 0;
		}
	}
	else {
		if ( startAddrWeb == -1){
			//startAddr = WEB_PAGE_OFFSET;
			startAddr = pHeader->burnAddr ;
			#ifdef _LITTLE_ENDIAN_
    				startAddr = DWORD_SWAP(startAddr);
    			#endif
		}
		else
			startAddr = startAddrWeb;

#ifdef COMPACK_SIZE
		if ( startAddr == -1 ) {
			strcpy(tmpBuf, T("Cannot update web pages because flash layout could not support!"));
			goto ret_upload;
		}
#endif
	}
	lseek(fh, startAddr, SEEK_SET);
	if(flag == 3){
		locWrite += sizeof(IMG_HEADER_T); // remove header
		numLeft -=  sizeof(IMG_HEADER_T);
		kill_processes();
	}
	
	numWrite = write(fh, &(wp->postData[locWrite+head_offset]), numLeft);
#else
	numWrite = fwrite(&(wp->postData[locWrite+head_offset]), sizeof(*(wp->postData)), numLeft, fp);
#endif
	if (numWrite < numLeft) {
#ifdef __mips__
		sprintf(tmpBuf, T("File write failed.<br> locWrite=%d numLeft=%d numWrite=%d Size=%d bytes."), locWrite, numLeft, numWrite, wp->lenPostData);
#else
                sprintf(tmpBuf, T("File write failed.<br> ferror=%d locWrite=%d numLeft=%d numWrite=%d Size=%d bytes."), ferror(fp), locWrite, numLeft, numWrite, wp->lenPostData);
#endif
	}
	locWrite += numWrite;
 	numLeft -= numWrite;
#ifdef __mips__
	close(fh);
#else
	fclose(fp);
#endif
	if (numLeft == 0)
		sprintf(tmpBuf, T("Update successfully (size = %d bytes)!<br><br>Please wait a while for rebooting..."), wp->lenPostData);
	else
		sprintf(tmpBuf, T("numLeft=%d locWrite=%d Size=%d bytes."), numLeft, locWrite, len);

#ifdef __mips__
	// Read written data back to compare
{	unsigned char read_buf[4096];
	int read_offset=0, read_len;
    	unsigned char *pData = &wp->postData[head_offset];
	int postLen= len ;

	if(flag == 3){
		fh = open(FLASH_DEVICE_NAME1, O_RDWR);
		pData += sizeof(IMG_HEADER_T);
		postLen -= sizeof(IMG_HEADER_T);
	}
	else
   		fh = open(FLASH_DEVICE_NAME, O_RDWR);
    	if ( fh == -1 ) {
		strcpy(tmpBuf, T("open flash driver error!"));
		goto ret_upload;
	}

	lseek(fh, startAddr, SEEK_SET);

	while (read_offset != postLen) {
		read_len = read(fh, read_buf, 4096);

		if (read_len <= 0) {
			strcpy(tmpBuf, T("Read flash data error!"));
			goto ret_upload;
		}
		if ((read_len + read_offset) > postLen)
			read_len =  postLen - read_offset;

		if (memcmp(pData, read_buf, read_len)) {
			sprintf(tmpBuf, T("Compare flash data error [idx=%d], you may try to update again!"), read_offset);
			goto ret_upload;
		}
		pData += read_len;
		read_offset += read_len;
	}
}

#endif  // __mips__
	//sc_yang
	head_offset += len + sizeof(IMG_HEADER_T) ;
	startAddr = -1 ; //by sc_yang to reset the startAddr for next image
    }
} //while //sc_yang    

	sprintf(strChecksum, "%04x", checksum);

	strFWChecksum = strChecksum;
	if ( apmib_set(MIB_FW_CHECKSUM, (void *)strFWChecksum) == 0) {
 			strcpy(tmpBuf, T("Set Firmware Checksum error!"));
			goto ret_upload;
	}

	apmib_update(CURRENT_SETTING);

    OK_MSG1(tmpBuf, submitUrl);

	//printf("end...\n");
#ifndef NO_ACTION
/*
	if(flag != 3){
	    pid = find_pid_by_name("init");
	    kill(pid, SIGTERM);
	}
	else */
		reboot( RB_AUTOBOOT);
#endif

    return;

ret_upload:
    ERR_MSG(tmpBuf);
}
#endif

/////////////////////////////////////////////////////////////////////////////
void formPasswordSetup(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strUser, *strPassword, *userid, *nextUserid;
	char tmpBuf[100];

	strUser = websGetVar(wp, T("username"), T(""));
	strPassword = websGetVar(wp, T("newpass"), T(""));
	if ( strUser[0] && !strPassword[0] ) {
		strcpy(tmpBuf, T("ERROR: Password cannot be empty."));
		goto setErr_pass;
	}

	if ( strUser[0] ) {
		/* Check if user name is the same as supervisor name */
		if ( !apmib_get(MIB_SUPER_NAME, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Get supervisor name MIB error!"));
			goto setErr_pass;
		}
		if ( !strcmp(strUser, tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Cannot use the same user name as supervisor."));
			goto setErr_pass;
		}

#if 0 // -- roger
		/* Check if supervisor account exist. if not, create it */
		if ( !umGroupExists(DEFAULT_GROUP) )
			if ( umAddGroup(DEFAULT_GROUP, (short)PRIV_ADMIN, AM_BASIC, FALSE, FALSE) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add group."));
				goto setErr_pass;
			}
		if ( !umAccessLimitExists(ACCESS_URL) )
			if ( umAddAccessLimit(ACCESS_URL, AM_FULL, (short)0, DEFAULT_GROUP) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add access limit."));
				goto setErr_pass;
			}
		if(superName[0]){
			if ( !umUserExists(superName))
				if ( umAddUser(superName, superPass, DEFAULT_GROUP, FALSE, FALSE) ) {
					strcpy(tmpBuf, T("ERROR: Unable to add supervisor account."));
					goto setErr_pass;
				}
		}

		/* Add new one */
		if ( umUserExists(strUser))
			umDeleteUser(strUser);

		if ( umAddUser(strUser, strPassword, DEFAULT_GROUP, FALSE, FALSE) ) {
			strcpy(tmpBuf, T("ERROR: Unable to add user account."));
			goto setErr_pass;
		}
#endif
	}
	else {
#if 0 // -- roger
		/* Set NULL account, delete supervisor from DB */
			umDeleteAccessLimit("/");
			umDeleteUser(superName);
			umDeleteGroup(DEFAULT_GROUP);
#endif
	}

	/* Delete current user account */
#if 0 // -- roger
	userid = umGetFirstUser();
	while (userid) {
		if ( gstrcmp(userid, superName) && gstrcmp(userid, strUser)) {
			nextUserid = umGetNextUser(userid);
			if ( umDeleteUser(userid) ) {
				strcpy(tmpBuf, T("ERROR: Unable to delete user account."));
				goto setErr_pass;
			}
			userid = nextUserid;
			continue;
		}
		userid = umGetNextUser(userid);
	}

	if (umCommit(NULL) != 0) {
		strcpy(tmpBuf, T("ERROR: Unable to save user configuration."));
		goto setErr_pass;
	}
#endif

/* 2005.06.17 Brian, G700AP don't set user account. */
#if 0
	/* Set user account to MIB */
	if ( !apmib_set(MIB_USER_NAME, (void *)strUser) ) {
		strcpy(tmpBuf, T("ERROR: Set user name to MIB database failed."));
		goto setErr_pass;
	}
#endif

	if(strcmp(strPassword, "********"))
	{
		if ( !apmib_set(MIB_USER_PASSWORD, (void *)strPassword) ) {
			strcpy(tmpBuf, T("ERROR: Set user password to MIB database failed."));
			goto setErr_pass;
		}

		/* Retrieve next page URL */
		apmib_update(CURRENT_SETTING);
	}
		
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	OK_MSG(submitUrl);
	return;

setErr_pass:
	ERR_MSG(tmpBuf);
}

////////////////////////////////////////////////////////////////////
void set_user_profile()
{
	/* first time load, get mib */
	if ( !apmib_get( MIB_SUPER_NAME, (void *)superName ) ||
		!apmib_get( MIB_SUPER_PASSWORD, (void *)superPass ) ||
			!apmib_get( MIB_USER_NAME, (void *)userName ) ||
				!apmib_get( MIB_USER_PASSWORD, (void *)userPass ) ) {
//		error(E_L, E_LOG, T("Get user account MIB failed"));
		printf("Get user account MIB failed");
		return;
	}

#if 0
	/* Create umconfig.txt if necessary */
	if ( userName[0] ) {
		/* Create supervisor */
		if ( !umGroupExists(DEFAULT_GROUP) )
			if ( umAddGroup(DEFAULT_GROUP, (short)PRIV_ADMIN, AM_BASIC, FALSE, FALSE) ) {
				error(E_L, E_LOG, T("ERROR: Unable to add group."));
				return;
			}
		if ( !umAccessLimitExists(ACCESS_URL) )
			if ( umAddAccessLimit(ACCESS_URL, AM_FULL, (short)0, DEFAULT_GROUP) ) {
				error(E_L, E_LOG, T("ERROR: Unable to add access limit."));
				return;
			}
		if(superName[0]){
			if ( !umUserExists(superName))
				if ( umAddUser(superName, superPass, DEFAULT_GROUP, FALSE, FALSE) ) {
					error(E_L, E_LOG, T("ERROR: Unable to add supervisor account."));
					return;
				}
		}

		/* Create user */
		if ( umUserExists(userName))
			umDeleteUser(userName);

		if ( umAddUser(userName, userPass, DEFAULT_GROUP, FALSE, FALSE) ) {
			error(E_L, E_LOG, T("ERROR: Unable to add user account."));
			return;
		}
	}
#endif
}

/////////////////////////////////////////////////////////////////////////////
void formStats(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;

	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	if (submitUrl[0])
		websRedirect(wp, submitUrl);
}

#ifdef WEBS
////////////////////////////////////////////////////////////////////////////////
int save_cs_to_file()
{
	char *buf, *ptr=NULL;
	PARAM_HEADER_Tp pHeader;
	unsigned char checksum;
	int len, fh;
	char tmpBuf[100];

	len = csHeader.len;
#ifdef _LITTLE_ENDIAN_
	//len  = WORD_SWAP(len);
#endif
	len += sizeof(PARAM_HEADER_T);
	buf = malloc(len);
	if ( buf == NULL ) {
		strcpy(tmpBuf, "Allocate buffer failed!");
		return 0;
	}
#ifdef __mips__
	fh = open("/web/config.dat", O_RDWR|O_CREAT|O_TRUNC);
#else
	fh = open("../web/config.dat", O_RDWR|O_CREAT|O_TRUNC);
#endif
	if (fh == -1) {
		printf("Create config file error!\n");
		free(buf);
		return 0;
	}

	pHeader = (PARAM_HEADER_Tp)buf;
	len = pHeader->len = csHeader.len;
	memcpy(&buf[sizeof(PARAM_HEADER_T)], pMib, len-1);

#ifdef _LITTLE_ENDIAN_
	//pHeader->len  = WORD_SWAP(pHeader->len);
	swap_mib_word_value((APMIB_Tp)&buf[sizeof(PARAM_HEADER_T)]);
#endif
	memcpy(pHeader->signature, csHeader.signature, SIGNATURE_LEN);
	ptr = (char *)&buf[sizeof(PARAM_HEADER_T)];
	checksum = CHECKSUM(ptr, len-1);
	buf[sizeof(PARAM_HEADER_T)+len-1] = checksum;

	ptr = &buf[sizeof(PARAM_HEADER_T)];
	ENCODE_DATA(ptr, len);

	if ( write(fh, buf, len+sizeof(PARAM_HEADER_T)) != len+sizeof(PARAM_HEADER_T)) {
		printf("Write config file error!\n");
		close(fh);
		free(buf);
		return 0;
	}

	close(fh);
	free(buf);

	return 1;
}
#endif // WEBS
#ifdef HOME_GATEWAY
/////////////////////////////////////////////////////////////////////////////
int  ntpHandler(webs_t wp, char *tmpBuf, int fromWizard)
{
	int enabled=0, ntpServerIdx ;
	struct in_addr ipAddr ;
	char *tmpStr ;
	
	if (fromWizard) {
		tmpStr = websGetVar(wp, T("enabled"), T(""));  
		if(!strcmp(tmpStr, "ON"))
			enabled = 1 ;
		else 
			enabled = 0 ;

		if ( apmib_set( MIB_NTP_ENABLED, (void *)&enabled) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_ntp;
		}
	}	
	else
		enabled = 1;
	
	if(enabled){
		tmpStr = websGetVar(wp, T("ntpServerId"), T(""));  
		if(tmpStr[0]){
			ntpServerIdx = tmpStr[0] - '0' ;
			if ( apmib_set(MIB_NTP_SERVER_ID, (void *)&ntpServerIdx) == 0) {
				strcpy(tmpBuf, T("Set Time Zone error!"));
				goto setErr_ntp;
			}
		}
		tmpStr = websGetVar(wp, T("timeZone"), T(""));  
		if(tmpStr[0]){
			if ( apmib_set(MIB_NTP_TIMEZONE, (void *)tmpStr) == 0) {
					strcpy(tmpBuf, T("Set Time Zone error!"));
				goto setErr_ntp;
		}
		}

		tmpStr = websGetVar(wp, T("ntpServerIp1"), T(""));  
		if(tmpStr[0]){
			inet_aton(tmpStr, &ipAddr);
			if ( apmib_set(MIB_NTP_SERVER_IP1, (void *)&ipAddr) == 0) {
				strcpy(tmpBuf, T("Set NTP server error!"));
				goto setErr_ntp;
			} 
			}
		tmpStr = websGetVar(wp, T("ntpServerIp2"), T(""));  
		if(tmpStr[0]){
			inet_aton(tmpStr, &ipAddr);
			if ( apmib_set(MIB_NTP_SERVER_IP2,(void *) &ipAddr ) == 0) {
				strcpy(tmpBuf, T("Set NTP server IP error!"));
				goto setErr_ntp;
			}
		}
	}
	return 0 ;	
setErr_ntp:
	return -1 ;
	
}
void formNtp(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl,*strVal, *tmpStr;
	char tmpBuf[100];
	int enabled=0;
	
#ifndef NO_ACTION
	int pid;
#endif
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	strVal = websGetVar(wp, T("save"), T(""));   

	if(strVal[0]){		
		struct tm tm_time;
		time_t tm;
		memcpy(&tm_time, localtime(&tm), sizeof(tm_time));
		tm_time.tm_sec = 0;
		tm_time.tm_min = 0;
		tm_time.tm_hour = 0;
		tm_time.tm_isdst = -1;  /* Be sure to recheck dst. */
		strVal = websGetVar(wp, T("year"), T(""));	
		tm_time.tm_year = atoi(strVal) - 1900;
		strVal = websGetVar(wp, T("month"), T(""));	
		tm_time.tm_mon = atoi(strVal)-1;
		strVal = websGetVar(wp, T("day"), T(""));	
		tm_time.tm_mday = atoi(strVal);
		strVal = websGetVar(wp, T("hour"), T(""));	
		tm_time.tm_hour = atoi(strVal);
		strVal = websGetVar(wp, T("minute"), T(""));	
		tm_time.tm_min = atoi(strVal);
		strVal = websGetVar(wp, T("second"), T(""));	
		tm_time.tm_sec = atoi(strVal);
		tm = mktime(&tm_time);
		if(tm < 0){
			sprintf(tmpBuf, "set Time Error\n");
			goto setErr_end;
		}
		if(stime(&tm) < 0){
			sprintf(tmpBuf, "set Time Error\n");
			goto setErr_end;
		}

		tmpStr = websGetVar(wp, T("timeZone"), T(""));  
		if(tmpStr[0]){
			if ( apmib_set(MIB_NTP_TIMEZONE, (void *)tmpStr) == 0) {
					strcpy(tmpBuf, T("Set Time Zone error!"));
				goto setErr_end;
			}
		}

		tmpStr = websGetVar(wp, T("enabled"), T(""));  
		if(!strcmp(tmpStr, "ON"))
			enabled = 1 ;
		else 
			enabled = 0 ;
		if ( apmib_set( MIB_NTP_ENABLED, (void *)&enabled) == 0) {
			strcpy(tmpBuf, T("Set enabled flag error!"));
			goto setErr_end;
		}
	}
	if (enabled == 0)		
		goto  set_ntp_end;
	
	if(ntpHandler(wp, tmpBuf, 0) < 0)
		goto setErr_end ;

set_ntp_end:
	apmib_update(CURRENT_SETTING);

#ifndef NO_ACTION
	pid = find_pid_by_name("ntp.sh");
	if(pid)
		kill(pid, SIGTERM);

	pid = fork();
        if (pid)
		waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _NTP_SCRIPT_PROG);
		execl( tmpBuf, _NTP_SCRIPT_PROG, NULL);
               	exit(1);
       	}
#endif
	OK_MSG(submitUrl);
	return;

setErr_end:
	ERR_MSG(tmpBuf);
}

#endif


/////////////////////////////////////////////////////////////////////////////
void formPasswordSetup4Wizard(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *strUser, *strPassword, *userid, *nextUserid;
	char tmpBuf[100];

	strUser = websGetVar(wp, T("username"), T(""));
	strPassword = websGetVar(wp, T("newpass"), T(""));
	//John H. 2006.01.10 move here to fix password can't be set 0
	//if ( strUser[0] && !strPassword[0] ) {
	//	strcpy(tmpBuf, T("ERROR: Password cannot be empty."));
	//	goto setErr_pass;
	//}
	//John H. 2006.01.10 move here to fix DHCP bug

	if ( strUser[0] ) {
		/* Check if user name is the same as supervisor name */
		if ( !apmib_get(MIB_SUPER_NAME, (void *)tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Get supervisor name MIB error!"));
			goto setErr_pass;
		}
		if ( !strcmp(strUser, tmpBuf)) {
			strcpy(tmpBuf, T("ERROR: Cannot use the same user name as supervisor."));
			goto setErr_pass;
		}

		/* Check if supervisor account exist. if not, create it */
#if 0 // -- roger
		if ( !umGroupExists(DEFAULT_GROUP) )
			if ( umAddGroup(DEFAULT_GROUP, (short)PRIV_ADMIN, AM_BASIC, FALSE, FALSE) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add group."));
				goto setErr_pass;
			}
		if ( !umAccessLimitExists(ACCESS_URL) )
			if ( umAddAccessLimit(ACCESS_URL, AM_FULL, (short)0, DEFAULT_GROUP) ) {
				strcpy(tmpBuf, T("ERROR: Unable to add access limit."));
				goto setErr_pass;
			}
		if(superName[0]){
			if ( !umUserExists(superName))
				if ( umAddUser(superName, superPass, DEFAULT_GROUP, FALSE, FALSE) ) {
					strcpy(tmpBuf, T("ERROR: Unable to add supervisor account."));
					goto setErr_pass;
				}
		}

		/* Add new one */
		if ( umUserExists(strUser))
			umDeleteUser(strUser);

		if ( umAddUser(strUser, strPassword, DEFAULT_GROUP, FALSE, FALSE) ) {
			strcpy(tmpBuf, T("ERROR: Unable to add user account."));
			goto setErr_pass;
		}
#endif
	}
	else {
		/* Set NULL account, delete supervisor from DB */
#if 0 // -- roger
			umDeleteAccessLimit("/");
			umDeleteUser(superName);
			umDeleteGroup(DEFAULT_GROUP);
#endif
	}

#if 0 // -- roger
	/* Delete current user account */
	userid = umGetFirstUser();
	while (userid) {
		if ( gstrcmp(userid, superName) && gstrcmp(userid, strUser)) {
			nextUserid = umGetNextUser(userid);
			if ( umDeleteUser(userid) ) {
				strcpy(tmpBuf, T("ERROR: Unable to delete user account."));
				goto setErr_pass;
			}
			userid = nextUserid;
			continue;
		}
		userid = umGetNextUser(userid);
	}

	if (umCommit(NULL) != 0) {
		strcpy(tmpBuf, T("ERROR: Unable to save user configuration."));
		goto setErr_pass;
	}
#endif

	/* Set user account to MIB */
	if ( !apmib_set(MIB_USER_NAME, (void *)strUser) ) {
		strcpy(tmpBuf, T("ERROR: Set user name to MIB database failed."));
		goto setErr_pass;
	}

	if(strcmp(strPassword, "********"))
	{
		if ( !apmib_set(MIB_USER_PASSWORD, (void *)strPassword) ) {
			strcpy(tmpBuf, T("ERROR: Set user password to MIB database failed."));
			goto setErr_pass;
		}
	}

	/* Retrieve next page URL */
	apmib_update(CURRENT_SETTING);
		
	//submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	//OK_MSG(submitUrl);
	return;

setErr_pass:
	ERR_MSG(tmpBuf);
}

void formWizard(webs_t wp, char_t *path, char_t *query)
{
	char_t *tmpStr;
	char tmpBuf[100];
	char varName[20];
	int i;
#ifdef HOME_GATEWAY	
	int dns_changed=0;
#endif	
	int mode=-1;
	char_t *submitUrl;
#ifndef NO_ACTION
	int pid;
#endif
#if 0	//sc_yang
	tmpStr = websGetVar(wp, T("finish"), T(""));   // finish button 
	if(! tmpStr[0]){ // not finish button 
		
		tmpStr = websGetVar(wp, T("back"), T(""));   // back button 
		if(tmpStr[0]){
			tmpStr = websGetVar(wp, T("back_url"), T(""));  
			websRedirect(wp, tmpStr);
			return ;
		}
		tmpStr = websGetVar(wp, T("next"), T(""));   // next button 
		if(tmpStr[0]){
			tmpStr = websGetVar(wp, T("next_url"), T("")); 
			websRedirect(wp, tmpStr);
			return ;
		}
	}
	else
#endif
#if 0
	tmpStr = websGetVar(wp, T("finish"), T(""));   // finish button 
	printf("finish = %s\n", tmpStr);
	printf("ntp --------------------------------\n");
	tmpStr = websGetVar(wp, T("enabled"), T(""));
	printf("enabled= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("timeZone"), T(""));
	printf("timeZone= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("ntpServer"), T(""));
	printf("ntpServer= %s\n", tmpStr);
	printf("lan--------------------------------\n");
	tmpStr = websGetVar(wp, T("lan_ip"), T(""));   
	printf("lan_ip= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("lan_mask"), T(""));  
	printf("lan_mask= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("lan_gateway"), T(""));
	printf("lan_gateway= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dhcp"), T(""));   
	printf("dhcp= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dhcpRangeStart"), T(""));   
	printf("start= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dhcpRangeEnd"), T(""));   
	printf("end= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("stp"), T(""));   
	printf("stp= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("lan_macAddr"), T(""));   
	printf("lan_macAddr= %s\n", tmpStr);

	printf("wan--------------------------------\n");
	tmpStr = websGetVar(wp, T("wanType"), T(""));   
	printf("wanType= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dnsMode"), T(""));   
	printf("dnsMode= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("wan_ip"), T(""));   
	printf("wan_ip= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("wan_mask"), T(""));   
	printf("wan_mask= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("wan_gateway"), T(""));   
	printf("wan_gateway= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pppUserName"), T(""));   
	printf("pppUserName= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pppPassword"), T(""));   
	printf("pppPassword= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pptpIpAddr"), T(""));   
	printf("pptpIpAddr= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pptpSubnetMask"), T(""));   
	printf("pptpSubnetMask= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pptpServerIpAddr"), T(""));   
	printf("pptpServerIpAddr= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pptpUserName"), T(""));   
	printf("pptpUserName= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pptpPassword"), T(""));   
	printf("pptpPassword= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dns1"), T(""));   
	printf("dns1= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pppConnectType"), T(""));   
	printf("pppConnectType= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pppIdleTime"), T(""));   
	printf("pppIdleTime= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pppMtuSize"), T(""));   
	printf("pppMtuSize= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("pptpMtuSize"), T(""));   
	printf("pptpMtuSize= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dsn2"), T(""));   
	printf("dsn2= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("dsn3"), T(""));   
	printf("dsn3= %s\n", tmpStr);
	tmpStr = websGetVar(wp, T("wan_macAddr"), T(""));   
	printf("wan_macAddr= %s\n", tmpStr);
for(i=0; i < wlan_num ; i++){
	printf("wlan%d--------------------------------\n",i);
	sprintf(varName, "wlanDisabled%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("wlanDisabled= %s\n", tmpStr);
	sprintf(varName, "ssid%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("ssid= %s\n", tmpStr);
	sprintf(varName, "chan%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("chan= %s\n", tmpStr);
	sprintf(varName, "band%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("band= %s\n", tmpStr);
	sprintf(varName, "basicrates%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("basicrates= %s\n", tmpStr);
	sprintf(varName, "operrates%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("operrates= %s\n", tmpStr);
	sprintf(varName, "mode%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("mode= %s\n", tmpStr);
	sprintf(varName, "type%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("type= %s\n", tmpStr);
	sprintf(varName, "method%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("method= %s\n", tmpStr);
	sprintf(varName, "length%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("length= %s\n", tmpStr);
	sprintf(varName, "format%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("format= %s\n", tmpStr);
	sprintf(varName, "defaultTxKeyId%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("defaultTxKeyId= %s\n", tmpStr);
	sprintf(varName, "key1%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("key1= %s\n", tmpStr);
	sprintf(varName, "key2%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("key2= %s\n", tmpStr);
	sprintf(varName, "key3%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("key3= %s\n", tmpStr);
	sprintf(varName, "key4%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("key4= %s\n", tmpStr);
	sprintf(varName, "ciphersuite%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("ciphersuite= %s\n", tmpStr);
	sprintf(varName, "pskFormat%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("pskFormat= %s\n", tmpStr);
	sprintf(varName, "pskValue%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("pskValue= %s\n", tmpStr);
	sprintf(varName, "wepEnabled%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("wepEnabled= %s\n", tmpStr);
	sprintf(varName, "use1x%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("use1x= %s\n", tmpStr);
	sprintf(varName, "wpaAuth%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("wpaAuth= %s\n", tmpStr);
	sprintf(varName, "radiusPort%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("radiusPort= %s\n", tmpStr);
	sprintf(varName, "radiusIP%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("radiusIP= %s\n", tmpStr);
	sprintf(varName, "radiusPass%d", i);
	tmpStr = websGetVar(wp, varName, T(""));   
	printf("radiusPass= %s\n", tmpStr);
}
#endif
#ifdef HOME_GATEWAY
	if(opModeHandler(wp, tmpBuf) < 0)
		goto setErr_end;

	if(ntpHandler(wp, tmpBuf, 1) < 0)
		goto setErr_end;
#endif
	if(tcpipLanHandler(wp, tmpBuf) < 0){
		submitUrl = websGetVar(wp, T("submit-url-lan"), T(""));   // hidden page
		goto setErr_end;
	}

#ifdef HOME_GATEWAY
	if(tcpipWanHandler(wp, tmpBuf, &dns_changed) < 0){
		submitUrl = websGetVar(wp, T("submit-url-wan"), T(""));   // hidden page
		goto setErr_end;	
	}
#endif
	for(i=0 ; i < wlan_num ;i++){	
		wlan_idx = i ;
		sprintf(WLAN_IF, "wlan%d", wlan_idx);
		if(wlanHandler(wp, tmpBuf,&mode, i) < 0){
		submitUrl = websGetVar(wp, T("submit-url-wlan1"), T(""));   // hidden page
		goto setErr_end;
	}	
		sprintf(varName, "method%d", i);
		tmpStr = websGetVar(wp, varName, T(""));
	if(tmpStr[0] && tmpStr[0] == '1'){
			if(wepHandler(wp, tmpBuf, i) < 0){
			submitUrl = websGetVar(wp, T("submit-url-wlan2"), T(""));   // hidden page
			goto setErr_end;
		}
	}	
		if(wpaHandler(wp, tmpBuf, i) < 0){
		submitUrl = websGetVar(wp, T("submit-url-wlan2"), T(""));   // hidden page
		goto setErr_end;
	}
	}
	formPasswordSetup4Wizard(wp, path, query);
	apmib_update(CURRENT_SETTING);
#ifndef NO_ACTION
	pid = fork();
        if (pid)
		waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "all", NULL);
#endif
               	exit(1);
       	}
#endif				
	submitUrl = websGetVar(wp, T("next_url"), T(""));								
	WIZARD_OK_MSG("/wizard.asp");
	return ;
setErr_end:
	
	OK_MSG1(tmpBuf,"/wizard.asp");
	return ;

}

///////////////////////////////////////////////////////////////////////////////////////////////
int logout=0 ;
void formLogout(webs_t wp, char_t *path, char_t *query)
{
	char_t *logout_str, *return_url;
	logout_str = websGetVar(wp, T("logout"), T(""));
	if (logout_str[0])
		logout = 1 ;

	return_url = websGetVar(wp, T("return-url"), T(""));
        OK_MSG(return_url);

	return;
}

#define _PATH_SYSCMD_LOG "/tmp/syscmd.log"

void formSysCmd(webs_t wp, char_t *path, char_t *query)
{
	char_t  *submitUrl, *sysCmd;
#ifndef NO_ACTION
	char_t tmpBuf[100];
#endif
	
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page
	sysCmd = websGetVar(wp, T("sysCmd"), T(""));   // hidden page

#ifndef NO_ACTION
	if(sysCmd[0]){
		snprintf(tmpBuf, 100, "%s 2>&1 > %s",sysCmd,  _PATH_SYSCMD_LOG);
		system(tmpBuf);
	}
#endif
		websRedirect(wp, submitUrl);
	return;
}

int sysCmdLog(int eid, webs_t wp, int argc, char_t **argv)
{
        FILE *fp;
	char  buf[150];
	int nBytesSent=0;

        fp = fopen(_PATH_SYSCMD_LOG, "r");
        if ( fp == NULL )
                goto err1;
        while(fgets(buf,150,fp)){
		nBytesSent += websWrite(wp, T("%s"), buf);
        }
	fclose(fp);
	unlink(_PATH_SYSCMD_LOG);
err1:
	return nBytesSent;
}


#ifdef HOME_GATEWAY

int  opModeHandler(webs_t wp, char *tmpBuf)
{
	char_t *tmpStr;
	int opmode, wanId;

	tmpStr = websGetVar(wp, T("opMode"), T(""));  
	if(tmpStr[0]){
		opmode = tmpStr[0] - '0' ;
		if ( apmib_set(MIB_OP_MODE, (void *)&opmode) == 0) {
			strcpy(tmpBuf, T("Set Opmode error!"));
			goto setErr_opmode;
		}
	}
	tmpStr = websGetVar(wp, T("wispWanId"), T(""));  
	if(tmpStr[0]){
		wanId = tmpStr[0] - '0' ;
		if ( apmib_set(MIB_WISP_WAN_ID, (void *)&wanId) == 0) {
			strcpy(tmpBuf, T("Set WISP WAN Id error!"));
			goto setErr_opmode;
		}
	}
	return 0;

setErr_opmode:
	return -1;

}
void formOpMode(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl;
	char tmpBuf[100];
	
#ifndef NO_ACTION
	int pid;
#endif
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	if(opModeHandler(wp, tmpBuf) < 0)
			goto setErr;
	
	apmib_update(CURRENT_SETTING);
#ifndef NO_ACTION
	pid = fork();
        if (pid)
		waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH,  _CONFIG_SCRIPT_PROG);
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "all", NULL);
               	exit(1);
       	}
#endif
	OK_MSG(submitUrl);
	return;

setErr:
	ERR_MSG(tmpBuf);
}
#endif


void formSysLog(webs_t wp, char_t *path, char_t *query)
{
	char_t *submitUrl, *tmpStr;
	char tmpBuf[100];
	int enabled, rt_enabled;
	struct in_addr ipAddr ;
	
#ifndef NO_ACTION
	int pid;
#endif
	submitUrl = websGetVar(wp, T("submit-url"), T(""));   // hidden page

	tmpStr = websGetVar(wp, T("nextPage"), T(""));
	if (!strcmp(tmpStr, "1")) {
		tmpStr = websGetVar(wp, T("curpage"), T(""));
		if (tmpStr[0]) {
			currentPage = atoi(&tmpStr[0]);
			websRedirect(wp, submitUrl);
			return;
		}
	}
	else if (!strcmp(tmpStr, "2")) {
		currentPage = 0;
		snprintf(tmpBuf, 100, "echo \" \" > %s", "/var/log/messages");
		system(tmpBuf);
		websRedirect(wp, submitUrl);
		return;
	}

	apmib_get(MIB_LOG_ENABLED, (void *)&enabled);
	
	tmpStr = websGetVar(wp, T("logEnabled"), T(""));  
	if(!strcmp(tmpStr, "ON")) {
		enabled |= 1;
		tmpStr = websGetVar(wp, "logtype", T(""));		
		if (!strcmp(tmpStr, "wlanlog"))
			enabled &= ~2;
		else
			enabled |= 2;	
	}
	else
		enabled = 0;
		
	if ( apmib_set(MIB_LOG_ENABLED, (void *)&enabled) == 0) {
		strcpy(tmpBuf, T("Set remote log enable error!"));
		goto setErr;
	}
	if(enabled){
		tmpStr = websGetVar(wp, T("logServer"), T(""));
		if(tmpStr[0]){
			inet_aton(tmpStr, &ipAddr);
			rt_enabled= 1;
		}
		else{
			inet_aton("0.0.0.0", &ipAddr);
			rt_enabled= 0;
		}
		
	}
	else {
		rt_enabled= 0;
		tmpStr = websGetVar(wp, T("logServer"), T(""));
		if(tmpStr[0])
			inet_aton(tmpStr, &ipAddr);
		else
			inet_aton("0.0.0.0", &ipAddr);
	}

		if ( apmib_set(MIB_REMOTELOG_SERVER, (void *)&ipAddr) == 0) {
			strcpy(tmpBuf, T("Set remote log server error!"));
			goto setErr;
		}

		if ( apmib_set(MIB_REMOTELOG_ENABLED, (void *)&rt_enabled) == 0) {
			strcpy(tmpBuf, T("Set remote log enable error!"));
				goto setErr;
		}

	apmib_update(CURRENT_SETTING);
#ifndef NO_ACTION
	pid = fork();
        if (pid)
		waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH,  _CONFIG_SCRIPT_PROG);
#ifdef HOME_GATEWAY
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "gw", "bridge", NULL);
#else
		execl( tmpBuf, _CONFIG_SCRIPT_PROG, "ap", "bridge", NULL);
#endif
               	exit(1);
       	}
#endif
	OK_MSG(submitUrl);
	return;

setErr:
	ERR_MSG(tmpBuf);
}


static int process_msg(char *msg, int is_wlan_only)
{
	char *p1, *p2;
	p1 = strstr(msg, "(none)"); // host name
	if (p1 == NULL)
		return 0;

	p2 = strstr(p1, "wlan");	
	if (p2 && p2[5]==':')  
		memcpy(p1, p2, strlen(p2)+1);
	else {
		if (is_wlan_only)
			return 0;
		
		p2 = strstr(p1, "klogd: ");
		if (p2 == NULL)
			return 0;
		memcpy(p1, p2+7, strlen(p2)-7+1);
	}
	return 1;
}


int sysLogList(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp;
	char  buf[150];
	int nBytesSent=0;
	int enabled, count=0;

	//apmib_get(MIB_LOG_ENABLED, (void *)&enabled);
	enabled = 3;
	if ( !(enabled & 1))
		goto err1;

	fp = fopen("/var/log/messages", "r");
	if (fp == NULL)
		goto err1;
        
	while(fgets(buf,150,fp)){
		int ret;
		if (enabled&2) // system all
			ret = process_msg(buf, 0);
		else // wlan only
			ret = process_msg(buf, 1);
		if (ret==0)
			continue;
		
		if ( count >= currentPage*MAX_PRE_PAGE )
			nBytesSent += websWrite(wp, T("%s"), buf);

		if ( count >= (currentPage*MAX_PRE_PAGE)+MAX_PRE_PAGE-1)
			break;
		
		count++;
	}
	fclose(fp);
err1:
	
	return nBytesSent;
}

int currentLogPage(int eid, webs_t wp, int argc, char_t **argv)
{
	int nBytesSent=0;

	nBytesSent += websWrite(wp, T("%d"), currentPage);	
	return nBytesSent;
}

int lastLogPage(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp;
	int nBytesSent=0, rowNum=0, lastPage = 0;
	char  buf[150];

	fp = fopen("/var/log/messages", "r");
	if (fp == NULL) {
		goto err1;
	}

	while(fgets(buf,150,fp))
		rowNum++;	//how many row
	fclose(fp);

	lastPage = rowNum / MAX_PRE_PAGE;
	if (lastPage < 0)
		lastPage = 0;
	nBytesSent += websWrite(wp, T("%d"), lastPage);	
	return nBytesSent;

err1:
	nBytesSent += websWrite(wp, T("%d"), 0);
	return nBytesSent;
}

static unsigned short calculateChecksum(char *buf, int len)
{
	int i, j;
	unsigned short sum=0, tmp;

	j = (len/2)*2;

	for (i=0; i<j; i+=2) {
		tmp = *((unsigned short *)(buf + i));
		sum += WORD_SWAP(tmp);
	}

	if ( len % 2 ) {
		tmp = buf[len-1];
		sum += WORD_SWAP(tmp);
	}

	return ~sum+1;
}

