/*
 *      Web server handler routines for get info and index (getinfo(), getindex())
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmget.c,v 1.1.1.1 2005/05/18 09:58:35 CAMEO+brian Exp $
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/sysinfo.h>

//#include "../webs.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"
#include "httpd.h"
#include "uemf.h"

#define CAMEO_FW_VERSION cameofwVersion
#define CAMEO_FW_DATE	cameofwDate
#define FW_VERSION	fwVersion
#define FW_DATE	fwDate
#define FW_CHECKSUM	checksum

extern char *cameofwVersion;	//defined in version.c
extern char *cameofwDate;		//defined in version.c
extern char *fwVersion;	// defined in version.c
extern char *fwDate;	// defined in version.c
extern char *checksum;		//defined in version.c

#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
extern int getIpsecInfo(IPSECTUNNEL_T *entry);
#endif
#endif

//yibin---------------------
extern void ejSetResult(int eid, char_t *s);

/////////////////////////////////////////////////////////////////////////////
static void translate_control_code(char *buffer)
{
	char tmpBuf[200], *p1 = buffer, *p2 = tmpBuf;


	while (*p1) {
		if (*p1 == '"') {
			memcpy(p2, "&quot;", 6);
			p2 += 6;
		}
		else if (*p1 == '\x27') {
			memcpy(p2, "&#39;", 5);
			p2 += 5;
		}
		else if (*p1 == '\x5c') {
			memcpy(p2, "&#92;", 5);
			p2 += 5;
		}
		else
			*p2++ = *p1;
		p1++;
	}
	*p2 = '\0';

	strcpy(buffer, tmpBuf);
}

static void translate_control_space(char *buffer)
{
	char tmpBuf[200], *p1 = buffer, *p2 = tmpBuf;


	while (*p1) {
		if (*p1 == '"') {
			memcpy(p2, "&quot;", 6);
			p2 += 6;
		}
		else if (*p1 == '\x27') {
			memcpy(p2, "&#39;", 5);
			p2 += 5;
		}
		else if (*p1 == '\x5c') {
			memcpy(p2, "&#92;", 5);
			p2 += 5;
		}
		else if (*p1 == ' ') {
			memcpy(p2, "&nbsp;", 6);
			p2 += 6;
		}
		else
			*p2++ = *p1;
		p1++;
	}
	*p2 = '\0';

	strcpy(buffer, tmpBuf);
}

/////////////////////////////////////////////////////////////////////////////
int getInfo(int eid, webs_t wp, int argc, char_t **argv)
{
	char_t	*name;
	struct in_addr	intaddr;
	struct sockaddr hwaddr;
	WDS_T wdsmac;
	unsigned char *pMacAddr;
	unsigned long sec, mn, hr, day;
	unsigned char buffer[500],buffer_1[10];	//John fix radius server problem for NULL gateway 2006.11.13
	int i,intVal;
 	struct user_net_device_stats stats;
	DHCP_T dhcp;
	bss_info bss;
	struct tm * tm_time;
	time_t current_secs;
#ifdef HOME_GATEWAY
	char_t *iface=NULL;
	OPMODE_T opmode=-1;
#endif
#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
	IPSECTUNNEL_T entry ;
#endif
#endif
   	if (ejArgs(argc, argv, T("%s"), &name) < 1) {
   		websError(wp, 400, T("Insufficient args\n"));
   		return -1;
   	}

   	if ( !strcmp(name, T("name")) ) {
		buffer[0]='\0';
		if ( !apmib_get(MIB_DEVICE_NAME,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("uptime"))) {
		struct sysinfo info ;

		sysinfo(&info);
		sec = (unsigned long) info.uptime ;
		day = sec / 86400;
		//day -= 10957; // day counted from 1970-2000

		sec %= 86400;
		hr = sec / 3600;
		sec %= 3600;
		mn = sec / 60;
		sec %= 60;

		return websWrite(wp, T("%dday:%dh:%dm:%ds"),
							day, hr, mn, sec);
	}
	else if ( !strcmp(name, T("year"))) {
	
		time(&current_secs);
		tm_time = localtime(&current_secs);
		#if 0
		sprintf(buffer , "%2d/%2d/%d %2d:%2d:%2d %s",
				(tm_time->tm_mon),
				(tm_time->tm_mday), (tm_time->tm_year+ 1900),
				(tm_time->tm_hour),
				(tm_time->tm_min),(tm_time->tm_sec)
				, _tzname[tm_time->tm_isdst]);
		#endif
		sprintf(buffer,"%d", (tm_time->tm_year+ 1900));
		
		return websWrite(wp, T("%s"), buffer);
							
	}
	else if ( !strcmp(name, T("month"))) {
		time(&current_secs);
		tm_time = localtime(&current_secs);
		sprintf(buffer,"%d", (tm_time->tm_mon+1));
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("day"))) {
		time(&current_secs);
		tm_time = localtime(&current_secs);
		sprintf(buffer,"%d", (tm_time->tm_mday));
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("hour"))) {
		time(&current_secs);
		tm_time = localtime(&current_secs);
		sprintf(buffer,"%d", (tm_time->tm_hour));
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("minute"))) {
		time(&current_secs);
		tm_time = localtime(&current_secs);
		sprintf(buffer,"%d", (tm_time->tm_min));
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("second"))) {
		time(&current_secs);
		tm_time = localtime(&current_secs);
		sprintf(buffer,"%d", (tm_time->tm_sec));
		return websWrite(wp, T("%s"), buffer);
	}
   	else if ( !strcmp(name, T("clientnum"))) {
		apmib_get( MIB_WLAN_DISABLED, (void *)&intVal);
		if (intVal == 1)	// disable
			intVal = 0;
		else {
			if ( getWlStaNum(WLAN_IF, &intVal) < 0)
			intVal = 0;
		}
		sprintf(buffer, "%d", intVal );
		return websWrite(wp, buffer);
	}
   	else if ( !strcmp(name, T("ssid"))) {
		if ( !apmib_get( MIB_WLAN_SSID,  (void *)buffer) )
			return -1;

		translate_control_code(buffer);
		
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("bssid2join"))) {
		if ( !apmib_get(MIB_WLAN_DEFAULT_SSID,  (void *)buffer) )
			return -1;
		
		if(buffer[0] == '\0')
			return websWrite(wp, T(""));
		else
			return websWrite(wp, T("%12s"), buffer);
	}
   	else if ( !strcmp(name, T("channel"))) {
		if ( !apmib_get( MIB_WLAN_CHAN_NUM,  (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
        else if ( !strcmp(name, T("wep"))) {
                ENCRYPT_T encrypt;
                if ( !apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt) )
                        return -1;
                if (encrypt == ENCRYPT_DISABLED)
                        strcpy( buffer, T("Disabled") );
                else if (encrypt == ENCRYPT_WPA)
                        strcpy( buffer, T("WPA") );
		else if (encrypt == ENCRYPT_WPA2)
                        strcpy( buffer, T("WPA2") ); 
		else if (encrypt == (ENCRYPT_WPA | ENCRYPT_WPA2))
                        strcpy( buffer, T("WPA2 Mixed") );                          
                else {
                        WEP_T wep;
                        if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) )
                                return -1;
                        if ( wep == WEP_DISABLED )
                                strcpy( buffer, T("Disabled") );
                        else if ( wep == WEP64 )
                                strcpy( buffer, T("WEP 64bits") );
                        else if ( wep == WEP128)
                                strcpy( buffer, T("WEP 128bits") );
                }
                return websWrite(wp, buffer);
        }
   	else if ( !strcmp(name, T("wdsEncrypt"))) {
   		WDS_ENCRYPT_T encrypt;
		if ( !apmib_get( MIB_WLAN_WDS_ENCRYPT,  (void *)&encrypt) )
			return -1;
		if ( encrypt == WDS_ENCRYPT_DISABLED)
			strcpy( buffer, T("Disabled") );
		else if ( encrypt == WDS_ENCRYPT_WEP64)
			strcpy( buffer, T("WEP 64bits") );
		else if ( encrypt == WDS_ENCRYPT_WEP128)
			strcpy( buffer, T("WEP 128bits") );
		else if ( encrypt == WDS_ENCRYPT_TKIP)
			strcpy( buffer, T("TKIP") );
		else if ( encrypt == WDS_ENCRYPT_AES)
			strcpy( buffer, T("AES") );
		else
			buffer[0] = '\0';
   		return websWrite(wp, buffer);
   	}
  	else if ( !strcmp(name, T("ip"))) {
		if ( getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr ) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("mask"))) {
		if ( getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&intaddr ))
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("gateway"))) {
		DHCP_T dhcp;
  		apmib_get( MIB_DHCP, (void *)&dhcp);
		if ( dhcp == DHCP_SERVER ) {
		// if DHCP server, default gateway is set to LAN IP
			if ( getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr ) )
				return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
			else
				return websWrite(wp, T("0.0.0.0"));
		}
		else
		if ( getDefaultRoute(BRIDGE_IF, &intaddr) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
	else if ( !strcmp(name, T("ip-rom"))) {
		if ( !apmib_get( MIB_IP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("mask-rom"))) {
		if ( !apmib_get( MIB_SUBNET_MASK,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("gateway-rom"))) {
		if ( !apmib_get( MIB_DEFAULT_GATEWAY,  (void *)buffer) )
			return -1;
		//John fix radius server problem for NULL gateway 2006.11.13
		if ( !apmib_get( MIB_IP_ADDR,  (void *)buffer_1) )
			return -1;
		//if (!memcmp(buffer, buffer_1, 4))
		//	return websWrite(wp, T("0.0.0.0"));
		//John fix radius server problem for NULL gateway 2006.11.13
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T("0.0.0.0"));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
 	else if ( !strcmp(name, T("dhcp-current")) ) {
   		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;

		if (dhcp==DHCP_CLIENT) {
			if (!isDhcpClientExist(BRIDGE_IF) &&
					!getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr))
				return websWrite(wp, T("Getting IP from DHCP server..."));
			if (isDhcpClientExist(BRIDGE_IF))
				return websWrite(wp, T("DHCP"));
		}
		return websWrite(wp, T("Fixed IP"));
	}
 	else if ( !strcmp(name, T("dhcp-server")) ) {
   		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;

		if (dhcp==DHCP_SERVER)
			return websWrite(wp, T("Enabled"));
		else
			return websWrite(wp, T("Disabled"));
	}
   	else if ( !strcmp(name, T("dhcpRangeStart"))) {
		if ( !apmib_get( MIB_DHCP_CLIENT_START,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("dhcpRangeEnd"))) {
		if ( !apmib_get( MIB_DHCP_CLIENT_END,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
 	else if ( !strcmp(name, T("wan-dns1"))) {
		if ( !apmib_get( MIB_WAN_DNS1,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("wan-dns2"))) {
		if ( !apmib_get( MIB_WAN_DNS2,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
  	else if ( !strcmp(name, T("wan-dns3"))) {
		if ( !apmib_get( MIB_WAN_DNS3,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
#ifdef  HOME_GATEWAY
	else if ( !strcmp(name, T("ntpServerIp1"))) { // sc_yang
		if ( !apmib_get( MIB_NTP_SERVER_IP1,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));

		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("ntpServerIp2"))) { // sc_yang
		if ( !apmib_get( MIB_NTP_SERVER_IP2,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("ntpTimeZone"))) { // sc_yang
		if ( !apmib_get( MIB_NTP_TIMEZONE,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), buffer);
	}

  	else if ( !strcmp(name, T("wan-ip"))) {
  		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
  		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if ( dhcp == PPPOE || dhcp == PPTP) {
			iface = PPPOE_IF;
			if ( !isConnectPPP() )
				iface = NULL;
		}
		else if (opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;
		if ( iface && getInAddr(iface, IP_ADDR, (void *)&intaddr ) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("wan-mask"))) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
  		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if ( dhcp == PPPOE || dhcp == PPTP) {
			iface = PPPOE_IF;
			if ( !isConnectPPP() )
				iface = NULL;
		}
		else if (opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;

		if ( iface && getInAddr(iface, SUBNET_MASK, (void *)&intaddr ))
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
   	else if ( !strcmp(name, T("wan-gateway"))) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
  		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if ( dhcp == PPPOE || dhcp == PPTP) {
			iface = PPPOE_IF;
			if ( !isConnectPPP() )
				iface = NULL;
		}
		else if (opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;
		if ( iface && getDefaultRoute(iface, &intaddr) )
			return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
		else
			return websWrite(wp, T("0.0.0.0"));
	}
	else if ( !strcmp(name, T("wan-hwaddr"))) {
  		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if(opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;
		if ( getInAddr(iface, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
	else if ( !strcmp(name, T("wan-ip-rom"))) {
		if ( !apmib_get( MIB_WAN_IP_ADDR,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("wan-mask-rom"))) {
		if ( !apmib_get( MIB_WAN_SUBNET_MASK,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
   	else if ( !strcmp(name, T("wan-gateway-rom"))) {
		if ( !apmib_get( MIB_WAN_DEFAULT_GATEWAY,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T("0.0.0.0"));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
    	else if ( !strcmp(name, T("wan-ppp-idle"))) {
		if ( !apmib_get( MIB_PPP_IDLE_TIME,  (void *)&intVal) )
			return -1;

		sprintf(buffer, "%d", intVal/60 );
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("wanDhcp-current")) ) {
   		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == DHCP_CLIENT) {
  			if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
				return -1;
			if(opmode == WISP_MODE)
				iface = WLAN_IF;
			else
				iface = WAN_IF;
		 	if (!isDhcpClientExist(iface))
				return websWrite(wp, T("Getting IP from DHCP server..."));
			else
				return websWrite(wp, T("DHCP"));
		}
		else if ( dhcp == DHCP_DISABLED )
			return websWrite(wp, T("Fixed IP"));
		else if ( dhcp ==  PPPOE ) {
			if ( isConnectPPP())
				return websWrite(wp, T("PPPoE Connected"));
			else
				return websWrite(wp, T("PPPoE Disconnected"));
		}
		else if ( dhcp ==  PPTP ) {
			if ( isConnectPPP())
				return websWrite(wp, T("PPTP Connected"));
			else
				return websWrite(wp, T("PPTP Disconnected"));
		}
	}
   	else if ( !strcmp(name, T("pppUserName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPP_USER,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
  	else if ( !strcmp(name, T("pppPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPP_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
 	else if ( !strcmp(name, T("dmzHost"))) {
		if ( !apmib_get( MIB_DMZ_HOST,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("wanMac"))) {
		if ( !apmib_get(MIB_WAN_MAC_ADDR,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}
	else if ( !strcmp(name, T("pppMtuSize"))) {
		if ( !apmib_get( MIB_PPP_MTU_SIZE, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("pptpIp"))) {
		if ( !apmib_get( MIB_PPTP_IP,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("pptpSubnet"))) {
		if ( !apmib_get( MIB_PPTP_SUBNET_MASK,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("pptpServerIp"))) {
		if ( !apmib_get( MIB_PPTP_SERVER_IP,  (void *)buffer) )
			return -1;
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("pptpMtuSize"))) {
		if ( !apmib_get( MIB_PPTP_MTU_SIZE, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
  	else if ( !strcmp(name, T("pptpUserName"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPTP_USER,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
  	else if ( !strcmp(name, T("pptpPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_PPTP_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}

#endif
	else if ( !strcmp(name, T("hwaddr"))) {
		if ( getInAddr(BRIDGE_IF, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
	else if ( !strcmp(name, T("cameohwaddr"))) {
		if ( getInAddr(BRIDGE_IF, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02X:%02X:%02X:%02X:%02X:%02X"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
	else if ( !strcmp(name, T("bridgeMac"))) {
		if ( !apmib_get(MIB_ELAN_MAC_ADDR,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), buffer[0], buffer[1],
						buffer[2], buffer[3], buffer[4], buffer[5]);
	}

	/* Advance setting stuffs */
	else if ( !strcmp(name, T("fragThreshold"))) {
		if ( !apmib_get( MIB_WLAN_FRAG_THRESHOLD, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("rtsThreshold"))) {
		if ( !apmib_get( MIB_WLAN_RTS_THRESHOLD, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("beaconInterval"))) {
		if ( !apmib_get( MIB_WLAN_BEACON_INTERVAL, (void *)&intVal) )
			return -1;

		intVal = intVal - 19;	//for support realtek 20~1024 and match d-link UI 1~1000
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("dtimPeriod"))) {
		if ( !apmib_get( MIB_WLAN_DTIM_PERIOD, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("cameofwVersion"))) {
		sprintf(buffer, "%s", CAMEO_FW_VERSION );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("cameofwDate"))) {
		sprintf(buffer, "%s", CAMEO_FW_DATE);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("fwVersion"))) {
		sprintf(buffer, "%s", FW_VERSION );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("fwDate"))) {
		sprintf(buffer, "%s", FW_DATE);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("fwChecksum"))) {
		buffer[0]='\0';
                //if ( !apmib_get(MIB_FW_CHECKSUM,  (void *)buffer) )
                //        return -1;
                sprintf(buffer, "%s", FW_CHECKSUM);
                return websWrite(wp, T("%s"), buffer);	
	}
	else if ( !strcmp(name, T("lanTxPacketNum"))) {
		if ( getStats(ELAN_IF, &stats) < 0)
			stats.tx_packets = 0;
		sprintf(buffer, "%d", (int)stats.tx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("lanRxPacketNum"))) {
		if ( getStats(ELAN_IF, &stats) < 0)
			stats.rx_packets = 0;
		sprintf(buffer, "%d", (int)stats.rx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("wlanTxPacketNum"))) {
		if ( getStats(WLAN_IF, &stats) < 0)
			stats.tx_packets = 0;
		sprintf(buffer, "%d", (int)stats.tx_packets);
   		return websWrite(wp, buffer);

	}
	else if ( !strcmp(name, T("wlanRxPacketNum"))) {
		if ( getStats(WLAN_IF, &stats) < 0)
			stats.rx_packets = 0;
		sprintf(buffer, "%d", (int)stats.rx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("bssid"))) {
		apmib_get( MIB_WLAN_DISABLED, (void *)&intVal);
		if ( intVal == 0 &&  getInAddr(WLAN_IF, HW_ADDR, (void *)&hwaddr ) ) {
			pMacAddr = hwaddr.sa_data;
			return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), pMacAddr[0], pMacAddr[1],
				pMacAddr[2], pMacAddr[3], pMacAddr[4], pMacAddr[5]);
		}
		else
			return websWrite(wp, T("00:00:00:00:00:00"));
	}
	else if ( !strcmp(name, T("bssid_drv"))) {
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return -1;
		return websWrite(wp, T("%02x:%02x:%02x:%02x:%02x:%02x"), bss.bssid[0], bss.bssid[1],
				bss.bssid[2], bss.bssid[3], bss.bssid[4], bss.bssid[5]);
	}
	else if ( !strcmp(name, T("ssid_drv"))) {
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return -1;
		memcpy(buffer, bss.ssid, SSID_LEN+1);
		translate_control_space(buffer);
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("state_drv"))) {
		char *pMsg;
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return -1;
		switch (bss.state) {
		case STATE_DISABLED:
			pMsg = T("Disabled");
			break;
		case STATE_IDLE:
			pMsg = T("Idle");
			break;
		case STATE_STARTED:
			pMsg = T("Started");
			break;
		case STATE_CONNECTED:
			pMsg = T("Connected");
			break;
		case STATE_SCANNING:
			pMsg = T("Scanning");
			break;
		default:
			pMsg=NULL;
		}
		return websWrite(wp, T("%s"), pMsg);
	}
	else if ( !strcmp(name, T("channel_drv"))) {
		if ( getWlBssInfo(WLAN_IF, &bss) < 0)
			return -1;

		if (bss.channel)
			sprintf(buffer, "%d", bss.channel);
		else
			buffer[0] = '\0';

		return websWrite(wp, T("%s"), buffer);
	}

#ifdef HOME_GATEWAY
	else if ( !strcmp(name, T("wanTxPacketNum"))) {
  		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if(opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;
		if ( getStats(iface, &stats) < 0)
			stats.tx_packets = 0;
		sprintf(buffer, "%d", (int)stats.tx_packets);
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("wanRxPacketNum"))) {
		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if(opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;
		if ( getStats(iface, &stats) < 0)
			stats.rx_packets = 0;
		sprintf(buffer, "%d", (int)stats.rx_packets);
   		return websWrite(wp, buffer);
	}
#endif

	else if ( !strcmp(name, T("rsIp"))) {
		if ( !apmib_get( MIB_WLAN_RS_IP,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("rsPort"))) {
		if ( !apmib_get( MIB_WLAN_RS_PORT, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("rsPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_RS_PASSWORD,  (void *)buffer) )
			return -1;
  		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("rs2Ip"))) {
		if ( !apmib_get( MIB_WLAN_RS_2IP,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("rs2Port"))) {
		if ( !apmib_get( MIB_WLAN_RS_2PORT, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("rs2Password"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_RS_2PASSWORD,  (void *)buffer) )
			return -1;
  		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("accountRsIp"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_IP,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	else if ( !strcmp(name, T("accountRsPort"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_PORT, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("accountRsPassword"))) {
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_PASSWORD,  (void *)buffer) )
			return -1;
		return websWrite(wp, T("%s"), buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTime"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeDay"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal/86400 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeHr"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", (intVal%86400)/3600 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeMin"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", ((intVal%86400)%3600)/60 );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("groupRekeyTimeSec"))) {
		if ( !apmib_get( MIB_WLAN_WPA_GROUP_REKEY_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", ((intVal%86400)%3600)%60 );
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("pskValue"))) {
		int i;
		buffer[0]='\0';
		if ( !apmib_get(MIB_WLAN_WPA_PSK,  (void *)buffer) )
			return -1;
		for (i=0; i<strlen(buffer); i++)
			buffer[i]='*';
		buffer[i]='\0';
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("wdsPskValue"))) {
		int i;
		buffer[0]='\0';
		if ( !apmib_get(MIB_WLAN_WDS_PSK,  (void *)buffer) )
			return -1;
		for (i=0; i<strlen(buffer); i++)
			buffer[i]='*';
		buffer[i]='\0';
   		return websWrite(wp, buffer);
	}
 	else if ( !strcmp(name, T("wlanWdsMac"))) {
		int i,nBytesSent=0,val;
		buffer[0]='\0';
		if ( !apmib_get( MIB_WLAN_WDS_NUM, (void *)&val) )
		    return -1;
		for(i=1;i<=val;i++)
		{
		    *((char *)&wdsmac) = (char)i;
		    if ( !apmib_get(MIB_WLAN_WDS,  (void *)&wdsmac) )
			    return -1;
		    nBytesSent += websWrite(wp, T("%02x%02x%02x%02x%02x%02x"), wdsmac.macAddr[0], wdsmac.macAddr[1],
			    wdsmac.macAddr[2], wdsmac.macAddr[3], wdsmac.macAddr[4], wdsmac.macAddr[5]);
	    }
		return nBytesSent;
	}
	else if ( !strcmp(name, T("accountRsUpdateDelay"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_UPDATE_DELAY, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("rsInterval"))) {
		if ( !apmib_get( MIB_WLAN_RS_INTERVAL_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("accountRsInterval"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, (void *)&intVal) )
			return -1;
		sprintf(buffer, "%d", intVal );
   		return websWrite(wp, buffer);
	}

#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
	else if( !strcmp(name, T("vpnTblIdx"))){
              	sprintf(buffer, "%d", getVpnTblIdx());
                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecConnName"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); // default
		else
			sprintf(buffer, "%s", entry.connName);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecLocalIp"))){
                if ( getIpsecInfo(&entry) < 0){
			if(getInAddr(BRIDGE_IF, IP_ADDR, (void *)&intaddr )) 
			 	return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
			else{
 				if ( !apmib_get( MIB_IP_ADDR,  (void *)buffer) )
					 return websWrite(wp, T("0.0.0.0"));
				return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
			}
		}
		else
                	return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *) entry.lc_ipAddr)));
	}
	else if( !strcmp(name, T("ipsecLocalIpMask"))){
                if ( getIpsecInfo(&entry) < 0){
			if ( getInAddr(BRIDGE_IF, SUBNET_MASK, (void *)&intaddr ))
				return websWrite(wp, T("%s"), inet_ntoa(intaddr) );
			else{
 				if ( !apmib_get( MIB_SUBNET_MASK,  (void *)buffer) )
					 return websWrite(wp, T("0.0.0.0"));
				return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
			}
		}
		else{
			len2Mask(entry.lc_maskLen, buffer);
                	return websWrite(wp, T("%s"), buffer);
		}
	}
	else if( !strcmp(name, T("ipsecRemoteIp"))){
                if ( getIpsecInfo(&entry) < 0)
			 return websWrite(wp, T("0.0.0.0"));
		else
                	return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *) entry.rt_ipAddr)));
	}
	else if( !strcmp(name, T("ipsecRemoteIpMask"))){
                if ( getIpsecInfo(&entry) < 0)
			 return websWrite(wp, T("0.0.0.0"));
		else{
			len2Mask(entry.rt_maskLen, buffer);
                	return websWrite(wp, T("%s"), buffer);
		}
	}
	else if( !strcmp(name, T("ipsecRemoteGateway"))){
                if ( getIpsecInfo(&entry) < 0)
			 return websWrite(wp, T("0.0.0.0"));
		else
                	return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *) entry.rt_gwAddr)));
		
	}
	else if( !strcmp(name, T("ipsecSpi"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); // default
		else
			sprintf(buffer, "%s",entry.spi);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecEncrKey"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); // default
		else
			sprintf(buffer, "%s",entry.encrKey);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecAuthKey"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); // default
		else
			sprintf(buffer, "%s",entry.authKey);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ikePsKey"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); // default
		else
			sprintf(buffer, "%s",entry.psKey);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ikeLifeTime"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%d", 3600); // default
		else
			sprintf(buffer, "%lu",entry.ikeLifeTime);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ikeEncr"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%d", TRI_DES_ALGO); // default
		else
			sprintf(buffer, "%d",entry.ikeEncr);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ikeAuth"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%d", MD5_ALGO); // default
		else
			sprintf(buffer, "%d",entry.ikeAuth);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ikeKeyGroup"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%d", DH2_GRP); // default 768 bits
		else
			sprintf(buffer, "%d",entry.ikeKeyGroup);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecLifeTime"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%d", 28800); // default
		else
			sprintf(buffer, "%lu",entry.ipsecLifeTime);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecPfs"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%d", 1); // default  on
		else
			sprintf(buffer, "%d",entry.ipsecPfs);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecLocalId"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); 
		else
			sprintf(buffer, "%s",entry.lcId);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("ipsecRemoteId"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); 
		else
			sprintf(buffer, "%s",entry.rtId);

                return websWrite(wp, T("%s"), buffer);
	}
	else if( !strcmp(name, T("rtRsaKey"))){
                if ( getIpsecInfo(&entry) < 0)
			sprintf(buffer, "%s", ""); 
		else
			sprintf(buffer, "%s",entry.rsaKey);
                return websWrite(wp, T("%s"), buffer);
	}
#endif
#endif
	else if ( !strcmp(name, T("userName"))){
		buffer[0]='\0';
                if ( !apmib_get(MIB_USER_NAME,  (void *)buffer) )
                        return -1;
                return websWrite(wp, T("%s"), buffer);	
	}

#ifdef WLAN_EASY_CONFIG
	else if ( !strcmp(name, T("autoCfgAlgReq"))) {		
		apmib_get( MIB_WLAN_MODE, (void *)&intVal);		
		if (intVal==CLIENT_MODE) { // client
			if ( !apmib_get( MIB_WLAN_EASYCFG_ALG_REQ, (void *)&intVal) )
				return -1;
		}
		else {
			if ( !apmib_get( MIB_WLAN_EASYCFG_ALG_SUPP, (void *)&intVal) )
				return -1;			
		}
		buffer[0]='\0';
		if (intVal & ACF_ALGORITHM_WEP64)
			strcat(buffer, "WEP64");
		if (intVal & ACF_ALGORITHM_WEP128) {
			if (strlen(buffer) > 0)
				strcat(buffer, "+");
			strcat(buffer, "WEP128");
		}
		if (intVal & ACF_ALGORITHM_WPA_TKIP) {
			if (strlen(buffer) > 0)
				strcat(buffer, "+");			
			strcat(buffer, "WPA_TKIP");
		}
		if (intVal & ACF_ALGORITHM_WPA_AES) {
			if (strlen(buffer) > 0)
				strcat(buffer, "+");			
			strcat(buffer, "WPA_AES");
		}
		if (intVal & ACF_ALGORITHM_WPA2_TKIP) {
			if (strlen(buffer) > 0)
				strcat(buffer, "+");			
			strcat(buffer, "WPA2_TKIP");
		}
		if (intVal & ACF_ALGORITHM_WPA2_AES) {
			if (strlen(buffer) > 0)
				strcat(buffer, "+");			
			strcat(buffer, "WPA2_AES");
		}
   		return websWrite(wp, buffer);
	}

	else if ( !strcmp(name, T("autoCfgKey"))) {
		if ( !apmib_get( MIB_WLAN_EASYCFG_KEY, (void *)buffer) )
			return -1;
		return websWrite(wp, buffer);
	}
	else if ( !strcmp(name, T("UserPassword"))) {
		if ( !apmib_get( MIB_USER_PASSWORD, (void *)buffer) )
			return -1;
		return websWrite(wp, buffer);
	}
#endif // WLAN_EASY_CONFIG
#ifdef HOME_GATEWAY
	else if ( !strcmp(name, T("ddnsDomainName"))) {
		if ( !apmib_get( MIB_DDNS_DOMAIN_NAME, (void *)&buffer) )
			return -1;
   		return websWrite(wp, buffer);

	}
	else if ( !strcmp(name, T("ddnsUser"))) {
		if ( !apmib_get( MIB_DDNS_USER, (void *)&buffer) )
			return -1;
   		return websWrite(wp, buffer);

	}
	else if ( !strcmp(name, T("ddnsPassword"))) {
		if ( !apmib_get( MIB_DDNS_PASSWORD, (void *)&buffer) )
			return -1;
   		return websWrite(wp, buffer);

	}
#endif
	else if ( !strcmp(name, T("rtLogServer"))) {
		if ( !apmib_get( MIB_REMOTELOG_SERVER,  (void *)buffer) )
			return -1;
		if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
			return websWrite(wp, T(""));
   		return websWrite(wp, T("%s"), inet_ntoa(*((struct in_addr *)buffer)) );
	}
	for(i=0 ;i < wlan_num ; i++){
		sprintf(buffer, "wlan%d-status", i);
		if ( !strcmp(name, buffer )) {
			wlan_idx = i ;
			sprintf(WLAN_IF, "wlan%d", i);
		return websWrite(wp,"");
	}
	}
	
 	return -1;
}

/////////////////////////////////////////////////////////////////////////////
/*
	Modified by anders 2005 03 20
	current getIndex function only gets index value from mib 
	if got return it, else return -1
*/
int getIndex(int eid, webs_t wp, int argc, char_t **argv)
{
	char_t *name, buffer[50], auth[50], encrypt[50], wpa[50];
	int chan, val;
	REG_DOMAIN_T domain;
	WEP_T wep;
	DHCP_T dhcp;
#ifdef HOME_GATEWAY
	OPMODE_T opmode=-1;
	char_t *iface=NULL;
#ifdef VPN_SUPPORT
	IPSECTUNNEL_T entry;
#endif
#endif

   	if (ejArgs(argc, argv, T("%s"), &name) < 1) {
   		websError(wp, 400, T("Insufficient args\n"));
   		return -1;
   	}
   	if ( !strcmp(name, T("dhcp")) ) {
 		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;
		return (int)dhcp;
	}
   	else if ( !strcmp(name, T("dhcp_lease_time")) ) {
 		if ( !apmib_get( MIB_DHCP_LEASE_TIME, (void *)&val) )
			return -1;
		return (int)val;
	}
  	else if ( !strcmp(name, T("dhcp-current")) ) {
   		if ( !apmib_get( MIB_DHCP, (void *)&dhcp) )
			return -1;
		if ( dhcp == DHCP_CLIENT && !isDhcpClientExist(BRIDGE_IF))
			dhcp = DHCP_DISABLED;
		return (int)dhcp;
	}
 	else if ( !strcmp(name, T("stp")) ) {
   		if ( !apmib_get( MIB_STP_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
#ifdef HOME_GATEWAY
 	else if ( !strcmp(name, T("ntpEnabled")) ) {
   		if ( !apmib_get( MIB_NTP_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("ntpServerId")) ) {
   		if ( !apmib_get( MIB_NTP_SERVER_ID, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wanDhcp")) ) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
		return (int)dhcp;
	}
	else if ( !strcmp(name, T("wanDhcp-current")) ) {
		if ( !apmib_get( MIB_WAN_DHCP, (void *)&dhcp) )
			return -1;
  		if ( !apmib_get( MIB_OP_MODE, (void *)&opmode) )
			return -1;
		if(opmode == WISP_MODE)
			iface = WLAN_IF;
		else
			iface = WAN_IF;
		if ( dhcp == DHCP_CLIENT && !isDhcpClientExist(iface))
			dhcp = DHCP_DISABLED;
		return (int)dhcp
	}
	else if ( !strcmp(name, T("wanDNS")) ) {
		DNS_TYPE_T dns;
		if ( !apmib_get( MIB_WAN_DNS_MODE, (void *)&dns) )
			return -1;
		return (int)dns;
	}
	else if ( !strcmp(name, T("pppConnectType")) ) {
		PPP_CONNECT_TYPE_T type;
		if ( !apmib_get( MIB_PPP_CONNECT_TYPE, (void *)&type) )
			return -1;
		return (int)type;
	}
	else if ( !strcmp(name, T("pppConnectStatus")) ) {
		return isConnectPPP();
	}
	else if ( !strcmp(name, T("portFwNum")) ) {
		if ( !apmib_get( MIB_PORTFW_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("ipFilterNum")) ) {
		if ( !apmib_get( MIB_IPFILTER_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("portFilterNum")) ) {
		if ( !apmib_get( MIB_PORTFILTER_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("macFilterNum")) ) {
		if ( !apmib_get( MIB_MACFILTER_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("triggerPortNum")) ) {
		if ( !apmib_get( MIB_TRIGGERPORT_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
#ifdef ROUTE_SUPPORT
	else if ( !strcmp(name, T("staticRouteNum")) ) {
		if ( !apmib_get( MIB_STATICROUTE_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
#endif
	else if ( !strcmp(name, T("portFwEnabled"))) {
		if ( !apmib_get( MIB_PORTFW_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("ipFilterEnabled"))) {
		if ( !apmib_get( MIB_IPFILTER_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("portFilterEnabled"))) {
		if ( !apmib_get( MIB_PORTFILTER_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("macFilterEnabled"))) {
		if ( !apmib_get( MIB_MACFILTER_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("triggerPortEnabled"))) {
		if ( !apmib_get( MIB_TRIGGERPORT_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
#ifdef ROUTE_SUPPORT
	else if ( !strcmp(name, T("staticRouteEnabled"))) {
		if ( !apmib_get( MIB_STATICROUTE_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
#endif
	else if ( !strcmp(name, T("dmzEnabled"))) {
		if ( !apmib_get( MIB_DMZ_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("upnpEnabled")) ) {
		if ( !apmib_get( MIB_UPNP_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
#ifdef ROUTE_SUPPORT
	else if ( !strcmp(name, T("ripEnabled")) ) {
                if ( !apmib_get( MIB_RIP_ENABLED, (void *)&val) )
                        return -1;
                return (int)val;
        }
	else if ( !strcmp(name, T("ripLanTx")) ) {
                if ( !apmib_get( MIB_RIP_LAN_TX, (void *)&val) )
                        return -1;
                return (int)val;
        }
	else if ( !strcmp(name, T("ripLanRx")) ) {
                if ( !apmib_get( MIB_RIP_LAN_RX, (void *)&val) )
                        return -1;
                return (int)val;
        }
	else if ( !strcmp(name, T("ripWanTx")) ) {
                if ( !apmib_get( MIB_RIP_WAN_TX, (void *)&val) )
                        return -1;
                return (int)val;
        }
	else if ( !strcmp(name, T("ripWanRx")) ) {
                if ( !apmib_get( MIB_RIP_WAN_RX, (void *)&val) )
                        return -1;
                return (int)val;
        }
#endif //ROUTE
#endif
#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
	
        else if ( !strcmp(name, T("ipsecTunnelNum")) ) {
                if ( !apmib_get( MIB_IPSECTUNNEL_NUM, (void *)&val) )
                        return -1;
                return (int)val;
        }
        else if ( !strcmp(name, T("ipsecVpnEnabled"))) {
                if ( !apmib_get( MIB_IPSECTUNNEL_ENABLED, (void *)&val) )
                        return -1;
                return (int)val;
        }
	else if ( !strcmp(name, T("ipsecNattEnabled"))) {
                if ( !apmib_get( MIB_IPSEC_NATT_ENABLED, (void *)&val) )
                        return -1;
                return (int)val;
        }
	else if ( !strcmp(name, T("tunnelEnabled"))) {
                if ( getIpsecInfo(&entry) < 0)
			return 1; // default
		else
	        		return (int)entry.enable;
	}
	else if ( !strcmp(name, T("ipsecLocalType"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)SUBNET_ADDR; // subnet Address default
		else
	        		return (int)entry.lcType;
	}
	else if ( !strcmp(name, T("ipsecRemoteType"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)SUBNET_ADDR; // subnet Address default
		else
	        		return (int)entry.rtType;
	}
	else if ( !strcmp(name, T("ipsecKeyMode"))) {
#if 0		//sc_yang
		int val ;
               if ((val= getVpnKeyMode()) != -1){
                       sprintf(buffer, "%d", (int) val ) ;
               } else{
#endif	       
		if ( getIpsecInfo(&entry) < 0)
			return (int)IKE_MODE; // IKE mode
		else
			return (int)entry.keyMode;
	}
/*
	else if ( !strcmp(name, T("ipsecEspAh"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)ESP_PROTO; // ESP
		else
	        	return (int)entry.espAh;
	}
*/
	else if ( !strcmp(name, T("ipsecEspEncr"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)TRI_DES_ALGO; // 3DES
		else
	        	return (int)entry.espEncr;
	}
	else if ( !strcmp(name, T("ipsecEspAuth"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)MD5_ALGO; // MD5
		else
	        	return (int)entry.espAuth;
	}
	/*else if ( !strcmp(name, T("ipsecAhAuth"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)MD5_ALGO; // MD5
		else
	        	return (int)entry.ahAuth;
	}*/
	else if ( !strcmp(name, T("vpnConnectionType"))) {
                if ( getIpsecInfo(&entry) < 0)
			return (int)RESPONDER; // responder
		else
	        	return (int)entry.conType;
	}
	else if( !strcmp(name, T("ikeConnectStatus"))){
                if ( getIpsecInfo(&entry) < 0){
			return 0; 
		}
		else{
			if ( getConnStat(entry.connName) < 0)
				return 0; 
			else
				return 1;
		}
	}
	else if( !strcmp(name, T("ipsecLocalIdType"))){
                if ( getIpsecInfo(&entry) < 0)
			return 0; 
		else
			return (int)entry.lcIdType;
		}
	else if( !strcmp(name, T("ipsecRemoteIdType"))){
                if ( getIpsecInfo(&entry) < 0)
			return 0; 
		else
			return (int)entry.rtIdType;
	}
	else if( !strcmp(name, T("ipsecAuthType"))){
                if ( getIpsecInfo(&entry) < 0)
			return 0; 
		else
			return (int)entry.authType;
	}
#endif
#endif
	else if ( !strcmp(name, T("channel")) ) {
		if ( !apmib_get( MIB_WLAN_CHAN_NUM, (void *)&chan) )
			return -1;
		return (int)chan;
	}
	else if ( !strcmp(name, T("regDomain")) ) {
		if ( !apmib_get( MIB_HW_REG_DOMAIN, (void *)&domain) )
			return -1;
		return (int)domain;
	}
	else if ( !strcmp(name, T("wep")) ) {
		if ( !apmib_get( MIB_WLAN_WEP, (void *)&wep) )
			return -1;
		return (int)wep;
	}
	else if ( !strcmp(name, T("defaultKeyId")) ) {
		if ( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
			return -1;
		val++;
		return (int)val;
	}
	else if ( !strcmp(name, T("keyType")) ) {
		if ( !apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&val) )
			return -1;
		return (int)val ;
	}
	else if ( !strcmp(name, T("antennaTransmitPow")) ) {
		if ( !apmib_get( MIB_WLAN_ANTENNA_TRANSMIT_POW, (void *)&val) )
			return -1;
		return (int)val;
	}
  	else if ( !strcmp(name, T("authType"))) {
		if ( !apmib_get( MIB_WLAN_AUTH_TYPE, (void *)&val) )
			return -1;
		sprintf(auth, "%d", (int)val) ;

		if ( !apmib_get( MIB_WLAN_ENCRYPT, (void *)&val) )
			return -1;
		sprintf(encrypt, "%d", val);

		if ( !apmib_get( MIB_WLAN_WPA_AUTH, (void *)&val) )
			return -1;
		sprintf(wpa, "%d", val);

		if( !gstrcmp(encrypt, T("0")) ||  !gstrcmp(encrypt, T("1")))
		{
			if(!gstrcmp(auth, T("0")))		//AUTH_OPEN
				sprintf(buffer, "%d", 0);
			else							//AUTH_SHARED
				sprintf(buffer, "%d", 1);				
		}
		else if(!gstrcmp(encrypt, T("2")))
		{
			if( !gstrcmp(wpa, T("1")))		//WPA_AUTH_AUTO--wpa
				sprintf(buffer, "%d", 2);				
			else							//WPA_AUTH_PSK--wpa-psk
				sprintf(buffer, "%d", 3);								
		}
		else if(!gstrcmp(encrypt, T("4")))
		{
			if( !gstrcmp(wpa, T("1")))		//WPA2_AUTH_AUTO--wpa2
				sprintf(buffer, "%d", 4);				
			else							//WPA_AUTH_PSK--wpa2-psk
				sprintf(buffer, "%d", 5);								
		}
		else if(!gstrcmp(encrypt, T("6")))
		{
			if( !gstrcmp(wpa, T("1")))		//WPA2_AUTH_AUTO--wpa-auto
				sprintf(buffer, "%d", 6);				
			else							//WPA_AUTH_PSK--wpa2-auto
				sprintf(buffer, "%d", 7);								
		}
		else
			return -1;
		return atoi(buffer);
	}
	else if ( !strcmp(name, T("operRate"))) {
		if ( !apmib_get( MIB_WLAN_SUPPORTED_RATE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("basicRate"))) {
		if ( !apmib_get( MIB_WLAN_BASIC_RATE, (void *)&val) )
			return -1;
		return (int)val;
}
	else if ( !strcmp(name, T("preamble"))) {
		if ( !apmib_get( MIB_WLAN_PREAMBLE_TYPE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("hiddenSSID"))) {
		if ( !apmib_get( MIB_WLAN_HIDDEN_SSID, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wmFilterNum"))) {
		if ( !apmib_get( MIB_WLAN_AC_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wlanDisabled"))) {
		if ( !apmib_get( MIB_WLAN_DISABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wlanAcNum")) ) {
		if ( !apmib_get( MIB_WLAN_AC_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wlanAcEnabled"))) {
		if ( !apmib_get( MIB_WLAN_AC_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("rateAdaptiveEnabled"))) {
		if ( !apmib_get( MIB_WLAN_RATE_ADAPTIVE_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wlanMode"))) {
		if ( !apmib_get( MIB_WLAN_MODE, (void *)&val) )
			return -1;
		return (int)val;
	}

	else if ( !strcmp(name, T("networkType"))) {
		if ( !apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("iappDisabled"))) {
		if ( !apmib_get( MIB_WLAN_IAPP_DISABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("protectionDisabled"))) {
		if ( !apmib_get( MIB_WLAN_PROTECTION_DISABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("encrypt"))) {
		if ( !apmib_get( MIB_WLAN_ENCRYPT, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("enable1X"))) {
		if ( !apmib_get( MIB_WLAN_ENABLE_1X, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("enableSuppNonWpa"))) {
		if ( !apmib_get( MIB_WLAN_ENABLE_SUPP_NONWPA, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("suppNonWpa"))) {
		if ( !apmib_get( MIB_WLAN_SUPP_NONWPA, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wpaAuth"))) {
		if ( !apmib_get( MIB_WLAN_WPA_AUTH, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wpaCipher"))) {
		if ( !apmib_get( MIB_WLAN_WPA_CIPHER_SUITE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("pskFormat"))) {
		if ( !apmib_get( MIB_WLAN_WPA_PSK_FORMAT, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("accountRsEnabled"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("accountRsUpdateEnabled"))) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_UPDATE_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("enableMacAuth"))) {
		if ( !apmib_get( MIB_WLAN_ENABLE_MAC_AUTH, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("rsRetry")) ) {
		if ( !apmib_get( MIB_WLAN_RS_RETRY, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("accountRsRetry")) ) {
		if ( !apmib_get( MIB_WLAN_ACCOUNT_RS_RETRY, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wlanWdsEnabled"))) {
		if ( !apmib_get( MIB_WLAN_WDS_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wlanWdsNum"))) {
		if ( !apmib_get( MIB_WLAN_WDS_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wdsEncrypt"))) {
		if ( !apmib_get( MIB_WLAN_WDS_ENCRYPT, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wdsWepFormat"))) {
		if ( !apmib_get( MIB_WLAN_WDS_WEP_FORMAT, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("wdsPskFormat"))) {
		if ( !apmib_get( MIB_WLAN_WDS_PSK_FORMAT, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("RFType")) ) {
		if ( !apmib_get( MIB_HW_RF_TYPE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("band")) ) {
		if ( !apmib_get( MIB_WLAN_BAND, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("fixTxRate")) ) {
		if ( !apmib_get( MIB_WLAN_FIX_RATE, (void *)&val) )
			return -1;
		return (int)val;
	}	
	else if ( !strcmp(name, T("preAuth")) ) {
		if ( !apmib_get( MIB_WLAN_WPA2_PRE_AUTH, (void *)&val) )
			return -1;
		return (int)val;
	}

#ifdef WLAN_EASY_CONFIG
	else if ( !strcmp(name, T("autoCfgEnabled"))) {
		if ( !apmib_get( MIB_WLAN_EASYCFG_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("autoCfgMode"))) {
		if ( !apmib_get( MIB_WLAN_EASYCFG_MODE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("autoCfgKeyInstall"))) {
		char tmpbuf[100];
		if ( !apmib_get( MIB_WLAN_EASYCFG_KEY, (void *)&tmpbuf) )
			return -1;
		if (strlen(tmpbuf))
			val = 1;
		else
			val = 0;
		return (int)val;
	}
	else if ( !strcmp(name, T("autoCfgDigestInstall"))) {
		char tmpbuf[100];
		int is_adhoc;
		if ( !apmib_get( MIB_WLAN_MODE, (void *)&val) )
			return -1;
		if (val == CLIENT_MODE) {
			apmib_get( MIB_WLAN_NETWORK_TYPE, (void *)&is_adhoc );
			if (is_adhoc) {
				apmib_get( MIB_WLAN_EASYCFG_MODE, (void *)&val);
				if (!(val & MODE_QUESTION))
					val = 2;
				else {
					apmib_get( MIB_WLAN_EASYCFG_DIGEST, (void *)&tmpbuf);				
					if (strlen(tmpbuf))
						val = 1;
					else
						val = 0;			
				}				
			}
			else			
				val = 2;
		}
		else {
			if ( !apmib_get( MIB_WLAN_EASYCFG_MODE, (void *)&val) )
				return -1;
			if (!(val & MODE_QUESTION))
				val = 2;
			else {
				if ( !apmib_get( MIB_WLAN_EASYCFG_DIGEST, (void *)&tmpbuf) )
					return -1;
				if (strlen(tmpbuf))
					val = 1;
				else
					val = 0;
			}
		}
		return (int)val;
	}
	else if ( !strcmp(name, T("autoCfgWlanMode"))) {
		if ( !apmib_get( MIB_WLAN_EASYCFG_WLAN_MODE, (void *)&val) )
			return -1;
		return (int)val;
	}
#endif // WLAN_EASY_CONFIG
#ifdef HOME_GATEWAY
	else if ( !strcmp(name, T("ddnsEnabled")) ) {
		if ( !apmib_get( MIB_DDNS_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("ddnsType")) ) {
		if ( !apmib_get( MIB_DDNS_TYPE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("webWanAccess")) ) {
		if ( !apmib_get( WEB_WAN_ACCESS_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
#endif
	else if ( !strcmp(name, T("wispWanId")) ) {
		if ( !apmib_get( MIB_WISP_WAN_ID, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("opMode")) ) {
		if ( !apmib_get( MIB_OP_MODE, (void *)&val) )
			return -1;
		return (int)val;
	}
	
	else if ( !strcmp(name, T("wlan_num"))) {
		sprintf(buffer, "%d", wlan_num);
		ejSetResult(eid, buffer);
		return 0;
	}
	else if ( !strcmp(name, T("wlan_idx"))) {
		return (int)wlan_idx;
	}
	else if ( !strcmp(name, T("wlanMacClone"))) {
		if ( !apmib_get( MIB_WLAN_NAT25_MAC_CLONE, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("rtLogEnabled")) ) {
		if ( !apmib_get( MIB_REMOTELOG_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("logEnabled")) ) {
		if ( !apmib_get( MIB_LOG_ENABLED, (void *)&val) )
			return -1;
		return (int)val;
	}
#ifdef TLS_CLIENT
	else if ( !strcmp(name, T("rootIdx"))) {
		if ( !apmib_get( MIB_ROOT_IDX, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("userIdx"))) {
		if ( !apmib_get( MIB_USER_IDX, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("rootNum"))) {
		if ( !apmib_get( MIB_CERTROOT_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}
	else if ( !strcmp(name, T("userNum"))) {
		if ( !apmib_get( MIB_CERTUSER_NUM, (void *)&val) )
			return -1;
		return (int)val;
	}		

#endif	
	else
		return -1;
}

#ifdef HOME_GATEWAY
/////////////////////////////////////////////////////////////////////////////
int isConnectPPP()
{
	struct stat status;

	if ( stat("/etc/ppp/link", &status) < 0)
		return 0;

	return 1;
}
#endif
