#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include "apmib.h"

#define O_RDONLY	0x0
#define SEEK_SET    0

#define WORD_SWAP(v) ((unsigned short)(((v>>8)&0xff) | ((v<<8)&0xff00)))

static unsigned short calculateChecksum(char *buf, int len);

static unsigned short calculateChecksum(char *buf, int len)
{
	int i, j;
	unsigned short sum=0, tmp;

	j = (len/2)*2;

	for (i=0; i<j; i+=2) {
		tmp = *((unsigned short *)(buf + i));
		//sum += WORD_SWAP(tmp);
		sum += tmp;
	}

	if ( len % 2 ) {
		tmp = buf[len-1];
		//sum += WORD_SWAP(tmp);
		sum += tmp;
	}

	return ~sum+1;
}

/////////////////////////////////////////////////////////////////////////////
int main(int argc, char* argv[])
{
	int fh, size;
	char imageFile[80]={0}, strChecksum[8]={0};
	char *buf;
	unsigned short checksum;
	struct stat status;

	// parse input arguments
	if ( argc != 2) {
		printf("Usage: checksum imageFile.\n");
		exit(1);
	}
	sscanf(argv[1], "%s", imageFile);

	// check input file and allocate buffer
	if ( stat(imageFile, &status) < 0 ) {
		printf("Can't stat file! [%s]\n", imageFile );
		exit(1);
	}
	size = status.st_size;

	buf = malloc(size);
	if (buf == NULL) {
		printf("Malloc buffer failed!\n");
		exit(1);
	}
	memset(buf, '\0', size);

	// Read data and generate header
	fh = open(imageFile, O_RDONLY);
	if ( fh == -1 ) {
		printf("Open input file error!\n");
		exit(1);
	}

	if ( read(fh, buf, status.st_size) != status.st_size) {
		printf("Read file error!\n");
		close(fh);
		exit(1);
	}
	close(fh);

	checksum = WORD_SWAP(calculateChecksum(buf, status.st_size));

	printf("The %s file checksum == %04x\n", imageFile, checksum);

	//write the checksum into config file using mkconfig-ap script
	sprintf(strChecksum, "%04x", checksum);
	printf("strChecksum=[%s]\n", strChecksum);
	execl( "./mkconfig-ap", "mkconfig-ap",strChecksum, "../config/config-ap.txt", "../config/config.txt", NULL);

}

