/*
 * Basic skin (shtml)
 *
 * Copyright 2004, Broadcom Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id: basic.c,v 1.1.1.1 2005/05/18 09:58:35 CAMEO+brian Exp $
 */

#include <stdio.h>
#include <httpd.h>

#include "apform.h"
#include "apmib.h"
#include "applycgi.h"
#include "utility.h"


static int 
isEnabled(int eid, webs_t wp, int argc, char_t **argv)
{
//	int val = getIndex(eid,  wp, argc, argv);
	int val = getIndex(eid,  wp, 1, argv);

	if(val == -1) {
   		websError(wp, 400, T("can't get index value"));
   		return -1;
	}
	else {
		int num = atoi(argv[1]);
		if(val == num)
			websWrite(wp,"%s", argv[2]);
		else
			websWrite(wp,"");		
	}
	return 0;
}

static int 
isNotEnabled(int eid, webs_t wp, int argc, char_t **argv)
{
//	int val = getIndex(eid,  wp, argc, argv);
	int val = getIndex(eid,  wp, 1, argv);
	if(val == -1) {
   		websError(wp, 400, T("can't get index value"));
   		return -1;
	}
	else {
		int num = atoi(argv[1]);
		
		if(val != num)
			websWrite(wp,"%s", argv[2]);
		else
			websWrite(wp,"");		
	}
	return 0;
}

static int 
getIndexValue(int eid, webs_t wp, int argc, char_t **argv)
{
	int val = getIndex(eid,  wp, argc, argv);
	if(val == -1) {
   		websError(wp, 400, T("can't get index value"));
   		return -1;
	}
	else {
		websWrite(wp,"%d", val);
	}
	return 0;
}


static int 
getIndexTo(int eid, webs_t wp, int argc, char_t **argv)
{
//	int val = getIndex(eid,  wp, argc, argv);
	int val = getIndex(eid,  wp, 1, argv);
	if(val == -1) {
   		websError(wp, 400, T("can't get index value"));
   		return -1;
}
	else {
		websWrite(wp,"%s=%d;", argv[1], val);
	}		
	return 0;
}

static int 
setTo_bnadIdx(int eid, webs_t wp, int argc, char_t **argv)
{
//	int val = getIndex(eid,  wp, argc, argv);
	int val = getIndex(eid, wp, 1, argv);
	if(val == -1) {
   		websError(wp, 400, T("can't get index value"));
   		return -1;
	}
	else {
		if( val > 0)
			val = val -1;
		
		websWrite(wp,"%s=%d;", argv[1], val);
	}	   	  	
	return 0;
	}
	
static int 
getTxRxPacket(int eid, webs_t wp, int argc, char_t **argv)
{
 	struct user_net_device_stats stats;
	int i = 0;
	
	if (1 == 0) {
		websWrite(wp, "tx_pkt_num[%d] = %d;\n", 0, 0);
		websWrite(wp, "rx_pkt_num[%d] = %d;\n", 0, 0);
	}
	else {
		for (i=0; i< wlan_num; i=i+1) 
		{
			/*
				wlan_name= "wlan"+i+"-status";
				<% getInfo("wlan_name"); %>
			*/

			//wlan_idx = i ;
			sprintf(WLAN_IF, "wlan%d", i);

			if ( getStats(WLAN_IF, &stats) < 0) {
				stats.tx_packets = 0;
				stats.rx_packets = 0;
			}
			websWrite(wp, "<tr><td bgColor=#b7dcfb colSpan=3 height=20 ><DIV align=left><font face=Arial size=2><b>Wireless </b></font></DIV></td>\n");
			websWrite(wp, "<DIV align=right></tr><tr><TD width=\"11%%\"><DIV align=right><FONT face=Arial>Send &nbsp;</FONT></DIV></TD>\n");
			websWrite(wp, "<td width=\"24%%\" height=20><font face=Arial size=2>Good Packets</font></td>\n");
			websWrite(wp, "<td width=\"65%%\" height=20><font face=Arial size=2> %d </font></td></DIV></tr>\n", (int)stats.tx_packets);
			websWrite(wp, "<TR><TD width=\"11%%\"></TD><TD width=\"24%%\" height=20>&nbsp;</TD><TD width=\"65%%\" height=20></TD></TR>\n");
			websWrite(wp, "<DIV align=right></tr><tr><TD width=\"11%%\"><DIV align=right><FONT face=Arial>Send &nbsp;</FONT></DIV></TD>\n");
			websWrite(wp, "<TR><TD width=\"11%%\"><DIV align=right><FONT face=Arial>Recv &nbsp; </FONT></DIV></TD>\n");
			websWrite(wp, "<TD width=\"24%%\" height=20><FONT face=Arial color=#000000 size=2>Good Packets</FONT></TD>\n");
			websWrite(wp, "<TD width=\"65%%\" height=20><FONT face=Arial size=2> %d </FONT></TD></TR>\n", (int)stats.rx_packets);
		}
	}     	   	
	
	return 0;
}


static int 
setKeyTypeSelect(int eid, webs_t wp, int argc, char_t **argv)
{
	int val = getIndex(eid,  wp, argc, argv);

	if(val == -1) {
   		websError(wp, 400, T("can't get index value"));
   		return -1;
}
	else {
		websWrite(wp,"format.selectedIndex = %d", val);
	} 
	return 0;
}



char no_cache[] =
"Cache-Control: no-cache\r\n"
"Pragma: no-cache"
 // "Expires: 0"
;


struct mime_handler mime_handlers[] = {
	{ "**.shtml", "text/html", no_cache, NULL, do_ej, do_auth, 1 },
//	{ "**.js", "text/html", no_cache, NULL, do_ej, do_auth, 1 },
	{ "**.gif", "image/gif", NULL, NULL, do_file, do_auth, 1 },
	{ "**.jpg", "image/jpeg", NULL, NULL, do_file, do_auth, 1 },
	{ "**.jpeg", "image/gif", NULL, NULL, do_file, do_auth, 1 },
	{ "apply.cgi*", "text/html", no_cache, do_apply_post, do_apply_cgi, do_auth, 0 },
	{ "upload.cgi*", "text/html", no_cache, do_upgrade_post, do_upgrade_cgi, do_auth, 0 },
	{ "**.htm", "text/html", no_cache, NULL, do_ej, do_auth, 1 },
	{ "**.html", "text/html", no_cache, NULL, do_ej, do_auth, 1 },
	{ NULL, NULL, NULL, NULL, NULL, NULL, 0 }
};

struct ej_handler ej_handlers[] = {
	// Anders's implementation
	{"getInfo",getInfo},
	{"dhcpClientList",dhcpClientList},
	{"connectPCList",connectPCList},
	// Brian's implementation
	{"getIndexTo", getIndexTo},
	{"getIndexValue",getIndexValue},
	{"isEnabled", isEnabled},
	{"isNotEnabled", isNotEnabled},
	{"getTxRxPacket", getTxRxPacket},
	{"setTo_bnadIdx", setTo_bnadIdx},
	{"setKeyTypeSelect", setKeyTypeSelect},
	// Roger's implementation
	{"currentLogPage", currentLogPage},
	{"lastLogPage", lastLogPage},
	{"sysCmdLog", sysCmdLog},
	{"sysLogList", sysLogList},
	// yibin's implementation
	{"wirelessClientList",wirelessClientList},
	{"wirelessModeWepList",wirelessModeWepList},
	{"wlAcList",wlAcList},
	{"wlSiteSurveyTbl",wlSiteSurveyTbl},
	{"wlWdsList",wlWdsList},
	{"wdsList",wdsList},
	{"wirelessChannelList",wirelessChannelList},
	{"wirelessTxrateList",wirelessTxrateList},
	{ NULL, NULL }
};

