#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "apform.h"
#include "apmib.h"
#include "applycgi.h"
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <fcntl.h>
#include "utility.h"
#include "uemf.h"

enum {
	NOTHING,
	REBOOT,
	RESTART,
};

/*
static const char * const apply_header =
	"<HEAD><TITLE>DWL-G700AP</TITLE><BODY text=#000000 bgColor=#ffffff topMargin=0>\n"
	"<TABLE cellSpacing=0 cellPadding=0 width=765 align=center border=0>\n"
	"<TBODY><TR><TD><IMG height=95 src=\"/images/home_01.jpg\" width=765></TD></TR>\n"
	"<TR><TD background=/images/home_02.jpg><DIV align=left>\n"
	"<TABLE height=\"131\" cellSpacing=0 cellPadding=0 width=\"500\" align=center border=0>\n"
	"<TBODY><TR><TD><DIV align=center><FONT face=Arial><B></B></FONT></DIV></TD></TR>\n"
	"<TR><TD>&nbsp;</TD></TR><TR><TD><DIV align=center>\n"
	"<FONT face=Arial color=#000000 size=2>Change setting successfully! <BR></FONT></DIV></TD></TR>\n"
	"<TR><TD>&nbsp;</TD></TR><TR><TD><DIV align=center>\n";

static const char * const apply_footer =
	"<IMG height=35 src=\"/images/continue_p.gif\" width=70 border=0></A></DIV></TD></TR>\n"
	"<TR><TD><DIV align=center></DIV></TD></TR></TBODY></TABLE></DIV></TD></TR>\n"
	"<TR><TD background=/images/home_03.jpg><DIV align=right>\n"
	"<IMG height=27 src=\"/images/down_44.gif\" width=25></DIV></TD></TR></TBODY></TABLE></BODY>\n";
*/
  

char post_buf[POST_BUF_SIZE];

FORM_HANDLER form_handlers[] = {
	{"formWep", formWep},
	{"formTcpipSetup", formTcpipSetup},
	{"formWirelessSetup", formWirelessSetup},
	{"formWirelessTbl", formWirelessTbl},
	{"formAdvanceSetup", formAdvanceSetup},
	{"formWlAc", formWlAc},
	{"formWlWds", formWlWds},
	{"formSysLog", formSysLog},
	{"formWizard", formWizard},
	{"formWlSiteSurvey", formWlSiteSurvey},
	{"formPasswordSetup", formPasswordSetup},
	{"formSaveConfig", formSaveConfig},
	{NULL, NULL}
};

FORM_HANDLER upload_handlers[] = {
	{"formUploadConfig", formUploadConfig},
	{"formUploadFirmw", formUploadFirmw},
	{NULL, NULL}
};

// david ------------------------------------

#ifndef NO_ACTION

int daemonKilled = 0;

static void killDaemon()
{
    int pid;
    if (daemonKilled)
		return;
    daemonKilled = 1;
    pid = find_pid_by_name("udhcpc");
    if (pid > 0)
		kill(pid, SIGKILL);
    pid = find_pid_by_name("udhcpd");
    if (pid > 0)
		kill(pid, SIGKILL);
    pid = find_pid_by_name("iwcontrol");
    if (pid > 0)
		kill(pid, SIGKILL);
    pid = find_pid_by_name("iapp");
    if (pid > 0)
		kill(pid, SIGKILL);
    pid = find_pid_by_name("auth");
    if (pid > 0)
		kill(pid, SIGKILL);

#ifdef HOME_GATEWAY

	//sc_yang
    pid = find_pid_by_name("pppoe.sh");
    if (pid > 0)
        kill(pid, SIGKILL);
    // kill all upnpd 
    while((pid = find_pid_by_name("upnpd")) > 0)
    {
	    if (pid > 0)
		kill(pid, SIGKILL);
    }
    pid = find_pid_by_name("pppd");
    if (pid > 0)
        kill(pid, SIGKILL);
    pid = find_pid_by_name("pppoe");
    if (pid > 0)
        kill(pid, SIGKILL);
    pid = find_pid_by_name("dnrd");
    if (pid > 0)
        kill(pid, SIGKILL);
    pid = find_pid_by_name("disc_server");
    if (pid > 0)
        kill(pid, SIGKILL);
    sleep(5);

#endif

}

#endif // NO_ACTION


void do_auth(char *userid, char *passwd, char *realm)
{
	apmib_get(MIB_USER_NAME, (void *)userid);
	apmib_get(MIB_USER_PASSWORD, (void *)passwd);
	strncpy(realm, "802.11g WLAN Login", AUTH_MAX);
}


void do_apply_post(char *url, FILE *stream, int len, char *boundary)
{
	/* Get query */
	if (!fgets(post_buf, MIN(len + 1, sizeof(post_buf)), stream))
		return;
	len -= strlen(post_buf);
	/* Initialize CGI */
	init_cgi(post_buf);
	/* Slurp anything remaining in the request */
	while (len--)
		(void) fgetc(stream);
}

void do_apply_cgi(char *url, FILE *stream)
{
	char *path, *query;
	/* Parse path */
	query = url;
	path = strsep(&query, "?") ? : url;

	printf("start apply cgi\n");
	apply_cgi(stream, NULL, NULL, 0, url, path, query);
	/* Reset CGI */
	init_cgi(NULL);
	printf("end of apply cgi\n");
}


 /*
 * fread() with automatic retry on syscall interrupt
 * @param	ptr	location to store to
 * @param	size	size of each element of data
 * @param	nmemb	number of elements
 * @param	stream	file stream
 * @return	number of items successfully read
 */

int
safe_fread(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
	size_t ret = 0;
	do {
		clearerr(stream);
		ret += fread((char *)ptr + (ret * size), size, nmemb - ret, stream);
	} while (ret < nmemb && ferror(stream) && errno == EINTR);
	return ret;
}

/*
 * fwrite() with automatic retry on syscall interrupt
 * @param	ptr	location to read from
 * @param	size	size of each element of data
 * @param	nmemb	number of elements
 * @param	stream	file stream
 * @return	number of items successfully written
 */

int
safe_fwrite(const void *ptr, size_t size, size_t nmemb, FILE *stream)
{
	size_t ret = 0;
	do {
		clearerr(stream);
		ret += fwrite((char *)ptr + (ret * size), size, nmemb - ret, stream);
	} while (ret < nmemb && ferror(stream) && errno == EINTR);
	return ret;
}
char *postData = NULL;	// global pointer only for upload functions -- roger
int upgrade_ret;
unsigned long lenPostData;
#define UPLOAD_BASE_SIZE 1024
static void strip_boundary(char *boundary)
{
	unsigned long i, j;
	int flag;
	int boundaryLen;

	boundaryLen = strlen(boundary);
	
	for(i=0; i<lenPostData - boundaryLen - 2; i++) {
		if(postData[i] == '\r' && postData[i+1] == '\n' &&
			postData[i+2] == '-' && postData[i+3] == '-' ) {
			flag = 1;
			for(j=0; j<boundaryLen; j++) {
				if(postData[i+4+j] != boundary[j]) {
					flag = 0;
					break;
				}
			}
			if (flag == 1) {
				// boundary matched, shorten the lenPostData
				lenPostData = i;
				return;
			}
		}
	}
}
/* Upgrade from remote server or socket stream */
static int
sys_upgrade(char *url, FILE *stream, int *total, char *boundary)
{
	int count;
	long flags = -1;
	int ret = 1;
	int done = 0;
	int isFirmw = 0;
	lenPostData = 0;
 	if (postData) {
		bfree(B_L, postData);
		postData = NULL;
 	}
	if ((flags = fcntl(fileno(stream), F_GETFL)) < 0 ||
	    fcntl(fileno(stream), F_SETFL, flags | O_NONBLOCK) < 0) {
		ret = 0;
		goto err;
	}
	while (!done) {
		if ((postData = brealloc(B_L, postData, lenPostData+UPLOAD_BASE_SIZE)) == NULL) {
			ret = 0;
			goto err;
		}

		waitfor(fileno(stream), 2);
		count = safe_fread(postData + lenPostData, 1, UPLOAD_BASE_SIZE, stream);
		if (!count && (ferror(stream) || feof(stream)))
			break;
		lenPostData += count;
		printf(".");
		if(lenPostData > 200 * UPLOAD_BASE_SIZE && !isFirmw) {
			// uploading firmware, do something here
			//printf("this should be a firmware upgrade\n");
			isFirmw = 1;
			killDaemon();
		}
	}
	printf("Get postDataLen = [%ld]\n", lenPostData);
	// scan boundary and get correct data len
	strip_boundary(boundary);
	printf("after stripping: [%ld]\n", lenPostData);

	/* Reset nonblock on the socket */
	if (fcntl(fileno(stream), F_SETFL, flags) < 0) {
		ret = 0;
		goto err;
	}
 err:
	return ret;

}


void do_upgrade_post(char *url, FILE *stream, int len, char *boundary)
{
	char buf[1024];
	char *pBoundary;

	/* Look for our part */
	while (1) {
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			return;
		/*
		printf("!get[%s]\n", buf);
		len -= strlen(buf);
		if(!strncasecmp(buf, "Content-Type:", 13)) {
			printf("!match[%s]\n", buf);
			if ((pBoundary = strstr(buf, BOUNDARY_KWD)) != NULL) {
			// get boundary string
			pBoundary += strlen(BOUNDARY_KWD);
			boundaryStr = malloc(strlen(pBoundary) + 3); // add \0
			sprintf(boundaryStr, "--%s", pBoundary);
			boundaryStr[strlen(pBoundary) + 2] = '\0';
			printf("boundaryStr=[%s], [%s]\n", pBoundary, boundaryStr);
			boundaryLen = strlen(pBoundary) + 2;
			continue;
				}
		}
		*/
		if (!strncasecmp(buf, "Content-Disposition:", 20) &&
		    strstr(buf, "name=\"binary\""))
			break;
	}

	if(boundary != NULL)
		printf("boundary:[%s]\n", boundary);
	/* Skip boundary and headers */
	while (1) {
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			return;
		len -= strlen(buf);
		if (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))
			break;
	}
	/* Initialize CGI */
	//init_cgi(buf);

	upgrade_ret = sys_upgrade(NULL, stream, &len, boundary);

}


void
do_upgrade_cgi(char *url, FILE *stream)
{
	char *path, *query;
	FORM_HANDLER *handler = NULL;
	webs_t wp = (webs_t) stream;
	if(!upgrade_ret) {
		// incomplete upload or malloc error
		/* Reset CGI */
		init_cgi(NULL);
		ERR_MSG("Fail to upload data");
		return;
	}
	/* Parse path */
	query = url;
	path = strsep(&query, "?") ? : url;

	if(query != NULL) {
		for (handler = &upload_handlers[0]; handler->pattern; handler++) {
			if (match(handler->pattern, query)) {
				handler->fn(wp, path, query);
				break;
			}
		}
	}
	/* Reset CGI */
	//init_cgi(NULL);
	if(query==NULL || !handler->pattern) {
		// no action command or not match
		ERR_MSG("Invalid upload action");
	}
}


int
apply_cgi(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg, 
char_t *url, char_t *path, char_t *query)
{
//	int action = NOTHING;
//	char *value;
	FORM_HANDLER *handler;
	if(query != NULL) {
		for (handler = &form_handlers[0]; handler->pattern; handler++) {
			if (match(handler->pattern, query)) {
				handler->fn(wp, path, query);
				break;
			}
		}
	}
	if(query==NULL || !handler->pattern) {
		// no action command or not match
		ERR_MSG("Invalid page");
	}
	return 1;
}
