/*
 *      Include file of form handler
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: apform.h,v 1.1.1.1 2005/05/18 09:58:35 CAMEO+brian Exp $
 *
 */

#ifndef _INCLUDE_APFORM_H
#define _INCLUDE_APFORM_H

#if HAVE_STDBOOL_H
# include <stdbool.h>
#else
typedef enum {false = 0, true = 1} bool;
#endif

#ifdef __i386__
  #define _CONFIG_SCRIPT_PATH	T(".")
  #define _LITTLE_ENDIAN_
#else
  #define _CONFIG_SCRIPT_PATH	T("/bin")
#endif

#define _CONFIG_SCRIPT_PROG	T("init.sh")
#define _WLAN_SCRIPT_PROG	T("wlan.sh")
#define _PPPOE_SCRIPT_PROG	T("pppoe.sh")
#define _FIREWALL_SCRIPT_PROG	T("firewall.sh")
#define _ROUTE_SCRIPT_PROG	T("route.sh")
#define _PPPOE_DC_SCRIPT_PROG	T("disconnect.sh")
#define _IAPPAUTH_SCRIPT_PROG	T("iappauth.sh")
#define _NTP_SCRIPT_PROG	T("ntp.sh")
#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
#define _VPN_SCRIPT_PROG	T("vpn.sh")
#endif
#endif
#define _WLAN_APP_SCRIPT_PROG	T("wlanapp.sh")

#ifdef WLAN_EASY_CONFIG
#define _AUTO_CONFIG_DAEMON_PROG T("autoconf")
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "httpd.h"


extern char no_cache[];
///////////////////////////////////////////////////////////////////////////
static bool _is_hex(char c)
{
    return (((c >= '0') && (c <= '9')) ||
            ((c >= 'A') && (c <= 'F')) ||
            ((c >= 'a') && (c <= 'f')));
}

// Validate digit
static bool _isdigit(char c)
{
    return ((c >= '0') && (c <= '9'));
}

static int __inline__ string_to_hex(char_t *string, unsigned char *key, int len)
{
	char tmpBuf[4];
	int idx, ii=0;
	for (idx=0; idx<len; idx+=2) {
		tmpBuf[0] = string[idx];
		tmpBuf[1] = string[idx+1];
		tmpBuf[2] = 0;
		if ( !_is_hex(tmpBuf[0]) || !_is_hex(tmpBuf[1]))
			return 0;

		key[ii++] = (unsigned char) strtol(tmpBuf, (char**)NULL, 16);
	}
	return 1;
}

static int __inline__ string_to_dec(char_t *string, int *val)
{
	int idx;
	int len = strlen(string);

	for (idx=0; idx<len; idx++) {
		if ( !_isdigit(string[idx]))
			return 0;
	}

	*val = strtol(string, (char**)NULL, 10);
	return 1;
}

#define ERR_MSG(msg) { \
	send_headers( 200, "Ok", no_cache, "text/html" ); \
	websHeader(wp); \
	websWrite(wp, T("<HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n")); \
	websWrite(wp, T("<link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n")); \
	websWrite(wp, T("</HEAD>\n<BODY bgcolor=\"#ffffff\" text=\"#000080\" link=\"#000080\">\n")); \
	websWrite(wp, T("<TR><TD><FONT face=Arial color=#000000 size=2>%s</FONT></TD></TR><BR>\n"), msg); \
	websWrite(wp, T("<A href=\"javascript:history.go (-1)\">\n")); \
	websWrite(wp, T("<b>&lt;&lt; Back</b></a>\n</body>\n")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define OK_MSG(url) { \
	send_headers( 200, "Ok", no_cache, "text/html" ); \
	websHeader(wp); \
	websWrite(wp, T("<HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n")); \
	websWrite(wp, T("<link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n")); \
	websWrite(wp, T("</HEAD>\n<BODY bgcolor=\"#ffffff\" text=\"#000080\" link=\"#000080\">\n")); \
	websWrite(wp, T("<TR><TD><FONT face=Arial color=#000000 size=2></FONT></TD></TR><BR>\n")); \
	if (url[0]) websWrite(wp, T("<A href=javascript:window.location.replace(\"%s\")>\n"), url); \
	else websWrite(wp, T("<A href=\"javascript:window.close()\">\n")); \
	websWrite(wp, T("<b>&lt;&lt; Back</b></a>\n</body>\n")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define WIZARD_OK_MSG(url) { \
	send_headers( 200, "Ok", no_cache, "text/html" ); \
	websHeader(wp); \
	websWrite(wp, T("<HEAD><TITLE>TRENDnet | TEW-430APB | Setup Wizard</TITLE>\n")); \
	websWrite(wp, T("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n")); \
	websWrite(wp, T("<link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n")); \
	websWrite(wp, T("<script language=\"JavaScript\" src=\"public.js\"></script>\n")); \
	websWrite(wp, T("</HEAD>\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" topmargin=\"0\" leftmargin=\"0\">\n")); \
	websWrite(wp, T("<form>\n<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" height=\"369\" width=\"450\">\n")); \
	websWrite(wp, T("<tr><td valign=\"top\" background=\"images/bg_wizard.gif\"><table width=\"450\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n")); \
	websWrite(wp, T("<tr><td width=\"49\"><img src=\"images/spacer.gif\" width=\"50\" height=\"70\"></td>\n")); \
	websWrite(wp, T("<td width=\"349\">&nbsp;</td><td width=\"52\"><img src=\"images/spacer.gif\" width=\"50\" height=\"70\"></td></tr>\n")); \
	websWrite(wp, T("<tr><td>&nbsp;</td><td align=\"center\"><p>&nbsp;</p><p><br></p>\n")); \
	websWrite(wp, T("<p><b><font face=Arial size=3>Saving Changes and Restarting</font></b></p></td><td>&nbsp;</td></tr>\n")); \
	websWrite(wp, T("<tr><td>&nbsp;</td><td align=\"center\" valign=\"bottom\"><br>\n")); \
	websWrite(wp, T("<input type=\"button\" value=\"Close\" name=\"close\" onClick=\"window.close()\"></td><td>&nbsp;</td></tr>\n")); \
	websWrite(wp, T("</table></td></tr></table></form></body>\n")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define OK_MSG1(msg, url) { \
	send_headers( 200, "Ok", no_cache, "text/html" ); \
	websHeader(wp); \
	websWrite(wp, T("<HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n")); \
	websWrite(wp, T("<link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n")); \
	websWrite(wp, T("</HEAD>\n<BODY bgcolor=\"#ffffff\" text=\"#000080\" link=\"#000080\">\n")); \
	websWrite(wp, T("<TR><TD><FONT face=Arial color=#000000 size=2>%s</FONT></TD></TR><BR><BR>\n"), msg); \
	if (url[0]) websWrite(wp, T("<A href=javascript:window.location.replace(\"%s\")>\n"), url); \
	else websWrite(wp, T("<A href=\"javascript:window.close()\">\n")); \
	websWrite(wp, T("<b>&lt;&lt; Back</b></a>\n</body>\n")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define OK_MSG2(msg, url) { \
	send_headers( 200, "Ok", no_cache, "text/html" ); \
	websHeader(wp); \
	websWrite(wp, T("<HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n")); \
	websWrite(wp, T("<link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n")); \
	websWrite(wp, T("<script language=\"JavaScript\" src=\"public.js\"></script>\n")); \
	websWrite(wp, T("<script language=\"JavaScript\">\n")); \
	websWrite(wp, T("var count = 50; function do_count_down(){ document.getElementById(\"Con_button\").style.display=\"none\"; document.getElementById(\"show_sec\").innerHTML = count;\n")); \
	websWrite(wp, T("if (count == 0) { document.getElementById(\"Con_button\").style.display=\"\"; return; }\n")); \
	websWrite(wp, T("if (count > 0) { count--; setTimeout('do_count_down()',1000); }}\n")); \
	websWrite(wp, T("</script></HEAD>\n<BODY bgcolor=\"#ffffff\" text=\"#000080\" link=\"#000080\">\n")); \
	websWrite(wp, T("<TABLE cellSpacing=0 cellPadding=0 border=0><TBODY><TR><TD>&nbsp;</TD></TR>\n")); \
	websWrite(wp, T("<TR><TD><DIV><FONT face=Arial color=#000000 size=2>%s</FONT></DIV></TD></TR>\n"), msg); \
	websWrite(wp, T("<TR><TD>&nbsp;</TD></TR>\n")); \
	websWrite(wp, T("<TR><TD><DIV><FONT face=Arial color=#000000 size=2><B>Please wait&nbsp;<span id=\"show_sec\"></span>&nbsp; seconds.</B></FONT></DIV></TD></TR>\n")); \
	websWrite(wp, T("<TR><TD>&nbsp;</TD></TR>\n")); \
	websWrite(wp, T("<TR><TD><DIV id=\"Con_button\" style=\"display:none\">\n")); \
	if (url[0]) websWrite(wp, T("<A href=javascript:window.location.replace(\"%s\")>\n"), url); \
	else websWrite(wp, T("<A href=\"javascript:window.close()\">\n")); \
	websWrite(wp, T("<b>&lt;&lt; Back</b></a></DIV></TD></TR>\n</TBODY></TABLE></body>\n")); \
	websWrite(wp, T("<script>do_count_down();</script>\n")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}


//////////////////////////////////////////////////////////////////////////

/* Routines exported in fmmgmt.c */
extern int sysLogList(int eid, webs_t wp, int argc, char_t **argv);
extern void formPasswordSetup(webs_t wp, char_t *path, char_t *query);
extern void formUpload(webs_t wp, char_t * path, char_t * query);
#ifdef TLS_CLIENT
extern void formCertUpload(webs_t wp, char_t * path, char_t * query);
#endif
extern void formSaveConfig(webs_t wp, char_t *path, char_t *query);
extern void formUploadConfig(webs_t wp, char_t *path, char_t *query);
extern void formUploadFirmw(webs_t wp, char_t *path, char_t *query);
extern void set_user_profile();
extern void formStats(webs_t wp, char_t *path, char_t *query);
extern void formLogout(webs_t wp, char_t *path, char_t *query);
extern void formSysCmd(webs_t wp, char_t *path, char_t *query);
extern int sysCmdLog(int eid, webs_t wp, int argc, char_t **argv);
extern void formSysLog(webs_t wp, char_t *path, char_t *query);
extern int sysLogList(int eid, webs_t wp, int argc, char_t **argv);
extern int currentLogPage(int eid, webs_t wp, int argc, char_t **argv);
extern int lastLogPage(int eid, webs_t wp, int argc, char_t **argv);
#ifdef HOME_GATEWAY
// by sc_yang
extern void formNtp(webs_t wp, char_t *path, char_t *query);
extern void formOpMode(webs_t wp, char_t *path, char_t *query);
#endif
extern void formWizard(webs_t wp, char_t *path, char_t *query);

/* Routines exported in fmget.c */
extern int getIndex(int eid, webs_t wp, int argc, char_t **argv);
extern int getInfo(int eid, webs_t wp, int argc, char_t **argv);
extern int isConnectPPP();

/* Routines exported in fmwlan.c */
extern void formWirelessSetup(webs_t wp, char_t *path, char_t *query);

extern void formWlanSetup(webs_t wp, char_t *path, char_t *query);
extern int wlAcList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWlAc(webs_t wp, char_t *path, char_t *query);
extern void formAdvanceSetup(webs_t wp, char_t *path, char_t *query);
extern int wirelessClientList(int eid, webs_t wp, int argc, char_t **argv);
extern int wirelessModeWepList(int eid, webs_t wp, int argc, char_t **argv);
extern int wirelessChannelList(int eid, webs_t wp, int argc, char_t **argv);
extern int wirelessTxrateList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWirelessTbl(webs_t wp, char_t *path, char_t *query);
extern void formWep(webs_t wp, char_t *path, char_t *query);
extern void formWlSiteSurvey(webs_t wp, char_t *path, char_t *query);
extern int wepHandler(webs_t wp, char *tmpBuf, int wlan_id);
extern int wlanHandler(webs_t wp, char *tmpBuf, int *mode, int wlan_id); 
extern int wpaHandler(webs_t wp, char *tmpBuf, int wlan_id);
extern void formWlanRedirect(webs_t wp, char_t *path, char_t *query);
#ifdef TLS_CLIENT
extern int certRootList(int eid, webs_t wp, int argc, char_t **argv);
extern int certUserList(int eid, webs_t wp, int argc, char_t **argv);
#endif

int wlSiteSurveyTbl(int eid, webs_t wp, int argc, char_t **argv);
extern void formWlEncrypt(webs_t wp, char_t *path, char_t *query);

extern void formWlWds(webs_t wp, char_t *path, char_t *query);
extern int wlWdsList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWdsEncrypt(webs_t wp, char_t *path, char_t *query);
extern int wdsList(int eid, webs_t wp, int argc, char_t **argv);

#ifdef WLAN_EASY_CONFIG
extern void sigHandler_autoconf(int signo);
extern void formAutoCfg(webs_t wp, char_t *path, char_t *query);
#endif

/* Routines exported in fmtcpip.c */
extern void formTcpipSetup(webs_t wp, char_t *path, char_t *query);
extern int isDhcpClientExist(char *name);
extern void formReflashClientTbl(webs_t wp, char_t *path, char_t *query);
extern int dhcpClientList(int eid, webs_t wp, int argc, char_t **argv);
extern int connectPCList(int eid, webs_t wp, int argc, char_t **argv);
extern int tcpipLanHandler(webs_t wp, char *tmpBuf);

#ifdef HOME_GATEWAY
extern void formWanTcpipSetup(webs_t wp, char_t *path, char_t *query);

/* Routines exported in fmfwall.c */
extern void formPortFw(webs_t wp, char_t *path, char_t *query);
extern void formFilter(webs_t wp, char_t *path, char_t *query);
extern int portFwList(int eid, webs_t wp, int argc, char_t **argv);
extern int portFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int ipFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int macFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern void formDMZ(webs_t wp, char_t *path, char_t *query);
extern void formTriggerPort(webs_t wp, char_t *path, char_t *query);
extern int triggerPortList(int eid, webs_t wp, int argc, char_t **argv);
extern int tcpipWanHandler(webs_t wp, char * tmpBuf, int *dns_changed);
/* Routines exported in fmroute.c */
#ifdef ROUTE_SUPPORT
extern void formRoute(webs_t wp, char_t *path, char_t *query);
extern int staticRouteList(int eid, webs_t wp, int argc, char_t **argv);
extern int kernelRouteList(int eid, webs_t wp, int argc, char_t **argv);
#endif
#endif

#ifdef HOME_GATEWAY
/* Routine exported in fmddns.c */
extern void formDdns(webs_t wp, char_t *path, char_t *query);
#endif

#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
/* Routines exported in fmvpn.c */
extern void formVpnSetup(webs_t wp, char_t *path, char_t *query);
extern void formVpnConn(webs_t wp, char_t *path, char_t *query);
//extern int vpnStatList(int eid, webs_t wp, int argc, char_t **argv);
extern int vpnConnList(int eid, webs_t wp, int argc, char_t **argv);
extern int vpnRsaList(int eid, webs_t wp, int argc, char_t **argv);
extern int vpnShowLog(int eid, webs_t wp, int argc, char_t **argv);
extern void formVpnLog(webs_t wp, char_t *path, char_t *query);
extern int getVpnTblIdx(void);
extern void len2Mask(int len, char * mask );
extern int mask2Len(char *buf);
extern int getVpnKeyMode(void);
extern int  getConnStat(char *in_connName);
#endif
#endif

/* variables exported in main.c */
#ifdef HOME_GATEWAY
extern char *WAN_IF;
extern char *BRIDGE_IF;
extern char *ELAN_IF;
extern char *PPPOE_IF;

#else
extern char *BRIDGE_IF;
extern char *ELAN_IF;
#endif
extern char WLAN_IF[];
extern int wlan_num;
extern int currentPage;

#endif // _INCLUDE_APFORM_H




