/*
 *      MIB table declaration
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: mibtbl.c,v 1.34 2006/03/08 10:14:41 davidhsu Exp $
 *
 */

/* Include files */
#include "apmib.h"
#include "mibtbl.h"

/* Global variable definitions */

/*
 * When using flash (set/get/all) command to access the MIB of below table,
 * it needs append a keyword "DEF_" in ahead of mib name when access
 * default setting MIB.
 */

mib_table_entry_T mib_table[]={
#ifdef HOME_GATEWAY
{MIB_WAN_MAC_ADDR, 		"WAN_MAC_ADDR",		BYTE6_T, 	_OFFSET(wanMacAddr), _SIZE(wanMacAddr)},
{MIB_WAN_IP_ADDR,		"WAN_IP_ADDR", 		IA_T,		_OFFSET(wanIpAddr), _SIZE(wanIpAddr)},
{MIB_WAN_SUBNET_MASK,		"WAN_SUBNET_MASK", 	IA_T, 		_OFFSET(wanSubnetMask), _SIZE(wanSubnetMask)},
{MIB_WAN_DEFAULT_GATEWAY,	"WAN_DEFAULT_GATEWAY",	IA_T,		_OFFSET(wanDefaultGateway), _SIZE(wanDefaultGateway)},
{MIB_WAN_DHCP,			"WAN_DHCP",		BYTE_T,		_OFFSET(wanDhcp), _SIZE(wanDhcp)},
{MIB_WAN_DNS_MODE,		"DNS_MODE",		BYTE_T,		_OFFSET(dnsMode), _SIZE(dnsMode)},
{MIB_PPP_USER,			"PPP_USER_NAME",	STRING_T,	_OFFSET(pppUserName), _SIZE(pppUserName)},
{MIB_PPP_PASSWORD,		"PPP_PASSWORD", 	STRING_T,	_OFFSET(pppPassword), _SIZE(pppPassword)},
{MIB_PPP_IDLE_TIME,		"PPP_IDLE_TIME",	WORD_T,		_OFFSET(pppIdleTime), _SIZE(pppIdleTime)},
{MIB_PPP_CONNECT_TYPE,		"PPP_CONNECT_TYPE",	BYTE_T,		_OFFSET(pppConnectType), _SIZE(pppConnectType)},
{MIB_PORTFW_ENABLED,		"PORTFW_ENABLED",	BYTE_T,		_OFFSET(portFwEnabled), _SIZE(portFwEnabled)},
{MIB_PORTFW_NUM,		"PORTFW_TBL_NUM",	BYTE_T,		_OFFSET(portFwNum), _SIZE(portFwNum)},
{MIB_PORTFW,			"PORTFW_TBL",		PORTFW_ARRAY_T,	_OFFSET(portFwArray), _SIZE(portFwArray)},
{MIB_IPFILTER_ENABLED,		"IPFILTER_ENABLED",	BYTE_T,		_OFFSET(ipFilterEnabled), _SIZE(ipFilterEnabled)},
{MIB_IPFILTER_NUM,		"IPFILTER_TBL_NUM",	BYTE_T,		_OFFSET(ipFilterNum), _SIZE(ipFilterNum)},
{MIB_IPFILTER,			"IPFILTER_TBL",		IPFILTER_ARRAY_T,_OFFSET(ipFilterArray), _SIZE(ipFilterArray)},
{MIB_PORTFILTER_ENABLED,	"PORTFILTER_ENABLED",	BYTE_T,		_OFFSET(portFilterEnabled), _SIZE(portFilterEnabled)},
{MIB_PORTFILTER_NUM,		"PORTFILTER_TBL_NUM",	BYTE_T,		_OFFSET(portFilterNum), _SIZE(portFilterNum)},
{MIB_PORTFILTER,		"PORTFILTER_TBL",	PORTFILTER_ARRAY_T,_OFFSET(portFilterArray), _SIZE(portFilterArray)},
{MIB_MACFILTER_ENABLED,		"MACFILTER_ENABLED",	BYTE_T,		_OFFSET(macFilterEnabled), _SIZE(macFilterEnabled)},
{MIB_MACFILTER_NUM,		"MACFILTER_TBL_NUM",	BYTE_T,		_OFFSET(macFilterNum), _SIZE(macFilterNum)},
{MIB_MACFILTER,			"MACFILTER_TBL",	MACFILTER_ARRAY_T,_OFFSET(macFilterArray), _SIZE(macFilterArray)},
{MIB_TRIGGERPORT_ENABLED,	"TRIGGERPORT_ENABLED",	BYTE_T,		_OFFSET(triggerPortEnabled), _SIZE(triggerPortEnabled)},
{MIB_TRIGGERPORT_NUM,		"TRIGGERPORT_TBL_NUM",	BYTE_T,		_OFFSET(triggerPortNum), _SIZE(triggerPortNum)},
{MIB_TRIGGERPORT,		"TRIGGERPORT_TBL",	TRIGGERPORT_ARRAY_T,_OFFSET(triggerPortArray), _SIZE(triggerPortArray)},
{MIB_DMZ_ENABLED,		"DMZ_ENABLED", 		BYTE_T,		_OFFSET(dmzEnabled), _SIZE(dmzEnabled)},
{MIB_DMZ_HOST,			"DMZ_HOST", 		IA_T,		_OFFSET(dmzHost), _SIZE(dmzHost)},
{MIB_UPNP_ENABLED,		"UPNP_ENABLED", 	BYTE_T,		_OFFSET(upnpEnabled), _SIZE(upnpEnabled)},
{MIB_PPP_MTU_SIZE,		"PPP_MTU_SIZE",		WORD_T,		_OFFSET(pppMtuSize), _SIZE(pppMtuSize)},
{MIB_PPTP_IP,			"PPTP_IP_ADDR", 	IA_T,		_OFFSET(pptpIpAddr), _SIZE(pptpIpAddr)},
{MIB_PPTP_SUBNET_MASK,		"PPTP_SUBNET_MASK", 	IA_T, 		_OFFSET(pptpSubnetMask), _SIZE(pptpSubnetMask)},
{MIB_PPTP_SERVER_IP,		"PPTP_SERVER_IP_ADDR",	IA_T,		_OFFSET(pptpServerIpAddr), _SIZE(pptpServerIpAddr)},
{MIB_PPTP_USER,			"PPTP_USER_NAME",	STRING_T,	_OFFSET(pptpUserName), _SIZE(pptpUserName)},
{MIB_PPTP_PASSWORD,		"PPTP_PASSWORD", 	STRING_T,	_OFFSET(pptpPassword), _SIZE(pptpPassword)},
{MIB_PPTP_MTU_SIZE,		"PPTP_MTU_SIZE",	WORD_T,		_OFFSET(pptpMtuSize), _SIZE(pptpMtuSize)},
{MIB_PPTP_SECURITY_ENABLED, "PPTP_SECURITY_ENABLED", BYTE_T, _OFFSET(pptpSecurityEnabled), _SIZE(pptpSecurityEnabled)},
{MIB_FIXED_IP_MTU_SIZE,	"FIXED_IP_MTU_SIZE", WORD_T,	_OFFSET(fixedIpMtuSize), _SIZE(fixedIpMtuSize)},
{MIB_DHCP_MTU_SIZE,		"DHCP_MTU_SIZE", WORD_T,	_OFFSET(dhcpMtuSize), _SIZE(dhcpMtuSize)},
{MIB_HOST_NAME,			"HOST_NAME", 		STRING_T,	_OFFSET(hostName), _SIZE(hostName)},

{MIB_NTP_ENABLED, 		"NTP_ENABLED",	BYTE_T, 	_OFFSET(ntpEnabled), _SIZE(ntpEnabled)},
{MIB_NTP_SERVER_ID, 		"NTP_SERVER_ID",	BYTE_T, 	_OFFSET(ntpServerId), _SIZE(ntpServerId)},
{MIB_NTP_TIMEZONE, 		"NTP_TIMEZONE",	STRING_T, 	_OFFSET(ntpTimeZone), _SIZE(ntpTimeZone)},
{MIB_NTP_SERVER_IP1, 		"NTP_SERVER_IP1",	IA_T, 	_OFFSET(ntpServerIp1), _SIZE(ntpServerIp1)},
{MIB_NTP_SERVER_IP2, 		"NTP_SERVER_IP2",	IA_T, 	_OFFSET(ntpServerIp2), _SIZE(ntpServerIp2)},
#ifdef VPN_SUPPORT
{MIB_IPSEC_NATT_ENABLED,	"IPSEC_NATT_ENABLED",	BYTE_T,		_OFFSET(ipsecNattEnabled), _SIZE(ipsecNattEnabled)},
{MIB_IPSECTUNNEL_ENABLED,	"IPSECTUNNEL_ENABLED",	BYTE_T,		_OFFSET(ipsecTunnelEnabled), _SIZE(ipsecTunnelEnabled)},
{MIB_IPSECTUNNEL_NUM,		"IPSECTUNNEL_TBL_NUM",	BYTE_T,		_OFFSET(ipsecTunnelNum ), _SIZE(ipsecTunnelNum )},
{MIB_IPSECTUNNEL,		"IPSECTUNNEL_TBL",	IPSECTUNNEL_ARRAY_T,_OFFSET(ipsecTunnelArray), _SIZE(ipsecTunnelArray)},
{MIB_IPSEC_RSA_FILE,	"IPSEC_RSA_FILE",	BYTE_ARRAY_T,		_OFFSET(ipsecRsaKeyFile), _SIZE(ipsecRsaKeyFile)},
#endif
#endif // HOME_GATEWAY
{MIB_WAN_DNS1,			"DNS1",			IA_T,		_OFFSET(dns1), _SIZE(dns1)},
{MIB_WAN_DNS2,			"DNS2", 		IA_T, 		_OFFSET(dns2), _SIZE(dns2)},
{MIB_WAN_DNS3,			"DNS3", 		IA_T,		_OFFSET(dns3), _SIZE(dns3)},
{MIB_DHCP_CLIENT_START,		"DHCP_CLIENT_START", 	IA_T, 		_OFFSET(dhcpClientStart), _SIZE(dhcpClientStart)},
{MIB_DHCP_CLIENT_END,		"DHCP_CLIENT_END", 	IA_T,		_OFFSET(dhcpClientEnd), _SIZE(dhcpClientEnd)},
{MIB_ELAN_MAC_ADDR, 		"ELAN_MAC_ADDR",	BYTE6_T, 	_OFFSET(elanMacAddr), _SIZE(elanMacAddr)},
{MIB_DEVICE_NAME,		"DEVICE_NAME",		STRING_T,	_OFFSET(deviceName), _SIZE(deviceName)},
{MIB_IP_ADDR,			"IP_ADDR", 		IA_T,		_OFFSET(ipAddr), _SIZE(ipAddr)},
{MIB_SUBNET_MASK,		"SUBNET_MASK", 		IA_T,		_OFFSET(subnetMask), _SIZE(subnetMask)},
{MIB_DEFAULT_GATEWAY,		"DEFAULT_GATEWAY",	IA_T,		_OFFSET(defaultGateway), _SIZE(defaultGateway)},
{MIB_DHCP,			"DHCP", 		BYTE_T,		_OFFSET(dhcp), _SIZE(dhcp)},
{MIB_STP_ENABLED,		"STP_ENABLED",		BYTE_T,		_OFFSET(stpEnabled), _SIZE(stpEnabled)},
{MIB_DOMAIN_NAME,		"DOMAIN_NAME",		STRING_T,	_OFFSET(domainName), _SIZE(domainName)},
{MIB_SUPER_NAME,		"SUPER_NAME", 		STRING_T,	_OFFSET(superName), _SIZE(superName)},
{MIB_SUPER_PASSWORD,		"SUPER_PASSWORD",	STRING_T,	_OFFSET(superPassword), _SIZE(superPassword)},
{MIB_USER_NAME,			"USER_NAME",		STRING_T,	_OFFSET(userName), _SIZE(userName)},
{MIB_USER_PASSWORD,		"USER_PASSWORD",	STRING_T,	_OFFSET(userPassword), _SIZE(userPassword)},
{MIB_LOG_ENABLED,		"SCRLOG_ENABLED",	BYTE_T,		_OFFSET(scrlogEnabled), _SIZE(scrlogEnabled)},
{MIB_AUTO_DISCOVERY_ENABLED,	"AUTODISCOVERY_ENABLED",BYTE_T,		_OFFSET(autoDiscoveryEnabled), _SIZE(autoDiscoveryEnabled)},
#ifdef HOME_GATEWAY
{MIB_DDNS_ENABLED,		"DDNS_ENABLED",		BYTE_T,		_OFFSET(ddnsEnabled), _SIZE(ddnsEnabled)},
{MIB_DDNS_TYPE,			"DDNS_TYPE",		BYTE_T,		_OFFSET(ddnsType), _SIZE(ddnsType)},
{MIB_DDNS_DOMAIN_NAME,		"DDNS_DOMAIN_NAME",	STRING_T,	_OFFSET(ddnsDomainName), _SIZE(ddnsDomainName)},
{MIB_DDNS_USER,			"DDNS_USER",		STRING_T,	_OFFSET(ddnsUser), _SIZE(ddnsUser)},
{MIB_DDNS_PASSWORD,		"DDNS_PASSWORD",	STRING_T,	_OFFSET(ddnsPassword), _SIZE(ddnsPassword)},
#endif
{MIB_OP_MODE,			"OP_MODE",		BYTE_T,		_OFFSET(opMode), _SIZE(opMode)},
{MIB_WISP_WAN_ID,		"WISP_WAN_ID",		BYTE_T,		_OFFSET(wispWanId), _SIZE(wispWanId)},
#ifdef TLS_CLIENT
{MIB_CERTROOT_NUM,		"CERTROOT_TBL_NUM",	BYTE_T,		_OFFSET(certRootNum), _SIZE(certRootNum)},
{MIB_CERTROOT,			"CERTROOT_TBL",		CERTROOT_ARRAY_T,_OFFSET(certRootArray), _SIZE(certRootArray)},
{MIB_CERTUSER_NUM,		"CERTUSER_TBL_NUM",	BYTE_T,		_OFFSET(certUserNum), _SIZE(certUserNum)},
{MIB_CERTUSER,			"CERTUSER_TBL",		CERTUSER_ARRAY_T,_OFFSET(certUserArray), _SIZE(certUserArray)},
{MIB_ROOT_IDX,			"ROOT_IDX",		BYTE_T,		_OFFSET(rootIdx), _SIZE(rootIdx)},
{MIB_USER_IDX,			"USER_IDX",		BYTE_T,		_OFFSET(userIdx), _SIZE(userIdx)},
#endif
#ifdef   HOME_GATEWAY
#ifdef ROUTE_SUPPORT
{MIB_STATICROUTE_ENABLED,	"STATICROUTE_ENABLED",	BYTE_T,		_OFFSET(staticRouteEnabled), _SIZE(staticRouteEnabled)},
{MIB_STATICROUTE_NUM,		"STATICROUTE_TBL_NUM",	BYTE_T,		_OFFSET(staticRouteNum), _SIZE(staticRouteNum)},
{MIB_STATICROUTE,		"STATICROUTE_TBL",	STATICROUTE_ARRAY_T,_OFFSET(staticRouteArray), _SIZE(staticRouteArray)},
{MIB_RIP_ENABLED,		"RIP_ENABLED",	BYTE_T, _OFFSET(ripEnabled), _SIZE(ripEnabled)},
{MIB_RIP_LAN_TX,		"RIP_LAN_TX",	BYTE_T, _OFFSET(ripLanTx), _SIZE(ripLanTx)},
{MIB_RIP_LAN_RX,		"RIP_LAN_RX",	BYTE_T, _OFFSET(ripLanRx), _SIZE(ripLanRx)},
{MIB_RIP_WAN_TX,		"RIP_WAN_TX",	BYTE_T, _OFFSET(ripWanTx), _SIZE(ripWanTx)},
{MIB_RIP_WAN_RX,		"RIP_WAN_RX",	BYTE_T, _OFFSET(ripWanRx), _SIZE(ripWanRx)},
#endif
{WEB_WAN_ACCESS_ENABLED,	"WEB_WAN_ACCESS_ENABLED",BYTE_T, _OFFSET(wanAccessEnabled), _SIZE(wanAccessEnabled)},
{PING_WAN_ACCESS_ENABLED,	"PING_WAN_ACCESS_ENABLED",BYTE_T, _OFFSET(pingAccessEnabled), _SIZE(pingAccessEnabled)},
#endif
{MIB_REMOTELOG_ENABLED,		"REMOTELOG_ENABLED",	BYTE_T, _OFFSET(rtLogEnabled), _SIZE(rtLogEnabled)},
{MIB_REMOTELOG_SERVER,		"REMOTELOG_SERVER",	IA_T, _OFFSET(rtLogServer), _SIZE(rtLogServer)},

#ifdef UNIVERSAL_REPEATER
{MIB_REPEATER_ENABLED1,		"REPEATER_ENABLED1",	BYTE_T, 	_OFFSET(repeaterEnabled1), _SIZE(repeaterEnabled1)},
{MIB_REPEATER_SSID1,		"REPEATER_SSID1", 	STRING_T,	_OFFSET(repeaterSSID1), _SIZE(repeaterSSID1)},
{MIB_REPEATER_ENABLED2,		"REPEATER_ENABLED2",	BYTE_T, 	_OFFSET(repeaterEnabled2), _SIZE(repeaterEnabled2)},
{MIB_REPEATER_SSID2,		"REPEATER_SSID2", 	STRING_T,	_OFFSET(repeaterSSID2), _SIZE(repeaterSSID2)},
#endif

{MIB_WIFI_SPECIFIC,		"WIFI_SPECIFIC",	BYTE_T, _OFFSET(wifiSpecific), _SIZE(wifiSpecific)},

#ifdef HOME_GATEWAY
{MIB_PPP_SERVICE,		"PPP_SERVICE_NAME",	STRING_T,	_OFFSET(pppServiceName), _SIZE(pppServiceName)},
#ifdef DOS_SUPPORT
{MIB_DOS_ENABLED, 			"DOS_ENABLED",			DWORD_T, 	_OFFSET(dosEnabled), _SIZE(dosEnabled)},
{MIB_DOS_SYSSYN_FLOOD, 	"DOS_SYSSYN_FLOOD",		WORD_T, 	_OFFSET(syssynFlood), _SIZE(syssynFlood)},
{MIB_DOS_SYSFIN_FLOOD, 		"DOS_SYSFIN_FLOOD",		WORD_T, 	_OFFSET(sysfinFlood), _SIZE(sysfinFlood)},
{MIB_DOS_SYSUDP_FLOOD, 	"DOS_SYSUDP_FLOOD",	WORD_T, 	_OFFSET(sysudpFlood), _SIZE(sysudpFlood)},
{MIB_DOS_SYSICMP_FLOOD, 	"DOS_SYSICMP_FLOOD",	WORD_T, 	_OFFSET(sysicmpFlood), _SIZE(sysicmpFlood)},
{MIB_DOS_PIPSYN_FLOOD, 		"DOS_PIPSYN_FLOOD",		WORD_T, 	_OFFSET(pipsynFlood), _SIZE(pipsynFlood)},
{MIB_DOS_PIPFIN_FLOOD, 		"DOS_PIPFIN_FLOOD",		WORD_T, 	_OFFSET(pipfinFlood), _SIZE(pipfinFlood)},
{MIB_DOS_PIPUDP_FLOOD, 		"DOS_PIPUDP_FLOOD",		WORD_T, 	_OFFSET(pipudpFlood), _SIZE(pipudpFlood)},
{MIB_DOS_PIPICMP_FLOOD, 	"DOS_PIPICMP_FLOOD",	WORD_T, 	_OFFSET(pipicmpFlood), _SIZE(pipicmpFlood)},
{MIB_DOS_BLOCK_TIME, 		"DOS_BLOCK_TIME",		WORD_T, 	_OFFSET(blockTime), _SIZE(blockTime)},
#endif
{MIB_URLFILTER_ENABLED,		"URLFILTER_ENABLED",		BYTE_T,		_OFFSET(urlFilterEnabled), _SIZE(urlFilterEnabled)},
{MIB_URLFILTER_NUM,			"URLFILTER_TBL_NUM",		BYTE_T,		_OFFSET(urlFilterNum), _SIZE(urlFilterNum)},
{MIB_URLFILTER,				"URLFILTER_TBL",			URLFILTER_ARRAY_T,_OFFSET(urlFilterArray), _SIZE(urlFilterArray)},
{VPN_PASSTHRU_IPSEC_ENABLED,	"VPN_PASSTHRU_IPSEC_ENABLED",BYTE_T, 	_OFFSET(vpnPassthruIPsecEnabled), _SIZE(vpnPassthruIPsecEnabled)},
{VPN_PASSTHRU_PPTP_ENABLED,	"VPN_PASSTHRU_PPTP_ENABLED",BYTE_T, 	_OFFSET(vpnPassthruPPTPEnabled), _SIZE(vpnPassthruPPTPEnabled)},
{VPN_PASSTHRU_L2TP_ENABLED,	"VPN_PASSTHRU_L2TP_ENABLED",BYTE_T, 	_OFFSET(vpnPassthruL2TPEnabled), _SIZE(vpnPassthruL2TPEnabled)},
#endif
{0}
};


/*
 * When using flash (set/get/all) command to access the MIB of below table,
 * it needs append a keyword "WLANx_" in ahead of mib name.
 * When access default setting, it needs appened a keyword "DEF_" in front of
 * "WLANx_" keyword.
 */

mib_table_entry_T mib_wlan_table[]={
{MIB_WLAN_MAC_ADDR, 		"WLAN_MAC_ADDR",	BYTE6_T, 	_OFFSET_WLAN(wlanMacAddr), _SIZE_WLAN(wlanMacAddr)},
{MIB_WLAN_SSID,			"SSID", 		STRING_T,	_OFFSET_WLAN(ssid), _SIZE_WLAN(ssid)},
{MIB_WLAN_CHAN_NUM,		"CHANNEL", 		BYTE_T, 	_OFFSET_WLAN(channel), _SIZE_WLAN(channel)},
{MIB_WLAN_WEP,			"WEP", 			BYTE_T,		_OFFSET_WLAN(wep), _SIZE_WLAN(wep)},
{MIB_WLAN_WEP64_KEY1,		"WEP64_KEY1", 		BYTE5_T,	_OFFSET_WLAN(wep64Key1), _SIZE_WLAN(wep64Key1)},
{MIB_WLAN_WEP64_KEY2,		"WEP64_KEY2", 		BYTE5_T,	_OFFSET_WLAN(wep64Key2), _SIZE_WLAN(wep64Key2)},
{MIB_WLAN_WEP64_KEY3,		"WEP64_KEY3", 		BYTE5_T,	_OFFSET_WLAN(wep64Key3), _SIZE_WLAN(wep64Key3)},
{MIB_WLAN_WEP64_KEY4,		"WEP64_KEY4", 		BYTE5_T,	_OFFSET_WLAN(wep64Key4), _SIZE_WLAN(wep64Key4)},
{MIB_WLAN_WEP128_KEY1,		"WEP128_KEY1", 		BYTE13_T,	_OFFSET_WLAN(wep128Key1), _SIZE_WLAN(wep128Key1)},
{MIB_WLAN_WEP128_KEY2,		"WEP128_KEY2", 		BYTE13_T,	_OFFSET_WLAN(wep128Key2), _SIZE_WLAN(wep128Key2)},
{MIB_WLAN_WEP128_KEY3,		"WEP128_KEY3", 		BYTE13_T,	_OFFSET_WLAN(wep128Key3), _SIZE_WLAN(wep128Key3)},
{MIB_WLAN_WEP128_KEY4,		"WEP128_KEY4", 		BYTE13_T,	_OFFSET_WLAN(wep128Key4), _SIZE_WLAN(wep128Key4)},
{MIB_WLAN_WEP_DEFAULT_KEY,	"WEP_DEFAULT_KEY", 	BYTE_T,		_OFFSET_WLAN(wepDefaultKey), _SIZE_WLAN(wepDefaultKey)},
{MIB_WLAN_WEP_KEY_TYPE,		"WEP_KEY_TYPE", 	BYTE_T,		_OFFSET_WLAN(wepKeyType), _SIZE_WLAN(wepKeyType)},
{MIB_WLAN_FRAG_THRESHOLD,	"FRAG_THRESHOLD", 	WORD_T,		_OFFSET_WLAN(fragThreshold), _SIZE_WLAN(fragThreshold)},
{MIB_WLAN_SUPPORTED_RATE,	"SUPPORTED_RATES", 	WORD_T,		_OFFSET_WLAN(supportedRates), _SIZE_WLAN(supportedRates)},
{MIB_WLAN_BEACON_INTERVAL,	"BEACON_INTERVAL", 	WORD_T,		_OFFSET_WLAN(beaconInterval), _SIZE_WLAN(beaconInterval)},
{MIB_WLAN_PREAMBLE_TYPE,	"PREAMBLE_TYPE", 	BYTE_T,		_OFFSET_WLAN(preambleType), _SIZE_WLAN(preambleType)},
{MIB_WLAN_BASIC_RATE,		"BASIC_RATES", 		WORD_T, 	_OFFSET_WLAN(basicRates), _SIZE_WLAN(basicRates)},
{MIB_WLAN_RTS_THRESHOLD,	"RTS_THRESHOLD", 	WORD_T, 	_OFFSET_WLAN(rtsThreshold), _SIZE_WLAN(rtsThreshold)},
{MIB_WLAN_AUTH_TYPE,		"AUTH_TYPE", 		BYTE_T,		_OFFSET_WLAN(authType), _SIZE_WLAN(authType)},
{MIB_WLAN_HIDDEN_SSID,		"HIDDEN_SSID", 		BYTE_T,		_OFFSET_WLAN(hiddenSSID), _SIZE_WLAN(hiddenSSID)},
{MIB_WLAN_DISABLED,		"WLAN_DISABLED", 	BYTE_T,		_OFFSET_WLAN(wlanDisabled), _SIZE_WLAN(wlanDisabled)},
{MIB_WLAN_INACTIVITY_TIME,	"INACTIVITY_TIME",	DWORD_T,	_OFFSET_WLAN(inactivityTime), _SIZE_WLAN(inactivityTime)},
{MIB_WLAN_RATE_ADAPTIVE_ENABLED,"RATE_ADAPTIVE_ENABLED",BYTE_T,		_OFFSET_WLAN(rateAdaptiveEnabled), _SIZE_WLAN(rateAdaptiveEnabled)},
{MIB_WLAN_DTIM_PERIOD,		"DTIM_PERIOD", 		BYTE_T,		_OFFSET_WLAN(dtimPeriod), _SIZE_WLAN(dtimPeriod)},
{MIB_WLAN_MODE,			"MODE", 		BYTE_T,		_OFFSET_WLAN(wlanMode), _SIZE_WLAN(wlanMode)},
{MIB_WLAN_NETWORK_TYPE,		"NETWORK_TYPE",		BYTE_T,		_OFFSET_WLAN(networkType), _SIZE_WLAN(networkType)},
{MIB_WLAN_IAPP_DISABLED,	"IAPP_DISABLED",	BYTE_T,		_OFFSET_WLAN(iappDisabled), _SIZE_WLAN(iappDisabled)},
{MIB_WLAN_PROTECTION_DISABLED,	"PROTECTION_DISABLED",	BYTE_T,		_OFFSET_WLAN(protectionDisabled), _SIZE_WLAN(protectionDisabled)},
{MIB_WLAN_DEFAULT_SSID,		"DEFAULT_SSID", 	STRING_T,	_OFFSET_WLAN(defaultSsid), _SIZE_WLAN(defaultSsid)},
{MIB_WLAN_WDS_ENABLED,		"WDS_ENABLED",		BYTE_T,		_OFFSET_WLAN(wdsEnabled), _SIZE_WLAN(wdsEnabled)},
{MIB_WLAN_WDS_NUM,		"WDS_NUM",		BYTE_T,		_OFFSET_WLAN(wdsNum), _SIZE_WLAN(wdsNum)},
{MIB_WLAN_WDS,			"WDS",			WDS_ARRAY_T,	_OFFSET_WLAN(wdsArray), _SIZE_WLAN(wdsArray)},
{MIB_WLAN_WDS_ENCRYPT,		"WDS_ENCRYPT", 		BYTE_T,		_OFFSET_WLAN(wdsEncrypt), _SIZE_WLAN(wdsEncrypt)},
{MIB_WLAN_WDS_WEP_FORMAT,	"WDS_WEP_FORMAT", 	BYTE_T,		_OFFSET_WLAN(wdsWepKeyFormat), _SIZE_WLAN(wdsWepKeyFormat)},
{MIB_WLAN_WDS_WEP_KEY,		"WDS_WEP_KEY",		STRING_T,	_OFFSET_WLAN(wdsWepKey), _SIZE_WLAN(wdsWepKey)},
{MIB_WLAN_WDS_PSK_FORMAT,	"WDS_PSK_FORMAT", 	BYTE_T,		_OFFSET_WLAN(wdsPskFormat), _SIZE_WLAN(wdsPskFormat)},
{MIB_WLAN_WDS_PSK,		"WDS_PSK",		STRING_T,	_OFFSET_WLAN(wdsPsk), _SIZE_WLAN(wdsPsk)},
{MIB_WLAN_ENCRYPT,		"ENCRYPT",		BYTE_T,		_OFFSET_WLAN(encrypt), _SIZE_WLAN(encrypt)},
{MIB_WLAN_ENABLE_SUPP_NONWPA,	"ENABLE_SUPP_NONWPA", 	BYTE_T,		_OFFSET_WLAN(enableSuppNonWpa), _SIZE_WLAN(enableSuppNonWpa)},
{MIB_WLAN_SUPP_NONWPA,		"SUPP_NONWPA", 		BYTE_T,		_OFFSET_WLAN(suppNonWpa), _SIZE_WLAN(suppNonWpa)},
{MIB_WLAN_WPA_AUTH,		"WPA_AUTH", 		BYTE_T,		_OFFSET_WLAN(wpaAuth), _SIZE_WLAN(wpaAuth)},
{MIB_WLAN_WPA_CIPHER_SUITE,	"WPA_CIPHER_SUITE",	BYTE_T,		_OFFSET_WLAN(wpaCipher), _SIZE_WLAN(wpaCipher)},
{MIB_WLAN_WPA_PSK,		"WPA_PSK",		STRING_T,	_OFFSET_WLAN(wpaPSK), _SIZE_WLAN(wpaPSK)},
{MIB_WLAN_WPA_GROUP_REKEY_TIME,	"WPA_GROUP_REKEY_TIME",	DWORD_T,	_OFFSET_WLAN(wpaGroupRekeyTime), _SIZE_WLAN(wpaGroupRekeyTime)},
{MIB_WLAN_ENABLE_MAC_AUTH,	"MAC_AUTH_ENABLED",     BYTE_T,         _OFFSET_WLAN(macAuthEnabled), _SIZE_WLAN(macAuthEnabled)},
{MIB_WLAN_RS_IP,		"RS_IP",		IA_T,		_OFFSET_WLAN(rsIpAddr), _SIZE_WLAN(rsIpAddr)},
{MIB_WLAN_RS_PORT,		"RS_PORT",		WORD_T,		_OFFSET_WLAN(rsPort), _SIZE_WLAN(rsPort)},
{MIB_WLAN_RS_PASSWORD,		"RS_PASSWORD",		STRING_T,	_OFFSET_WLAN(rsPassword), _SIZE_WLAN(rsPassword)},
{MIB_WLAN_RS_RETRY,		"RS_MAXRETRY",		BYTE_T,		_OFFSET_WLAN(rsMaxRetry), _SIZE_WLAN(rsMaxRetry)},
{MIB_WLAN_RS_INTERVAL_TIME,	"RS_INTERVAL_TIME",	WORD_T,		_OFFSET_WLAN(rsIntervalTime), _SIZE_WLAN(rsIntervalTime)},
{MIB_WLAN_ACCOUNT_RS_ENABLED,	"ACCOUNT_RS_ENABLED", 	BYTE_T,		_OFFSET_WLAN(accountRsEnabled), _SIZE_WLAN(accountRsEnabled)},
{MIB_WLAN_ACCOUNT_RS_IP,	"ACCOUNT_RS_IP",	IA_T,		_OFFSET_WLAN(accountRsIpAddr), _SIZE_WLAN(accountRsIpAddr)},
{MIB_WLAN_ACCOUNT_RS_PORT,	"ACCOUNT_RS_PORT",	WORD_T,		_OFFSET_WLAN(accountRsPort), _SIZE_WLAN(accountRsPort)},
{MIB_WLAN_ACCOUNT_RS_PASSWORD,	"ACCOUNT_RS_PASSWORD",	STRING_T,	_OFFSET_WLAN(accountRsPassword), _SIZE_WLAN(accountRsPassword)},
{MIB_WLAN_ACCOUNT_UPDATE_ENABLED,"ACCOUNT_RS_UPDATE_ENABLED",BYTE_T,	_OFFSET_WLAN(accountRsUpdateEnabled), _SIZE_WLAN(accountRsUpdateEnabled)},
{MIB_WLAN_ACCOUNT_UPDATE_DELAY,"ACCOUNT_RS_UPDATE_DELAY",WORD_T,	_OFFSET_WLAN(accountRsUpdateDelay), _SIZE_WLAN(accountRsUpdateDelay)},
{MIB_WLAN_ACCOUNT_RS_RETRY,	"ACCOUNT_RS_MAXRETRY",	BYTE_T,		_OFFSET_WLAN(accountRsMaxRetry), _SIZE_WLAN(accountRsMaxRetry)},
{MIB_WLAN_ACCOUNT_RS_INTERVAL_TIME, "ACCOUNT_RS_INTERVAL_TIME",	WORD_T,	_OFFSET_WLAN(accountRsIntervalTime), _SIZE_WLAN(accountRsIntervalTime)},
{MIB_WLAN_ENABLE_1X,		"ENABLE_1X", 		BYTE_T,		_OFFSET_WLAN(enable1X), _SIZE_WLAN(enable1X)},
{MIB_WLAN_WPA_PSK_FORMAT,	"PSK_FORMAT", 		BYTE_T,		_OFFSET_WLAN(wpaPSKFormat), _SIZE_WLAN(wpaPSKFormat)},
{MIB_WLAN_WPA2_PRE_AUTH,	"WPA2_PRE_AUTH",	BYTE_T,         _OFFSET_WLAN(wpa2PreAuth), _SIZE_WLAN(wpa2PreAuth)},
{MIB_WLAN_WPA2_CIPHER_SUITE,	"WPA2_CIPHER_SUITE",	BYTE_T,		_OFFSET_WLAN(wpa2Cipher), _SIZE_WLAN(wpa2Cipher)},
{MIB_WLAN_AC_NUM, 		"MACAC_NUM",		BYTE_T,		_OFFSET_WLAN(acNum), _SIZE_WLAN(acNum)},
{MIB_WLAN_AC_ENABLED,		"MACAC_ENABLED",	BYTE_T,		_OFFSET_WLAN(acEnabled), _SIZE_WLAN(acEnabled)},
{MIB_WLAN_AC_ADDR,		"MACAC_ADDR",		WLAC_ARRAY_T,  _OFFSET_WLAN(acAddrArray), _SIZE_WLAN(acAddrArray)},
{MIB_WLAN_BLOCK_RELAY,		"BLOCK_RELAY",		BYTE_T,		_OFFSET_WLAN(blockRelay), _SIZE_WLAN(blockRelay)},
{MIB_WLAN_NAT25_MAC_CLONE,	"MACCLONE_ENABLED",	BYTE_T,		_OFFSET_WLAN(maccloneEnabled), _SIZE_WLAN(maccloneEnabled)},
{MIB_WLAN_BAND,			"BAND",			BYTE_T,		_OFFSET_WLAN(wlanBand), _SIZE_WLAN(wlanBand)},
{MIB_WLAN_FIX_RATE,		"FIX_RATE",		WORD_T,		_OFFSET_WLAN(fixedTxRate), _SIZE_WLAN(fixedTxRate)},
{MIB_TURBO_MODE,		"TURBO_MODE",	BYTE_T, _OFFSET_WLAN(turboMode), _SIZE_WLAN(turboMode)},
{MIB_WLAN_RF_POWER,		"RFPOWER_SCALE", BYTE_T, _OFFSET_WLAN(RFPowerScale), _SIZE_WLAN(RFPowerScale)},

#ifdef WLAN_EASY_CONFIG
{MIB_WLAN_EASYCFG_ENABLED,	"EASYCFG_ENABLED",	BYTE_T,		_OFFSET_WLAN(acfEnabled), _SIZE_WLAN(acfEnabled)},
{MIB_WLAN_EASYCFG_MODE,		"EASYCFG_MODE",		BYTE_T,		_OFFSET_WLAN(acfMode), _SIZE_WLAN(acfMode)},
{MIB_WLAN_EASYCFG_SSID,		"EASYCFG_SSID",		STRING_T,	_OFFSET_WLAN(acfSSID), _SIZE_WLAN(acfSSID)},
{MIB_WLAN_EASYCFG_KEY,		"EASYCFG_KEY",		STRING_T,	_OFFSET_WLAN(acfKey), _SIZE_WLAN(acfKey)},
{MIB_WLAN_EASYCFG_DIGEST,	"EASYCFG_DIGEST",	STRING_T,	_OFFSET_WLAN(acfDigest), _SIZE_WLAN(acfDigest)},
{MIB_WLAN_EASYCFG_ALG_REQ,	"EASYCFG_ALG_REQ",	BYTE_T,		_OFFSET_WLAN(acfAlgReq), _SIZE_WLAN(acfAlgReq)},
{MIB_WLAN_EASYCFG_ALG_SUPP,	"EASYCFG_ALG_SUPP",	BYTE_T,		_OFFSET_WLAN(acfAlgSupp), _SIZE_WLAN(acfAlgSupp)},
{MIB_WLAN_EASYCFG_ROLE,		"EASYCFG_ROLE",		BYTE_T,		_OFFSET_WLAN(acfRole), _SIZE_WLAN(acfRole)},
{MIB_WLAN_EASYCFG_SCAN_SSID,	"EASYCFG_SCAN_SSID",	STRING_T,	_OFFSET_WLAN(acfScanSSID), _SIZE_WLAN(acfScanSSID)},
{MIB_WLAN_EASYCFG_WLAN_MODE,	"EASYCFG_WLAN_MODE",	BYTE_T,		_OFFSET_WLAN(acfWlanMode), _SIZE_WLAN(acfWlanMode)},
#endif
{0}
};


/*
 * When using flash (set/get/all) command to access the MIB of below table,
 * it needs append a keyword "HW_" in ahead of mib name.
 */

mib_table_entry_T hwmib_table[]={
{MIB_HW_BOARD_VER, 		"BOARD_ID",		BYTE_T, 	_OFFSET_HW(boardVer), _SIZE_HW(boardVer)},
{MIB_HW_NIC0_ADDR, 		"NIC0_ADDR",		BYTE6_T, 	_OFFSET_HW(nic0Addr), _SIZE_HW(nic0Addr)},
{MIB_HW_NIC1_ADDR, 		"NIC1_ADDR",		BYTE6_T, 	_OFFSET_HW(nic1Addr), _SIZE_HW(nic1Addr)},
{0}
};


/*
 * When using flash (set/get/all) command to access the MIB of below table,
 * it needs append a keyword "HW_WLANx_" in ahead of mib name.
 */

mib_table_entry_T hwmib_wlan_table[]={
{MIB_HW_WLAN_ADDR, 		"WLAN_ADDR",		BYTE6_T, 	_OFFSET_HW_WLAN(macAddr), _SIZE_HW_WLAN(macAddr)},
{MIB_HW_REG_DOMAIN, 		"REG_DOMAIN",		BYTE_T, 	_OFFSET_HW_WLAN(regDomain), _SIZE_HW_WLAN(regDomain)},
{MIB_HW_RF_TYPE, 		"RF_TYPE",		BYTE_T, 	_OFFSET_HW_WLAN(rfType), _SIZE_HW_WLAN(rfType)},
{MIB_HW_TX_POWER_CCK, 		"TX_POWER_CCK",		BYTE_ARRAY_T, 	_OFFSET_HW_WLAN(txPowerCCK), _SIZE_HW_WLAN(txPowerCCK)},
{MIB_HW_TX_POWER_OFDM, 		"TX_POWER_OFDM",	BYTE_ARRAY_T, 	_OFFSET_HW_WLAN(txPowerOFDM), _SIZE_HW_WLAN(txPowerOFDM)},
{MIB_HW_ANT_DIVERSITY, 		"ANT_DIVERSITY",	BYTE_T, 	_OFFSET_HW_WLAN(antDiversity), _SIZE_HW_WLAN(antDiversity)},
{MIB_HW_TX_ANT, 		"TX_ANT",		BYTE_T, 	_OFFSET_HW_WLAN(txAnt), _SIZE_HW_WLAN(txAnt)},
{MIB_HW_INIT_GAIN, 		"INIT_GAIN",		BYTE_T, 	_OFFSET_HW_WLAN(initGain), _SIZE_HW_WLAN(initGain)},
{MIB_HW_CCA_MODE, 		"CCA_MODE",		BYTE_T, 	_OFFSET_HW_WLAN(ccaMode), _SIZE_HW_WLAN(ccaMode)},
{MIB_HW_LED_TYPE, 		"LED_TYPE",		BYTE_T, 	_OFFSET_HW_WLAN(ledType), _SIZE_HW_WLAN(ledType)},
{0}
};


